!---------------------------------------------------------------
! Copyright (C) 2009-2013 GFD Dennou Club. All rights reserved.
!---------------------------------------------------------------

module cloud
! CReSS αʪ
  use Thermo_Function
  use Thermo_Const

contains

real function Src_theta_warm( temp, pres, qv, qr )
! warm rain Ǥ theta Υ
  use Thermo_Const
  implicit none
  real, intent(in) :: temp  !  [K]
  real, intent(in) :: pres  ! ȡ뵤 [Pa]
  real, intent(in) :: qv  !  [kg/kg]
  real, intent(in) :: qr  ! 庮 [kg/kg]
  real :: vapor_qv, rhob

  vapor_qv=qvss( temp, pres )
  rhob=TP_2_rho( temp, pres )

  Src_theta_warm=Lv( temp )*EVrv( temp, qv, qr, pres )

  Src_theta_warm=rhob*Src_theta_warm/(cpd*exner_func_dry( pres ))

  return

end function Src_theta_warm

!---------------------------------

!!!real function Src_theta_cold( rhob, rhop, rho0, ptb, ptp, pb, pp, qv, qc, qr, qi, qs, qg )
!!!! warm rain Ǥ theta Υ
!!!  use Thermo_Const
!!!  implicit none
!!!  real, intent(in) :: rhob  ! ܾ̩ [kg/m3]
!!!  real, intent(in) :: rhop  ! ̩٤ư [kg/m3]
!!!  real, intent(in) :: rho0  ! ɽ̤δܾ̩ [kg/m3]
!!!  real, intent(in) :: ptb  ! ̤δܾ [K]
!!!  real, intent(in) :: ptp  ! ̤ư [K]
!!!  real, intent(in) :: pb  ! ̤δܾ [K]
!!!  real, intent(in) :: pp  ! ̤ư [K]
!!!  real, intent(in) :: qv  !  [kg/kg]
!!!  real, intent(in) :: qc  ! 庮 [kg/kg]
!!!  real, intent(in) :: qr  ! 庮 [kg/kg]
!!!  real, intent(in) :: qi  ! ɹ [kg/kg]
!!!  real, intent(in) :: qs  ! 㺮 [kg/kg]
!!!  real, intent(in) :: qg  ! Ǻ [kg/kg]
!!!  real :: vapor_qv
!!!
!!!  vapor_qv=qvs( temp )
!!!
!!!  Src_theta_cold=Lv( temp )*(VDvr())  &
!!!  &              +Ls( temp )*(NUAvi()+VDvi()+VDvs()+VDvg())  &
!!!  &              +Lf( temp )*(NUFci()+NUCci()+NUHci()  &
!!!  &              +CLri()-MLic()-MLsr()-MLgr()+FRrg())
!!!
!!!  Src_theta_cold=Src_theta_cold/(cpd*exner())
!!!
!!!  return
!!!
!!!end function Src_theta_cold
!!!
!!!!---------------------------------
! common function (in cloud module)
!---------------------------------

real function Lv( temp )
!  -> ǤǮǮ
  use Thermo_Const
  implicit none
  real, intent(in) :: temp  !  [K]

  Lv=2.50078e6*(ti0/temp)**(0.167+3.67e-4*temp)

  return

end function Lv

real function Ls( temp )
! ɹ -> ǤǮǮ
  use Thermo_Const
  implicit none
  real, intent(in) :: temp !  [K]

  Ls=2.834e6+100.0*(temp-ti0)

  return

end function Ls

real function Lf( temp )
!  -> ɹǤͻǮ
  use Thermo_Const
  implicit none
  real, intent(in) :: temp !  [K]

  Lf=3.34e5+2500.0*(temp-ti0)

  return

end function Lf

real function nu_air( pres, temp )
! ưǴ
  use Thermo_Const
  implicit none
  real, intent(in) :: pres !  [Pa]
  real, intent(in) :: temp !  [K]

  nu_air=1.328e-5*(p00/pres)*(temp/ti0)**1.754

  return

end function nu_air

real function mu_air( pres, temp )
! Ǵ
  implicit none
  real, intent(in) :: pres
  real, intent(in) :: temp
  real :: rho

  rho=TP_2_rho( temp, pres )

  mu_air=nu_air( pres, temp )*rho

  return

end function mu_air

real function Dv( pres, temp )
  use Thermo_Const
  implicit none
  real, intent(in) :: pres
  real, intent(in) :: temp

  Dv=2.23e-5*(p00/pres)*(temp/ti0)**1.81

  return

end function

real function qvss( temp, pres )
  use Thermo_Const
  implicit none
  real, intent(in) :: temp
  real, intent(in) :: pres
  real :: eps

  eps=Rd/Rv
  qvss=eps*tetens(temp)/(pres)

  return

end function

!--------------------------------------
! warm bulk physics
!--------------------------------------

subroutine Moist_Sature_Adjust( pres, pt, qv, qc, err )
  use Thermo_Const
  implicit none
  real, intent(in) :: pres !  [Pa]
  real, intent(inout) :: pt   !  [K]
  real, intent(inout) :: qv   !  [kg kg-1]
  real, intent(inout) :: qc   ! 庮 [kg kg-1]
  real, intent(in), optional :: err  ! convergence limit [default = 1.0e-8]
  real :: tmppt, tmpqv, tmpqc, dqc, temp, gam, coe, pt1, qv1, qc1, err_max
  real :: tmp_err

  if(qv<0.0.or.qc<0.0)then
     write(*,*) "ERROR : Argument in Moist_Sature_Adjust must be greater than zero."
     write(*,*) "STOP."
     stop
  end if

  if(present(err))then
     err_max=err
  else
     err_max=1.0e-8
  end if

  temp=thetaP_2_T( pt, pres )
  dqc=qv-qvss( temp, pres )
  gam=Lv( temp )/(Cpd*exner_func_dry( pres ))
  pt1=pt
  qv1=qv
  qc1=qc

  do while (dqc>0.0.or.qc>0.0)
     coe=qvss( temp, pres )*  &
  &      (Cpd/(pt1*Rd)+17.269*(t0-35.86)/(exner_func_dry( pres )*(temp-t0)**2))
     tmppt=pt1+gam*(dqc)/(1.0+gam*coe)
     tmpqv=qv1+(pt1-tmppt)/gam
     tmpqc=qv1+qc1-tmpqv
     if(tmpqc>0.0)then
        pt1=tmppt
        qv1=tmpqv
        qc1=tmpqc
     else if(tmpqc<=0.0)then
        pt1=pt1-gam*qc1
        qv1=qv1+qc1
        qc1=0.0
        exit
     end if
     temp=thetaP_2_T( pt1, pres )
     dqc=qv-qvss( temp, pres )

     tmp_err=abs(tmppt-pt1)
     if(err_max>tmp_err)then
        exit
     end if
  end do

  pt=pt1
  qv=qv1
  qc=qc1

end subroutine Moist_Sature_Adjust

real function CNcr( qc, a )
  implicit none
  real, intent(in) :: qc
  real, intent(in), optional :: a
  real, parameter :: k1=1.0e-3
  real :: tmp

  if(present(a))then
     tmp=a
  else
     tmp=1.0e-3
  end if

  if(qc>tmp)then

     CNcr=k1*(qc-tmp)

  else

     CNcr=0.0

  end if

  return

end function CNcr

real function CLcr( qc, qr )
  implicit none
  real, intent(in) :: qc
  real, intent(in) :: qr
  real, parameter :: k2=2.2

  CLcr=k2*qc*(qr**0.875)

  return

end function CLcr

real function EVrv( temp, qv, qr, p )
  implicit none
  real, intent(in) :: temp  !  [K]
  real, intent(in) :: qv    !  [kg/kg]
  real, intent(in) :: qr    ! 庮 [kg/kg]
  real, intent(in) :: p     !  [Pa]
  real :: C, qvs, rhob

  rhob=TP_2_rho( temp, p )
  qvs=qvss( temp, p )
  C=1.6+124.9*(rhob*qr)**0.2046

  EVrv=((1.0-qv/qvs)*C*(rhob*qr)**0.525)/(rhob*(5.4e5+2.55e6/(p*qvs)))

  return

end function EVrv

real function term_v( rhob, qr, rho0 )
  implicit none
  real, intent(in) :: rhob
  real, intent(in) :: qr
  real, intent(in) :: rho0

  term_v=36.34*(rho0/rhob)*(rhob*qr)**0.1346

  return

end function term_v

!-----------------------------------------
!  cold bulk parameterization
!-----------------------------------------

!!!real function FRrg( temp, rhob, lambdar )
!!!! γ
!!!  use Thermo_Const
!!!  use Cloud_Const
!!!  use Math_Const
!!!  implicit none
!!!  real, intent(in) :: temp  !  [K]
!!!  real, intent(in) :: rhob  ! ܾ̩ [kg/m3]
!!!  real, intent(in) :: lambdar  ! γʬۤη
!!!  real :: tsp  ! Ѳ [K]
!!!
!!!  tsp=ti0-temp
!!!
!!!  FRrg=20.0*pi*pi*bd*nr0*rhow*(exp(ad*tsp)-1.0)/(rhob*lambdar**7)
!!!
!!!  return
!!!
!!!end function FRrg
!!!
!!!!-----------------------------------------
!!!
!!!real function MLxr( temp, rhob, pres, qv, cat )
!!!! , Ǥͻ
!!!  use Math_Const
!!!  use Thermo_Const
!!!  use Cloud_Const
!!!  implicit none
!!!  real, intent(in) :: temp  !  [K]
!!!  real, intent(in) :: rhob  ! ܾ̩ [kg/m3]
!!!  real, intent(in) :: pres  !  [Pa]
!!!  real, intent(in) :: qv  !  [kg/kg]
!!!  character(1), intent(in) :: cat  ! ѴΥƥ
!!!                ! 's' -> , 'g' -> 
!!!  real :: tdg  ! 륷
!!!
!!!  tdg=temp-t0
!!!
!!!  if(tdg>t0)then
!!!     MKxr=(2.0*pi*VENTx( temp, rhob, rhos, trim(cat) )  &
!!!  &       *(kpa*tdg/rhob+Lv( temp )*Dv( pres, temp )*(qv-qvs(ti0)))  &
!!!  &       +cw*tdg*(CLxy( 'c'//trim(cat) )+CLxy( 'r'//trim(cat) )))/(Lf( temp ))
!!!  else
!!!     MLxr=0.0
!!!  end if
!!!
!!!  return
!!!
!!!end function MLxr
!!!
!!!!-----------------------------------------
!!!
!!!real function MLic( dt, qi )
!!!! ɹͻ
!!!  implicit none
!!!  real, intent(in) :: dt  ! dtbig [s]
!!!  real, intent(in) :: qi  ! ɹ [kg/kg]
!!!
!!!  MLic=0.5*qi/dt
!!!
!!!  return
!!!
!!!end function MLic
!!!
!!!!-----------------------------------------
!!!
!!!!!real function CLxy( )
!!!! 
!!!
!!!!!end function CLxy
!!!
!!!!-----------------------------------------
!!!









end module
