program solver_LF
! Nolan and Montgomery 2001 ǥ
! ֥꡼ץեåˤ.
! old ߻, tmp  1 ƥå, new  1 ƥåɽ.
  use gtool_history
  use Derivation
  use ffts
  use max_min
  use Statistics
  use Math_Const
  use Phys_Const
  use special_function
  use val_define
  use read_namelist
  use val_alloc
  use val_coord

  implicit none

!-- do loop ѿ
  integer :: i, j, it, ct
  integer, parameter :: init_n=1  ! ΥΥޥȿ

!-- namelist ɤ߹

  call read_name()

!-- allocating array

  call val_allocate()

!-- Ͳ (2d ǡ 3 ǡؤγĥ)

write(*,*) "starting initialization."
  call HistoryGet( trim(finame), 'vbar', vib )
  call HistoryGet( trim(finame), 'hbar', hib )
  call HistoryGet( trim(finame), 'r', ri )

!-- ʻκ
  call val_coordinate()

!-- bar Ⱦʻؤ
  call cont_interpolation( ri, rv, vib, vb )
  call cont_interpolation( ri, rs, hib, hb )

!-- 쥤꡼ԥ
  epsu=0.0
  epsv=0.0
  epsh=0.0

  do i=1,nr
     if(rv(i)>=r_dmp)then
        epsu(i)=1.0
        epsv(i)=1.0
        epsh(i)=1.0
     end if
  end do

!-- ͺ

  do j=1,ntheta
     do i=1,nr
!        urp_dmp(i,j)=bessj(0,rv(i)/100000.0)*cos(real(init_n)*theta(j))
!        vrp_dmp(i,j)=bessj(0,rv(i)/100000.0)*cos(real(init_n)*theta(j))
!        hrp_dmp(i,j)=bessj(0,rv(i)/100000.0)*cos(real(init_n)*theta(j))
        urp_dmp(i,j)=exp(-2.0*(rv(i)/100000.0-1.0)**2)*cos(real(init_n)*theta(j))
        vrp_dmp(i,j)=exp(-2.0*(rv(i)/100000.0-1.0)**2)*cos(real(init_n)*theta(j))
        hrp_dmp(i,j)=exp(-2.0*(rv(i)/100000.0-1.0)**2)*cos(real(init_n)*theta(j))
     end do
  end do

  write(*,*) "normally pass the initialization."

!-- ϥեν
  call HistoryCreate( file=trim(foname), title='shallow result data', &
  & source='test', institution='test', dims=(/'r    ','theta', 't    '/),  &
  & dimsizes=(/nr,ntheta, 0/),  & 
  & longnames=(/'r-coordinate    ','theta-coordinate', 'time            '/),  &
  & units=(/'m  ', 'rad', 's  '/), origin=0.0, interval=dmpstp*dt )
  
  call HistoryPut( 'r', rs )
  call HistoryPut( 'theta', theta )
  
  call HistoryAddVariable( varname='up', dims=(/'r    ','theta','t    '/), &
    & longname='radial wind', units='m/s', xtype='float')

  call HistoryAddVariable( varname='vp', dims=(/'r    ','theta','t    '/), &
    & longname='tangential wind', units='m/s', xtype='float')

  call HistoryAddVariable( varname='hp', dims=(/'r    ','theta','t    '/), &
    & longname='geopotential height', units='m', xtype='float')

  write(*,*) "time integration start."

!-- solver  (, ʹߤȤѿ̾ǵҤƤ)

  do it=1,nt
     ! ν
     if(it==1)then

        do j=1,ntheta
           do i=2,nr
              urp_old(i,j)=urp_dmp(i,j)
              vrp_old(i,j)=vrp_dmp(i,j)
              hrp_old(i,j)=hrp_dmp(i,j)
           end do
        end do

        call HistoryPut( 'up', urp_dmp )
        call HistoryPut( 'vp', vrp_dmp )
        call HistoryPut( 'hp', hrp_dmp )

!$omp parallel default(shared)
!$omp do private(i)
        do i=2,nr
           call r2c_ffttp_1d( ntheta, urp_old(i,:), ucp_new(i,:) )
           call r2c_ffttp_1d( ntheta, vrp_old(i,:), vcp_new(i,:) )
           call r2c_ffttp_1d( ntheta, hrp_old(i,:), hcp_new(i,:) )
        end do
!$omp end do
!$omp end parallel

!write(*,*) hcp_old
     else

        if(mod(it,dmpstp)==0)then  ! ѴԤ¿Ϥ.

!$omp parallel default(shared)
!$omp do private(i)
           do i=2,nr
              call c2r_ffttp_1d( ntheta, ucp_new(i,:), urp_new(i,:) )
              call c2r_ffttp_1d( ntheta, vcp_new(i,:), vrp_new(i,:) )
              call c2r_ffttp_1d( ntheta, hcp_new(i,:), hrp_new(i,:) )
           end do
!$omp end do
!$omp end parallel

           call HistoryPut( 'up', urp_new )
           call HistoryPut( 'vp', vrp_new )
           call HistoryPut( 'hp', hrp_new )

        end if
     end if

     !-- ֤ν°ѿζʬ׻

     call grad_1d( rs, hb, dhbdr )
     call grad_1d( rv, vb, dvbdr )

     if(it==1)then
        do j=1,hnt
           do i=2,nr
              ucp_tmp(i,j)=ucp_new(i,j)  ! old ()  tmp (1 ƥå) .
              vcp_tmp(i,j)=vcp_new(i,j)
              hcp_tmp(i,j)=hcp_new(i,j)
              ucp_old(i,j)=ucp_new(i,j)  ! new (1 ƥå)  old () .
              vcp_old(i,j)=vcp_new(i,j)
              hcp_old(i,j)=hcp_new(i,j)
           end do
        end do
     else
        do j=1,hnt
           do i=2,nr
              ucp_tmp(i,j)=ucp_old(i,j)  ! old ()  tmp (1 ƥå) .
              vcp_tmp(i,j)=vcp_old(i,j)
              hcp_tmp(i,j)=hcp_old(i,j)
              ucp_old(i,j)=ucp_new(i,j)  ! new (1 ƥå)  old () .
              vcp_old(i,j)=vcp_new(i,j)
              hcp_old(i,j)=hcp_new(i,j)
           end do
        end do
     end if

     !-- ڥȥѿʬ

!$omp parallel default(shared)
!$omp do private(i,j)
     do j=1,hnt
        do i=2,nr
           hrp_old(i,j)=real(hcp_old(i,j))
           hip_old(i,j)=aimag(hcp_old(i,j))
           urp_old(i,j)=real(ucp_old(i,j))
           uip_old(i,j)=aimag(ucp_old(i,j))
           vrp_old(i,j)=real(vcp_old(i,j))
           vip_old(i,j)=aimag(vcp_old(i,j))
        end do

        call grad_1d( rs, hrp_old(:,j), dhrpdr(:,j) )
        call grad_1d( rv, urp_old(:,j), durpdr(:,j) )
        call grad_1d( rv, vrp_old(:,j), dvrpdr(:,j) )
        call grad_1d( rs, hip_old(:,j), dhipdr(:,j) )
        call grad_1d( rv, uip_old(:,j), duipdr(:,j) )
        call grad_1d( rv, vip_old(:,j), dvipdr(:,j) )

        do i=2,nr
           ducpdr(i,j)=durpdr(i,j)+img*duipdr(i,j)
           dvcpdr(i,j)=dvrpdr(i,j)+img*dvipdr(i,j)
           dhcpdr(i,j)=dhrpdr(i,j)+img*dhipdr(i,j)
        end do

!write(*,*) ducpdr(10,10)
!-- ƹ׻
     !-- ήη׻

        do i=2,nr
           updvb(i,j)=ucp_old(i,j)*dvbdr(i)
           vpdvb(i,j)=vcp_old(i,j)*dvbdr(i)
           hpdvb(i,j)=hcp_old(i,j)*dvbdr(i)
           updhb(i,j)=ucp_old(i,j)*dhbdr(i)
           vpdhb(i,j)=vcp_old(i,j)*dhbdr(i)
           hpdhb(i,j)=hcp_old(i,j)*dhbdr(i)
           vbdup(i,j)=vb(i)*ducpdr(i,j)
           vbdvp(i,j)=vb(i)*dvcpdr(i,j)
           vbdhp(i,j)=vb(i)*dhcpdr(i,j)
           hbdup(i,j)=hb(i)*ducpdr(i,j)
           hbdvp(i,j)=hb(i)*dvcpdr(i,j)
           hbdhp(i,j)=hb(i)*dhcpdr(i,j)
        end do

     !-- ѷη׻
        do i=2,nr
           vbup(i,j)=vb(i)*ucp_old(i,j)
           vbvp(i,j)=vb(i)*vcp_old(i,j)
           vbhp(i,j)=vb(i)*hcp_old(i,j)
           hbup(i,j)=hb(i)*ucp_old(i,j)
           hbvp(i,j)=hb(i)*vcp_old(i,j)
           hbhp(i,j)=hb(i)*hcp_old(i,j)
        end do

     !-- 쥤꡼ԥ󥰹η׻

        do i=2,nr
           eup(i,j)=-epsu(i)*ucp_old(i,j)
           evp(i,j)=-epsv(i)*vcp_old(i,j)
           ehp(i,j)=-epsh(i)*hcp_old(i,j)
        end do

     !-- ꥪη׻

        do i=2,nr
           corilu(i,j)=coril(i,j)*ucp_old(i,j)
           corilv(i,j)=coril(i,j)*vcp_old(i,j)
        end do

     !-- ήη׻

        if(nl_flag.eqv..true.)then
           do i=2,nr
              updup(i,j)=ucp_old(i,j)*ducpdr(i,j)
              updvp(i,j)=ucp_old(i,j)*dvcpdr(i,j)
              vpdup(i,j)=vcp_old(i,j)*ducpdr(i,j)
              vpdvp(i,j)=vcp_old(i,j)*dvcpdr(i,j)
              updhp(i,j)=ucp_old(i,j)*dhcpdr(i,j)
              vpdhp(i,j)=vcp_old(i,j)*dhcpdr(i,j)
              upup(i,j)=ucp_old(i,j)*ucp_old(i,j)
              upvp(i,j)=ucp_old(i,j)*vcp_old(i,j)
              uphp(i,j)=ucp_old(i,j)*hcp_old(i,j)
              vpup(i,j)=vcp_old(i,j)*ucp_old(i,j)
              vpvp(i,j)=vcp_old(i,j)*vcp_old(i,j)
              vphp(i,j)=vcp_old(i,j)*hcp_old(i,j)
              hpup(i,j)=hcp_old(i,j)*ucp_old(i,j)
              hpvp(i,j)=hcp_old(i,j)*vcp_old(i,j)
              hphp(i,j)=hcp_old(i,j)*hcp_old(i,j)
           end do
        end if

     !-- ؤޤȤ
        do i=2,nr-1
           forceu(i,j)=img*(real(j-1)/real(hnt-1))*vbup(i,j)/rv(i)  &
  &                    +corilv(i,j)  &
  &                    -2.0*vbvp(i,j)/rv(i)  &
  &                    -g*(dhcpdr(i,j))  &
  &                    -(real(j-1)/real(hnt-1))**2*ucp_old(i,j)  &
  &                    +0.5*(ucp_old(i+1,j)+ucp_old(i-1,j)-2.0*ucp_old(i,j))/dr/dr  &
  &                    +eup(i,j)
           forcev(i,j)=-updvb(i,j)  &
  &                    +img*(real(j-1)/real(hnt-1))*vbvp(i,j)/rv(i)  &
  &                    -corilu(i,j)  &
  &                    -vbup(i,j)/rv(i)  &
  &                    +img*g*(real(j-1)/real(hnt-1))*hcp_old(i,j)/rv(i)  &
  &                    -(real(j-1)/real(hnt-1))**2*vcp_old(i,j)  &
  &                    +0.5*(vcp_old(i+1,j)+vcp_old(i-1,j)-2.0*vcp_old(i,j))/dr/dr  &
  &                    +evp(i,j)
           forceh(i,j)=-updhb(i,j)  &
  &                    +img*(real(j-1)/real(hnt-1))*vbhp(i,j)/rs(i)  &
  &                    -hbdup(i,j)  &
  &                    -hbup(i,j)/rs(i)  &
  &                    -(real(j-1)/real(hnt-1))**2*hcp_old(i,j)  &
  &                    +img*(real(j-1)/real(hnt-1))*hbvp(i,j)/rs(i)  &
  &                    +0.5*(hcp_old(i+1,j)+hcp_old(i-1,j)-2.0*hcp_old(i,j))/dr/dr  &
  &                    +ehp(i,j)
        end do

!write(*,*) "forceu", forceu
!write(*,*) "forcev", forcev
!write(*,*) "forceh", forceh

!--  ʬ (LF ˡ)

        select case (it)
        case (1)
           do i=2,nr
              ucp_new(i,j)=ucp_old(i,j)+dt*forceu(i,j)
              vcp_new(i,j)=vcp_old(i,j)+dt*forcev(i,j)
              hcp_new(i,j)=hcp_old(i,j)+dt*forceh(i,j)
           end do
        case default
           do i=2,nr-1
              ucp_new(i,j)=ucp_tmp(i,j)+2.0*dt*forceu(i,j)
              vcp_new(i,j)=vcp_tmp(i,j)+2.0*dt*forcev(i,j)
              hcp_new(i,j)=hcp_tmp(i,j)+2.0*dt*forceh(i,j)
           end do
        end select
     end do
!$omp end do
!$omp end parallel

!-- 

     do j=1,hnt
        ucp_new(1,j)=(0.0,0.0)
        vcp_new(1,j)=(0.0,0.0)
        hcp_new(1,j)=(0.0,0.0)
        ucp_new(nr,j)=ucp_new(nr-1,j)
        vcp_new(nr,j)=vcp_new(nr-1,j)
        hcp_new(nr,j)=hcp_new(nr-1,j)
     end do

  !-- ƥåפοʤ߶
     write(*,*) "This step is ", it, "(time =", real(it-1)*dt, "[s])."

  !-- ν
     do j=1,hnt
        do i=1,nr
           forceu(i,j)=(0.0,0.0)
           forcev(i,j)=(0.0,0.0)
           forceh(i,j)=(0.0,0.0)
        end do
     end do

  end do

!-- solver ȥå

  write(*,*) "solver is normally."

contains

subroutine cont_interpolation( icor, ocor, ival, oval )
!-- Ⱦʻ줿ؤޤԤ.
  use Statistics

  implicit none

  real, intent(in) :: icor(:)  ! κɸ
  real, intent(in) :: ocor(:)  ! ޸κɸ
  real, intent(in) :: ival(size(icor))  ! icor ѿ
  real, intent(inout) :: oval(size(ocor))  ! ocor ѿ
  integer :: i, ni, no, tmpi

  ni=size(icor)
  no=size(ocor)

  do i=1,no
     call interpo_search_1d( icor, ocor(i), tmpi )
     call interpolation_1d( (/icor(tmpi), icor(tmpi+1)/),  &
  &                         (/ival(tmpi), ival(tmpi+1)/),  &
  &                         ocor(i), oval(i) )
  end do

end subroutine

end program
