!---------------------------------------------------------------
! Copyright (C) 2009-2013 GFD Dennou Club. All rights reserved.
!---------------------------------------------------------------

module Map_Function
!  Ͽ޺ɸϤˤ뤤餫Ѵؿ

contains

real function dis2lon( x, lon0, phi0 )
!   lon0 ֵΥ x [m] Υ줿֤ˤ [rad].
!  ,  phi0 [rad] ƱپǷ¬ΥѤ.
!  x ˷׻ݤ, ˷׻ݤͤͿз׻ǽ.
  use Phys_Const
  use Math_Const
  implicit none
  real, intent(in) :: x     !  lon0 ζֵΥ [m] ()
  real, intent(in) :: lon0  !  [rad]
  real, intent(in) :: phi0  !  [rad]

  dis2lon=x/(radius*cos(phi0))+lon0

  return
end function

!---------------------------------

real function dis2lat( y, phi0 )
!   phi0 ֵΥ y [m] Υ줿֤ˤ [rad].
!  y ̤˷׻ݤ, ˷׻ݤͤͿз׻ǽ.
  use Phys_Const
  use Math_Const
  implicit none
  real, intent(in) :: y     !  phi0 ζֵΥ [m] (̸)
  real, intent(in) :: phi0  !  [rad]

  dis2lat=y/radius+phi0

  return
end function

!---------------------------------

!-- ʹ, Υȥ륫ȥɸϤˤٷѴؿ
real function dis2mlon(x,lam0)
!   lam0 Ͽ޵Υ x [m] Υ줿֤ˤ [rad].
!  , x , Ϳз׻ǽ.
  use Phys_Const
  implicit none
  real, intent(in) :: x     !  lam0 ζֵΥ [m] ()
  real, intent(in) :: lam0  !  [rad]

  dis2mlon=x/radius+lam0

  return
end function

!---------------------------------

real function dis2mlat(y,phi0)
!   phi0 ֵΥ y [m] Υ줿֤ˤ [rad].
!  , x , Ϳз׻ǽ.
  use Phys_Const
  use Math_Const
  implicit none
  real, intent(in) :: y     !  phi0 ζֵΥ [rad] (̸).
  real, intent(in) :: phi0  !  [rad]

  dis2mlat=asin(tanh(log(tan(0.25*pi+0.5*phi0))+y/radius))

  return
end function

!---------------------------------

real function lonlat2lamdis( lon, phi, lon0, phi1, phi2, phi0 )
!   phi1, phi2,  lon0 ٰ lon, phi [rad] Υ줿
!  ֤ޤǤϿ޾εΥ [m].
  use Phys_Const
  use Math_Const
  implicit none
  real, intent(in) :: lon     ! ᤿η [rad].
  real, intent(in) :: phi     ! ᤿ΰ [rad].
  real, intent(in) :: lon0  !  [rad]
  real, intent(in) :: phi1  !  1 [rad]
  real, intent(in) :: phi2  !  2 [rad]
  real, intent(in), optional :: phi0  ! Ͽ޺ɸ 0 [rad].
        ! phi0 ꤵƤ, y ɸεΥ.
  real :: n
  real :: rho, rho0

  n=log(cos(phi1)/cos(phi2))/log(tan(0.25*pi-0.5*phi1)/tan(0.25*pi-0.5*phi2))

  rho=(cos(phi1)*(tan(0.25*pi-0.5*phi))**n)/(n*(tan(0.25*pi-0.5*phi1))**n)

  if(present(phi0))then
     rho0=(cos(phi1)*(tan(0.25*pi-0.5*phi0))**n)/(n*(tan(0.25*pi-0.5*phi1))**n)
     lonlat2lamdis=rho0-rho*cos(n*(lon-lon0))
  else
     lonlat2lamdis=rho*sin(n*(lon-lon0))
  end if

  return
end function

!---------------------------------


end module
