module val_define
! 変数の定義
! 変数名の命名規則
! 実数 -> r, 純虚数 -> i, 複素数 -> c
! 平均場 -> b, 擾乱場 -> p
! 時間発展 -> old, new
!-- 配列および一貫変数は save 属性をつけて module を読み込んだときに値が
!  保存される仕様にする.

  implicit none

!-- value definition
!-- integer, save part
  integer, save :: nr  ! r 方向の配列個数
  integer, save :: ntheta  ! theta 方向の配列個数
  integer, save :: nt  ! 時間ステップ
  integer, save :: jnt  ! 非線形変換法における分点
  integer, save :: hnt  ! theta 方向の切断波数
  integer, save :: ni  ! r 方向の配列個数(初期値データ)
  integer, save :: nthetai  ! theta 方向の配列個数(初期値データ)
  integer, save :: dmpstp  ! ダンプ間隔
  integer, save :: init_n  ! 初期の波数

!-- logical part
  logical, save :: nl_flag  ! 非線形項計算を行うかどうかのフラグ

!-- real, save part
  real, save :: rmin  ! 動径方向内径
  real, save :: dis_reg  ! 接線方向計算距離 [m]
  real, save :: dr  ! 動径方向格子間隔
  real, save :: dt  ! 時間方向格子間隔
  real, save :: dtheta  ! 接線方向格子間隔
  real, save :: r_dmp  ! レイリーダンピングをかける半径
  real, save :: diff_r  ! 動径方向の拡散係数
  real, save :: diff_t  ! 接線方向の拡散係数
!-- 1d val
  real, save, allocatable, dimension(:) :: ri  ! スカラー動径座標初期値
  real, save, allocatable, dimension(:) :: thetai  ! 接線座標初期値
  real, save, allocatable, dimension(:) :: rs  ! スカラー動径座標
  real, save, allocatable, dimension(:) :: rv  ! ベクトル動径座標
  real, save, allocatable, dimension(:) :: theta  ! 接線座標
  real, save, allocatable, dimension(:) :: epsu  ! レイリーダンピング係数 u
  real, save, allocatable, dimension(:) :: epsv  ! レイリーダンピング係数 v
  real, save, allocatable, dimension(:) :: epsh  ! レイリーダンピング係数 h
!-- 2d val
  real, save, allocatable, dimension(:,:) :: hib  ! 初期ジオポテンシャル平均場
  real, save, allocatable, dimension(:,:) :: uib  ! 初期動径風平均場
  real, save, allocatable, dimension(:,:) :: vib  ! 初期接線風平均場
  real, save, allocatable, dimension(:,:) :: urp_dmp  ! 動径風速 dmp
  real, save, allocatable, dimension(:,:) :: vrp_dmp  ! 接線風速 dmp
  real, save, allocatable, dimension(:,:) :: hrp_dmp  ! ジオポテンシャル dmp
  real, save, allocatable, dimension(:,:) :: urp_old  ! 動径風速 old
  real, save, allocatable, dimension(:,:) :: vrp_old  ! 接線風速 old
  real, save, allocatable, dimension(:,:) :: hrp_old  ! ジオポテンシャル old
  real, save, allocatable, dimension(:,:) :: uip_old  ! 動径風速 old
  real, save, allocatable, dimension(:,:) :: vip_old  ! 接線風速 old
  real, save, allocatable, dimension(:,:) :: hip_old  ! ジオポテンシャル old
  real, save, allocatable, dimension(:,:) :: urp_new  ! 動径風速 new
  real, save, allocatable, dimension(:,:) :: vrp_new  ! 接線風速 new
  real, save, allocatable, dimension(:,:) :: hrp_new  ! ジオポテンシャル new
  real, save, allocatable, dimension(:,:) :: uip_new  ! 動径風速 new
  real, save, allocatable, dimension(:,:) :: vip_new  ! 接線風速 new
  real, save, allocatable, dimension(:,:) :: hip_new  ! ジオポテンシャル new
  real, save, allocatable, dimension(:,:) :: durpdr
  real, save, allocatable, dimension(:,:) :: dvrpdr
  real, save, allocatable, dimension(:,:) :: dhrpdr
  real, save, allocatable, dimension(:,:) :: duipdr
  real, save, allocatable, dimension(:,:) :: dvipdr
  real, save, allocatable, dimension(:,:) :: dhipdr
  real, save, allocatable, dimension(:,:) :: inv_up  ! 配列を入れ替える一時変数
  real, save, allocatable, dimension(:,:) :: inv_vp  ! 配列を入れ替える一時変数
  real, save, allocatable, dimension(:,:) :: inv_hp  ! 配列を入れ替える一時変数
  real, save, allocatable, dimension(:) :: coril  ! コリオリパラメータ

!-- complex, save part

  complex, parameter :: img=( 0.0, 1.0 )  ! 虚数単位

  complex, save, allocatable, dimension(:,:) :: ucp_dmp  ! 動径風速 old
  complex, save, allocatable, dimension(:,:) :: vcp_dmp  ! 接線風速 old
  complex, save, allocatable, dimension(:,:) :: hcp_dmp  ! ジオポテンシャル old
  complex, save, allocatable, dimension(:,:) :: ucp_tmp  ! 動径風速 old
  complex, save, allocatable, dimension(:,:) :: vcp_tmp  ! 接線風速 old
  complex, save, allocatable, dimension(:,:) :: hcp_tmp  ! ジオポテンシャル old
  complex, save, allocatable, dimension(:,:) :: ucp_old  ! 動径風速 old
  complex, save, allocatable, dimension(:,:) :: vcp_old  ! 接線風速 old
  complex, save, allocatable, dimension(:,:) :: hcp_old  ! ジオポテンシャル old
  complex, save, allocatable, dimension(:,:) :: ucp_new  ! 動径風速 new
  complex, save, allocatable, dimension(:,:) :: vcp_new  ! 接線風速 new
  complex, save, allocatable, dimension(:,:) :: hcp_new  ! ジオポテンシャル new
  complex, save, allocatable, dimension(:,:) :: ducpdr
  complex, save, allocatable, dimension(:,:) :: dvcpdr
  complex, save, allocatable, dimension(:,:) :: dhcpdr
  complex, save, allocatable, dimension(:,:) :: updup  ! updup
  complex, save, allocatable, dimension(:,:) :: updvp  ! updvp
  complex, save, allocatable, dimension(:,:) :: updhp  ! updhp
  complex, save, allocatable, dimension(:,:) :: vpdup  ! vpdup
  complex, save, allocatable, dimension(:,:) :: vpdvp  ! vpdvp
  complex, save, allocatable, dimension(:,:) :: vpdhp  ! vpdhp
  complex, save, allocatable, dimension(:,:) :: hpdup  ! hpdup
  complex, save, allocatable, dimension(:,:) :: hpdvp  ! hpdvp
  complex, save, allocatable, dimension(:,:) :: hpdhp  ! hpdhp
  complex, save, allocatable, dimension(:,:) :: upup  ! upup
  complex, save, allocatable, dimension(:,:) :: upvp  ! upvp
  complex, save, allocatable, dimension(:,:) :: uphp  ! uphp
  complex, save, allocatable, dimension(:,:) :: vpup  ! vpup
  complex, save, allocatable, dimension(:,:) :: vpvp  ! vpvp
  complex, save, allocatable, dimension(:,:) :: vphp  ! vphp
  complex, save, allocatable, dimension(:,:) :: hpup  ! hpup
  complex, save, allocatable, dimension(:,:) :: hpvp  ! hpvp
  complex, save, allocatable, dimension(:,:) :: hphp  ! hphp
  complex, save, allocatable, dimension(:,:) :: forceu  ! forceu
  complex, save, allocatable, dimension(:,:) :: forcev  ! forcev
  complex, save, allocatable, dimension(:,:) :: forceh  ! forceh
  complex, save, allocatable, dimension(:,:) :: forceua  ! forceu
  complex, save, allocatable, dimension(:,:) :: forceva  ! forcev
  complex, save, allocatable, dimension(:,:) :: forceha  ! forceh
  complex, save, allocatable, dimension(:,:) :: eup  ! レイリーダンピング項 u
  complex, save, allocatable, dimension(:,:) :: evp  ! レイリーダンピング項 v
  complex, save, allocatable, dimension(:,:) :: ehp  ! レイリーダンピング項 h
  complex, save, allocatable, dimension(:,:) :: corilu  ! コリオリ項 u
  complex, save, allocatable, dimension(:,:) :: corilv  ! コリオリ項 v
  complex, save, allocatable, dimension(:,:) :: fup  ! 非線形評価項
  complex, save, allocatable, dimension(:,:) :: fvp  ! 非線形評価項
  complex, save, allocatable, dimension(:,:) :: fhp  ! 非線形評価項
  complex, save, allocatable, dimension(:,:) :: fdupdr  ! 非線形評価項
  complex, save, allocatable, dimension(:,:) :: fdvpdr  ! 非線形評価項
  complex, save, allocatable, dimension(:,:) :: fdhpdr  ! 非線形評価項
  complex, save, allocatable, dimension(:,:) :: fdupdt  ! 非線形評価項
  complex, save, allocatable, dimension(:,:) :: fdvpdt  ! 非線形評価項
  complex, save, allocatable, dimension(:,:) :: fdhpdt  ! 非線形評価項
  complex, save, allocatable, dimension(:,:) :: frup  ! 非線形評価項
  complex, save, allocatable, dimension(:,:) :: frvp  ! 非線形評価項
  complex, save, allocatable, dimension(:,:) :: frhp  ! 非線形評価項
  complex, save, allocatable, dimension(:,:) :: frdupdr  ! 非線形評価項
  complex, save, allocatable, dimension(:,:) :: frdvpdr  ! 非線形評価項
  complex, save, allocatable, dimension(:,:) :: frdhpdr  ! 非線形評価項
  complex, save, allocatable, dimension(:,:) :: frdupdt  ! 非線形評価項
  complex, save, allocatable, dimension(:,:) :: frdvpdt  ! 非線形評価項
  complex, save, allocatable, dimension(:,:) :: frdhpdt  ! 非線形評価項
  complex, save, allocatable, dimension(:,:) :: fupup  ! 非線形評価項
  complex, save, allocatable, dimension(:,:) :: fupvp  ! 非線形評価項
  complex, save, allocatable, dimension(:,:) :: fuphp  ! 非線形評価項
  complex, save, allocatable, dimension(:,:) :: fvpvp  ! 非線形評価項
  complex, save, allocatable, dimension(:,:) :: fvphp  ! 非線形評価項
  complex, save, allocatable, dimension(:,:) :: fhphp  ! 非線形評価項
  complex, save, allocatable, dimension(:,:) :: fupdup  ! 非線形評価項
  complex, save, allocatable, dimension(:,:) :: fupdvp  ! 非線形評価項
  complex, save, allocatable, dimension(:,:) :: fupdhp  ! 非線形評価項
  complex, save, allocatable, dimension(:,:) :: fvpdup  ! 非線形評価項
  complex, save, allocatable, dimension(:,:) :: fvpdvp  ! 非線形評価項
  complex, save, allocatable, dimension(:,:) :: fvpdhp  ! 非線形評価項
  complex, save, allocatable, dimension(:,:) :: fhpdup  ! 非線形評価項
  complex, save, allocatable, dimension(:,:) :: fhpdvp  ! 非線形評価項
  complex, save, allocatable, dimension(:,:) :: fhpdhp  ! 非線形評価項
  complex, save, allocatable, dimension(:,:) :: fiupup  ! 非線形評価項
  complex, save, allocatable, dimension(:,:) :: fiupvp  ! 非線形評価項
  complex, save, allocatable, dimension(:,:) :: fiuphp  ! 非線形評価項
  complex, save, allocatable, dimension(:,:) :: fivpvp  ! 非線形評価項
  complex, save, allocatable, dimension(:,:) :: fivphp  ! 非線形評価項
  complex, save, allocatable, dimension(:,:) :: fihphp  ! 非線形評価項
  complex, save, allocatable, dimension(:,:) :: fiupdup  ! 非線形評価項
  complex, save, allocatable, dimension(:,:) :: fiupdvp  ! 非線形評価項
  complex, save, allocatable, dimension(:,:) :: fiupdhp  ! 非線形評価項
  complex, save, allocatable, dimension(:,:) :: fivpdup  ! 非線形評価項
  complex, save, allocatable, dimension(:,:) :: fivpdvp  ! 非線形評価項
  complex, save, allocatable, dimension(:,:) :: fivpdhp  ! 非線形評価項
  complex, save, allocatable, dimension(:,:) :: fihpdup  ! 非線形評価項
  complex, save, allocatable, dimension(:,:) :: fihpdvp  ! 非線形評価項
  complex, save, allocatable, dimension(:,:) :: fihpdhp  ! 非線形評価項



!-- character part
  character(80) :: finame  ! 初期値ファイル名
  character(80) :: foname  ! 結果値ファイル名
  character(1) :: time_flag  ! 時間スキームに関するフラグ
  character(10) :: force_flag  ! 強制項の各効果を入れるためのフラグ

!-- namelist の読み込み

end module
