program sound_make
!  台風外縁でのサウンディングファイルを作成するプログラム.
!  必要に応じて適宜書き換え.
!  単位はすべて MKS 単位.
  use Thermo_Function
  use Algebra
  use Phys_Const
  use Thermo_Const
  use Thermo_Function

  implicit none

!-- namelist valiables
  integer :: nr, nz  ! 水平・鉛直格子
  integer :: mom_flag
  real :: coril
  real :: dr, dz     ! 水平・鉛直格子間隔 [m]
  character(4) :: bc  ! not use
  character(80) :: fname  ! not use
  character(80) :: sound_name  ! サウンディングファイルの名前

  real, parameter :: t_s=300.0  ! 地表面温度
  real, parameter :: t_trop=200.0  ! 対流圏界面での温度
  real, parameter :: z_trop=15.0e3  ! 対流圏界面高度
  real, allocatable :: z(:)  ! 高度
  real, allocatable :: temp(:)  ! 温度
  real, allocatable :: theta(:)  ! 温位
  real, allocatable :: pres(:)  ! 気圧
  real, allocatable :: temp_inv(:)  ! 温度
  real :: gamma_dd  ! 温度減率
  real :: p_s  ! 地表面気圧, 図 3 から目視.

  integer :: i

!-- namelist からのパラメータの代入
  namelist /input /nr, nz, dr, dz, bc, fname, sound_name, coril, mom_flag
  read(5,nml=input)

!-- allocate
  allocate(z(nz))
  allocate(temp(nz))
  allocate(theta(nz))
  allocate(pres(nz))
  allocate(temp_inv(nz))

!-- 地表面気圧の計算
  p_s=1000.0e2


  z=(/(dz*real(i-1),i=1,nz)/)

  gamma_dd=(t_trop-t_s)/z_trop  ! 圏界面までの温度減率を設定 (constant)

  do i=1,nz
     if(z(i)<=z_trop)then
        temp(i)=t_s+gamma_dd*z(i)
     else
        temp(i)=t_trop
     end if
     temp_inv(i)=1.0/temp(i)
  end do

  pres(1)=p_s

  do i=2,nz
     pres(i)=p_s/((gamma_dd*z(i)/t_s+1.0)**(g/(Rd*gamma_dd)))  ! 等減率大気における静力学関係から得られる式を用いて計算する.
  end do

  do i=1,nz
     theta(i)=theta_dry( temp(i), pres(i) )
  end do

!-- サウンディングファイルへの書き出し.
  open(unit=10,file=trim(sound_name),status='unknown')
  write(*,*) "output the sounding file."
  write(10,*) "'height',  'temperature',  'pressure',  'potential temperature'"
  write(10,*) "'m',  'K',  'Pa',  'K'"
  do i=1,nz
     write(10,'(1P4E16.8)') z(i), temp(i), pres(i), theta(i)
  end do
  close(unit=10,status='keep')

end program
