module savegloval_alloc

!-- Allocate global variables in savegloval_define

contains

subroutine savegloval_allocate()

  use savegloval_define

  implicit none

  integer :: err

  err=0

  allocate(x(nx),stat=err)  ! ベクトル動径座標
  allocate(y(ny),stat=err)  ! 接線座標

  allocate(xd(nx),stat=err)  ! ベクトル動径座標
  allocate(yd(ny),stat=err)  ! 接線座標

  !-- 変換法用座標
  allocate(xj(jxnt),stat=err)
  allocate(yj(jynt),stat=err)

  allocate(xi(nxi),stat=err)
  allocate(yi(nyi),stat=err)

!ORG  allocate(t(nt))
  allocate(cr(jxnt,jynt),stat=err)
  allocate(cr_isp(jynt,jxnt),stat=err)
  allocate(zinit_isp(jynt,jxnt),stat=err)

  if(err/=0)then
     write(*,*) "*** ERROR (savegloval_allocate) *** : cannot allocate."
     stop
  end if

  !-- For ISPACK variables

  err=0
  allocate(TJR(2*ny),stat=err)
  allocate(TIR(2*nx),stat=err)
  allocate(ITJR(5),stat=err)
  allocate(ITIR(5),stat=err)
  allocate(TJJ(2*jynt),stat=err)
  allocate(TIJ(2*jxnt),stat=err)
  allocate(ITJJ(5),stat=err)
  allocate(ITIJ(5),stat=err)

  if(err/=0)then
     write(*,*) "*** ERROR (savegloval_allocate) *** : cannot allocate for ISPACK variables."
     stop
  end if

end subroutine savegloval_allocate

end module savegloval_alloc
