program test

  use sub_calc
  use file_operate
  use Math_Const
  use Phys_Const
  use Thermo_Const
  use Statistics
  use Thermo_Function
  use Max_Min
  use Derivation
  use Ellip_Slv
  use Thermo_Advanced_Routine

  implicit none

  integer, parameter :: nx=241, ny=253, nz=16
  integer :: i, j, k, l, nl, itmpx, itmpy, itmpz
  real, parameter :: lonmin=120.0, latmin=22.4, dlon=0.125, dlat=0.1
  real, parameter :: eps=1.0e-1, epsqgom=1.0e-1, eppsi=2.0e3
  real :: errmax
  real :: lon(nx), lat(ny), p(nz), pex(nz), lond(nx), latd(ny), f0(ny), tt_ref(nz)
  real, dimension(nx,ny) :: sx, sy, a1, a2, cor
  real, dimension(nx,ny,nz) :: qgpvb, zeta, bo_psi, rhoc
  real, dimension(nx,ny,nz) :: rub, rvb, rphib, rtb, rptb, qgpsib
  real, allocatable, dimension(:,:) :: t_ref
  real, allocatable, dimension(:,:,:,:) :: rut, rvt, rphit, rtt, rptt
  real, allocatable, dimension(:,:,:,:) :: qgut, qgvt, qgphit, qgtt, qgptt, qgpsit
  real, allocatable, dimension(:,:,:,:) :: eut, evt, ephit, ett, eptt, epsit
  real, allocatable, dimension(:,:,:,:) :: rzt, qgzt, ezt
  real, allocatable, dimension(:,:,:,:) :: qgpvt, epvt, qgomg, bomg
  real, allocatable, dimension(:,:,:,:) :: diaq, ercheck
  character(1000) :: lname
  character(1000), allocatable, dimension(:) :: fname

  write(*,*) "Input converting file list"
  read(*,*) lname

  lon=(/((lonmin+real(i-1)*dlon),i=1,nx)/)
  lat=(/((latmin+real(i-1)*dlat),i=1,ny)/)
  p=(/1000.0, 975.0, 950.0, 925.0, 900.0, 850.0, 800.0, 700.0, 600.0,  &
  &   500.0, 400.0, 300.0, 250.0, 200.0, 150.0, 100.0/)
  p=p*1.0e2
  lond=lon*pi/180.0
  latd=lat*pi/180.0
  pex=(p/p0)**(Rd/Cpd)
  f0=2.0*omega*sin(latd)

  do j=1,ny
     do i=1,nx
        sx(i,j)=radius*cos(latd(j))
        sy(i,j)=radius
        a1(i,j)=cos(latd(j))**2
        a2(i,j)=-sin(latd(j))*cos(latd(j))
        cor(i,j)=f0(j)
        do k=1,nz
           rhoc(i,j,k)=-g*(Rd/Cpd)*pex(k)/p(k)
        end do
     end do
  end do

  nl=line_number_counter( trim(lname) )
  allocate(fname(nl))
  call read_file_text( trim(lname), 1, nl, fname )

  allocate(t_ref(nz,nl))
  allocate(rut(nx,ny,nz,nl))
  allocate(rvt(nx,ny,nz,nl))
  allocate(rphit(nx,ny,nz,nl))
  allocate(rtt(nx,ny,nz,nl))
  allocate(rptt(nx,ny,nz,nl))
  allocate(qgut(nx,ny,nz,nl))
  allocate(qgvt(nx,ny,nz,nl))
  allocate(qgphit(nx,ny,nz,nl))
  allocate(qgpsit(nx,ny,nz,nl))
  allocate(qgtt(nx,ny,nz,nl))
  allocate(qgptt(nx,ny,nz,nl))
  allocate(eut(nx,ny,nz,nl))
  allocate(evt(nx,ny,nz,nl))
  allocate(ephit(nx,ny,nz,nl))
  allocate(epsit(nx,ny,nz,nl))
  allocate(ett(nx,ny,nz,nl))
  allocate(eptt(nx,ny,nz,nl))
  allocate(qgpvt(nx,ny,nz,nl))
  allocate(epvt(nx,ny,nz,nl))
  allocate(qgomg(nx,ny,nz,nl))
  allocate(bomg(nx,ny,nz,nl))
  allocate(diaq(nx,ny,nz,nl))
  allocate(ercheck(nx,ny,nz,nl))
  allocate(rzt(nx,ny,nz,nl))
  allocate(qgzt(nx,ny,nz,nl))
  allocate(ezt(nx,ny,nz,nl))

  do i=1,nl
  !-- reading data

     call read_file_3d( trim(fname(i)), nx, ny, nz, 1, rzt(:,:,:,i) )
     call read_file_3d( trim(fname(i)), nx, ny, nz, nz+1, rut(:,:,:,i) )
     call read_file_3d( trim(fname(i)), nx, ny, nz, 2*nz+1, rvt(:,:,:,i) )
     call read_file_3d( trim(fname(i)), nx, ny, nz, 4*nz+1, rtt(:,:,:,i) )

     do k=1,nz
        call Mean_2d( rtt(:,:,k,i), t_ref(k,i) )
        do j=1,ny
           do l=1,nx
              rphit(l,j,k,i)=rzt(l,j,k,i)*g
              rptt(l,j,k,i)=theta_dry( rtt(l,j,k,i), p(k) )
              ercheck(l,j,k,i)=rphit(l,j,k,i)
           end do
        end do
     end do
  end do

  do k=1,nz
     call Mean_1d( t_ref(k,:), tt_ref(k) )
  end do

  do i=1,nl
  !-- calculating QGPV
     call QG_PV( lond, latd, p, rphit(:,:,:,i), tt_ref, qgpvt(:,:,:,i) )

  !-- writing QGPV
     call write_file_3d( trim(fname(i))//'.pv', nx, ny, nz, 1,  &
  &                      qgpvt(:,:,:,i), mode='replace')

  !-- EPV check
  !-- calculating EPV
     call HEPV( lond, latd, pex, rut(:,:,:,i), rvt(:,:,:,i), rhoc,  &
  &             rptt(:,:,:,i), cor, epvt(:,:,:,i+1), sx=sx, sy=sy )

  !-- writing EPV
     call write_file_3d( trim(fname(i))//'.pv', nx, ny, nz, nz+1,  &
  &                      epvt(:,:,:,i), mode='old')
     write(*,*) "Finish : ", trim(fname(i))//'.pv'

  end do

  do k=1,nz
     do j=1,ny
        do i=1,nx
           call Mean_1d( rphit(i,j,k,:), rphib(i,j,k) )
           call Mean_1d( rut(i,j,k,:), rub(i,j,k) )
           call Mean_1d( rvt(i,j,k,:), rvb(i,j,k) )
           call Mean_1d( rtt(i,j,k,:), rtb(i,j,k) )
           call Mean_1d( qgpvt(i,j,k,:), qgpvb(i,j,k) )
           call Mean_1d( rptt(i,j,k,:), rptb(i,j,k) )
           qgpsib(i,j,k)=rphib(i,j,k)/(2.0*omega*sin(latd(ny/2)))
           do l=1,nl
              qgphit(i,j,k,l)=rphit(i,j,k,l)-rphib(i,j,k)
              qgut(i,j,k,l)=rut(i,j,k,l)-rub(i,j,k)
              qgvt(i,j,k,l)=rvt(i,j,k,l)-rvb(i,j,k)
              qgtt(i,j,k,l)=rtt(i,j,k,l)-rtb(i,j,k)
              qgpvt(i,j,k,l)=qgpvt(i,j,k,l)-qgpvb(i,j,k)
           end do
        end do
     end do
  end do

  do i=1,nl
  !-- calculating inversion dynamics and thermodynamics fields.
     call QGPV_inv( lond, latd, p, tt_ref, eps,  &
  &                 qgpvt(:,:,:,i), qgphit(:,:,:,i), qgtt(:,:,:,i),  &
  &                 qgut(:,:,:,i), qgvt(:,:,:,i), qgpsit(:,:,:,i) )

     do k=1,nz
        do j=1,ny
           do l=1,nx
              qgphit(l,j,k,i)=qgphit(l,j,k,i)+rphib(l,j,k)
              qgut(l,j,k,i)=qgut(l,j,k,i)+rub(l,j,k)
              qgvt(l,j,k,i)=qgvt(l,j,k,i)+rvb(l,j,k)
              qgtt(l,j,k,i)=qgtt(l,j,k,i)+rtb(l,j,k)
              qgpsit(l,j,k,i)=qgpsit(l,j,k,i)+qgpsib(l,j,k)
              ercheck(l,j,k,i)=abs(ercheck(l,j,k,i)-qgphit(l,j,k,i))
           end do
        end do
     end do

     call max_val_3d( ercheck(:,:,:,i), itmpx, itmpy, itmpz, errmax )
     write(*,*) "*** MESSAGE (main) ***"
     write(*,'(a16,I4,a2,I4,a2,I4,a2,1PE14.6,a5)')  &
  &             "max phi diff. : ", itmpx, ', ', itmpy, ', ', itmpz,  &
  &             ', ', errmax, " [J]."

     call QGOMG_inv( lond, latd, p, tt_ref, epsqgom,  &
  &                  qgphit(:,:,:,i), qgomg(:,:,:,i), diaq=diaq(:,:,:,i) )

     do k=1,nz
        do j=1,ny
           do l=1,nx
              qgzt(l,j,k,i)=qgphit(l,j,k,i)/g
           end do
        end do
     end do

  !-- writing inverted dynamics and thermodynamics data.
     call write_file_3d( trim(fname(i))//'.inv', nx, ny, nz, 1,  &
  &                      qgzt(:,:,:,i), mode='replace' )
     call write_file_3d( trim(fname(i))//'.inv', nx, ny, nz, nz+1, qgut(:,:,:,i) )
     call write_file_3d( trim(fname(i))//'.inv', nx, ny, nz, 2*nz+1, qgvt(:,:,:,i) )
     call write_file_3d( trim(fname(i))//'.inv', nx, ny, nz, 3*nz+1, qgtt(:,:,:,i) )
     call write_file_3d( trim(fname(i))//'.inv', nx, ny, nz, 4*nz+1, qgomg(:,:,:,i) )
     call write_file_3d( trim(fname(i))//'.inv', nx, ny, nz, 5*nz+1, qgpsit(:,:,:,i) )
     call write_file_3d( trim(fname(i))//'.inv', nx, ny, nz, 6*nz+1, rphib(:,:,:) )
     call write_file_3d( trim(fname(i))//'.inv', nx, ny, nz, 7*nz+1, qgpvt(:,:,:,i) )
     write(*,*) "Finish : ", trim(fname(i))//'.inv'

  end do

  !-- inverting EPV
  do i=1,nl

     do k=1,nz
        do j=1,ny
           do l=1,nx
              ephit(l,j,k,i)=qgphit(l,j,k,i)
              eut(l,j,k,i)=rut(l,j,k,i)
              evt(l,j,k,i)=rvt(l,j,k,i)
              eptt(l,j,k,i)=rptt(l,j,k,i)
              epsit(l,j,k,i)=qgpsit(l,j,k,i)
           end do
        end do
     end do

  !-- setting psi (u,v -> zeta -> psi)
     do k=1,nz
        call curl( lond, latd, rut(:,:,k,i), rvt(:,:,k,i), zeta(:,:,k),  &
  &                hx=sx, hy=sy )
        do j=1,ny
           do l=1,nx
              zeta(l,j,k)=zeta(l,j,k)*(radius*cos(latd(j)))**2
           end do
        end do
        do j=1,ny
           bo_psi(1,j,k)=rvt(1,j,k,i)*radius*cos(latd(j))
           bo_psi(nx,j,k)=rvt(nx,j,k,i)*radius*cos(latd(j))
        end do
        do l=1,nx
           bo_psi(l,1,k)=-rut(l,1,k,i)*radius
           bo_psi(l,ny,k)=-rut(l,ny,k,i)*radius
        end do
     end do
     do k=1,nz
        call Ellip_Jacobi_2d( lond, latd, zeta(:,:,k), eppsi, '2222',  &
  &                           epsit(:,:,k,i), bound_opt=bo_psi(:,:,k),  &
  &                           c=a1, e=a2, init_flag=.false. )
     end do

     write(*,*) "Finish : calculating psi."

     call EPV_varinv( lond, latd, pex,  &
  &                   epvt(:,:,:,i), ephit(:,:,:,i), eptt(:,:,:,i),  &
  &                   eut(:,:,:,i), evt(:,:,:,i), epsit(:,:,:,i),  &
  &                   ini_flag=.false. )

write(*,*) "Passing EPV"

!     call BOMG_inv( lond, latd, pex, eptt(:,:,1,i), eptt(:,:,nz,i),  &
!  &                 ephit(:,:,:,i), epsit(:,:,:,i),  &
!  &                 epvt(:,:,:,i), bomg(:,:,:,i), eut(:,:,:,i), evt(:,:,:,i) )

write(*,*) "Passing BOMG"

     do k=1,nz
        do j=1,ny
           do l=1,nx
              ezt(l,j,k,i)=ephit(l,j,k,i)/g
           end do
        end do
     end do

     call write_file_3d( trim(fname(i))//'.einv', nx, ny, nz, 1,  &
  &                      ezt(:,:,:,i), mode='replace' )
     call write_file_3d( trim(fname(i))//'.einv', nx, ny, nz, nz+1, eut(:,:,:,i) )
     call write_file_3d( trim(fname(i))//'.einv', nx, ny, nz, 2*nz+1, evt(:,:,:,i) )
     call write_file_3d( trim(fname(i))//'.einv', nx, ny, nz, 3*nz+1, eptt(:,:,:,i) )
     call write_file_3d( trim(fname(i))//'.einv', nx, ny, nz, 4*nz+1, epsit(:,:,:,i) )
     call write_file_3d( trim(fname(i))//'.einv', nx, ny, nz, 5*nz+1, bomg(:,:,:,i) )
     write(*,*) "Finish : ", trim(fname(i))//'.einv'
  end do

end program
