module saveval_alloc

! 変数の定義
! 変数名の命名規則
! 実数 -> r, 純虚数 -> i, 複素数 -> c
! 平均場 -> b, 擾乱場 -> p
! 時間発展 -> old, new
!-- Allocate working variables in saveval_define

contains

subroutine saveval_allocate()

  use savegloval_define
  use saveval_define

  implicit none

  integer :: err

  allocate(zi(nxi,nyi),stat=err)
  allocate(zor(nx,ny),stat=err)
  allocate(psiko(kxnt,kynt),stat=err)
  allocate(zko(kxnt,kynt),stat=err)
  allocate(psikn(kxnt,kynt),stat=err)
  allocate(pk(kxnt,kynt),stat=err)
  allocate(uko_mbl(kxnt,kynt,0:nzp+1),stat=err)
  allocate(vko_mbl(kxnt,kynt,0:nzp+1),stat=err)
  allocate(ukn_mbl(kxnt,kynt,0:nzp+1),stat=err)
  allocate(vkn_mbl(kxnt,kynt,0:nzp+1),stat=err)
  allocate(nbm_opt(kxnt,kynt),stat=err)
  allocate(mbl_optu(kxnt,kynt,0:nzp+1),stat=err)
  allocate(mbl_optv(kxnt,kynt,0:nzp+1),stat=err)
  allocate(tmpr(nx,ny),stat=err)
  allocate(tmpi(nx,ny),stat=err)

  allocate(u_nbm_isp(jynt,jxnt),stat=err)
  allocate(v_nbm_isp(jynt,jxnt),stat=err)

  if(err/=0)then
     write(*,*) "*** ERROR (saveval_allocate) *** : cannot allocate."
     stop
  end if

end subroutine saveval_allocate

end module saveval_alloc
