module time_scheme
! 時間スキームごとに計算を行うモジュール
! force_solv で計算した強制項の値をスキームに合わせて割り振り,
! 時間ステップを発展させる.
  use Derivation
  use ffts
  use max_min
  use Statistics
  use Math_Const
  use Phys_Const
  use special_function
  use val_define
  use read_namelist
  use val_alloc
  use val_coord
  use complex_initialize
  use force_solv

contains

subroutine time_schematic( step )

  implicit none
  integer, intent(in) :: step  ! タイムステップ番号
  integer :: ct, i, j

!-- スペクトル変数を実部・虚部に分割

  select case (time_flag(1:1))
  case ('1')  ! RK4 スキーム

  !-- 変数の更新
     do j=1,ntheta
        do i=1,nr
           ucp_tmp(i,j)=ucp_new(i,j)
           vcp_tmp(i,j)=vcp_new(i,j)
           hcp_tmp(i,j)=hcp_new(i,j)
           ucp_old(i,j)=ucp_new(i,j)
           vcp_old(i,j)=vcp_new(i,j)
           hcp_old(i,j)=hcp_new(i,j)
        end do
     end do

  !-- RK4 のときのみ用いる全強制変数の初期化 force_solv とは独立で RK4 のときのみ動作する.

     call complex_init( forceua )
     call complex_init( forceva )
     call complex_init( forceha )
!     do j=1,ntheta
!        do i=1,nr
!           forceua(i,j)=(0.0,0.0)
!           forceva(i,j)=(0.0,0.0)
!           forceha(i,j)=(0.0,0.0)
!        end do
!     end do

     do ct=1,4  ! RK4 の傾きをそれぞれ計算

     !-- 強制項を計算.

        call force()

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(j,i)
        do j=1,hnt+1
           do i=2,nr-1
              select case (ct)
              case (1)
                 forceua(i,j)=forceua(i,j)+forceu(i,j)
                 forceva(i,j)=forceva(i,j)+forcev(i,j)
                 forceha(i,j)=forceha(i,j)+forceh(i,j)
              case (2)
                 forceua(i,j)=forceua(i,j)+2.0*forceu(i,j)
                 forceva(i,j)=forceva(i,j)+2.0*forcev(i,j)
                 forceha(i,j)=forceha(i,j)+2.0*forceh(i,j)
              case (3)
                 forceua(i,j)=forceua(i,j)+2.0*forceu(i,j)
                 forceva(i,j)=forceva(i,j)+2.0*forcev(i,j)
                 forceha(i,j)=forceha(i,j)+2.0*forceh(i,j)
              case (4)
                 forceua(i,j)=forceua(i,j)+forceu(i,j)
                 forceva(i,j)=forceva(i,j)+forcev(i,j)
                 forceha(i,j)=forceha(i,j)+forceh(i,j)
              end select
           end do

!write(*,*) "forceu", forceu
!write(*,*) "forcev", forcev
!write(*,*) "forceh", forceh

!--  時間積分 (RK4 法)

           select case (ct)
           case (1)
              do i=2,nr-1
                 ucp_old(i,j)=ucp_tmp(i,j)+(0.5*dt)*forceu(i,j)
                 vcp_old(i,j)=vcp_tmp(i,j)+(0.5*dt)*forcev(i,j)
                 hcp_old(i,j)=hcp_tmp(i,j)+(0.5*dt)*forceh(i,j)
              end do
           case (2)
              do i=2,nr-1
                 ucp_old(i,j)=ucp_tmp(i,j)+(0.5*dt)*forceu(i,j)
                 vcp_old(i,j)=vcp_tmp(i,j)+(0.5*dt)*forcev(i,j)
                 hcp_old(i,j)=hcp_tmp(i,j)+(0.5*dt)*forceh(i,j)
              end do
           case (3)
              do i=2,nr-1
                 ucp_old(i,j)=ucp_tmp(i,j)+(dt)*forceu(i,j)
                 vcp_old(i,j)=vcp_tmp(i,j)+(dt)*forcev(i,j)
                 hcp_old(i,j)=hcp_tmp(i,j)+(dt)*forceh(i,j)
              end do
           case (4)
              do i=2,nr-1
                 ucp_new(i,j)=ucp_tmp(i,j)+(dt/6.0)*forceua(i,j)
                 vcp_new(i,j)=vcp_tmp(i,j)+(dt/6.0)*forceva(i,j)
                 hcp_new(i,j)=hcp_tmp(i,j)+(dt/6.0)*forceha(i,j)
              end do
           end select
        end do
!$omp end do
!$omp end parallel
!-- 境界条件の設定

        do j=1,hnt+1
           ucp_new(1,j)=(0.0,0.0)
           vcp_new(1,j)=(0.0,0.0)
           hcp_new(1,j)=(0.0,0.0)
           ucp_new(nr,j)=ucp_new(nr-1,j)
           vcp_new(nr,j)=vcp_new(nr-1,j)
           hcp_new(nr,j)=hcp_new(nr-1,j)
        end do

!-- 複素共役の配列については, 計算せずに, 共役を返すだけ.
        do j=2,hnt+1
           do i=1,nr
              ucp_new(i,hnt+j)=conjg(ucp_new(i,hnt-j+3))
              vcp_new(i,hnt+j)=conjg(vcp_new(i,hnt-j+3))
              hcp_new(i,hnt+j)=conjg(hcp_new(i,hnt-j+3))
           end do
        end do

     end do

  case ('2')  ! Leap Frog スキーム

     if(step==1)then
        do j=1,hnt+1
           do i=2,nr
              ucp_tmp(i,j)=ucp_new(i,j)  ! old (今) を tmp (1 ステップ前) に.
              vcp_tmp(i,j)=vcp_new(i,j)
              hcp_tmp(i,j)=hcp_new(i,j)
              ucp_old(i,j)=ucp_new(i,j)  ! new (1 ステップ先) を old (今) に.
              vcp_old(i,j)=vcp_new(i,j)
              hcp_old(i,j)=hcp_new(i,j)
           end do
        end do
     else
        do j=1,hnt+1
           do i=2,nr
              ucp_tmp(i,j)=ucp_old(i,j)  ! old (今) を tmp (1 ステップ前) に.
              vcp_tmp(i,j)=vcp_old(i,j)
              hcp_tmp(i,j)=hcp_old(i,j)
              ucp_old(i,j)=ucp_new(i,j)  ! new (1 ステップ先) を old (今) に.
              vcp_old(i,j)=vcp_new(i,j)
              hcp_old(i,j)=hcp_new(i,j)
           end do
        end do
     end if

  !-- 強制項を計算.

     call force()

     if(step==1)then

!$omp parallel default(shared)
!$omp do private(j,i)
        do j=1,hnt+1
           do i=2,nr-1
              ucp_new(i,j)=ucp_old(i,j)+dt*forceu(i,j)
              vcp_new(i,j)=vcp_old(i,j)+dt*forcev(i,j)
              hcp_new(i,j)=hcp_old(i,j)+dt*forceh(i,j)
           end do
        end do
!$omp end do
!$omp end parallel

     else

!$omp parallel default(shared)
!$omp do private(j,i)
        do j=1,hnt+1
           do i=2,nr-1
              ucp_new(i,j)=ucp_tmp(i,j)+2.0*dt*forceu(i,j)
              vcp_new(i,j)=vcp_tmp(i,j)+2.0*dt*forcev(i,j)
              hcp_new(i,j)=hcp_tmp(i,j)+2.0*dt*forceh(i,j)
           end do
        end do
!$omp end do
!$omp end parallel

     end if

!-- 境界条件の設定

     do j=1,hnt+1
        ucp_new(1,j)=(0.0,0.0)
        vcp_new(1,j)=(0.0,0.0)
        hcp_new(1,j)=(0.0,0.0)
        ucp_new(nr,j)=ucp_new(nr-1,j)
        vcp_new(nr,j)=vcp_new(nr-1,j)
        hcp_new(nr,j)=hcp_new(nr-1,j)
     end do

!-- 複素共役の配列については, 計算せずに, 共役を返すだけ.
     do j=2,hnt+1
        do i=1,nr
           ucp_new(i,hnt+j)=conjg(ucp_new(i,hnt-j+3))
           vcp_new(i,hnt+j)=conjg(vcp_new(i,hnt-j+3))
           hcp_new(i,hnt+j)=conjg(hcp_new(i,hnt-j+3))
        end do
     end do

  end select



end subroutine

end module
