module time_scheme
! 時間スキームごとに計算を行うモジュール
! force_solv で計算した強制項の値をスキームに合わせて割り振り,
! 時間ステップを発展させる.
  use Derivation
  use Ellip_Slv
  use max_min
  use Statistics
  use Math_Const
  use Phys_Const
  use val_define
  use read_namelist
  use val_alloc
  use val_coord
  use real_initialize
  use sub_calc
  use force_solv

contains

subroutine time_schematic( step )

  implicit none
  integer, intent(in) :: step  ! タイムステップ番号
  integer :: ct, i, j

!-- スペクトル変数を実部・虚部に分割

  select case (time_flag(1:1))
  case ('1')  ! RK4 スキーム

  !-- 変数の更新
     do j=1,ny
        do i=1,nx
           omega_tmp(i,j)=omega_new(i,j)
           omega_old(i,j)=omega_new(i,j)
           psi_old(i,j)=psi_new(i,j)
        end do
     end do

  !-- RK4 のときのみ用いる全強制変数の初期化 force_solv とは独立で RK4 のときのみ動作する.

     call real_init( forcea_omega )

     do ct=1,4  ! RK4 の傾きをそれぞれ計算

     !-- 強制項を計算.

        call force()

!--  時間積分 (RK4 法)
!$omp parallel default(shared)
!$omp do schedule(dynamic) private(j,i)
        do j=1,ny
           do i=1,nx
              if(calc_flag(i,j).eqv..true.)then
                 select case (ct)
                 case (1)
                    forcea_omega(i,j)=forcea_omega(i,j)+force_omega(i,j)
                    omega_old(i,j)=omega_tmp(i,j)+(0.5*dt)*force_omega(i,j)
                 case (2)                         
                    forcea_omega(i,j)=forcea_omega(i,j)+2.0*force_omega(i,j)
                    omega_old(i,j)=omega_tmp(i,j)+(0.5*dt)*force_omega(i,j)
                 case (3)                         
                    forcea_omega(i,j)=forcea_omega(i,j)+2.0*force_omega(i,j)
                    omega_old(i,j)=omega_tmp(i,j)+(dt)*force_omega(i,j)
                 case (4)                         
                    forcea_omega(i,j)=forcea_omega(i,j)+force_omega(i,j)
                    omega_new(i,j)=omega_tmp(i,j)+(dt/6.0)*forcea_omega(i,j)
                 end select
              end if
           end do
        end do
!$omp end do
!$omp end parallel

!-- 内部領域の渦度場から流線関数場を逆算

        pois_force=0.0

        do j=1,ny
           do i=1,nx
              if(calc_flag(i,j).eqv..false.)then
                 omega_new(i,j)=undef
                 pois_force(i,j)=undef
              else
                 select case (ct)
                 case (1,2,3)
                    pois_force(i,j)=-omega_old(i,j)
                 case (4)
                    pois_force(i,j)=-omega_new(i,j)
                 end select
              end if
           end do
        end do

        select case (ct)
        case (1,2,3)
           call Ellip_Jacobi_2d( x, y, pois_force, eps, boundary, psi_old,  &
  &                              bound_opt=bndp, c=x2_inv_2d, d=x_inv_2d,  &
   &                             undef=undef, inner_bound=ibp,  &
  &                              init_flag=.false. )

           call set_omega_inner( x, y, psi_old, ibo, bndo )
           call bound_set( x, y, omega_old, ibo, bndo, undef )

        case (4)
           call Ellip_Jacobi_2d( x, y, pois_force, eps, boundary, psi_new,  &
  &                              bound_opt=bndp, c=x2_inv_2d, d=x_inv_2d,  &
  &                              undef=undef, inner_bound=ibp,  &
  &                              init_flag=.false. )

        end select

     end do

!-- 境界条件の設定
!-- 一般流の流入口 -> 流速一定 => psi : 流れに垂直な方向に線形変化, omega : 0
!-- 一般流の流出口 -> 口に垂直な流れはない => psi, omega : ノイマンフラックスゼロ条件
!-- 側壁 -> 自由すべり条件 -> psi は流入口と同じ値で一定, omega : 0
!-- 内部境界 -> すべりなし -> psi : 0, omega : 内側の psi からの変動値.

     call set_omega_inner( x, y, psi_new, ibo, bndo )
     call bound_set( x, y, omega_new, ibo, bndo, undef )

  case ('2')  ! Leap Frog スキーム

     if(step==1)then
        do j=1,ny
           do i=1,nx
              if(calc_flag(i,j).eqv..true.)then
                 omega_tmp(i,j)=omega_new(i,j)  ! old (今) を tmp (1 ステップ前) に.
                 omega_old(i,j)=omega_new(i,j)  ! new (1 ステップ先) を old (今) に.
              end if
           end do
        end do
     else
        do j=1,ny
           do i=1,nx
              if(calc_flag(i,j).eqv..true.)then
                 omega_tmp(i,j)=omega_old(i,j)  ! old (今) を tmp (1 ステップ前) に.
                 omega_old(i,j)=omega_new(i,j)  ! new (1 ステップ先) を old (今) に.
              end if
           end do
        end do
     end if

  !-- 強制項を計算.

     call force()

     if(step==1)then

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(j,i)
        do j=1,ny
           do i=1,nx
              if(calc_flag(i,j).eqv..true.)then
                 omega_new(i,j)=omega_old(i,j)+dt*force_omega(i,j)
              end if
           end do
        end do
!$omp end do
!$omp end parallel

     else

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(j,i)
        do j=1,ny
           do i=1,nx
              if(calc_flag(i,j).eqv..true.)then
                 omega_new(i,j)=omega_tmp(i,j)+2.0*dt*force_omega(i,j)
              end if
           end do
        end do
!$omp end do
!$omp end parallel

     end if

!-- 内部領域の渦度場から流線関数場を逆算

     do j=1,ny
        do i=1,nx
           if(calc_flag(i,j).eqv..false.)then
              omega_new(i,j)=undef
              pois_force(i,j)=undef
           else
              pois_force(i,j)=-omega_new(i,j)
           end if
        end do
     end do

     call Ellip_Jacobi_2d( x, y, pois_force, eps, boundary, psi_new,  &
  &                        bound_opt=bndp, c=x2_inv_2d, d=x_inv_2d,  &
  &                        undef=undef, inner_bound=ibp,  &
  &                        init_flag=.false. )

!-- 境界条件の設定
!-- 一般流の流入口 -> 流速一定 => psi : 流れに垂直な方向に線形変化, omega : 0
!-- 一般流の流出口 -> 口に垂直な流れはない => psi, omega : ノイマンフラックスゼロ条件
!-- 側壁 -> 自由すべり条件 -> psi は流入口と同じ値で一定, omega : 0
!-- 内部境界 -> すべりなし -> psi : 0, omega : 内側の psi からの変動値.

     call set_omega_inner( x, y, psi_new, ibo, bndo )
     call bound_set( x, y, omega_new, ibo, bndo, undef )

  end select



end subroutine

end module
