program solver
! A coupled model of a slab-boundary layer and a non-divergent barotropic layer
! in Kuo et al. (2016; JGR)
!-- gtool5 library
  use gtool_history

!-- STPK library
  use Math_Const
  use Phys_Const
  use statistics

!-- local modules
  use savegloval_define
  use saveval_define
  use savegloval_alloc
  use saveval_alloc
  use read_namelist
  use sub_mod
  use val_coord
  use fftsub_mod
  use file_output
  use time_scheme

  implicit none

!-- do loop 用変数の定義
  integer :: i, j, it, subm
  integer :: access, status

  type(GT_HISTORY) :: dmp_hst

!-- namelist の読み込み

  call read_name()

write(*,*) "Read namelist file."

!-- allocating array

  call savegloval_allocate()
  call saveval_allocate()

write(*,*) "Allocate global and local save variables."

!-- 変数の初期値化

  call all_clear()

write(*,*) "Initialize the global and local save variables."

!-- 格子点の再定義

  call val_coordinate()

write(*,*) "Set coordinates."

!-- 定数係数の設定

  f0=2.0d0*omega_dp*dsin(cent_lat*pi_dp/180.0d0)

write(*,*) "Set physical constants."
write(*,'(a5,1PE16.8)') "f0 = ", f0
write(*,'(a5,1PE16.8)') "rho0 = ", rho0

!-- stretching 時の係数設定

  if(flag_stretch.eqv..true.)then
     !-- x, y 座標は xi, yi と同じと仮定している (zi, cr は内挿用変数, ここだけで使う).
     call HistoryGet( trim(sth_fname), trim(adjustl(inixd)), xi )
     call HistoryGet( trim(sth_fname), trim(adjustl(iniyd)), yi )
     call HistoryGet( trim(sth_fname), trim(adjustl(sth_vname)), zi )
     write(*,*) "starting interpolation of stretching coefficient."
     call auto_interpolation_2d( xi, yi, xj, yj, zi, cr )
     call rearrange_rxy2ryx( jxnt, jynt, cr(1:jxnt,1:jynt),  &
  &                          cr_isp(1:jynt,1:jxnt) )
     write(*,*) "starting interpolation of the initial vorticity."
     call HistoryGet( trim(ininame), trim(adjustl(iniz)), zi )
     call auto_interpolation_2d( xi, yi, xj, yj, zi, cr )
     call rearrange_rxy2ryx( jxnt, jynt, cr(1:jxnt,1:jynt),  &
  &                          zinit_isp(1:jynt,1:jxnt) )
  end if

write(*,*) "starting initialization for ISPACK."

!-- Initializing FFT

  !-- No change for ITJ, TJ, ITI, TI
  CALL P2INIT( ny, nx, ITJR, TJR, ITIR, TIR )
  CALL P2INIT( jynt, jxnt, ITJJ, TJJ, ITIJ, TIJ )

!-- reading initial data
  if(resopt==0)then

     call HistoryGet( trim(ininame), trim(adjustl(inixd)), xi )
     call HistoryGet( trim(ininame), trim(adjustl(iniyd)), yi )
!     call HistoryGet( trim(ininame), trim(adjustl(inif)), fi )
     call HistoryGet( trim(ininame), trim(adjustl(iniz)), zi )
     nrt=1

     !-- 初期データからモデルにおける物理・スペクトル空間への置き換え
     write(*,*) "starting interpolation of initial data."
!     call auto_interpolation_1d( yi, y, fi, coril )
     call auto_interpolation_2d( xi, yi, x, y, zi, zor )

!  call grad_1d( y, coril, betaf )

     !-- setting psi
     write(*,*) "setting initial data of psi."
     call phys2spec( zor(1:nx,1:ny), zko(1:kxnt,1:kynt) )

     basezeta=zko(1,1)
     call zetak2psik( zko(1:kxnt,1:kynt), psiko(1:kxnt,1:kynt) )
     call psik2zetak( psiko(1:kxnt,1:kynt), zko(1:kxnt,1:kynt), basezeta )

     write(*,*) "normally pass the initialization in NBM."

     !-- Initialization in SBL
     !-- First, uko_sbl, vko_sbl = uko_nbm, vko_nbm
     call psik2ukvk( psiko(1:kxnt,1:kynt), uko_sbl(1:kxnt,1:kynt),  &
  &                  vko_sbl(1:kxnt,1:kynt) )
     call time_integration_NBM( 1, psiko(1:kxnt,1:kynt), psikn(1:kxnt,1:kynt),  &
  &                             pk=pk(1:kxnt,1:kynt), u_isp=u_nbm_isp(1:jynt,1:jxnt),  &
  &                             v_isp=v_nbm_isp(1:jynt,1:jxnt) )

     if(calc_sbl_flag.eqv..true.)then
        do it=1,i_adj
           call time_integration_SBL( it, pk(1:kxnt,1:kynt), u_nbm_isp(1:jynt,1:jxnt),  &
  &                                   v_nbm_isp(1:jynt,1:jxnt), uko_sbl(1:kxnt,1:kynt),  &
  &                                   vko_sbl(1:kxnt,1:kynt), ukn_sbl(1:kxnt,1:kynt),  &
  &                                   vkn_sbl(1:kxnt,1:kynt), sbl_optu=sbl_optu(1:kxnt,1:kynt),  &
  &                                   sbl_optv=sbl_optv(1:kxnt,1:kynt) )
           uko_sbl(1:kxnt,1:kynt)=ukn_sbl(1:kxnt,1:kynt)
           vko_sbl(1:kxnt,1:kynt)=vkn_sbl(1:kxnt,1:kynt)
        end do
     end if

     write(*,*) "normally pass the initialization in SBL."

  else if(resopt==1)then

     call HistoryGetAttr( trim(adjustl(resfname)), trim(adjustl(respsir)),  &
  &                       trim(adjustl(restn)), nrt )
     call HistoryGetAttr( trim(adjustl(resfname)), trim(adjustl(respsir)),  &
  &                       trim(adjustl(rest)), restime )

     write(*,*) "Start as restart mode. nrt, restime = ", nrt, restime

     select case (time_flag(1:3))
     case ('L-F','AB2')
        call read_restart( trim(adjustl(resfname)), psiko, zko, uko_sbl,  &
  &                        vko_sbl, nbm_opt, sbl_optu, sbl_optv )
     case default
        call read_restart( trim(adjustl(resfname)), psiko, zko, uko_sbl,  &
  &                        vko_sbl )
     end select

     basezeta=zko(1,1)

     !-- calculation of pk and {u,v}_nbm_isp
     call time_integration_NBM( 1, psiko(1:kxnt,1:kynt), psikn(1:kxnt,1:kynt),  &
  &                             pk=pk(1:kxnt,1:kynt), u_isp=u_nbm_isp(1:jynt,1:jxnt),  &
  &                             v_isp=v_nbm_isp(1:jynt,1:jxnt) )

  end if

!-- Initializing output file
  call output_initialization( dmp_hst )
  
  write(*,*) "time integration start."

  if(resopt==0)then
     !-- Output the initial values
     call dmp_file( psiko(1:kxnt,1:kynt), uko_sbl(1:kxnt,1:kynt),  &
  &                 vko_sbl(1:kxnt,1:kynt), pk, 0, dmp_hst )
  end if

!-- Start time integration

  do it=nrt,nt

     if((calc_nbm_flag.eqv..true.).and.(calc_sbl_flag.eqv..true.))then
        call time_integration( it, psiko, uko_sbl, vko_sbl,  &
  &                            psikn, ukn_sbl, vkn_sbl, pk,  &
  &                            nbm_opt=nbm_opt, sbl_optu=sbl_optu,  &
  &                            sbl_optv=sbl_optv )
     else
        if(calc_nbm_flag.eqv..true.)then
           call time_integration_NBM( it, psiko(1:kxnt,1:kynt), psikn(1:kxnt,1:kynt) )
        else if(calc_sbl_flag.eqv..true.)then
           call time_integration_SBL( it, pk(1:kxnt,1:kynt), u_nbm_isp(1:jynt,1:jxnt),  &
  &                                   v_nbm_isp(1:jynt,1:jxnt), uko_sbl(1:kxnt,1:kynt),  &
  &                                   vko_sbl(1:kxnt,1:kynt), ukn_sbl(1:kxnt,1:kynt),  &
  &                                   vkn_sbl(1:kxnt,1:kynt), sbl_optu=sbl_optu(1:kxnt,1:kynt),  &
  &                                   sbl_optv=sbl_optv(1:kxnt,1:kynt) )
           psikn=psiko
        end if
     end if

     psiko=psikn
     uko_sbl=ukn_sbl
     vko_sbl=vkn_sbl

  !-- ステップの進み具合出力
     write(*,*) "This step is ", it, "(time =", dble(it)*dt, "[s])."

     !-- 出力等の処理 (2)
     if(mod(it,dmpstp)==0)then  ! 逆変換を行い実数出力する.

        call dmp_file( psiko(1:kxnt,1:kynt), uko_sbl(1:kxnt,1:kynt),  &
  &                    vko_sbl(1:kxnt,1:kynt), pk, it, dmp_hst )

     end if

     !-- リスタートファイル出力処理
     if(mod(it,restp)==0)then

        call psik2zetak( psiko(1:kxnt,1:kynt), zko(1:kxnt,1:kynt), zkopt=basezeta )

        select case (time_flag(1:3))
        case ('L-F','AB2')
           call make_restart( it+1, real(it)*real(dt), psiko, uko_sbl,  &
  &                           vko_sbl, zko, nbm_opt, sbl_optu, sbl_optv )
        case default
           call make_restart( it+1, real(it)*real(dt), psiko, uko_sbl,  &
  &                           vko_sbl, zko )
        end select

     end if

  end do

!-- solver ストップ

  call HistoryClose( history=dmp_hst )

  write(*,*) "solver is normally."

end program solver
