program poison
  use gtool_history
  use Alge_Solv

  implicit none

  integer :: nx, ny
  integer :: i, j
  real :: dx, dy
  real, allocatable :: x(:), y(:)
  real, allocatable :: rho(:,:)
  real, allocatable :: psi(:,:)
  integer :: method
  character(4) :: tp

 namelist /input /nx,ny,tp,method
 read(5,input)

  allocate(x(nx))
  allocate(y(ny))
  allocate(psi(nx,ny))
  allocate(rho(nx,ny))

  dx=1.0/real(nx-1)
  dy=1.0/real(ny-1)

  x=(/(dx*(i-1),i=1,nx)/)
  y=(/(dy*(i-1),i=1,ny)/)

  rho=0.0
! do i=1,nx
! do j=1,ny
! rho(i,j)=exp(-10.0*((x(i)-0.5)**2+(y(j)-0.5)**2))
! end do
! end do
  do i=1,nx
     do j=1,ny

        if((((i-50)**2+(j-50)**2)*dx*dy)<0.05*0.05)then

           rho(i,j)=-1.0e4/8.85

        end if

     end do
  end do
 
  select case (method)
  case(1)
     call Poisson_GauSei(x,y,rho,1.0e-6,tp,psi)
  case(2)
     call Poisson_Jacobi(x,y,rho,1.0e-6,tp,psi)
  end select

!-- gtool history (netcdf dump)

  call HistoryCreate( &                             ! ҥȥ꡼
    & file='poison.nc', title='poison model', &
    & source='Sample program of gtool_history/gtool5',   &
    & institution='GFD_Dennou Club davis project',       &
    & dims=(/'x','y'/), dimsizes=(/nx,ny/),               &
    & longnames=(/'X-coordinate','Y-coordinate'/),       &
    & units=(/'m','m'/),                                 &
    & origin=0.0, interval=0.0 )
  
  call HistoryPut( 'x', x )                            ! ѿ
  call HistoryPut( 'y', y )                            ! ѿ

  call HistoryAddVariable( &                           ! ѿ
    & varname='psi', dims=(/'x','y'/), &
    & longname='psi', units='1', xtype='float')

  call HistoryPut('psi',psi)                         ! ѿ

  call HistoryAddVariable( &                           ! ѿ
    & varname='rho', dims=(/'x','y'/), &
    & longname='forcing', units='1', xtype='float')

  call HistoryPut('rho',rho)                         ! ѿ
  call HistoryClose

end program
