!---------------------------------------------------------------
! Copyright (C) 2009-2015 GFD Dennou Club. All rights reserved.
!---------------------------------------------------------------

module Phys_Const  ! 物理(力学)定数集
  ! 単位はすべて MKS 単位系
  implicit none
  real, parameter :: omega=7.291893328e-5    ! 地球の自転角速度 [1 / s]
  real, parameter :: g=9.80665        ! 重力加速度 [m^2 / s]
  real, parameter :: radius=6.371e6   ! 地球の極半径 [m]
!  real, parameter :: radius=6.378e6   ! 地球の極半径 [m]
  real, parameter :: Me=5.9736e24     ! 地球の質量 [kg]
  real, parameter :: kB=1.380658e-23  ! ボルツマン定数 [J/K]

  double precision, parameter :: omega_dp=7.2918933286303412732d-5    ! 地球の自転角速度 [1 / s]
  double precision, parameter :: g_dp=9.80665d0      ! 重力加速度 [m^2 / s]
  double precision, parameter :: radius_dp=6.371d6   ! 地球の極半径 [m]
!  double precision, parameter :: radius_dp=6.378d6   ! 地球の極半径 [m]
  double precision, parameter :: Me_dp=5.9736d24     ! 地球の質量 [kg]
  double precision, parameter :: kB_dp=1.380658d-23  ! ボルツマン定数 [J/K]

end module
