!---------------------------------------------------------------
! Copyright (C) 2009-2015 GFD Dennou Club. All rights reserved.
!---------------------------------------------------------------

module Math_Function
! 数値変換等を行う関数集

contains

subroutine digit_conv( numb, digit, numa )
! 任意の整数 numb を digit 進数の文字列 numa に変換するルーチン
! 参考 URL:http://www2.cc.niigata-u.ac.jp/~takeuchi/
  implicit none
  integer, intent(in) :: numb  ! 変換する 10 進数
  integer, intent(in) :: digit  ! 変換する進数数
  character(*), intent(inout) :: numa  ! 変換後の文字列
  character(1) :: tmpc
  integer :: tmpi, tmpci

  tmpi=numb
  numa=''
  do while((tmpi/digit)/=0)
     tmpci=mod(tmpi,digit)
     tmpi=tmpi/digit
     write(tmpc,'(i1)') tmpci
     numa=tmpc//numa
  end do
  tmpci=mod(tmpi,digit)
  tmpi=tmpi/digit
  write(tmpc,'(i1)') tmpci
  numa=tmpc//numa

  return

end subroutine

character(1) function digit_char_conv( num )
! 進数変換の際, それに対応する文字列を返す関数.
! たとえば, 10 進数から 16 進数への変換の際, num = 16 なら, f を返す.
! アルファベット小文字のみに対応しており, 事実上, 36 進数変換まで対応可.
  implicit none
  integer, intent(in) :: num  ! 変換する数値 [10 以上でない場合は, 同じ数字を返す.]
  select case (num)
  case (1:9)
     write(digit_char_conv,'(i1)') num
  case (10)
     digit_char_conv='a'
  case (11)
     digit_char_conv='b'
  case (12)
     digit_char_conv='c'
  case (13)
     digit_char_conv='d'
  case (14)
     digit_char_conv='e'
  case (15)
     digit_char_conv='f'
  case (16)
     digit_char_conv='g'
  case (17)
     digit_char_conv='h'
  case (18)
     digit_char_conv='i'
  case (19)
     digit_char_conv='j'
  case (20)
     digit_char_conv='k'
  case (21)
     digit_char_conv='l'
  case (22)
     digit_char_conv='m'
  case (23)
     digit_char_conv='n'
  case (24)
     digit_char_conv='o'
  case (25)
     digit_char_conv='p'
  case (26)
     digit_char_conv='q'
  case (27)
     digit_char_conv='r'
  case (28)
     digit_char_conv='s'
  case (29)
     digit_char_conv='t'
  case (30)
     digit_char_conv='u'
  case (31)
     digit_char_conv='v'
  case (32)
     digit_char_conv='w'
  case (33)
     digit_char_conv='x'
  case (34)
     digit_char_conv='y'
  case (35)
     digit_char_conv='z'
  end select

  return
end function

end module
