#!/usr/bin/ruby
# Kurihara et al. (1990) check script.

include Math

if ARGV.size == 0 then
   puts "[USAGE] : ruby check_kuri.rb arg1 arg2"
   puts "          arg1 = filterring wave length (int)"
   puts "          arg2 = wave length of checking amplitude (int)"
   exit
end

num = ARGV[0].to_i
r = ARGV[1].to_f

m = [2,3,4,2,5,6,7,2,8,9,2]
kcoe = Array.new(m.size)

for i in 0..m.size-1
   kcoe[i] = 1.0/(1.0-cos(2.0*PI/m[i].to_f))
end

z = 1.0

for i in 0..num-1
   z = z * (1.0-kcoe[i]*(1.0-cos(2.0*PI/r)))
end

puts "Result = #{z}"
