program fft_test
! fft 롼μ¹®٤׻롼
! ¿ǡ򥹥ڥȥѴ, ˵ѴƸ᤹Ȥ
! ѴΥǡȤθκ֤ͤ.

  use ffts
  use Math_Const
  use max_min

  implicit none

  integer :: n
  real, allocatable :: re(:)
  complex, allocatable :: co(:)
  real, allocatable :: err(:)
  real, allocatable :: ren(:)
  real :: tf1, tf2, to1, to2, ta1, ta2, err_max
  integer :: i, l, emax, loop
  character(1) :: flag
  integer, dimension(5) :: prim
  complex, allocatable, dimension(:,:) :: omegar, omegai, omeganr, omegani
  character(20) :: foma, fomb

  flag=""

  foma='(a13,1p,E14.5)'
  fomb='(a18,1p,E14.5,a5)'

  write(*,*) "Input the data number (odd number)."
  read(*,*) n

  write(*,*) "Input the loop number."
  read(*,*) loop

  write(*,*) "Do calculate the prime factors? [y/n]"
  read(*,*) flag

  call prim_calc( n, prim(1:4), prim(5) )
  write(*,*) "draw result prim", prim(1), prim(2), prim(3), prim(4), prim(5)

  allocate(re(n))
  allocate(co(n/2))
  allocate(ren(n))
  allocate(err(n))

  do i=1,n
!     re(i)=sin(2.0*pi*i/real(n))
     re(i)=exp(-4.0*(i-n/2)**2)
  end do

  call cpu_time(ta1)
  if(flag=='n')then
     allocate(omegar(0:n/2-1,0:n/2-1))
     allocate(omegai(0:n/2-1,0:n/2-1))
     allocate(omeganr(0:n/2-1,0:n/2-1))
     allocate(omegani(0:n/2-1,0:n/2-1))
     call rotate_array_f()
     call rotate_calc( n/2, 'r', (/prim(1)-1,prim(2),prim(3),prim(4),prim(5)/),  &
  &                    omegar(0:prim(5)-1,0:prim(5)-1),  &
  &                    omeganr(0:n/2-1,0:n/2-1) )
     call rotate_calc( n/2, 'i', (/prim(1)-1,prim(2),prim(3),prim(4),prim(5)/),  &
  &                    omegai(0:prim(5)-1,0:prim(5)-1),  &
  &                    omegani(0:n/2-1,0:n/2-1) )
  end if
  call cpu_time(ta2)

  call cpu_time( tf1 )

  do l=1,loop
     if(flag=='y')then
        call r2c_ffttp_1d( n, re, co, prim='o' )
        call c2r_ffttp_1d( n, co, ren, prim='o' )
     else
        call r2c_ffttp_1d( n, re, co, prim='o', prim_fact=prim,  &
  &                        omega_fix=omegar, omegan_fix=omeganr )
        call c2r_ffttp_1d( n, co, ren, prim='o', prim_fact=prim,  &
  &                        omega_fix=omegai, omegan_fix=omegani )
     end if
  end do

  call cpu_time( tf2 )

  do i=1,n
     err(i)=abs(re(i)-ren(i))
!write(*,*) "fft check analysis", re(i), ren(i)
  end do

  call max_val_1d( err, emax, err_max )

  write(*,*) "-------------------------------------"
  write(*,trim(foma)) "fft error is ", err_max

  call cpu_time( to1 )

  do l=1,loop
     if(flag=='y')then
        call r2c_ffttp_1d( n, re, co, prim='x' )
        call c2r_ffttp_1d( n, co, ren, prim='x' )
     else
        prim=(/1,0,0,0,n/2/)
        call r2c_ffttp_1d( n, re, co, prim='x', prim_fact=prim,  &
  &                     omega_fix=omeganr, omegan_fix=omeganr )
        call c2r_ffttp_1d( n, co, ren, prim='x', prim_fact=prim,  &
  &                     omega_fix=omegani, omegan_fix=omegani )
     end if
  end do

  call cpu_time( to2 )

  do i=1,n
     err(i)=abs(re(i)-ren(i))
!write(*,*) "fft check analysis", re(i), ren(i)
  end do

  call max_val_1d( err, emax, err_max )

  write(*,trim(foma)) "fft error is ", err_max
  write(*,*) "-------------------------------------"

  write(*,*) "-------------------------------------"
  write(*,trim(fomb)) "cpu time (rot) is ", ta2-ta1, " [s]."
  write(*,trim(fomb)) "cpu time (fft) is ", tf2-tf1, " [s]."
  write(*,trim(fomb)) "cpu time (dft) is ", to2-to1, " [s]."
  write(*,*) "-------------------------------------"

end program
