program solver
! Nolan and Montgomery 2001 ǥ
  use gtool_history
  use Derivation
  use ffts
  use max_min
  use Statistics
  use Math_Const
  use Phys_Const
  use special_function
  use val_define
  use read_namelist
  use val_alloc
  use val_coord
  use time_scheme
  use basis
  use mpi

  implicit none

!-- character values for MPI
  character(4) :: cpnum

!-- do loop ѿ
  integer :: i, j, it

!-- Initializing MPI

  call MPI_INIT( IERROR )

!-- Getting total process number and oneself process ID.

  call MPI_COMM_RANK( MPI_COMM_WORLD, MY_RANK, IERROR )
  call MPI_COMM_SIZE( MPI_COMM_WORLD, PETOT, IERROR )

!-- namelist ɤ߹

  call read_name_mpi()

!-- calculating rotate array 2,3,5,7

  call rotate_array()

!-- calculating rotate array jnt

  call prim_calc( jnt, pfact(1:4), pfact(5) )
  call prim_calc( ntheta, p1fact(1:4), p1fact(5) )

  if(MY_RANK==0)then
     write(*,*) "prim_calc check", jnt, pfact
     write(*,*) "prim_calc check", ntheta, p1fact
  end if

  allocate(omega_br(0:pfact(5)-1,0:pfact(5)-1))
  allocate(omega_nr(0:jnt-1,0:jnt-1))
  allocate(omega_bi(0:pfact(5)-1,0:pfact(5)-1))
  allocate(omega_ni(0:jnt-1,0:jnt-1))
  allocate(omega_br1(0:p1fact(5)-1,0:p1fact(5)-1))
  allocate(omega_nr1(0:ntheta-1,0:ntheta-1))
  allocate(omega_bi1(0:p1fact(5)-1,0:p1fact(5)-1))
  allocate(omega_ni1(0:ntheta-1,0:ntheta-1))

  call rotate_calc( jnt, 'r', pfact,  &
  &                 omega_br(0:pfact(5)-1,0:pfact(5)-1),  &
  &                 omega_nr(0:jnt-1,0:jnt-1) )
  call rotate_calc( jnt, 'i', pfact,  &
  &                 omega_bi(0:pfact(5)-1,0:pfact(5)-1),  &
  &                 omega_ni(0:jnt-1,0:jnt-1) )
  call rotate_calc( ntheta, 'r', p1fact,  &
  &                 omega_br1(0:p1fact(5)-1,0:p1fact(5)-1),  &
  &                 omega_nr1(0:ntheta-1,0:ntheta-1) )
  call rotate_calc( ntheta, 'i', p1fact,  &
  &                 omega_bi1(0:p1fact(5)-1,0:p1fact(5)-1),  &
  &                 omega_ni1(0:ntheta-1,0:ntheta-1) )

!-- allocating array

  call val_allocate()

!-- Ͳ (2d ǡ 3 ǡؤγĥ)

  do i=1,nr
     ub(i)=0.0
  end do

  if(MY_RANK==0)then
     write(*,*) "starting initialization."
  end if

  cpnum=i2c_convert( MY_RANK, '(i4.4)' )
  finame=trim(adjustl(finame(1:len_trim(finame)-3)))//'.'//cpnum(1:4)//'.nc'
  foname=trim(adjustl(foname(1:len_trim(foname)-3)))//'.'//cpnum(1:4)//'.nc'

  call HistoryGet( trim(finame), 'vbar', vib )
  call HistoryGet( trim(finame), 'hbar', hib )
  call HistoryGet( trim(finame), 'r', ri )

!-- time splitting method ˤ dtl, dts Υƥå׿Ψ׻

  slratio=int(dtl/dts)

!-- ʻκ
  call val_coordinate_mpi()

!-- bar Ⱦʻؤ
  call auto_interpolation_1d( ri, rv, vib, vb )
  call auto_interpolation_1d( ri, rs, hib, hb )

!-- 쥤꡼ԥ
  epsu=0.0
  epsv=0.0
  epsh=0.0

  do i=1,nr
     if(rv(i)>=r_dmp)then
        epsu(i)=1.0
        epsv(i)=1.0
        epsh(i)=1.0
     end if
  end do

!-- ͺ

  do j=1,ntheta
     do i=1,nr
!        urp_dmp(i,j)=bessj(0,rv(i)/100000.0)*cos(real(init_n)*theta(j))
!        vrp_dmp(i,j)=bessj(0,rv(i)/100000.0)*cos(real(init_n)*theta(j))
!        hrp_dmp(i,j)=bessj(0,rv(i)/100000.0)*cos(real(init_n)*theta(j))
        urp_dmp(i,j)=exp(-10.0*(rv(i)/50000.0-1.0)**2)*cos(real(init_n)*theta(j))
        vrp_dmp(i,j)=exp(-10.0*(rv(i)/50000.0-1.0)**2)*cos(real(init_n)*theta(j))
        hrp_dmp(i,j)=exp(-10.0*(rv(i)/50000.0-1.0)**2)*cos(real(init_n)*theta(j))
     end do
  end do

  write(*,*) "normally pass the initialization."

!-- ϥեν
  call HistoryCreate( file=trim(foname), title='shallow result data', &
  & source='test', institution='test', dims=(/'r    ','theta', 't    '/),  &
  & dimsizes=(/nr,ntheta, 0/),  & 
  & longnames=(/'r-coordinate    ','theta-coordinate', 'time            '/),  &
  & units=(/'m  ', 'rad', 's  '/), origin=0.0, interval=dmpstp*dt )
  
  call HistoryPut( 'r', rs )
  call HistoryPut( 'theta', theta )
  
  call HistoryAddVariable( varname='up', dims=(/'r    ','theta','t    '/), &
    & longname='radial wind', units='m/s', xtype='float')

  call HistoryAddVariable( varname='vp', dims=(/'r    ','theta','t    '/), &
    & longname='tangential wind', units='m/s', xtype='float')

  call HistoryAddVariable( varname='hp', dims=(/'r    ','theta','t    '/), &
    & longname='geopotential height', units='m', xtype='float')

  write(*,*) "time integration start."

  !-- ν (ͤν)
  do j=1,ntheta
     do i=1,nr
        ucp_old(i,j)=urp_dmp(i,j)
        vcp_old(i,j)=vrp_dmp(i,j)
        hcp_old(i,j)=hrp_dmp(i,j)
     end do
  end do

  if(MY_RANK==0)then
     write(*,*) "*******************************************"
     write(*,*) "File damp (time =", 0.0, "[s])."
     write(*,*) "*******************************************"
  end if

  call HistoryPut( 'up', urp_dmp )
  call HistoryPut( 'vp', vrp_dmp )
  call HistoryPut( 'hp', hrp_dmp )

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i)
  do i=1,nr
     call ffttp_1d( ntheta, ucp_old(i,:), ucp_new(i,:), 'r', prim='o',  &
  &                 prim_fact=p1fact,  &
  &                 omega_fix=omega_br1(0:p1fact(5)-1,0:p1fact(5)-1),  &
  &                 omegan_fix=omega_nr1(0:ntheta-1,0:ntheta-1) )
     call ffttp_1d( ntheta, vcp_old(i,:), vcp_new(i,:), 'r', prim='o',  &
  &                 prim_fact=p1fact,  &
  &                 omega_fix=omega_br1(0:p1fact(5)-1,0:p1fact(5)-1),  &
  &                 omegan_fix=omega_nr1(0:ntheta-1,0:ntheta-1) )
     call ffttp_1d( ntheta, hcp_old(i,:), hcp_new(i,:), 'r', prim='o',  & 
  &                 prim_fact=p1fact,  &
  &                 omega_fix=omega_br1(0:p1fact(5)-1,0:p1fact(5)-1),  &
  &                 omegan_fix=omega_nr1(0:ntheta-1,0:ntheta-1) )
  end do
!$omp end do
!$omp end parallel

!-- solver 

  do it=1,nt

     call time_schematic( it )

  !-- ƥåפοʤ߶
     if(MY_RANK==0)then
        write(*,*) "This step is ", it, "(time =", real(it)*dt, "[s])."
     end if

     !-- ν (2)
     if(mod(it,dmpstp)==0)then  ! ѴԤ¿Ϥ.

!$omp parallel default(shared)
!$omp do schedule(dynamic) private(i,j)
        do i=1,nr
           call ffttp_1d( ntheta, ucp_new(i,:), ucp_dmp(i,:), 'i', prim='o',  &
  &                       prim_fact=p1fact,  &
  &                       omega_fix=omega_bi1(0:p1fact(5)-1,0:p1fact(5)-1),  &
  &                       omegan_fix=omega_ni1(0:ntheta-1,0:ntheta-1) )
           call ffttp_1d( ntheta, vcp_new(i,:), vcp_dmp(i,:), 'i', prim='o',  &
  &                       prim_fact=p1fact,  &
  &                       omega_fix=omega_bi1(0:p1fact(5)-1,0:p1fact(5)-1),  &
  &                       omegan_fix=omega_ni1(0:ntheta-1,0:ntheta-1) )
           call ffttp_1d( ntheta, hcp_new(i,:), hcp_dmp(i,:), 'i', prim='o',  &
  &                       prim_fact=p1fact,  &
  &                       omega_fix=omega_bi1(0:p1fact(5)-1,0:p1fact(5)-1),  &
  &                       omegan_fix=omega_ni1(0:ntheta-1,0:ntheta-1) )
           do j=1,ntheta
              urp_new(i,j)=real(ucp_dmp(i,j))
              vrp_new(i,j)=real(vcp_dmp(i,j))
              hrp_new(i,j)=real(hcp_dmp(i,j))
           end do
        end do
!$omp end do
!$omp end parallel

        if(MY_RANK==0)then
           write(*,*) "*******************************************"
           write(*,*) "File damp (time =", real(it)*dt, "[s])."
           write(*,*) "*******************************************"
        end if

        call HistoryPut( 'up', urp_new )
        call HistoryPut( 'vp', vrp_new )
        call HistoryPut( 'hp', hrp_new )

     end if

  end do

!-- solver ȥå

  if(MY_RANK==0)then
     write(*,*) "solver is normally."
  end if

!-- finishing MPI process

  call MPI_FINALIZE( IERROR )

end program
