!---------------------------------------------------------------
! Copyright (C) 2009-2015 GFD Dennou Club. All rights reserved.
!---------------------------------------------------------------

module Poly_Function  ! ľ¿༰׻륵֥롼

  use special_function

interface CHEBYSHEV

  module procedure CHEBYSHEV_f, CHEBYSHEV_d

end interface CHEBYSHEV

interface GEGENBAUER

  module procedure GEGENBAUER_f, GEGENBAUER_d

end interface GEGENBAUER

interface HERMITE

  module procedure HERMITE_f, HERMITE_d

end interface HERMITE

interface JACOBI_POLY

  module procedure JACOBI_POLY_f, JACOBI_POLY_d

end interface JACOBI_POLY

interface LAGUERRE

  module procedure LAGUERRE_f, LAGUERRE_d

end interface LAGUERRE

interface LEGENDRE

  module procedure LEGENDRE_f, LEGENDRE_d

end interface LEGENDRE

interface AS_LEGENDRE

  module procedure AS_LEGENDRE_f, AS_LEGENDRE_d

end interface AS_LEGENDRE

interface SONINE

  module procedure SONINE_f, SONINE_d

end interface SONINE


contains
subroutine CHEBYSHEV_f(n, x, che)
!****************************************
!*** ӥΥ֥롼 ***
!****************************************
  implicit none
  integer, intent(in) :: n  ! ׻ӥդκǹ⼡
  real, intent(in) :: x(:)  ! ӥ¿༰ΰ
  real, intent(inout) :: che(0:n,size(x))  ! ׻ӥ¿༰
  integer :: i, j
  integer :: nmax  !  x ǿ

  nmax=size(x)

!--  ---
  do i=1,nmax
     che(0,i)=1.0
  end do

  if(n > 0)then

     do i=1,nmax
        che(1,i)=x(i)
     end do

     if(n > 1)then
!-- η׻ ---
        do j=1,n-1
           do i=1,nmax
              che(j+1,i)=2.0*che(1,i)*che(j,i)-che(j-1,i)
           end do
        end do
     end if
  end if

end  subroutine

subroutine CHEBYSHEV_d(n, x, che)
!****************************************
!*** ӥΥ֥롼 ***
!****************************************
  implicit none
  integer, intent(in) :: n  ! ׻ӥդκǹ⼡
  double precision, intent(in) :: x(:)  ! ӥ¿༰ΰ
  double precision, intent(inout) :: che(0:n,size(x))
  integer :: i, j
  integer :: nmax  !  x ǿ

  nmax=size(x)

!--  ---
  do i=1,nmax
     che(0,i)=1.0d0
  end do

  if(n > 0)then

     do i=1,nmax
        che(1,i)=x(i)
     end do

     if(n > 1)then
!-- η׻ ---
        do j=1,n-1
           do i=1,nmax
              che(j+1,i)=2.0d0*che(1,i)*che(j,i)-che(j-1,i)
           end do
        end do
     end if
  end if

end subroutine


subroutine GEGENBAUER_f(n, x, p, lambda)
!************************************
!*  Х ¿༰׻֥롼  *
!************************************
!* Ȥ
!* n=(0ǽ)
!************************************
  implicit none
  integer, intent(in) :: n  ! ׻륲Х¿༰κǹ⼡
  real, intent(in) :: x(:)  ! 
  real, intent(in) :: lambda  ! Х
  real, intent(inout) :: p(0:n,size(x))  ! ׻륲Х¿༰
  integer :: i, j
  integer :: nmax  !  x ǿ

  nmax=size(x)

!--  ---
  do i=1,nmax
     p(0,i)=1.0
  end do

  if(n > 0)then

     do i=1,nmax
        p(1,i)=2.0*lambda*x(i)
     end do

     if(n > 1)then
!-- η׻ ---
        do j=1,n-1
           do i=1,nmax
              p(j+1,i)=(1.0/real(j+1))*(2.0*(lambda+real(j))*x(i)*p(j,i)  &
     &               -(2.0*lambda+real(j-1))*p(j-1,i))
           end do
        end do
     end if
  end if

end subroutine

subroutine GEGENBAUER_d(n, x, p, lambda)
!************************************
!*  Х ¿༰׻֥롼  *
!************************************
!* Ȥ
!* n=(0ǽ)
!************************************
  implicit none
  integer, intent(in) :: n  ! ׻륲Х¿༰κǹ⼡
  double precision, intent(in) :: x(:)  ! 
  double precision, intent(in) :: lambda  ! Х
  double precision, intent(inout) :: p(0:n,size(x))  ! ׻륲Х¿༰
  integer :: i, j
  integer :: nmax  !  x ǿ

  nmax=size(x)

!--  ---
  do i=1,nmax
     p(0,i)=1.0d0
  end do

  if(n > 0)then

     do i=1,nmax
        p(1,i)=2.0d0*lambda*x(i)
     end do

     if(n > 1)then
!-- η׻ ---
        do j=1,n-1
           do i=1,nmax
              p(j+1,i)=(1.0d0/dble(j+1))*(2.0d0*(lambda+dble(j))*x(i)*p(j,i)  &
     &               -(2.0d0*lambda+dble(j-1))*p(j-1,i))
           end do
        end do
     end if
  end if

end subroutine


subroutine HERMITE_f(n, x, p)
!************************************
!*  Hermite ¿༰׻֥롼  *
!************************************
!* Ȥ
!* n=(0ǽ)
!************************************
  implicit none
  integer, intent(in) :: n  ! ׻ Hermite ¿༰κǹ⼡
  real, intent(in) :: x(:)  ! 
  real, intent(inout) :: p(0:n,size(x))  ! ׻ Hermite ¿༰
  integer :: i, j
  integer :: nmax  !  x ǿ

  nmax=size(x)

!--  ---
  do i=1,nmax
     p(0,i)=1.0
  end do

  if(n > 0)then

     do i=1,nmax
        p(1,i)=2.0*x(i)
     end do

     if(n > 1)then
!-- η׻ ---
        do j=1,n-1
           do i=1,nmax
              p(j+1,i)=2.0*(x(i)*p(j,i)-real(j)*p(j-1,i))
           end do
        end do
     end if
  end if

end subroutine


subroutine HERMITE_d(n, x, p)
!************************************
!*  Hermite ¿༰׻֥롼  *
!************************************
!* Ȥ
!* n=(0ǽ)
!************************************
  implicit none
  integer, intent(in) :: n  ! ׻ Hermit ¿༰κǹ⼡
  double precision, intent(in) :: x(:)  ! 
  double precision, intent(inout) :: p(0:n,size(x))  ! ׻ Hermit ¿༰
  integer :: i, j
  integer :: nmax  !  x ǿ

  nmax=size(x)

!--  ---
  do i=1,nmax
     p(0,i)=1.0d0
  end do

  if(n > 0)then

     do i=1,nmax
        p(1,i)=2.0d0*x(i)
     end do

     if(n > 1)then
!-- η׻ ---
        do j=1,n-1
           do i=1,nmax
              p(j+1,i)=2.0d0*(x(i)*p(j,i)-dble(j)*p(j-1,i))
           end do
        end do
     end if
  end if

end subroutine


subroutine JACOBI_POLY_f(n, x, p, alpha, beta)
!***********************************
!  Jacobi ¿༰׻֥롼   *
!***********************************
! Ȥ
! n=(0ǽ)
! nmax=ֳʻ
! p=p(0:n,nmax) 2
!***********************************
  implicit none
  integer, intent(in) :: n  ! ׻ jacobi ¿༰κǹ⼡
  real, intent(in) :: x(:)  ! 
  real, intent(inout) :: p(0:n,size(x))  ! ׻ Jacobi ¿༰
  real, intent(in) :: alpha  ! 
  real, intent(in) :: beta  ! 
  real :: gamma, omega
  integer :: i, j
  integer :: nmax  !  x ǿ

  nmax=size(x)

!--  ---
  gamma=alpha+beta
  omega=alpha-beta

!--  ---
  do i=1,nmax
     p(0,i)=1.0
  end do

  if(n > 0)then

     do i=1,nmax
        p(1,i)=0.5*((gamma+2.0)*x(i)+omega)
     end do

     if(n > 1)then
!-- η׻ ---
        do j=1,n-1
           do i=1,nmax
              p(j+1,i)=(0.5/(real(j+1)*real(j+1+gamma)*real(2.0*j+gamma)))  &
     &                 *((2.0*j+gamma+1.0)  &
     &                 *(gamma*omega+(2.0*j+gamma)*(2.0*(j+1)+gamma)*x(i))  &
     &                 *p(j,i)  &
     &                 -2.0*(j+alpha)*(j+beta)*(2.0*(j+1)+gamma)*p(j-1,i))
           end do
        end do
     end if
  end if

end subroutine



subroutine JACOBI_POLY_d(n, x, p, alpha, beta)
!***********************************
!  Jacobi ¿༰׻֥롼   *
!***********************************
! Ȥ
! n=(0ǽ)
! nmax=ֳʻ
! p=p(0:n,nmax) 2
!***********************************
  implicit none
  integer, intent(in) :: n  ! ׻ jacobi ¿༰κǹ⼡
  double precision, intent(in) :: x(:)  ! 
  double precision, intent(inout) :: p(0:n,size(x))  ! ׻ Jacobi ¿༰
  double precision, intent(in) :: alpha  ! 
  double precision, intent(in) :: beta  ! 
  double precision :: gamma, omega
  integer :: i, j
  integer :: nmax  !  x ǿ

  nmax=size(x)

!--  ---
  gamma=alpha+beta
  omega=alpha-beta

!--  ---
  do i=1,nmax
     p(0,i)=1.0d0
  end do

  if(n > 0)then

     do i=1,nmax
        p(1,i)=0.5d0*((gamma+2.0d0)*x(i)+omega)
     end do

     if(n > 1)then
!-- η׻ ---
        do j=1,n-1
           do i=1,nmax
              p(j+1,i)=(0.5d0/(dble(j+1)*dble(j+1+gamma)*dble(2.0*j+gamma)))  &
     &                 *((2.0d0*dble(j)+gamma+1.0d0)  &
     &                 *(gamma*omega+(2.0d0*dble(j)+gamma)  &
     &                 *(2.0d0*dble(j+1)+gamma)*x(i))*p(j,i)  &
     &                 -2.0d0*dble(j+alpha)*dble(j+beta)  &
     &                 *(2.0d0*dble(j+1)+gamma)*p(j-1,i))
           end do
        end do
     end if
  end if

end subroutine


subroutine LAGUERRE_f(n, x, p)
!***********************************
!  Laguerre ¿༰׻֥롼 *
!***********************************
! Ȥ
! n=(0ǽ)
! nmax=ֳʻ
! p=p(0:n,nmax) 2
!***********************************
  implicit none
  integer, intent(in) :: n  ! ׻ jacobi ¿༰κǹ⼡
  real, intent(in) :: x(:)  ! 
  real, intent(inout) :: p(0:n,size(x))  ! ׻ Jacobi ¿༰
  integer :: i, j
  integer :: nmax  !  x ǿ

  nmax=size(x)

!--  ---
  do i=1,nmax
     p(0,i)=1.0
  end do

  if(n > 0)then

     do i=1,nmax
        p(1,i)=1.0-x(i)
     end do

     if(n > 1)then
!-- η׻ ---
        do j=1,n-1
           do i=1,nmax
              p(j+1,i)=(2.0*real(j)+1.0-x(i))*p(j,i)  &
     &                 -((real(j))**2)*p(j-1,i)
           end do
        end do
     end if
  end if

end subroutine


subroutine LAGUERRE_d(n, x, p)
!***********************************
!  Laguerre ¿༰׻֥롼 *
!***********************************
! Ȥ
! n=(0ǽ)
! nmax=ֳʻ
! p=p(0:n,nmax) 2
!***********************************
  implicit none
  integer, intent(in) :: n  ! ׻ jacobi ¿༰κǹ⼡
  double precision, intent(in) :: x(:)  ! 
  double precision, intent(inout) :: p(0:n,size(x))  ! ׻ Jacobi ¿༰
  integer :: i, j
  integer :: nmax  !  x ǿ

  nmax=size(x)

!--  ---
  do i=1,nmax
     p(0,i)=1.0d0
  end do

  if(n > 0)then

     do i=1,nmax
        p(1,i)=1.0d0-x(i)
     end do

     if(n > 1)then
!-- η׻ ---
        do j=1,n-1
           do i=1,nmax
              p(j+1,i)=(2.0d0*dble(j)+1.0d0-x(i))*p(j,i)  &
     &                 -((dble(j))**2)*p(j-1,i)
           end do
        end do
     end if
  end if

end subroutine


subroutine LEGENDRE_f(n, x, p)
!***********************************
!  Legendre ¿༰׻֥롼 *
!***********************************
! Ȥ
! n=(0ǽ)
! nmax=ֳʻ
! p=p(0:n,nmax) 2
!***********************************
  implicit none
  integer, intent(in) :: n  ! ׻ jacobi ¿༰κǹ⼡
  real, intent(in) :: x(:)  ! 
  real, intent(inout) :: p(0:n,size(x))  ! ׻ Jacobi ¿༰
  integer :: i, j
  integer :: nmax  !  x ǿ

  nmax=size(x)

!--  ---
  do i=1,nmax
     p(0,i)=1.0
  end do

  if(n > 0)then

     do i=1,nmax
        p(1,i)=x(i)
     end do

     if(n > 1)then
!-- η׻ ---
        do j=1,n-1
           do i=1,nmax
              p(j+1,i)=(1.0/real(j+1))*(p(j,i)*(2.0*real(j)+1.0)  &
     &                 *(p(1,i))-real(j)*p(j-1,i))
           end do
        end do
     end if
  end if

end subroutine


subroutine LEGENDRE_d(n, x, p)
!***********************************
!  Legendre ¿༰׻֥롼 *
!***********************************
! Ȥ
! n=(0ǽ)
! nmax=ֳʻ
! p=p(0:n,nmax) 2
!***********************************
  implicit none
  integer, intent(in) :: n  ! ׻ jacobi ¿༰κǹ⼡
  double precision, intent(in) :: x(:)  ! 
  double precision, intent(inout) :: p(0:n,size(x))  ! ׻ Jacobi ¿༰
  integer :: i, j
  integer :: nmax  !  x ǿ

  nmax=size(x)

!--  ---
  do i=1,nmax
     p(0,i)=1.0d0
  end do

  if(n > 0)then

     do i=1,nmax
        p(1,i)=x(i)
     end do

     if(n > 1)then
!-- η׻ ---
        do j=1,n-1
           do i=1,nmax
              p(j+1,i)=(1.0d0/dble(j+1))*(p(j,i)*(2.0d0*dble(j)+1.0d0)  &
     &                 *(p(1,i))-dble(j)*p(j-1,i))
           end do
        end do
     end if
  end if

end subroutine

subroutine AS_LEGENDRE_f(n, m, x, p)
!***********************************
!  Legendre ؿ׻֥롼 *
!***********************************
! Ȥ
! n=(0ǽ)
! m=ȼ(n>=m)
! nmax=ֳʻ
! p=p(0:n,nmax) 2
!***********************************
  use special_function
  implicit none
  integer, intent(in) :: n  ! ׻ legendre ؿκǹ⼡
  integer, intent(in) :: m  ! ׻ legendre ؿοȼ
  real, intent(in) :: x(:)  ! 
  real, intent(inout) :: p(abs(m):n,size(x))  ! ׻ legendre ؿ
  integer :: i, j, abm
  integer :: nmax  !  x ǿ
  real :: coe

  nmax=size(x)
  abm=abs(m)

  if(abm>n)then
     write(*,*) "### ERROR : subroutine AS_LEGENDRE ###"
     write(*,*) "P^m_n : m must be less than n, stop."
     stop
  end if

!-- m ˤĤƤ 2 󳬾׻

  coe=1.0

  if(abm>1)then
     do i=2,abm
        coe=(2.0*real(i)-1.0)*coe
     end do
  end if

!-- m=0 ξϥ른ɥ¿༰ƱʤΤ, ή.

  if(m==0)then
     call Legendre_f( n, x, p(:,:) )
  else

  !-- ʲ, m/=0ξη׻.
  !--  ---

     do i=1,nmax
        p(abm,i)=sqrt(coe*(1.0-x(i)**2)**abm)
     end do

     if(abm<n)then  ! |m|<n ξη׻.

        do i=1,nmax
           p(abm+1,i)=p(abm,i)*(2.0*real(abm)+1.0)*x(i)
        end do

        if(abm+1<n)then  ! |m+1|<n ξη׻.

        !-- η׻ ---
           do j=abm+1,n-1
              do i=1,nmax
                 p(j+1,i)=(1.0/real(j-abm+1))*(p(j,i)*(2.0*real(j)+1.0)  &
     &                      *x(i)-real(j+abm)*p(j-1,i))
              end do
           end do

        end if
     end if

     if(m<0)then  ! 鼡ξɲ÷׻
        coe=real(kaijo_i(n-m))/real(kaijo_i(n+m))

        if(mod(m,2)==0)then
           do j=abm,n
              do i=1,nmax
                 p(j,i)=coe*p(j,i)
              end do
           end do
        else
           do j=abm,n
              do i=1,nmax
                 p(j,i)=-coe*p(j,i)
              end do
           end do
        end if

     end if

  end if

end subroutine


subroutine AS_LEGENDRE_d(n, m, x, p)
!***********************************
!  Legendre ¿༰׻֥롼 *
!***********************************
! Ȥ
! n=(0ǽ)
! nmax=ֳʻ
! p=p(0:n,nmax) 2
!***********************************
  use special_function
  implicit none
  integer, intent(in) :: n  ! ׻ legendre ؿκǹ⼡
  integer, intent(in) :: m  ! ׻ legendre ؿοȼ
  double precision, intent(in) :: x(:)  ! 
  double precision, intent(inout) :: p(abs(m):n,size(x))  ! ׻ legendre ؿ
  integer :: i, j, abm
  integer :: nmax  !  x ǿ
  double precision :: coe

  nmax=size(x)
  abm=abs(m)

  if(abm>n)then
     write(*,*) "### ERROR : subroutine AS_LEGENDRE ###"
     write(*,*) "P^m_n : m must be less than n, stop."
     stop
  end if

!-- m ˤĤƤ 2 󳬾׻

  coe=1.0d0

  if(abm>1)then
     do i=2,abm
        coe=(2.0d0*dble(i)-1.0d0)*coe
     end do
  end if

!-- m=0 ξϥ른ɥ¿༰ƱʤΤ, ή.

  if(m==0)then
     call Legendre_d( n, x, p(:,:) )
  else

  !-- ʲ, m/=0ξη׻.
  !--  ---

     do i=1,nmax
        p(abm,i)=dsqrt(coe*(1.0d0-x(i)**2)**abm)
     end do

     if(abm<n)then  ! |m|<n ξη׻.

        do i=1,nmax
           p(abm+1,i)=p(abm,i)*(2.0d0*dble(abm)+1.0d0)*x(i)
        end do

        if(abm+1<n)then  ! |m+1|<n ξη׻.

        !-- η׻ ---
           do j=abm+1,n-1
              do i=1,nmax
                 p(j+1,i)=(1.0d0/dble(j-abm+1))*(p(j,i)*(2.0d0*dble(j)+1.0d0)  &
     &                      *x(i)-dble(j+abm)*p(j-1,i))
              end do
           end do

        end if
     end if

     if(m<0)then  ! 鼡ξɲ÷׻
        coe=dble(kaijo_i(n-m))/dble(kaijo_i(n+m))

        if(mod(m,2)==0)then
           do j=abm,n
              do i=1,nmax
                 p(j,i)=coe*p(j,i)
              end do
           end do
        else
           do j=abm,n
              do i=1,nmax
                 p(j,i)=-coe*p(j,i)
              end do
           end do
        end if

     end if

  end if

end subroutine


subroutine SONINE_f(n, x, p, lambda)
!***********************************
!  Sonine ¿༰׻֥롼  *
!***********************************
! Ȥ
! n=(0ǽ)
! nmax=ֳʻ
! p=p(0:n,nmax) 2
!***********************************
  implicit none
  integer, intent(in) :: n  ! ׻ jacobi ¿༰κǹ⼡
  real, intent(in) :: x(:)  ! 
  real, intent(inout) :: p(0:n,size(x))  ! ׻ Jacobi ¿༰
  real, intent(in) :: lambda  ! 
  integer :: i, j
  integer :: nmax  !  x ǿ

  nmax=size(x)

!--  ---
  do i=1,nmax
     p(0,i)=1.0
  end do

  if(n > 0)then

     do i=1,nmax
         p(1,i)=lambda+1.0-x(i)
     end do

     if(n > 1)then
!-- η׻ ---
        do j=1,n-1
           do i=1,nmax
              p(j+1,i)=(1.0/real(j+1))  &
     &                 *((lambda+2.0*j+1.0-x(i))*p(j,i)  &
     &                 -(j+lambda)*p(j-1,i))
           end do
        end do
     end if
  end if

end subroutine


subroutine SONINE_d(n, x, p, lambda)
!***********************************
!  Sonine ¿༰׻֥롼  *
!***********************************
! Ȥ
! n=(0ǽ)
! nmax=ֳʻ
! p=p(0:n,nmax) 2
!***********************************
  implicit none
  integer, intent(in) :: n  ! ׻ jacobi ¿༰κǹ⼡
  double precision, intent(in) :: x(:)  ! 
  double precision, intent(inout) :: p(0:n,size(x))  ! ׻ Jacobi ¿༰
  double precision, intent(in) :: lambda  ! 
  integer :: i, j
  integer :: nmax  !  x ǿ

  nmax=size(x)

!--  ---
  do i=1,nmax
     p(0,i)=1.0d0
  end do

  if(n > 0)then

     do i=1,nmax
         p(1,i)=lambda+1.0d0-x(i)
     end do

     if(n > 1)then
!-- η׻ ---
        do j=1,n-1
           do i=1,nmax
              p(j+1,i)=(1.0d0/dble(j+1))  &
     &                 *((lambda+2.0d0*dble(j)+1.0d0-x(i))*p(j,i)  &
     &                 -(dble(j)+lambda)*p(j-1,i))
           end do
        end do
     end if
  end if

end subroutine


subroutine ymn( n, m, x, y, p )
! Ĵ´ؿ׻롼
  implicit none
  integer, intent(in) :: n  ! ȿ
  integer, intent(in) :: m  ! ȿ
  real, intent(in) :: x(:)  ! ѿ [0<=x<=2*pi]
  real, intent(in) :: y(:)  ! ѿ [-1<=y<=1]
  complex, intent(inout) :: p(0:n,-m:m,size(x),size(y))  ! Ĵ´ؿ
  integer :: nmax, mmax
  integer :: i, j, k, l
  complex, parameter :: img=(0.0,1.0)
  real :: pm(0:n,-m:m,size(y))

  nmax=size(x)
  mmax=size(y)

!-- 른ɥؿ׻.
  do j=-m,m
     call AS_Legendre( n, j, y, pm(abs(j):n,j,:) )
  end do

  do l=-m,m
     do k=abs(l),n
        do j=1,mmax
           do i=1,nmax
              p(k,l,i,j)=pm(k,l,j)*(cos(real(m)*x(i))+img*(sin(real(m)*x(i))))
           end do
        end do
     end do
  end do

end subroutine


subroutine gauss_lat( n, lat, eps )
! ٤׻롼
  use Math_Const
  implicit none
  integer, intent(in) :: n  ! ٤ʬο
  real, intent(inout) :: lat(n)  ! ٤γǤΰ [degree]
  real, intent(in), optional :: eps  ! ˥塼ȥˡǤΥȽ
                                ! ǥեȤ 1.0e-6.
  real :: tmp(0:n,1)
  real :: nu(1)
  integer :: k
  real :: diff, eps_max

  if(present(eps))then
     eps_max=eps
  else
     eps_max=1.0e-6
  end if

  do k=1,n  ! k ܤʬ

     nu(1)=cos((pi*(4.0*real(k)-1.0))/(4.0*real(n)+2.0))
     call legendre( n, nu(1:1), tmp(0:n,1:1) )

     do while (eps_max<=tmp(n,1))
        diff=(1.0-nu(1)**2)/(real(n)*(tmp(n-1,1)-nu(1)*tmp(n,1)))
        nu(1)=nu(1)-tmp(n,1)*diff
        call legendre( n, nu(1:1), tmp(0:n,1:1) )
     end do

     lat(k)=asin(nu(1))*180.0/pi

  end do

end subroutine




end module
