#!/usr/bin/ruby
fname = ARGV[0]  # list file name
list = open(fname,'r')
content = list.read.split("\n")
colum = Array.new(content.size)

#-- each parameter
xtitle = ["Temperature","Salinity"]
ytitle = ["Depth","Depth"]
xsub = ["degC","PSU"]
ysub = ["m","m"]
xrange = ["5.0:30.0","34.2:35.2"]
yrange = ["500.0:0.0","500.0:0.0"]
fact = 0.6
col_xnum = [4,17]
col_ynum = [3,3]
skip = 356
fig_type = 2  # ޤο

for i in 0..content.size-1
   colum[i] = content[i].gsub("  "," ").split(" ")
end

for i in 0..content.size-1
   for j in 0..fig_type-1
      puts "dclplot --with-xline=[#{col_xnum[j]}] \
            --with-yline=[#{col_ynum[j]}] \
            --set-title=#{colum[i][1]} \
            --set-xrange=[#{xrange[j]}] \
            --set-yrange=[#{yrange[j]}] \
            --skip=#{skip} --save-mode='PS' \
            --set-ytitle=#{ytitle[j]} --set-ysub=#{ysub[j]} \
            --set-xtitle=#{xtitle[j]} --set-xsub=#{xsub[j]} \
            --fact=#{fact} --with-clip #{colum[i][0]}".gsub("  ","")
      system("dclplot --with-xline=[#{col_xnum[j]}] \
              --with-yline=[#{col_ynum[j]}] \
              --set-title=#{colum[i][1]} \
              --set-xrange=[#{xrange[j]}] \
              --set-yrange=[#{yrange[j]}] \
              --skip=#{skip} --save-mode='PS' \
              --set-ytitle=#{ytitle[j]} --set-ysub=#{ysub[j]} \
              --set-xtitle=#{xtitle[j]} --set-xsub=#{xsub[j]} \
              --fact=#{fact} --with-clip #{colum[i][0]}")
      puts "dclpsyohaku.sh dcl.ps"
      system("dclpsyohaku.sh dcl.ps")
      puts "convert -density 200 -alpha deactivate dcl.ps \
            #{xtitle[j]}_#{colum[i][1]}.png".gsub("  ","")
      system("convert -density 200 -alpha deactivate dcl.ps \
              #{xtitle[j]}_#{colum[i][1]}.png")
   end
end
