!---------------------------------------------------------------
! Copyright (C) 2009-2015 GFD Dennou Club. All rights reserved.
!---------------------------------------------------------------

module Basis  ! Ūʷ׻ؿ¹Ԥ⥸塼

  type dtime  ! 
     integer :: year_d  ! 
     integer :: month_d  ! 
     integer :: day_d  ! 
     integer :: hour_d  ! 
     integer :: min_d  ! ʬ
     integer :: sec_d  ! 
  end type dtime

contains

subroutine rand_make(L,output)
  ! Ǥդηǵ륵֥롼
  ! ƱˡȤ르ꥺѤƵ
  ! $x_{n+1}=a\times x_{n}+b (mod \; L)$
  implicit none
  integer, intent(in) :: L  ! Ϥ + 1 ο
  integer, intent(inout) :: output  ! Ϥ
  integer :: a, b, x0, i, input
  integer, external :: time

  input=time()
  input=mod(input,L)
  write(*,*) input
  a=11
  b=12
  x0=input

  do i=1,10
     x0=a*x0+b
     x0=mod(x0,L)
  end do

  output=x0

end subroutine

!-----------------------------------
!-----------------------------------

character(100) function r2c_convert( rval, forma )
! ¿ʸѴ
  implicit none
  real, intent(in) :: rval  ! Ѵ¿
  character(*), intent(in), optional :: forma  ! ꤹեޥå
  character(100) :: tmp

  if(present(forma))then
     write(tmp,trim(forma)) rval
  else
     write(tmp,*) rval
  end if

  r2c_convert=tmp

  return
end function

!-----------------------------------
!-----------------------------------

real function c2r_convert( cval )
! ʸ¿Ѵ
  implicit none
  character(*), intent(in) :: cval  ! Ѵʸ

  read(cval,*) c2r_convert

  return
end function

!-----------------------------------
!-----------------------------------

character(100) function i2c_convert( ival, forma )
! ¿ʸѴ
  implicit none
  integer, intent(in) :: ival  ! Ѵ
  character(*), intent(in), optional :: forma  ! ꤹեޥå
  character(100) :: tmp

  if(present(forma))then
     write(tmp,trim(forma)) ival
  else
     write(tmp,*) ival
  end if

  i2c_convert=tmp

  return
end function

!-----------------------------------
!-----------------------------------

integer function c2i_convert( cval )
! ʸ¿Ѵ
  implicit none
  character(*), intent(in) :: cval  ! Ѵʸ

  read(cval,*) c2i_convert

  return
end function

!-----------------------------------
!-----------------------------------

integer function split_num( cval, split_str )
! split_str ǻꤵ줿ʸʬȤ, ʸ cval ʬ䤷Ȥ
! ʬĿ֤. split_str ꤵʤ, ʸʬ䵭Ȥƽ.
! , ʬ䵭 1 ʸΤб.
  implicit none
  character(*), intent(in) :: cval  ! ʬ䤷ʸ
  character(1), intent(in), optional :: split_str  ! ʬ䵭
  character(1) :: split
  integer :: nc, counter, i
  logical :: double_flag

  if(present(split_str))then
     split=trim(adjustl(split_str))
  else
     split=' '
  end if

  nc=len_trim(adjustl(cval))
  counter=0
  double_flag=.false.

  do i=2,nc-1  ! ʸκǽȺǸʬʸäƤƤ⤽̵Ǥ뤿.
     if(cval(i:i)==split)then
        if(double_flag.eqv..false.)then
           counter=counter+1
           double_flag=.true.
        end if
     else
        double_flag=.false.
     end if
  end do

  split_num=counter+1

  return
end function

!-----------------------------------
!-----------------------------------

subroutine splitting( cval, num, cval_ar, split_str )
! cval  split_str ʬʸȤ cval_ar Ȥʬ䤹.
! , split_str  1 ʸˤΤбƤ. ǥեȤǤȾѥڡ
! бƤ.
  implicit none
  character(*), intent(in) :: cval  ! ʬ䤷ʸ
  integer, intent(in) :: num        ! num Ĥʬ.
                                    ! ͤ split_num ؿĴ٤Ƥ.
  character(*), dimension(num), intent(inout) :: cval_ar
                                    ! ʬ䤵줿ʸ󤬳Ǽ.
  character(1), intent(in), optional :: split_str
  character(1) :: split
  integer :: nc, counter, counter_counter, i
  integer, dimension(num) :: isnum, ienum
  logical :: double_flag

  if(present(split_str))then
     split=split_str
  else
     split=' '
  end if

  nc=len_trim(adjustl(cval))
  counter=0
  counter_counter=0
  double_flag=.false.

  isnum(1)=1
  do i=2,nc-1  ! ʸκǽȺǸʬʸäƤƤ⤽̵Ǥ뤿.
     if(cval(i:i)==split)then
        if(double_flag.eqv..false.)then
           counter_counter=counter_counter+1
           counter=0
           ienum(counter_counter)=i-1
           double_flag=.true.
        else
           counter=counter+1
        end if
     else
        if(double_flag.eqv..true.)then
           isnum(counter_counter)=i
        end if
        double_flag=.false.
     end if
  end do

  do i=1,num
     cval_ar(i)=cval(isnum(i):ienum(i))
  end do

end subroutine splitting

!-----------------------------------
!-----------------------------------

integer function counter_day( stime, etime )
! 齪λޤǤ򥫥Ȥ.
  implicit none
  type(dtime), intent(in) :: stime  ! 
  type(dtime), intent(in) :: etime  ! λ
  integer, parameter, dimension(13) :: month=(/31,28,31,30,31,30,  &
  &                                            31,31,30,31,30,31,29/)
  integer :: nt, nm, days, i, year_tmp, year_fact
  integer :: nsy, nsm, nsd, ney, nem, ned

  nt=etime%year_d-stime%year_d+1
  nm=etime%month_d-stime%month_d
  days=0
  nsy=stime%year_d
  nsm=stime%month_d
  nsd=stime%day_d
  ney=etime%year_d
  nem=etime%month_d
  ned=etime%day_d

!-- ʣǯˤޤ, ǯǾʬ.
!-- ǯ 1 ǯʬȤ(Ȥǰ).
  if(nt>1)then
     do i=1,nt-1
        year_tmp=nsy+i-1
        if(mod(year_tmp,4)==0)then
           year_fact=366
        else
           year_fact=365
        end if
        days=days+year_fact
     end do
  end if

!-- νԤäƤΤ, ȤϽλǯ­,
!-- ǯǳޤǤҤΤ.
!-- ޤ, 1 ޤޤ¸ߤ­碌.
!-- ,  12 , λ 1 ξ, ­­Τ,
!-- ǤϥȤʤ.
  if(nt>1)then  ! ǯޤ
     ! λ­碌
     if(nem>1)then  ! λ 1 ǤϤʤ.
        do i=1,nem-1
           if(i==2.and.mod(ney,4)==0)then
              days=days+month(13)
           else
              days=days+month(i)
           end if
        end do
     end if

     if(nsm>1)then  !  1 ǤϤʤ.
        do i=1,nsm-1
           if(i==2.and.mod(nsy,4)==0)then
              days=days-month(13)
           else
              days=days-month(i)
           end if
        end do
     end if

  else

     if(nm/=0)then  ! ǯޤ餺, ޤ.
        do i=nsm,nem-1
           if(i==2.and.mod(ney,4)==0)then
              days=days+month(13)
           else
              days=days+month(i)
           end if
        end do
     end if
  end if

!-- , ϷȽλ­碌.
!  if(nt/=1.or.nm/=1)then  ! ǯ⤫֤äƤʤ
!     if(mod(nsy,4)==0.and.nsm==2)then
!        days=days+month(13)-nsd
!     else
!        days=days+month(nsm)-nsd
!     end if

!     if(mod(ney,4)==0.and.nem==2)then
!        days=days+ned
!     else
!        days=days+ned
!     end if
!  end if

  days=days+ned-nsd

  days=days+1
  counter_day=days

  return
end function

!-----------------------------------
!-----------------------------------

integer function counter_sec( stime, etime )
! 齪λޤǤÿ򥫥Ȥ.
  implicit none
  type(dtime), intent(in) :: stime  ! 
  type(dtime), intent(in) :: etime  ! λ
  integer :: nday, tmp_sec
  integer :: nsh, nsm, nss, neh, nem, nes

  tmp_sec=0

!-- ޤ, 򥫥Ȥ.

  nday=counter_day( stime, etime )

!-- 򸵤, ʬä򥫥.
! counter_day  1 ׻Ƥ뤫
! ƱǤ counter_day = 1, 24 ְޤ counter_day = 2.

  if(nday>2)then
     tmp_sec=(nday-2)*86400
  end if

!-- stime  etime ޤǤ hour, minite, sec ׻, ȡä֤.

  nsh=stime%hour_d
  nsm=stime%min_d
  nss=stime%sec_d
  neh=etime%hour_d
  nem=etime%min_d
  nes=etime%sec_d

  if(nday==1)then  !  1 ¸ߤ, hour Τ߷׻.
     tmp_sec=tmp_sec+(neh-nsh)*3600+(nem-nsm)*60+(nes-nss)
  else  ! ޤäƤ, stime  86400 s ǥȤƤ
        ! nsh, nsm, nss Фä׻Ǥ.
     tmp_sec=tmp_sec+86400  ! stime  1 ʬ
     tmp_sec=tmp_sec+neh*3600+nem*60+nes  ! etime ä­
     tmp_sec=tmp_sec-nsh*3600-nsm*60-nss  ! stime ä
  end if

  counter_sec=tmp_sec

  return
end function

!-----------------------------------
!-----------------------------------

subroutine time_zone_convert( factor, itime, ctime )
! ॾѴԤ롼
! 㤨, JST  UTC Ѵ, factor = -9 ȤФ褤.
  implicit none
  integer, intent(in) :: factor        ! Ѳ뤫.
  type(dtime), intent(in) :: itime     ! Ѵλ
  type(dtime), intent(inout) :: ctime  ! Ѵλ
  integer :: iyear, imonth, iday, ihour
  integer, parameter, dimension(13) :: month=(/31,28,31,30,31,30,  &
  &                                            31,31,30,31,30,31,29/)

  iyear=itime%year_d
  imonth=itime%month_d
  iday=itime%day_d
  ihour=itime%hour_d

  ihour=ihour+factor

  if(ihour<0)then
     do while(ihour<0)
        iday=iday-1
        ihour=ihour+24
     end do
  else if(ihour>=24)then
     do while(ihour>=24)
        iday=iday+1
        ihour=ihour-24
     end do
  end if

  if(iday<1)then
     do while(iday<1)
        if(mod(iyear,4)==0.and.imonth==2)then
           iday=iday+month(13)
        else
           iday=iday+month(imonth)
        end if

        imonth=imonth-1

        if(imonth<=0)then
           iyear=iyear-1
           imonth=12
        end if
     end do
  else if(iday>month(imonth))then
     do while(iday>month(imonth))
        if(mod(iyear,4)==0.and.imonth==2)then
           iday=iday-month(13)
        else
           iday=iday-month(imonth)
        end if
        imonth=imonth+1
        if(imonth>12)then
           iyear=iyear+1
           imonth=1
        end if
     end do
  end if

  ctime%year_d=iyear
  ctime%month_d=imonth
  ctime%day_d=iday
  ctime%hour_d=ihour
  ctime%min_d=itime%min_d
  ctime%sec_d=itime%sec_d

end subroutine

!-----------------------------------
!-----------------------------------

subroutine sec_convert( factor, itime, ctime )
! factor ʬ, øԤ롼
  implicit none
  integer, intent(in) :: factor        ! øԤÿ.
  type(dtime), intent(in) :: itime     ! Ѵλ
  type(dtime), intent(inout) :: ctime  ! Ѵλ
  type(dtime) :: ttime
  integer :: ifact, ofact, fhour, fmin, fsec

  fhour=factor/3600
  fmin=(factor-fhour*3600)/60  ! factor is both of positive and negative.
  fsec=factor-fhour*3600-fmin*60

  !-- sec
  ttime%sec_d=itime%sec_d+fsec
  ttime%min_d=itime%min_d+fmin
  ttime%hour_d=itime%hour_d+fhour
  ttime%day_d=itime%day_d
  ttime%month_d=itime%month_d
  ttime%year_d=itime%year_d

  do while(ttime%sec_d<0)
     ttime%min_d=ttime%min_d-1
     ttime%sec_d=ttime%sec_d+60
  end do

  do while(ttime%sec_d>=60)
     ttime%min_d=ttime%min_d+1
     ttime%sec_d=ttime%sec_d-60
  end do

  do while(ttime%min_d<0)
     ttime%hour_d=ttime%hour_d-1
     ttime%min_d=ttime%min_d+60
  end do

  do while(ttime%min_d>=60)
     ttime%hour_d=ttime%hour_d+1
     ttime%min_d=ttime%min_d-60
  end do

  call time_zone_convert( 0, ttime, ctime )

end subroutine

!-----------------------------------
!-----------------------------------

end module
