!---------------------------------------------------------------
! Copyright (C) 2009-2013 GFD Dennou Club. All rights reserved.
!---------------------------------------------------------------

module Map_Function
!  Ͽ޺ɸϤˤ뤤餫Ѵؿ

contains

subroutine rt2ll( r, theta, lon0, lat0, lon, lat )
! ϵε̺ɸϤˤ, (lon0, lat0) ΰ֤Ȥ (r,\theta) ɸ
! ŸȤ, Υ r, Ʊ̳ theta ΰ֤ˤ̾Ǥη٤
! ׻. Υ r ϵ̾α߸̵ΥȤ, theta = 90, 270 deg ̤
! Ҹ̤̾褦 theta ֤.
! ̻ˡѤƷ׻Ԥ,  theta ϵ̻ѷܳ٤ȶ.
  use Phys_Const
  use Math_Const
  implicit none
  real, intent(in) :: r          ! lon0 α߸̵Υ [m]
  real, intent(in) :: theta      ! lon0 ǤƱ̳ [rad]
  real, intent(in) :: lon0       ! ˺ɸη [rad]
  real, intent(in) :: lat0       ! ˺ɸΰ [rad]
  real, intent(inout) :: lon     ! ׻줿 [rad]
  real, intent(inout) :: lat     ! ׻줿 [rad]
  real :: thetad, lond, latd, tmplon, tmplat, rratio

  thetad=180.0*theta/pi
  lond=180.0*lon0/pi
  latd=180.0*lat0/pi
  rratio=r/radius

  if(thetad==-90.0.or.thetad==270.0)then
     lon=lon0
     lat=lat0-rratio
  else if(thetad==90.0)then
     lon=lon0
     lat=lat0+rratio
  else if((-90.0<thetad.and.90.0>thetad).or.  &
  &  (270.0<thetad.and.360.0>=thetad))then
     tmplat=cos(lat0)*sin(rratio)*sin(theta)+sin(lat0)*cos(rratio)
     lat=asin(tmplat)
     tmplon=sin(rratio)*cos(theta)/cos(asin(tmplat))
     lon=lon0+asin(tmplon)
  else if((90.0<thetad.and.270.0>thetad).or.  &
  &       (-180.0<=thetad.and.-90.0>thetad))then
     tmplat=cos(lat0)*sin(rratio)*sin(theta)+sin(lat0)*cos(rratio)
     lat=asin(tmplat)
     tmplon=-sin(rratio)*cos(theta)/cos(asin(tmplat))
     lon=lon0-asin(tmplon)
  else
     write(*,*) "### ERROR : (rt2ll:Map_Function)"
     write(*,*) "argument 'theta' is not valid : ", theta
     write(*,*) "STOP."
     stop
  end if

end subroutine rt2ll

real function ll2radi( lon1, lat1, lon2, lat2 )
! ̾Ǥ 2 Ǥΰ, ٤򸵤, 򽪻Ȥ߸̤εΥ
! ׻.
  real, intent(in) :: lon1    !  1 Ǥη [rad]
  real, intent(in) :: lat1    !  1 Ǥΰ [rad]
  real, intent(in) :: lon2    !  2 Ǥη [rad]
  real, intent(in) :: lat2    !  2 Ǥΰ [rad]
  real :: tmp

  tmp=sin(lat1)*sin(lat2)+cos(lat1)*cos(lat2)*cos(lon2-lon1)
  ll2radi=acos(tmp)*radius

  return
end function ll2radi

real function dis2lon( x, lon0, phi0 )
!   lon0 ֵΥ x [m] Υ줿֤ˤ [rad].
!  ,  phi0 [rad] ƱپǷ¬ΥѤ.
!  x ˷׻ݤ, ˷׻ݤͤͿз׻ǽ.
  use Phys_Const
  use Math_Const
  implicit none
  real, intent(in) :: x     !  lon0 ζֵΥ [m] ()
  real, intent(in) :: lon0  !  [rad]
  real, intent(in) :: phi0  !  [rad]

  dis2lon=x/(radius*cos(phi0))+lon0

  return
end function

!---------------------------------

real function dis2lat( y, phi0 )
!   phi0 ֵΥ y [m] Υ줿֤ˤ [rad].
!  y ̤˷׻ݤ, ˷׻ݤͤͿз׻ǽ.
  use Phys_Const
  use Math_Const
  implicit none
  real, intent(in) :: y     !  phi0 ζֵΥ [m] (̸)
  real, intent(in) :: phi0  !  [rad]

  dis2lat=y/radius+phi0

  return
end function

!---------------------------------

!-- ʹ, Υȥ륫ȥɸϤˤٷѴؿ
real function dis2mlon(x,lam0)
!   lam0 Ͽ޵Υ x [m] Υ줿֤ˤ [rad].
!  , x , Ϳз׻ǽ.
  use Phys_Const
  implicit none
  real, intent(in) :: x     !  lam0 ζֵΥ [m] ()
  real, intent(in) :: lam0  !  [rad]

  dis2mlon=x/radius+lam0

  return
end function

!---------------------------------

real function dis2mlat(y,phi0)
!   phi0 ֵΥ y [m] Υ줿֤ˤ [rad].
!  , x , Ϳз׻ǽ.
  use Phys_Const
  use Math_Const
  implicit none
  real, intent(in) :: y     !  phi0 ζֵΥ [rad] (̸).
  real, intent(in) :: phi0  !  [rad]

  dis2mlat=asin(tanh(log(tan(0.25*pi+0.5*phi0))+y/radius))

  return
end function

!---------------------------------

real function lonlat2lamdis( lon, phi, lon0, phi1, phi2, phi0 )
!   phi1, phi2,  lon0 ٰ lon, phi [rad] Υ줿
!  ֤ޤǤϿ޾εΥ [m].
  use Phys_Const
  use Math_Const
  implicit none
  real, intent(in) :: lon     ! ᤿η [rad].
  real, intent(in) :: phi     ! ᤿ΰ [rad].
  real, intent(in) :: lon0  !  [rad]
  real, intent(in) :: phi1  !  1 [rad]
  real, intent(in) :: phi2  !  2 [rad]
  real, intent(in), optional :: phi0  ! Ͽ޺ɸ 0 [rad].
        ! phi0 ꤵƤ, y ɸεΥ.
  real :: n
  real :: rho, rho0

  n=log(cos(phi1)/cos(phi2))/log(tan(0.25*pi-0.5*phi1)/tan(0.25*pi-0.5*phi2))

  rho=(cos(phi1)*(tan(0.25*pi-0.5*phi))**n)/(n*(tan(0.25*pi-0.5*phi1))**n)

  if(present(phi0))then
     rho0=(cos(phi1)*(tan(0.25*pi-0.5*phi0))**n)/(n*(tan(0.25*pi-0.5*phi1))**n)
     lonlat2lamdis=rho0-rho*cos(n*(lon-lon0))
  else
     lonlat2lamdis=rho*sin(n*(lon-lon0))
  end if

  return
end function

!---------------------------------


end module
