program sound_2d
! ʣΥǥǡޤץ
! ꥹȺκݤ 00Z ǻϤޤ, 00Z ǽ褦˺뤳.
! ­ʤʬ unknown 䤦.

  use dcl
  use Dcl_Automatic
  use file_operate
  use basis
  use Statistics
  use Thermo_Function

  implicit none

!-- integer
  integer :: nt       ! γʻҿ
  integer :: nz       ! z γʻҿ
  integer :: nf       ! conv_dat ѥǡ
  integer :: IWS      ! ǥХ
  integer :: days     ! 
  integer :: i_counter    ! 󥿡
  integer :: i_counter_c  ! 󥿡
  integer :: snum, cnum  ! 顼ο
  integer :: cont_flag, shade_flag  ! 顼, ѥե饰ѿ
  integer, allocatable, dimension(:) :: year_v    ! ǯ
  integer, allocatable, dimension(:) :: month_v   ! 
  integer, allocatable, dimension(:) :: day_v     ! 
  integer, allocatable, dimension(:) :: hour_v    ! 
  integer, allocatable, dimension(:) :: inter_z ! ѹ
  integer, allocatable, dimension(:) :: i_flag  ! 
  integer, allocatable, dimension(:) :: o_flag  ! 
  integer, allocatable, dimension(:) :: c_flag  ! 
!-- tmp
  integer :: nttmp, i, j, k
!-- parameter
  integer, parameter :: col_num=6

!-- real
  real :: z_bot       ! βü
  real :: z_top       ! ξü
  real :: dz          ! ľֳ [m]
  real :: smax, smin, cmax, cmin  ! 顼, ξ
  real, allocatable, dimension(:) :: time  ! 
  real, allocatable, dimension(:) :: z     ! ٺɸ
  real, allocatable, dimension(:,:) :: val_f        ! ׻
  real, allocatable, dimension(:,:) :: val_inter    ! ׻ѿ
  real, allocatable, dimension(:,:) :: tline        ! ׻ѿ
  real, allocatable, dimension(:,:) :: yline        ! ׻ѿ
  real, allocatable, dimension(:,:,:) :: val_draw   ! ѿ
  real :: undef
  real :: conv_undef
!-- tmp
  real, dimension(2) :: pt_tmp, ept_tmp, sept_tmp, s_int, c_int

!-- character
  character(80) :: flist         ! եꥹ̾
  character(80) :: conv_dat      ! sound_1d ǽϤήѥ᡼ǡ
  character(80) :: title_txt     ! ȥ̾
  character(10) :: cont_val      ! ѿ̾
  character(10) :: shade_val     ! 顼ѿ̾
  character(10) :: conv_list     ! ǡե饰
  character(80), allocatable, dimension(:,:) :: fname  ! ե̾
  character(20), allocatable, dimension(:,:) :: val_w  ! ƥȥǡ
!-- tmp
  character(80) :: tmp_c

!-- logical
  logical :: vec_val       ! ѿ̾

!-- type
  type(dtime) :: start_day, end_day
  type(dcl_date) :: stime

!-- namelist reading
  namelist /input /flist, conv_dat, conv_list, conv_undef, dz, z_bot,  &
  &                z_top, IWS, title_txt,  &
  &                cmin, cmax, smin, smax, cont_val, shade_val,  &
  &                vec_val, cnum, snum, undef
  read(5,nml=input)

  nz=int((z_top-z_bot)/dz)+1
  nt=line_number_counter( trim(flist) )
  s_int=(/smin, smax/)
  c_int=(/cmin, cmax/)

  allocate(fname(2,nt))
  allocate(time(nt))
  allocate(z(nz))
  allocate(inter_z(nz))
  allocate(val_inter(col_num+3,nz))
  allocate(val_draw(col_num+3,nt,nz))
  allocate(year_v(nt))
  allocate(month_v(nt))
  allocate(day_v(nt))
  allocate(hour_v(nt))

!-- DCL set
  call SGISET('IFONT', 2)
  call UZFACT(0.65)
  call DclSetParm( 'ENABLE_CONTOUR_MESSAGE', .false. )
  CALL GLRSET( 'RMISS', undef )
  CALL GLLSET( 'LMISS', .TRUE. )

  call read_file_text( trim(flist), 2, nt, fname )

  do i=1,nt
     tmp_c=trim(fname(2,i))
     year_v(i)=c2i_convert( trim(tmp_c(1:4)) )
     month_v(i)=c2i_convert( trim(tmp_c(5:6)) )
     day_v(i)=c2i_convert( trim(tmp_c(7:8)) )
     hour_v(i)=c2i_convert( trim(tmp_c(9:10)) )
  end do

  start_day%year_d=year_v(1)
  start_day%month_d=month_v(1)
  start_day%day_d=day_v(1)
  end_day%year_d=year_v(nt)
  end_day%month_d=month_v(nt)
  end_day%day_d=day_v(nt)
  days=counter_day( start_day, end_day )-1
  stime%year=year_v(1)
  stime%month=month_v(1)
  stime%day=day_v(1)

  do i=1,nz
     z(i)=z_bot+dz*real(i-1)
  end do
  do i=1,nt
     end_day%year_d=year_v(i)
     end_day%month_d=month_v(i)
     end_day%day_d=day_v(i)
     time(i)=real(counter_day( start_day, end_day ))+real(hour_v(i))/24.0-1.0
  end do

!-- time loop
!-- 1. reading values from text file
!-- 2. interpolating to grid point
!-- 3. calculating each value

  do i=1,nt
     if(trim(fname(1,i))/='unknown')then
        nttmp=line_number_counter( trim(fname(1,i)) ) -2
        allocate(val_w(col_num,nttmp))
        allocate(val_f(col_num,nttmp))
        call read_file_text( trim(fname(1,i)), col_num, nttmp, val_w, skip=2 )

     !-- convert type from character to float
        do k=1,nttmp
           do j=1,col_num
              val_f(j,k)=c2r_convert( val_w(j,k) )
           end do
        end do

     !-- calculating the interpolating points
        do k=1,nz
           call interpo_search_1d( val_f(1,:), z(k), inter_z(k), undeff=int(undef) )
        end do

     !-- calculating each value (temp, u, v, rh)
        do k=1,nz
           do j=2,col_num
              if(inter_z(k)/=int(undef).and.inter_z(k)/=nttmp)then
                 if(val_f(j,inter_z(k))==undef.or.  &
  &                 val_f(j,inter_z(k)+1)==undef)then
                    val_inter(:,k)=undef
                    exit
                 end if

                 call interpolation_1d( val_f(1,inter_z(k):inter_z(k)+1),  &
  &                                     val_f(j,inter_z(k):inter_z(k)+1),  &
  &                                     z(k), val_inter(j,k) )
              else
                 val_inter(j,k)=undef
              end if
           end do
        end do

     !-- calculating each value (pt, ept, sept)
        do k=1,nz
           if(val_inter(2,k)==undef)then
              val_inter(col_num+1,k)=undef
              val_inter(col_num+2,k)=undef
              val_inter(col_num+3,k)=undef
           else
              pt_tmp(1)=theta_dry( val_f(3,inter_z(k)), val_f(2,inter_z(k)) )
              ept_tmp(1)=thetae_Bolton( val_f(3,inter_z(k)),  &
  &                                     val_f(4,inter_z(k)),  &
  &                                     val_f(2,inter_z(k)) )
              sept_tmp(1)=thetaes_Bolton( val_f(3,inter_z(k)),  &
  &                                       val_f(2,inter_z(k)) )
              pt_tmp(2)=theta_dry( val_f(3,inter_z(k)), val_f(2,inter_z(k)) )
              ept_tmp(2)=thetae_Bolton( val_f(3,inter_z(k)+1),  &
  &                                     val_f(4,inter_z(k)+1),  &
  &                                     val_f(2,inter_z(k)+1) )
              sept_tmp(2)=thetaes_Bolton( val_f(3,inter_z(k)+1),  &
  &                                       val_f(2,inter_z(k)+1) )

              call interpolation_1d( val_f(1,inter_z(k):inter_z(k)+1),  &
  &                                  pt_tmp, z(k), val_inter(col_num+1,k) )
              call interpolation_1d( val_f(1,inter_z(k):inter_z(k)+1),  &
  &                                  ept_tmp, z(k), val_inter(col_num+2,k) )
              call interpolation_1d( val_f(1,inter_z(k):inter_z(k)+1),  &
  &                                  sept_tmp, z(k), val_inter(col_num+3,k) )

           end if
        end do

        deallocate(val_w)
        deallocate(val_f)

     else
        val_inter=undef
     end if

     do j=1,col_num+3
        do k=1,nz
           val_draw(j,i,k)=val_inter(j,k)
        end do
     end do

  end do

!-- draw value separate
!--  val_inter ȤƤ.(ޤ̤)

  select case (cont_val)
  case ('temp')
     cont_flag=3
  case ('rh')
     cont_flag=4
  case ('pt')
     cont_flag=col_num+1
  case ('ept')
     cont_flag=col_num+2
  case ('sept')
     cont_flag=col_num+3
  case ('east')
     cont_flag=5
  case ('north')
     cont_flag=6
  end select

  select case (shade_val)
  case ('temp')
     shade_flag=3
  case ('rh')
     shade_flag=4
  case ('pt')
     shade_flag=col_num+1
  case ('ept')
     shade_flag=col_num+2
  case ('sept')
     shade_flag=col_num+3
  case ('east')
     shade_flag=5
  case ('north')
     shade_flag=6
  end select

!-- DCL part
!-- ޤ, -
  call color_setting( snum, s_int, col_min=15, col_max=85,  &
  &                   min_tab=10999, max_tab=999999 )

  call DclOpenGraphics(IWS)

  if(vec_val.eqv..false.)then
     call Dcl_2D_Cont_Shade_Calendar( trim(title_txt),  &
  &       time, z, val_draw(cont_flag,:,:), val_draw(shade_flag,:,:),  &
  &       c_int, s_int,  &
  &       (/'            ', 'altitude (m)'/), stime, days, (/'(f6.1)', '(f6.1)'/),  &
  &       c_num=(/cnum, snum/), trigleg='a' )
  else
     call Dcl_2D_Cont_Shade_vec_Calendar( trim(title_txt),  &
  &       time, z, val_draw(cont_flag,:,:), val_draw(shade_flag,:,:),  &
  &       val_draw(5,:,:), val_draw(6,:,:), (/20,20/),  &
  &       c_int, s_int,  &
  &       (/'            ', 'altitude (m)'/), stime, days,  &
  &       (/'(f6.1)', '(f6.1)'/),  &
  &       c_num=(/cnum, snum/), trigleg='a',  &
  &       unitv=.true., vfact=(/2.0e-3, 2.0e-3/),  &
  &       unit_fact=(/5.0e-2, 5.0e-2/),  &
  &       unit_fact_sign=.false., unit_title=(/'U = 25m/s', ''/) )
  end if

!-- ʹ, ήѥ᡼ѿλǡ񤭽Ф

  deallocate(fname)
  deallocate(year_v)
  deallocate(month_v)
  deallocate(day_v)
  deallocate(hour_v)
  deallocate(time)

  if(trim(conv_dat(1:1))/='')then
     nf=len_trim(conv_list)
     nt=line_number_counter( trim(conv_dat) )

     allocate(fname(nf,nt))
     allocate(year_v(nt-2))
     allocate(month_v(nt-2))
     allocate(day_v(nt-2))
     allocate(hour_v(nt-2))
     allocate(i_flag(3))
     allocate(o_flag(nf))
     allocate(c_flag(nf))
     allocate(time(nt-2))
     allocate(tline(nt,nf))
     allocate(yline(nt,nf))

     call read_file_text( trim(conv_dat), nf, nt, fname )
     i_counter=0
     i_counter_c=0

     do i=1,nf
        select case(conv_list(i:i))
        case('t')
           i_flag(1)=i
        case('z')
           i_flag(2)=i
        case('p')
           i_flag(3)=i
        case('o')
           i_counter=i_counter+1
           o_flag(i_counter)=i
        case('c')
           i_counter_c=i_counter_c+1
           c_flag(i_counter_c)=i
        end select
     end do

     do i=1,nt-2
        tmp_c=trim(fname(i_flag(1),i+2))
        year_v(i)=c2i_convert( trim(tmp_c(1:4)) )
        month_v(i)=c2i_convert( trim(tmp_c(5:6)) )
        day_v(i)=c2i_convert( trim(tmp_c(7:8)) )
        hour_v(i)=c2i_convert( trim(tmp_c(9:10)) )
     end do

     start_day%year_d=year_v(1)
     start_day%month_d=month_v(1)
     start_day%day_d=day_v(1)
     end_day%year_d=year_v(nt-2)
     end_day%month_d=month_v(nt-2)
     end_day%day_d=day_v(nt-2)
     days=counter_day( start_day, end_day )-1
     stime%year=year_v(1)
     stime%month=month_v(1)
     stime%day=day_v(1)

     do i=1,nt-2
        end_day%year_d=year_v(i)
        end_day%month_d=month_v(i)
        end_day%day_d=day_v(i)
        time(i)=real(counter_day( start_day, end_day ))+real(hour_v(i))/24.0-1.0
     end do

     if(i_counter>0)then

        do i=1,nt-2
           do j=1,i_counter
              tmp_c=trim(fname(o_flag(j),i+2))
              tline(i,j)=time(i)
              yline(i,j)=c2r_convert( trim(tmp_c))
           end do
        end do
      
        do j=1,i_counter
           call Dcl_PL_Calendar( 'l', '', tline(:,j:j), yline(:,j:j),  &
  &                              tline(:,j:j), yline(:,j:j),  &
  &                              (/'', trim(fname(o_flag(j),1))/), stime, days )
        end do

     end if

     if(i_counter_c>0)then

        do i=1,nt-2
           do j=1,i_counter_c
              tmp_c=trim(fname(o_flag(j),i+2))
              tline(i,j)=time(i)
              yline(i,j)=c2r_convert( trim(tmp_c))
           end do
        end do
      
        tmp_c=''
        do j=1,i_counter_c
           tmp_c=trim(tmp_c)//', '//trim(fname(c_flag(j),1))
        end do
      
        call Dcl_PL_Calendar( 'l', '',  &
  &                           tline(:,1:c_flag(j)), yline(:,1:c_flag(j)),  &
  &                           tline(:,1:c_flag(j)), yline(:,1:c_flag(j)),  &
  &                           (/'', trim(tmp_c)/), stime, days )

     end if

  end if

  call DclCloseGraphics

end program
