program make_initial
! ͥǡ.

  use gtool_history
  use Algebra
  use Phys_Const

  implicit none

  integer, parameter :: nr=10000
  integer :: i
  real, dimension(nr) :: ri, vb, hb, ub, fv
  real, parameter :: rmin=0.0, dr=110.0, r0=100000.0, coril=1.0e-5, hmin=1.0e3
  real, parameter :: vmax=60.0
  character(80) :: finame

!-- ͥե̾

  write(*,*) "input the initial file name."
  read(*,*) finame

!-- ɸѿ

  ri=(/((rmin+dr*(i-1)),i=1,nr)/)

!-- Ƽо

  do i=1,nr
     if(ri(i)/=0.0)then
        vb(i)=2.0*vmax*(ri(i)/r0)/(1.0+(ri(i)/r0)**3)
        fv(i)=coril*vb(i)+vb(i)*vb(i)/ri(i)
        call rectangle_int( ri(1:i), fv(1:i), ri(1), ri(i), hb(i) )
        hb(i)=hmin+hb(i)/g
        ub(i)=0.0
     else
        fv(i)=0.0
        vb(i)=0.0
        hb(i)=hmin
        ub(i)=0.0
     end if
  end do

!-- ϥեν

  call HistoryCreate( file=trim(finame), title='shallow initial data', &
  & source='test', institution='test', dims=(/'r'/), dimsizes=(/nr/),  & 
  & longnames=(/'r-coordinate'/),  &
  & units=(/'m'/), origin=0.0, interval=0.0 )
  
  call HistoryPut( 'r', ri )
  
  call HistoryAddVariable( varname='vbar', dims=(/'r'/), &
    & longname='basic tangential wind', units='m/s', xtype='float')

  call HistoryPut( 'vbar', vb )

  call HistoryAddVariable( varname='hbar', dims=(/'r'/), &
    & longname='basic geopotential', units='m', xtype='float')

  call HistoryPut( 'hbar', hb )

  call HistoryAddVariable( varname='ubar', dims=(/'r'/), &
    & longname='basic radial wind', units='m/s', xtype='float')

  call HistoryPut( 'ubar', ub )

end program
