program draw
  use dcl
  use Dcl_Automatic
  use gtool_history
  use Statistics
  use max_min
  use Thermo_Const
  implicit none
  integer :: i, j, k
  integer :: nr, nz
  integer :: nargv
  integer :: rdmin, rdmax, zdmin, zdmax
  integer :: max_v
  real :: rmin, rmax, zmin, zmax
  real, allocatable, dimension(:) :: r, z, vmax, rdraw, zdraw
  real, allocatable, dimension(:,:) :: val1, val2, v, z_vmax
  character(80) :: argv
  character(80) :: value_name1, value_name2, fname, tmp_name1, tmp_name2
  real :: cmin, cmax, smin, smax

  namelist /drawinput /nr, nz, rmin, rmax, zmin, zmax, fname, value_name1, value_name2, cmin, cmax, smin, smax
  read(5,nml=drawinput)

  allocate(r(nr))
  allocate(z(nz))
  allocate(rdraw(nr))
  allocate(zdraw(nz))
  allocate(vmax(nz))
  allocate(z_vmax(nz,2))
  allocate(val1(nr,nz))
  allocate(val2(nr,nz))
  allocate(v(nr,nz))

  tmp_name1=''
  tmp_name2=''

  call SGISET('IFONT',2 )

  if(trim(value_name1)=='exner')then
     value_name1='pres'
     tmp_name1='exner'
  end if

  if(trim(value_name2)=='exner')then
     value_name2='pres'
     tmp_name2='exner'
  end if

!-- ѿ
  call HistoryGet( trim(fname), 'r', r(1:nr) )
  call HistoryGet( trim(fname), 'z', z(1:nz) )
  call HistoryGet( trim(fname), trim(value_name1), val1(1:nr,1:nz) )
  call HistoryGet( trim(fname), trim(value_name2), val2(1:nr,1:nz) )

  zdraw=z*1.0e-3
  rdraw=r*1.0e-3

!-- ǡ
  call HistoryGet( 'initial.nc', 'v', v(1:nr,1:nz) )

!-- ΰη
  call nearest_search_1d( r, rmin, rdmin )
  call nearest_search_1d( r, rmax, rdmax )
  call nearest_search_1d( z, zmin, zdmin )
  call nearest_search_1d( z, zmax, zdmax )

!  xscale=0.05
!  call calc_vscale( (xmax-xmin), (ymax-ymin), 0.6, 0.6, xscale, yscale )

!  dummy=-10.0

!-- ƹ٤Ǥ vmax ׻.
  do j=1,nz
     call max_val_1d( v(:,j), max_v, vmax(j) )
     z_vmax(j,1)=rdraw(max_v)
     z_vmax(j,2)=zdraw(j)
  end do

!-- qv 
  if(trim(value_name1)=='qv')then
     do j=1,nz
        do i=1,nr
           if(val1(i,j)==0.0)then
              val1(i,j)=-0.1
           end if
        end do
     end do
  end if

  if(trim(value_name2)=='qv')then
     do j=1,nz
        do i=1,nr
           if(val2(i,j)==0.0)then
              val2(i,j)=-0.1
           end if
        end do
     end do
  end if

!-- theta0 anorm 
  if(trim(value_name1)=='theta0'.or.trim(value_name1)=='pres')then
     do j=1,nz
        do i=1,nr
           if(trim(tmp_name1)=='exner')then
              val1(i,j)=(val1(i,j)/1000.0e2)**(Rd/cpd)-(val1(nr,j)/1000.0e2)**(Rd/cpd)
           else
!              val1(i,j)=val1(i,j)-val1(nr,j)
           end if
        end do
     end do
  end if

  if(trim(value_name2)=='theta0'.or.trim(value_name2)=='pres')then
     do j=1,nz
        do i=1,nr
           if(trim(tmp_name2)=='exner')then
              val2(i,j)=(val2(i,j)/1000.0e2)**(Rd/cpd)-(val2(nr,j)/1000.0e2)**(Rd/cpd)
           else
!              val2(i,j)=val2(i,j)-val2(nr,j)
           end if
        end do
     end do
  end if

  call color_setting( 10, smin, smax, min_tab=99999 )  

  call DclOpenGraphics(2)

  call Dcl_2D_cont_shade( trim(value_name1)//' and '//trim(value_name2),  &
  &    rdraw(rdmin:rdmax), zdraw(zdmin:zdmax),  &
  &    val1(rdmin:rdmax,zdmin:zdmax), val2(rdmin:rdmax,zdmin:zdmax),  &
!  &    u, v, 21, 21,  &
!  &    pres, dummy, u, v, 21, 21,  &
  &    cmin, cmax, smin, smax, 'r-axis (km)', 'z-axis (km)', '(f6.1)', 'f(6.1)',  &
  &    color_num=10, viewx_min=0.13, viewx_max=0.83, viewy_min=0.3, viewy_max=0.7,  &
  &    xg=z_vmax(1:nz,1:1), yg=z_vmax(1:nz,2:2), trigleg='a' )  !,  &
!  &    unitv=.true., vfact=(/xscale, yscale/), unit_fact_sign=.true.,  &
!  &    unit_fact=(/1.0, 1.0/), unit_title=(/'U','V'/) )

  call DclCloseGraphics

end program
