program sound_conv
! ǤդΥǥ󥰥ǡᥤץबɤ߹ߤ䤹Ѵ.
  use file_operate
  use Basis
  use Thermo_Const
  use Thermo_Function

  implicit none

  real, allocatable, dimension(:,:) :: val
  character(30), allocatable, dimension(:,:) :: cval
  integer :: i, j, k, nx, nz, i_undef, skip_num, rh_flag, nf
  character(30) :: flag, sign_flag
  character(80) :: list_name, output_name, undef, fname
  character(80), allocatable, dimension(:) :: iname, oname
  character(10) :: unity(4)  ! unit convert flags
  real, parameter :: conv_undef=-999.0
  real :: limit_height, factor
  real, allocatable, dimension(:) :: height, pres, temp, vapor, tmp, ew, ww

  i_undef=len_trim(undef)

!-- namelist file read

  namelist/ input/ flag, fname, undef, skip_num, unity, limit_height, output_name
  read(5,nml=input)

!-- list file read

  nf=line_number_counter( trim(list_name) )
  allocate(iname(nf))
  allocate(oname(nf))
  call read_file_text( trim(list_name), 1, nf, iname )

!-- do loop counter

  do i=1,nf

!-- column and array set

     nx=len_trim(flag)
     nz=line_number_counter( trim(iname(i)) )

     oname(i)="conv-"//iname(i)

     allocate(cval(nx,nz))
     allocate(val(nx,nz))
     allocate(height(nz))
     allocate(temp(nz))
     allocate(pres(nz))
     allocate(vapor(nz))
     allocate(ew(nz))
     allocate(ww(nz))
     allocate(tmp(nz))

!-- reading file

     call read_file_text( trim(iname(i)), nx, nz, cval, skip=skip_num )

!-- type convert

     do j=1,nx
        if(flag(j:j)=='o')then
           do k=1,nz
              if(trim(cval(j,k))==trim(undef))then
                 val(j,k)=conv_undef
              else
                 val(j,k)=c2r_convert( cval(j,k) )
              end if
           end do
        end if
     end do

!-- val sign

     do i=1,nx
        select case (sign_flag(i:i))
        case('1')
           if(unity(1)=='m')then
              factor=1.0
           else
              factor=1000.0
           end if
           do j=1,nz
              if(val(i,j)/=conv_undef)then
                 height(j)=val(i,j)*factor
              else
                 height(j)=conv_undef
              end if
           end do
        case('2')
           if(unity(2)=='K')then
              factor=0.0
           else
              factor=273.15
           end if
           do j=1,nz
              if(val(i,j)/=conv_undef)then
                 temp(j)=val(i,j)+factor
              else
                 temp(j)=conv_undef
              end if
           end do
        case('3')
           if(unity(3)=='Pa')then
              factor=1.0
           else
              factor=100.0
           end if
           do j=1,nz
              if(val(i,j)/=conv_undef)then
                 temp(j)=val(i,j)+factor
              else
                 temp(j)=conv_undef
              end if
              pres(j)=val(i,j)*factor
           end do
        case('4')
           if(unity(4)=='g/kg')then
              factor=1.0e-3
           else
              factor=1.0
              rh_flag=i
           end if
           do j=1,nz
              if(val(i,j)/=conv_undef)then
                 vapor(j)=val(i,j)*factor
              else
                 vapor(j)=conv_undef
              end if
           end do
        case('5')
           do j=1,nz
              if(val(i,j)/=conv_undef)then
                 ew(j)=val(i,j)
              else
                 ew(j)=conv_undef
              end if
           end do
        case('6')
           do j=1,nz
              if(val(i,j)/=conv_undef)then
                 ww(j)=val(i,j)
              else
                 ww(j)=conv_undef
              end if
           end do
        case('7')
           do j=1,nz
              tmp(j)=val(i,j)
           end do
        case('8')
           do j=1,nz
              tmp(j)=val(i,j)
           end do
        case('9')
           do j=1,nz
              tmp(j)=val(i,j)
           end do
        end select
     end do

!-- convert check RH

     if(unity(4)=='%')then
        do j=1,nz
           if(vapor(j)/=conv_undef)then
              vapor(j)=RHTP_2_qv( vapor(j), temp(j), pres(j) )
           end if
        end do
     end if

!-- writing file
     open(unit=11+2*i,file=trim(oname(i)),status='unknown')
     write(11+i,*) 'height', 'pressure', 'temperature', 'vapor', 'eastwind', 'westwind'
     write(11+i,*) "'m'", "'Pa'", "'K'", "'kg/kg'", "'m/s'", "'m/s'"
     do j=1,nz
        if(height(j)>limit_height)then
           write(11+i,'(1000f)') height(j), pres(j), temp(j), vapor(j), ew(j), ww(j)
           if(height(j+1)<height(j))then
              exit
           end if
        end if
     end do
     close(unit=11+i,status='keep')

  end do

!-- output list file writing
  open(unit=11,file=trim(output_name),status='unknown')
     do i=1,nf
        write(11,*) trim(oname(i))
     end do
  close(unit=11)

end program
