program read_mgdsst_nc
  ! mgdsst  netcdf ǡ褹ץ
  ! sst_list ˺ǡե񤭹, ưǺ.
  ! , ˤĤƤ loop ƤʤΤ, ׽.
  ! Ϣ³եɤ߹뤬, Ϣ³ե˽ϤϤǤʤ.
  use file_operate
  use gtool_history
  implicit none
  integer, parameter :: nx=1440  ! mgdsst longtitude
  integer, parameter :: ny=720   ! mgdsst latitude
  real, parameter :: dlon=0.25  ! resolution of longtitude
  real, parameter :: dlat=0.25  ! resolution of latitude
  real, parameter :: lonmin=0.125  ! data start point (long)
  real, parameter :: latmin=-89.875  ! data start point (lat)
  real, dimension(nx,ny) :: sst, tmp
  real :: lon(nx), lat(ny)
  character(80), parameter :: dat_name='sst_list'
  character(80), allocatable, dimension(:) :: dat_list
  integer :: dat_line
  character(10) :: formatt
  integer :: i, j, k
  real, parameter :: cmin=270.0, cmax=306.0, contmin=270.0, contmax=306.0
  real, parameter :: vxmin=0.15, vxmax=0.85, vymin=0.225, vymax=0.775
  character(6) :: form_typec='(f5.1)', form_types='(f5.1)'

  lon=(/((lonmin+dlon*(i-1)),i=1,nx)/)
  lat=(/((latmin+dlat*(i-1)),i=1,ny)/)

  formatt='(1440a3)'
  dat_line=line_number_counter( trim(dat_name) )
  allocate(dat_list(dat_line))
  open(unit=11,file=trim(dat_name),status='old')
  do i=1,dat_line
     read(11,*) dat_list(i)
  end do
  close(unit=11,status='keep')

  do i=1,dat_line
     call read_mgdsst( trim(dat_list(i)), sst )  ! ɤ߹

     do k=1,ny
        do j=1,nx
           if(sst(j,k)==888.0)then
              sst(j,k)=263.0  ! ɹξ, -10 ٤ǸꤷƤ.
           end if
        end do
     end do

     call HistoryCreate( &                             ! ҥȥ꡼
       & file=trim(dat_list(i))//'.nc', title=trim(dat_list(i))//'sst data', &
       & source='Sample program of gtool_history/gtool5',   &
       & institution='GFD_Dennou Club davis project',       &
       & dims=(/'lon','lat'/), dimsizes=(/nx,ny/),               &
       & longnames=(/'longitude','latitude'/),       &
       & units=(/'deg','deg'/),                                 &
       & origin=0.0, interval=0.0 )

     call HistoryPut( 'lon', lon )                            ! ѿ
     call HistoryPut( 'lat', lat )                            ! ѿ

     call HistoryAddVariable( &                           ! ѿ
       & varname='sst', dims=(/'lon','lat'/), &
       & longname='sea surface temperature', units='K', xtype='float')

     call HistoryPut( 'sst', sst )

     call HistoryClose

  end do

end program
