module Thermo_Advanced_Routine
! å롼, ؿ use ʣǮϳشؿ׻⥸塼
use Thermo_Function
use Thermo_Const
use Thermo_Routine
use Math_Const
use Phys_Const
use Thermo_Advanced_Function

contains

subroutine Rich_horizon( za, pta, ptg, va, qva, qvs, Ri )
! Х륯㡼ɥ׻롼
  use Phys_Const
  use Thermo_Function
  use Thermo_Advanced_Function
  implicit none
  real, intent(in) :: za  ! 㡼ɥ׻ [m]
  real, intent(in), dimension(:,:) :: pta  ! za Ǥβ [K]
  real, intent(in), dimension(size(pta,1),size(pta,2)) :: ptg  ! ɽ̤Ǥβ [K]
  real, intent(in), dimension(size(pta,1),size(pta,2)) :: va  !  za Ǥοʿ® [m/s]
  real, intent(in), dimension(size(pta,1),size(pta,2)) :: qva  ! za Ǥκ [kg/kg]
  real, intent(in), dimension(size(pta,1),size(pta,2)) :: qvs  ! ɽ̤Ǥ˰º [kg/kg]
  real, intent(inout), dimension(size(pta,1),size(pta,2)) :: Ri  ! 㡼ɥ
  real, dimension(size(pta,1),size(pta,2)) :: ptvg, ptva, dpt
  integer :: i, j, nx, ny

  nx=size(pta,1)
  ny=size(pta,2)

!$omp parallel default(shared) do private(i,j)
  do j=1,ny
     do i=1,nx
        Ri(i,j)=Rich( za, pta(i,j), ptg(i,j), va(i,j), qva(i,j), qvs(i,j) )
     end do
  end do
!$omp end parallel do

end subroutine

!--------------------------------------------------------

subroutine Louis_horizon( z, z0m, richard, Lo )
! Louis(1980) ƤƤ絤԰٤θХ륯׻ؿ
  use Thermo_Const
  use Thermo_Advanced_Function
  implicit none
  real, intent(in) :: z  ! cm  [m]
  real, intent(in), dimension(:,:) :: z0m  ! ǥǷ׻ٹ [m]
  real, intent(in), dimension(size(z0m,1),size(z0m,2)) :: richard  ! Х륯㡼ɥ
  real, intent(inout), dimension(size(z0m,1),size(z0m,2)) :: Lo  ! 
  real, parameter :: b=5.0, c=5.0
  real :: cm_tmp, zratio
  integer :: i, j, nx, ny

  nx=size(z0m,1)
  ny=size(z0m,2)

!$omp parallel default(shared) do private(i,j)
  do j=1,ny
     do i=1,nx
        Lo(i,j)=Louis( z, z0m(i,j), richard(i,j) )
     end do
  end do
!$omp end parallel do

end subroutine

!--------------------------------------------------------

subroutine cm_horizon( z, z0m, coem, richard )
! ư̤˴ؤХ륯׻롼
  use Thermo_Const
  use Thermo_Advanced_Function
  implicit none
  real, intent(in) :: z  ! cm  [m]
  real, intent(in), dimension(:,:) :: z0m  ! ǥǷ׻ٹ [m]
  real, intent(inout), dimension(size(z0m,1),size(z0m,2)) :: coem  ! Х륯
  real, intent(in), dimension(size(z0m,1),size(z0m,2)), optional :: richard  ! Louis (1980) ΥǷ׻ΥХ륯㡼ɥ
  integer :: i, j, nx, ny

  nx=size(z0m,1)
  ny=size(z0m,2)

  if(present(richard))then
!$omp parallel default(shared) do private(i,j)
     do j=1,ny
        do i=1,nx
           coem(i,j)=cm( z, z0m(i,j), richard(i,j) )
        end do
     end do
!$omp end parallel do
  else
!$omp parallel default(shared) do private(i,j)
     do j=1,ny
        do i=1,nx
           coem(i,j)=cm( z, z0m(i,j), richard(i,j) )
        end do
     end do
!$omp end parallel do
  end if

end subroutine

!--------------------------------------------------------

subroutine ust_horizon( cm, va, velst )
! ໤® u_* ׻롼
  use Thermo_Advanced_Function
  implicit none
  real, intent(in), dimension(:,:) :: cm  !  za ǤΥХ륯
  real, intent(in), dimension(size(cm,1),size(cm,2)) :: va  !  za Ǥοʿ [m/s]
  real, intent(inout), dimension(size(cm,1),size(cm,2)) :: velst  ! ໤® [m/s]
  integer :: i, j, nx, ny

!$omp parallel default(shared) do private(i,j)
     do j=1,ny
        do i=1,nx
           velst(i,j)=ust( cm(i,j), va(i,j) )
        end do
     end do
!$omp end parallel do

end subroutine




end module
