module analy  ! ׻̥ǡѲϥ⥸塼

contains

subroutine div( x, y, u, v, val, undeff, hx, hy )
! 2ȯ׻롼
! 
! $\frac{\partial u}{\partial x} +\frac{\partial v}{\partial y} $ 
! 2 ʬǽ񤭴,  $(i,j)$ Ǥȯ
! $\frac{u_{i+1,j}-u_{i-1,j}}{2dx} + \frac{v_{i,j+1}-v_{i,j-1}}{2dy} $
! ȤǤ. Ѥ2ȯ׻.
! ǡ­ʤΰǤ, 1 κʬǷ׻Τ, ٤
! .
! ŪֳֳʻҤΥǡΤߤ׻ǤʤΤ, ֳ֤Υǡ
! ֳ֤ޤʤԤäƤ餳Υ롼ƤӽФɬפ.
! , ǤդγʻҺɸϤб뤿, ˥󥰥եץ
! ɲä, ߤϻѤƤʤ.
  implicit none
  real, intent(in) :: x(:)  ! x ζֺɸ [m]
  real, intent(in) :: y(:)  ! y ζֺɸ [m]
  real, intent(in) :: u(size(x),size(y))  ! x б 2 ٥ȥʬ
  real, intent(in) :: v(size(x),size(y))  ! y б 2 ٥ȥʬ
  real, intent(inout) :: val(size(x),size(y))  ! 2ȯ
  real, intent(in), optional :: undeff
  real, intent(in), optional :: hx(size(x),size(y))  ! x Υ
  real, intent(in), optional :: hy(size(x),size(y))  ! y Υ
  integer :: i   ! 졼ź
  integer :: j   ! 졼ź
  integer :: nx  ! ǿ 1 
  integer :: ny  ! ǿ 2 
  real :: dx  ! 1 ܤʬʻҴֳ [m]
  real :: dy  ! 2 ܤʬʻҴֳ [m]

  dx=x(2)-x(1)
  dy=y(2)-y(1)
  nx=size(x)
  ny=size(y)

  if(present(undeff))then
     do j=2,ny-1
        do i=2,nx-1
           if(u(i+1,j)==undeff.or.u(i-1,j)==undeff.or.v(i,j+1)==undeff.or.  &
  &           v(i,j-1)==undeff)then
              val(i,j)=undeff
           else
              val(i,j)=0.5*((u(i+1,j)-u(i-1,j))/dx+(v(i,j+1)-v(i,j-1))/dy)
           end if
        end do
     end do

!-- ΰü ---
!-- y ξü ---
     do i=2,nx-1
        if(u(i+1,1)==undeff.or.u(i-1,1)==undeff.or.v(i,2)==undeff.or.v(i,1)==undeff)then
           val(i,1)=undeff
        else
           val(i,1)=0.5*(u(i+1,1)-u(i-1,1))/dx+(v(i,2)-v(i,1))/dy
        end if

        if(u(i+1,ny)==undeff.or.u(i-1,ny)==undeff.or.v(i,ny)==undeff.or.  &
  &        v(i,ny-1)==undeff)then
           val(i,ny)=undeff
        else
           val(i,ny)=0.5*(u(i+1,ny)-u(i-1,ny))/dx+(v(i,ny)-v(i,ny-1))/dy
        end if
     end do
!-- x ξü ---
     do j=2,ny-1
        if(u(2,j)==undeff.or.u(1,j)==undeff.or.v(1,j+1)==undeff.or.v(1,j-1)==undeff)then
           val(1,j)=undeff
        else
           val(1,j)=(u(2,j)-u(1,j))/dx+0.5*((v(1,j+1)-v(1,j-1))/dy)
        end if

        if(u(nx,j)==undeff.or.u(nx-1,j)==undeff.or.v(nx,j+1)==undeff.or.  &
  &        v(nx,j-1)==undeff)then
           val(nx,j)=undeff
        else
           val(nx,j)=(u(nx,j)-u(nx-1,j))/dx+0.5*((v(nx,j+1)-v(nx,j-1))/dy)
        end if
     end do
!-- 4  ---
     if(u(2,1)==undeff.or.u(1,1)==undeff.or.v(1,2)==undeff.or.v(1,1)==undeff)then
        val(1,1)=undeff
     else
        val(1,1)=(u(2,1)-u(1,1))/dx+(v(1,2)-v(1,1))/dy
     end if

     if(u(2,ny)==undeff.or.u(1,ny)==undeff.or.v(1,ny)==undeff.or.v(1,ny-1)==undeff)then
        val(1,ny)=undeff
     else
        val(1,ny)=(u(2,ny)-u(1,ny))/dx+(v(1,ny)-v(1,ny-1))/dy
     end if

     if(u(nx,1)==undeff.or.u(nx-1,1)==undeff.or.v(nx,2)==undeff.or.v(nx,1)==undeff)then
        val(nx,1)=undeff
     else
        val(nx,1)=(u(nx,1)-u(nx-1,1))/dx+(v(nx,2)-v(nx,1))/dy
     end if

     if(u(nx,ny)==undeff.or.u(nx-1,ny)==undeff.or.v(nx,ny)==undeff.or.  &
  &     v(nx,ny-1)==undeff)then
        val(nx,ny)=undeff
     else
        val(nx,ny)=(u(nx,ny)-u(nx-1,ny))/dx+(v(nx,ny)-v(nx,ny-1))/dy
     end if

  else

     do j=2,ny-1
        do i=2,nx-1
           val(i,j)=0.5*((u(i+1,j)-u(i-1,j))/dx+(v(i,j+1)-v(i,j-1))/dy)
        end do
     end do

!-- ΰü ---
!-- y ξü ---
     do i=2,nx-1
        val(i,1)=0.5*(u(i+1,1)-u(i-1,1))/dx+(v(i,2)-v(i,1))/dy
        val(i,ny)=0.5*(u(i+1,ny)-u(i-1,ny))/dx+(v(i,ny)-v(i,ny-1))/dy
     end do
!-- x ξü ---
     do j=2,ny-1
        val(1,j)=(u(2,j)-u(1,j))/dx+0.5*((v(1,j+1)-v(1,j-1))/dy)
        val(nx,j)=(u(nx,j)-u(nx-1,j))/dx+0.5*((v(nx,j+1)-v(nx,j-1))/dy)
     end do
!-- 4  ---
     val(1,1)=(u(2,1)-u(1,1))/dx+(v(1,2)-v(1,1))/dy
     val(1,ny)=(u(2,ny)-u(1,ny))/dx+(v(1,ny)-v(1,ny-1))/dy
     val(nx,1)=(u(nx,1)-u(nx-1,1))/dx+(v(nx,2)-v(nx,1))/dy
     val(nx,ny)=(u(nx,ny)-u(nx-1,ny))/dx+(v(nx,ny)-v(nx,ny-1))/dy

  end if

end subroutine div


subroutine curl( x, y, u, v, val, undeff, hx, hy, ord )
! 2 ٷ׻롼
!
! x, y μμ㤤ɬ¤٤뤳.
!
! u, v ϶ִθ֤, Ǥդ2٤׻ǽ
! , du/dz-dw/dx ׻ȤΤ, (x,z,u,w) ν֤, ord ץ false.
!
! $\frac{\partial v}{\partial x} -\frac{\partial u}{\partial y} $ 
! 2 ʬǽ񤭴,  $(i,j)$ Ǥȯ
! $\frac{v_{i,j+1}-v_{i,j-1}}{2dx} -\frac{u_{i+1,j}-u_{i-1,j}}{2dy} $
! ȤǤ. Ѥ2ȯ׻.
! ǡ­ʤΰǤ, 1 κʬǷ׻Τ, ٤
! .
! ŪֳֳʻҤΥǡΤߤ׻ǤʤΤ, ֳ֤Υǡ
! ֳ֤ޤʤԤäƤ餳Υ롼ƤӽФɬפ.
! , ǤդγʻҺɸϤб뤿, ˥󥰥եץ
! ɲä, ߤϻѤƤʤ.
  implicit none
  real, intent(in) :: x(:)  ! x ζֺɸ [m]
  real, intent(in) :: y(:)  ! y ζֺɸ [m]
  real, intent(in) :: u(size(x),size(y))  ! x б 2 ٥ȥʬ
  real, intent(in) :: v(size(x),size(y))  ! y б 2 ٥ȥʬ
  real, intent(inout) :: val(size(x),size(y))  ! 2
  real, intent(in), optional :: undeff
  real, intent(in), optional :: hx(size(x),size(y))  ! x Υ
  real, intent(in), optional :: hy(size(x),size(y))  ! y Υ
  logical, intent(in),  optional :: ord  ! ʬν֤ؤ륪ץ.
                 ! true ʤ, ؤʤ, false ʤ, ؤ.
                 ! ǥեȤ true, du/dz-dw/dx ׻ȤΤѤ.
  integer :: i   ! 졼ź
  integer :: j   ! 졼ź
  integer :: nx  ! ǿ 1 
  integer :: ny  ! ǿ 2 
  real :: dx  ! 1 ܤʬʻҴֳ [m]
  real :: dy  ! 2 ܤʬʻҴֳ [m]
  logical :: order

  if(present(ord))then
     order=ord
  else
     order=.true.
  end if

  dx=x(2)-x(1)
  dy=y(2)-y(1)
  nx=size(x)
  ny=size(y)

  if(present(undeff))then
     do j=2,ny-1
        do i=2,nx-1
           if(v(i+1,j)==undeff.or.v(i-1,j)==undeff.or.u(i,j+1)==undeff.or.  &
  &           u(i,j-1)==undeff)then
              val(i,j)=undeff
           else
              val(i,j)=0.5*((v(i+1,j)-v(i-1,j))/dx-(u(i,j+1)-u(i,j-1))/dy)
           end if
        end do
     end do

!-- ΰü ---
!-- y ξü ---
     do i=2,nx-1
        if(v(i+1,1)==undeff.or.v(i-1,1)==undeff.or.u(i,2)==undeff.or.u(i,1)==undeff)then
           val(i,1)=undeff
        else
           val(i,1)=0.5*(v(i+1,1)-v(i-1,1))/dx-(u(i,2)-u(i,1))/dy
        end if

        if(v(i+1,ny)==undeff.or.v(i-1,ny)==undeff.or.u(i,ny)==undeff.or.  &
  &        u(i,ny-1)==undeff)then
           val(i,ny)=undeff
        else
           val(i,ny)=0.5*(v(i+1,ny)-v(i-1,ny))/dx-(u(i,ny)-u(i,ny-1))/dy
        end if
     end do
!-- x ξü ---
     do j=2,ny-1
        if(v(2,j)==undeff.or.v(1,j)==undeff.or.u(1,j+1)==undeff.or.u(1,j-1)==undeff)then
           val(1,j)=undeff
        else
           val(1,j)=(v(2,j)-v(1,j))/dx-0.5*((u(1,j+1)-u(1,j-1))/dy)
        end if

        if(v(nx,j)==undeff.or.v(nx-1,j)==undeff.or.u(nx,j+1)==undeff.or.  &
  &        u(nx,j-1)==undeff)then
           val(nx,j)=undeff
        else
           val(nx,j)=(v(nx,j)-v(nx-1,j))/dx-0.5*((u(nx,j+1)-u(nx,j-1))/dy)
        end if
     end do
!-- 4  ---
     if(v(2,1)==undeff.or.v(1,1)==undeff.or.u(1,2)==undeff.or.u(1,1)==undeff)then
        val(1,1)=undeff
     else
        val(1,1)=(v(2,1)-v(1,1))/dx-(u(1,2)-u(1,1))/dy
     end if

     if(v(2,ny)==undeff.or.v(1,ny)==undeff.or.u(1,ny)==undeff.or.u(1,ny-1)==undeff)then
        val(1,ny)=undeff
     else
        val(1,ny)=(v(2,ny)-v(1,ny))/dx-(u(1,ny)-u(1,ny-1))/dy
     end if

     if(v(nx,1)==undeff.or.v(nx-1,1)==undeff.or.u(nx,2)==undeff.or.u(nx,1)==undeff)then
        val(nx,1)=undeff
     else
        val(nx,1)=(v(nx,1)-v(nx-1,1))/dx-(u(nx,2)-u(nx,1))/dy
     end if

     if(v(nx,ny)==undeff.or.v(nx-1,ny)==undeff.or.u(nx,ny)==undeff.or.  &
  &     u(nx,ny-1)==undeff)then
        val(nx,ny)=undeff
     else
        val(nx,ny)=(v(nx,ny)-v(nx-1,ny))/dx-(u(nx,ny)-u(nx,ny-1))/dy
     end if

  else

     do j=2,ny-1
        do i=2,nx-1
           val(i,j)=0.5*((v(i+1,j)-v(i-1,j))/dx-(u(i,j+1)-u(i,j-1))/dy)
        end do
     end do

!-- ΰü ---
!-- y ξü ---
     do i=2,nx-1
        val(i,1)=0.5*(v(i+1,1)-v(i-1,1))/dx-(u(i,2)-u(i,1))/dy
        val(i,ny)=0.5*(v(i+1,ny)-v(i-1,ny))/dx-(u(i,ny)-u(i,ny-1))/dy
     end do
!-- x ξü ---
     do j=2,ny-1
        val(1,j)=(v(2,j)-v(1,j))/dx-0.5*((u(1,j+1)-u(1,j-1))/dy)
        val(nx,j)=(v(nx,j)-v(nx-1,j))/dx-0.5*((u(nx,j+1)-u(nx,j-1))/dy)
     end do
!-- 4  ---
     val(1,1)=(v(2,1)-v(1,1))/dx-(u(1,2)-u(1,1))/dy
     val(1,ny)=(v(2,ny)-v(1,ny))/dx-(u(1,ny)-u(1,ny-1))/dy
     val(nx,1)=(v(nx,1)-v(nx-1,1))/dx-(u(nx,2)-u(nx,1))/dy
     val(nx,ny)=(v(nx,ny)-v(nx-1,ny))/dx-(u(nx,ny)-u(nx,ny-1))/dy
  end if

  if(order.eqv..false.)then
     do j=1,ny
        do i=1,nx
           val(i,j)=-val(i,j)
        end do
     end do
  end if

end subroutine curl

!-----------------------------------------
!-----------------------------------------

subroutine div_3d( x, y, z, u, v, w, val, undeff, hx, hy, hz )
! 3ȯ׻롼
!
! $\frac{\partial u}{\partial x} +\frac{\partial v}{\partial y} +\frac{\partial w}{\partial z} $ 
! 2 ʬǽ񤭴,  $(i,j,k)$ Ǥȯ
! $\frac{u_{i+1,j,k}-u_{i-1,j,k}}{2dx} + \frac{v_{i,j+1,k}-v_{i,j-1,k}}{2dy} + \frac{w_{i,j,k+1}-w_{i,j,k-1}}{2dz} $
! ȤǤ. Ѥ2ȯ׻.
! ǡ­ʤΰǤ, 1 κʬǷ׻Τ, ٤
! .
! ŪֳֳʻҤΥǡΤߤ׻ǤʤΤ, ֳ֤Υǡ
! ֳ֤ޤʤԤäƤ餳Υ롼ƤӽФɬפ.
! , ǤդγʻҺɸϤб뤿, ˥󥰥եץ
! ɲä, ߤϻѤƤʤ.
  implicit none
  real, intent(in) :: x(:)  ! x ζֺɸ [m]
  real, intent(in) :: y(:)  ! y ζֺɸ [m]
  real, intent(in) :: z(:)  ! z ζֺɸ [m]
  real, intent(in) :: u(size(x),size(y),size(z))  ! x б 2 ٥ȥʬ
  real, intent(in) :: v(size(x),size(y),size(z))  ! y б 2 ٥ȥʬ
  real, intent(in) :: w(size(x),size(y),size(z))  ! y б 2 ٥ȥʬ
  real, intent(inout) :: val(size(x),size(y),size(z))  ! 3 ȯ
  real, intent(in), optional :: undeff
  real, intent(in), optional :: hx(size(x),size(y),size(z))  ! x Υ
  real, intent(in), optional :: hy(size(x),size(y),size(z))  ! y Υ
  real, intent(in), optional :: hz(size(x),size(y),size(z))  ! z Υ
  integer :: i   ! 졼ź
  integer :: j   ! 졼ź
  integer :: k   ! 졼ź
  integer :: nx  ! ǿ 1 
  integer :: ny  ! ǿ 2 
  integer :: nz  ! ǿ 3 
  real :: dx  ! 1 ܤʬʻҴֳ [m]
  real :: dy  ! 2 ܤʬʻҴֳ [m]
  real :: dz  ! 3 ܤʬʻҴֳ [m]

  dx=x(2)-x(1)
  dy=y(2)-y(1)
  dz=z(2)-z(1)
  nx=size(x)
  ny=size(y)
  nz=size(z)

  if(present(undeff))then
!$omp parallel default(shared)
!$omp do private(i,j,k)
     do k=2,nz-1
        do j=2,ny-1
           do i=2,nx-1
              if(u(i+1,j,k)==undeff.or.u(i-1,j,k)==undeff.or.  &
   &             v(i,j+1,k)==undeff.or.v(i,j-1,k)==undeff.or.  &
   &             w(i,j,k+1)==undeff.or.w(i,j,k-1)==undeff)then
                 val(i,j,k)=undeff
              else
                 val(i,j,k)=0.5*((u(i+1,j,k)-u(i-1,j,k))/dx   &
   &                         +(v(i,j+1,k)-v(i,j-1,k))/dy   &
   &                         +(w(i,j,k+1)-w(i,j,k-1))/dz)
              end if
           end do
        end do
     end do
!$omp end do
!$omp end parallel
  else
!$omp parallel default(shared)
!$omp do private(i,j,k)
     do k=2,nz-1
        do j=2,ny-1
           do i=2,nx-1
              val(i,j,k)=0.5*((u(i+1,j,k)-u(i-1,j,k))/dx   &
   &                         +(v(i,j+1,k)-v(i,j-1,k))/dy   &
   &                         +(w(i,j,k+1)-w(i,j,k-1))/dz)
           end do
        end do
     end do
!$omp end do
!$omp end parallel
  end if

!-- ΰü ---
!-- ̤η׻ div 롼˷׻, η̤̤˿ľʬ
!   ȯ­碌뤳ȤǷ׻.
!-- z ˿ľ ---
  if(present(undeff))then
     call div( x, y, u(:,:,1), v(:,:,1), val(:,:,1), undeff )
     call div( x, y, u(:,:,nz), v(:,:,nz), val(:,:,nz), undeff )
     do j=2,ny-1
        do i=2,nx-1
           if(val(i,j,1)==undeff.or.w(i,j,2)==undeff.or.w(i,j,1)==undeff)then
              val(i,j,1)=undeff
           else
              val(i,j,1)=val(i,j,1)+(w(i,j,2)-w(i,j,1))/dz
           end if

           if(val(i,j,nz)==undeff.or.w(i,j,nz)==undeff.or.w(i,j,nz-1)==undeff)then
              val(i,j,nz)=undeff
           else
              val(i,j,nz)=val(i,j,nz)+(w(i,j,nz)-w(i,j,nz-1))/dz
           end if
        end do
     end do
  else
     call div( x, y, u(:,:,1), v(:,:,1), val(:,:,1) )
     call div( x, y, u(:,:,nz), v(:,:,nz), val(:,:,nz) )
     do j=2,ny-1
        do i=2,nx-1
           val(i,j,1)=val(i,j,1)+(w(i,j,2)-w(i,j,1))/dz
           val(i,j,nz)=val(i,j,nz)+(w(i,j,nz)-w(i,j,nz-1))/dz
        end do
     end do
  end if

!-- y ˿ľ ---
  if(present(undeff))then
     call div( x, z, u(:,1,:), w(:,1,:), val(:,1,:), undeff )
     call div( x, z, u(:,ny,:), w(:,ny,:), val(:,ny,:), undeff )
     do k=2,nz-1
        do i=2,nx-1
           if(val(i,1,k)==undeff.or.v(i,2,k)==undeff.or.v(i,1,k)==undeff)then
              val(i,1,k)=undeff
           else
              val(i,1,k)=val(i,1,k)+(v(i,2,k)-v(i,1,k))/dy
           end if

           if(val(i,ny,k)==undeff.or.v(i,ny,k)==undeff.or.v(i,ny-1,k)==undeff)then
              val(i,ny,k)=undeff
           else
              val(i,ny,k)=val(i,ny,k)+(v(i,ny,k)-v(i,ny-1,k))/dy
           end if
        end do
     end do
  else
     call div( x, z, u(:,1,:), w(:,1,:), val(:,1,:) )
     call div( x, z, u(:,ny,:), w(:,ny,:), val(:,ny,:) )
     do k=2,nz-1
        do i=2,nx-1
           val(i,1,k)=val(i,1,k)+(v(i,2,k)-v(i,1,k))/dy
           val(i,ny,k)=val(i,ny,k)+(v(i,ny,k)-v(i,ny-1,k))/dy
        end do
     end do
  end if

!-- x ˿ľ ---
  if(present(undeff))then
     call div( y, z, v(1,:,:), w(1,:,:), val(1,:,:), undeff )
     call div( y, z, v(nx,:,:), w(nx,:,:), val(nx,:,:), undeff )
     do k=2,nz-1
        do j=2,ny-1
           if(val(1,j,k)==undeff.or.u(2,j,k)==undeff.or.u(1,j,k)==undeff)then
              val(1,j,k)=undeff
           else
              val(1,j,k)=val(1,j,k)+(u(2,j,k)-u(1,j,k))/dx
           end if

           if(val(nx,j,k)==undeff.or.u(nx,j,k)==undeff.or.u(nx-1,j,k)==undeff)then
              val(nx,j,k)=undeff
           else
              val(nx,j,k)=val(nx,j,k)+(u(nx,j,k)-u(nx-1,j,k))/dx
           end if
        end do
     end do
  else
     call div( y, z, v(1,:,:), w(1,:,:), val(1,:,:) )
     call div( y, z, v(nx,:,:), w(nx,:,:), val(nx,:,:) )
     do k=2,nz-1
        do j=2,ny-1
           val(1,j,k)=val(1,j,k)+(u(2,j,k)-u(1,j,k))/dx
           val(nx,j,k)=val(nx,j,k)+(u(nx,j,k)-u(nx-1,j,k))/dx
        end do
     end do
  end if

!-- ƼʿԤʶ 12 
!-- x ʿԤ 4 
  if(present(undeff))then
     do i=2,nx-1
        if(u(i+1,1,1)==undeff.or.u(i-1,1,1)==undeff.or.  &
    &      v(i,2,1)==undeff.or.v(i,1,1)==undeff.or.  &
    &      w(i,1,2)==undeff.or.w(i,1,1)==undeff)then
           val(i,1,1)=undeff
        else
           val(i,1,1)=0.5*(u(i+1,1,1)-u(i-1,1,1))/dx  &
    &                +(v(i,2,1)-v(i,1,1))/dy  &
    &                +(w(i,1,2)-w(i,1,1))/dz
        end if

        if(u(i+1,ny,1)==undeff.or.u(i-1,ny,1)==undeff.or.  &
    &      v(i,ny,1)==undeff.or.v(i,ny-1,1)==undeff.or.  &
    &      w(i,ny,2)==undeff.or.w(i,ny,1)==undeff)then
           val(i,ny,1)=undeff
        else
           val(i,ny,1)=0.5*(u(i+1,ny,1)-u(i-1,ny,1))/dx  &
    &                  +(v(i,ny,1)-v(i,ny-1,1))/dy  &
    &                  +(w(i,ny,2)-w(i,ny,1))/dz
        end if

        if(u(i+1,1,nz)==undeff.or.u(i-1,1,nz)==undeff.or.  &
    &      v(i,2,nz)==undeff.or.v(i,1,nz)==undeff.or.  &
    &      w(i,1,nz)==undeff.or.w(i,1,nz-1)==undeff)then
           val(i,1,nz)=undeff
        else
           val(i,1,nz)=0.5*(u(i+1,1,nz)-u(i-1,1,nz))/dx  &
    &                  +(v(i,2,nz)-v(i,1,nz))/dy  &
    &                  +(w(i,1,nz)-w(i,1,nz-1))/dz
        end if

        if(u(i+1,ny,nz)==undeff.or.u(i-1,ny,nz)==undeff.or.  &
    &      v(i,ny,nz)==undeff.or.v(i,ny-1,nz)==undeff.or.  &
    &      w(i,ny,nz)==undeff.or.w(i,ny,nz-1)==undeff)then
           val(i,ny,nz)=undeff
        else
           val(i,ny,nz)=0.5*(u(i+1,ny,nz)-u(i-1,ny,nz))/dx  &
    &                   +(v(i,ny,nz)-v(i,ny-1,nz))/dy  &
    &                   +(w(i,ny,nz)-w(i,ny,nz-1))/dz
        end if
     end do
  else
     val(i,1,1)=0.5*(u(i+1,1,1)-u(i-1,1,1))/dx  &
    &          +(v(i,2,1)-v(i,1,1))/dy  &
    &          +(w(i,1,2)-w(i,1,1))/dz
     val(i,ny,1)=0.5*(u(i+1,ny,1)-u(i-1,ny,1))/dx  &
    &          +(v(i,ny,1)-v(i,ny-1,1))/dy  &
    &          +(w(i,ny,2)-w(i,ny,1))/dz
     val(i,1,nz)=0.5*(u(i+1,1,nz)-u(i-1,1,nz))/dx  &
    &          +(v(i,2,nz)-v(i,1,nz))/dy  &
    &          +(w(i,1,nz)-w(i,1,nz-1))/dz
     val(i,ny,nz)=0.5*(u(i+1,ny,nz)-u(i-1,ny,nz))/dx  &
    &          +(v(i,ny,nz)-v(i,ny-1,nz))/dy  &
    &          +(w(i,ny,nz)-w(i,ny,nz-1))/dz
  end if

!-- y ʿԤ 4 
  if(present(undeff))then
     do j=2,ny-1
        if(u(2,j,1)==undeff.or.u(1,j,1)==undeff.or.  &
    &      v(1,j+1,1)==undeff.or.v(1,j-1,1)==undeff.or.  &
    &      w(1,j,2)==undeff.or.w(1,j,1)==undeff)then
           val(1,j,1)=undeff
        else
           val(1,j,1)=(u(2,j,1)-u(1,j,1))/dx  &
    &                +0.5*(v(1,j+1,1)-v(1,j-1,1))/dy  &
    &                +(w(1,j,2)-w(1,j,1))/dz
        end if

        if(u(nx,j,1)==undeff.or.u(nx-1,j,1)==undeff.or.  &
    &      v(nx,j+1,1)==undeff.or.v(nx,j-1,1)==undeff.or.  &
    &      w(nx,j,2)==undeff.or.w(nx,j,1)==undeff)then
           val(nx,j,1)=undeff
        else
           val(nx,j,1)=(u(nx,j,1)-u(nx-1,j,1))/dx  &
    &                +0.5*(v(nx,j+1,1)-v(nx,j-1,1))/dy  &
    &                +(w(nx,j,2)-w(nx,j,1))/dz
        end if

        if(u(2,j,nz)==undeff.or.u(1,j,nz)==undeff.or.  &
    &      v(1,j+1,nz)==undeff.or.v(1,j-1,nz)==undeff.or.  &
    &      w(1,j,nz)==undeff.or.w(1,j,nz-1)==undeff)then
           val(1,j,nz)=undeff
        else
           val(1,j,nz)=(u(2,j,nz)-u(1,j,nz))/dx  &
    &                +0.5*(v(1,j+1,nz)-v(1,j-1,nz))/dy  &
    &                +(w(1,j,nz)-w(1,j,nz-1))/dz
        end if

        if(u(nx,j,nz)==undeff.or.u(nx-1,j,nz)==undeff.or.  &
    &      v(nx,j+1,nz)==undeff.or.v(nx,j-1,nz)==undeff.or.  &
    &      w(nx,j,nz)==undeff.or.w(nx,j,nz-1)==undeff)then
           val(nx,j,nz)=undeff
        else
           val(nx,j,nz)=(u(nx,j,nz)-u(nx-1,j,nz))/dx  &
    &                +0.5*(v(nx,j+1,nz)-v(nx,j-1,nz))/dy  &
    &                +(w(nx,j,nz)-w(nx,j,nz-1))/dz
        end if
     end do
  else
     do j=2,ny-1
        val(1,j,1)=(u(2,j,1)-u(1,j,1))/dx  &
    &             +0.5*(v(1,j+1,1)-v(1,j-1,1))/dy  &
    &             +(w(1,j,2)-w(1,j,1))/dz
        val(nx,j,1)=(u(nx,j,1)-u(nx-1,j,1))/dx  &
    &             +0.5*(v(nx,j+1,1)-v(nx,j-1,1))/dy  &
    &             +(w(nx,j,2)-w(nx,j,1))/dz
        val(1,j,nz)=(u(2,j,nz)-u(1,j,nz))/dx  &
    &             +0.5*(v(1,j+1,nz)-v(1,j-1,nz))/dy  &
    &             +(w(1,j,nz)-w(1,j,nz-1))/dz
        val(nx,j,nz)=(u(nx,j,nz)-u(nx-1,j,nz))/dx  &
    &             +0.5*(v(nx,j+1,nz)-v(nx,j-1,nz))/dy  &
    &             +(w(nx,j,nz)-w(nx,j,nz-1))/dz
     end do
  end if

!-- z ʿԤ 4 
  if(present(undeff))then
     do k=2,nz-1
        if(u(2,1,k)==undeff.or.u(1,1,k)==undeff.or.  &
    &      v(1,2,k)==undeff.or.v(1,1,k)==undeff.or.  &
    &      w(1,1,k+1)==undeff.or.w(1,1,k-1)==undeff)then
           val(1,1,k)=undeff
        else
           val(1,1,k)=(u(2,1,k)-u(1,1,k))/dx  &
    &                +(v(1,2,k)-v(1,1,k))/dy  &
    &                +0.5*(w(1,1,k+1)-w(1,1,k-1))/dz
        end if

        if(u(nx,1,k)==undeff.or.u(nx-1,1,k)==undeff.or.  &
    &      v(nx,2,k)==undeff.or.v(nx,1,k)==undeff.or.  &
    &      w(nx,1,k+1)==undeff.or.w(nx,1,k-1)==undeff)then
           val(nx,1,k)=undeff
        else
           val(nx,1,k)=(u(nx,1,k)-u(nx-1,1,k))/dx  &
    &                +(v(nx,2,k)-v(nx,1,k))/dy  &
    &                +0.5*(w(nx,1,k+1)-w(nx,1,k-1))/dz
        end if

        if(u(2,ny,k)==undeff.or.u(1,ny,k)==undeff.or.  &
    &      v(1,ny,k)==undeff.or.v(1,ny-1,k)==undeff.or.  &
    &      w(1,ny,k+1)==undeff.or.w(1,ny,k-1)==undeff)then
           val(1,ny,k)=undeff
        else
           val(1,ny,k)=(u(2,ny,k)-u(1,ny,k))/dx  &
    &                +(v(1,ny,k)-v(1,ny-1,k))/dy  &
    &                +0.5*(w(1,ny,k+1)-w(1,ny,k-1))/dz
        end if

        if(u(nx,ny,k)==undeff.or.u(nx-1,ny,k)==undeff.or.  &
    &      v(nx,ny,k)==undeff.or.v(nx,ny-1,k)==undeff.or.  &
    &      w(nx,ny,k+1)==undeff.or.w(nx,ny,k-1)==undeff)then
           val(nx,ny,k)=undeff
        else
           val(nx,ny,k)=(u(nx,ny,k)-u(nx-1,ny,k))/dx  &
    &                +(v(nx,ny,k)-v(nx,ny-1,k))/dy  &
    &                +0.5*(w(nx,ny,k+1)-w(nx,ny,k-1))/dz
        end if
     end do
  else
     do k=2,nz-1
        val(1,1,k)=(u(2,1,k)-u(1,1,k))/dx  &
    &             +(v(1,2,k)-v(1,1,k))/dy  &
    &             +0.5*(w(1,1,k+1)-w(1,1,k-1))/dz
        val(nx,1,k)=(u(nx,1,k)-u(nx-1,1,k))/dx  &
    &             +(v(nx,2,k)-v(nx,1,k))/dy  &
    &             +0.5*(w(nx,1,k+1)-w(nx,1,k-1))/dz
        val(1,ny,k)=(u(2,ny,k)-u(1,ny,k))/dx  &
    &             +(v(1,ny,k)-v(1,ny-1,k))/dy  &
    &             +0.5*(w(1,ny,k+1)-w(1,ny,k-1))/dz
        val(nx,ny,k)=(u(nx,ny,k)-u(nx-1,ny,k))/dx  &
    &             +(v(nx,ny,k)-v(nx,ny-1,k))/dy  &
    &             +0.5*(w(nx,ny,k+1)-w(nx,ny,k-1))/dz
     end do
  end if

!-- 8  ---
  if(present(undeff))then
     if(u(2,1,1)==undeff.or.-u(1,1,1)==undeff.or.  &
  &     v(1,2,1)==undeff.or.v(1,1,1)==undeff.or.  &
  &     w(1,1,2)==undeff.or.w(1,1,1)==undeff)then
        val(1,1,1)=undeff
     else
        val(1,1,1)=(u(2,1,1)-u(1,1,1))/dx  &
  &               +(v(1,2,1)-v(1,1,1))/dy  &
  &               +(w(1,1,2)-w(1,1,1))/dz
     end if

     if(u(nx,1,1)==undeff.or.u(nx-1,1,1)==undeff.or.  &
  &     v(nx,2,1)==undeff.or.v(nx,1,1)==undeff.or.  &
  &     w(nx,1,2)==undeff.or.w(nx,1,1)==undeff)then
        val(nx,1,1)=undeff
     else
        val(nx,1,1)=(u(nx,1,1)-u(nx-1,1,1))/dx  &
  &               +(v(nx,2,1)-v(nx,1,1))/dy  &
  &               +(w(nx,1,2)-w(nx,1,1))/dz
     end if

     if(u(2,ny,1)==undeff.or.u(1,ny,1)==undeff.or.  &
  &     v(1,ny,1)==undeff.or.v(1,ny-1,1)==undeff.or.  &
  &     w(1,ny,2)==undeff.or.w(1,ny,1)==undeff)then
        val(1,ny,1)=undeff
     else
        val(1,ny,1)=(u(2,ny,1)-u(1,ny,1))/dx  &
  &               +(v(1,ny,1)-v(1,ny-1,1))/dy  &
  &               +(w(1,ny,2)-w(1,ny,1))/dz
     end if

     if(u(2,1,nz)==undeff.or.u(1,1,nz)==undeff.or.  &
  &     v(1,2,nz)==undeff.or.v(1,1,nz)==undeff.or.  &
  &     w(1,1,nz)==undeff.or.w(1,1,nz-1)==undeff)then
        val(1,1,nz)=undeff
     else
        val(1,1,nz)=(u(2,1,nz)-u(1,1,nz))/dx  &
  &               +(v(1,2,nz)-v(1,1,nz))/dy  &
  &               +(w(1,1,nz)-w(1,1,nz-1))/dz
     end if

     if(u(nx,ny,1)==undeff.or.u(nx-1,ny,1)==undeff.or.  &
  &     v(nx,ny,1)==undeff.or.v(nx,ny-1,1)==undeff.or.  &
  &     w(nx,ny,2)==undeff.or.w(nx,ny,1)==undeff)then
        val(nx,ny,1)=undeff
     else
        val(nx,ny,1)=(u(nx,ny,1)-u(nx-1,ny,1))/dx  &
  &               +(v(nx,ny,1)-v(nx,ny-1,1))/dy  &
  &               +(w(nx,ny,2)-w(nx,ny,1))/dz
     end if

     if(u(2,ny,nz)==undeff.or.u(1,ny,nz)==undeff.or.  &
  &     v(1,ny,nz)==undeff.or.v(1,ny-1,nz)==undeff.or.  &
  &     w(1,ny,nz)==undeff.or.w(1,ny,nz-1)==undeff)then
        val(1,ny,nz)=undeff
     else
        val(1,ny,nz)=(u(2,ny,nz)-u(1,ny,nz))/dx  &
  &               +(v(1,ny,nz)-v(1,ny-1,nz))/dy  &
  &               +(w(1,ny,nz)-w(1,ny,nz-1))/dz
     end if

     if(u(nx,1,nz)==undeff.or.u(nx-1,1,nz)==undeff.or.  &
  &     v(nx,2,nz)==undeff.or.v(nx,1,nz)==undeff.or.  &
  &     w(nx,1,nz)==undeff.or.w(nx,1,nz-1)==undeff)then
        val(nx,1,nz)=undeff
     else
        val(nx,1,nz)=(u(nx,1,nz)-u(nx-1,1,nz))/dx  &
  &               +(v(nx,2,nz)-v(nx,1,nz))/dy  &
  &               +(w(nx,1,nz)-w(nx,1,nz-1))/dz
     end if

     if(u(nx,ny,nz)==undeff.or.u(nx-1,ny,nz)==undeff.or.  &
  &     v(nx,ny,nz)==undeff.or.v(nx,ny-1,nz)==undeff.or.  &
  &     w(nx,ny,nz)==undeff.or.w(nx,ny,nz-1)==undeff)then
        val(nx,ny,nz)=undeff
     else
        val(nx,ny,nz)=(u(nx,ny,nz)-u(nx-1,ny,nz))/dx  &
  &               +(v(nx,ny,nz)-v(nx,ny-1,nz))/dy  &
  &               +(w(nx,ny,nz)-w(nx,ny,nz-1))/dz
     end if
  else
     val(1,1,1)=(u(2,1,1)-u(1,1,1))/dx  &
  &            +(v(1,2,1)-v(1,1,1))/dy  &
  &            +(w(1,1,2)-w(1,1,1))/dz
     val(nx,1,1)=(u(nx,1,1)-u(nx-1,1,1))/dx  &
  &            +(v(nx,2,1)-v(nx,1,1))/dy  &
  &            +(w(nx,1,2)-w(nx,1,1))/dz
     val(1,ny,1)=(u(2,ny,1)-u(1,ny,1))/dx  &
  &            +(v(1,ny,1)-v(1,ny-1,1))/dy  &
  &            +(w(1,ny,2)-w(1,ny,1))/dz
     val(1,1,nz)=(u(2,1,nz)-u(1,1,nz))/dx  &
  &            +(v(1,2,nz)-v(1,1,nz))/dy  &
  &            +(w(1,1,nz)-w(1,1,nz-1))/dz
     val(nx,ny,1)=(u(nx,ny,1)-u(nx-1,ny,1))/dx  &
  &            +(v(nx,ny,1)-v(nx,ny-1,1))/dy  &
  &            +(w(nx,ny,2)-w(nx,ny,1))/dz
     val(1,ny,nz)=(u(2,ny,nz)-u(1,ny,nz))/dx  &
  &            +(v(1,ny,nz)-v(1,ny-1,nz))/dy  &
  &            +(w(1,ny,nz)-w(1,ny,nz-1))/dz
     val(nx,1,nz)=(u(nx,1,nz)-u(nx-1,1,nz))/dx  &
  &            +(v(nx,2,nz)-v(nx,1,nz))/dy  &
  &            +(w(nx,1,nz)-w(nx,1,nz-1))/dz
     val(nx,ny,nz)=(u(nx,ny,nz)-u(nx-1,ny,nz))/dx  &
  &            +(v(nx,ny,nz)-v(nx,ny-1,nz))/dy  &
  &            +(w(nx,ny,nz)-w(nx,ny,nz-1))/dz
  end if

end subroutine

!-----------------------------------------
!-----------------------------------------

subroutine rotate( x, y, z, u, v, w, zeta, eta, xi, undeff, hx, hy, hz )
! 3 ٤׻.
! ν֤ϱϤ x, y, z ΥǥȺɸ,
! б٥ȥʬ u, v, w ,
! б٥٥ȥʬ zeta, eta, xi ׻.
! curl λȤޤ路.
! div_3d Ǥ div Ȥ󤷤, rotate ϳ̤˿ľʥ٥ȥȤ
! ٥٥ȥ׻Τ, ̤ȶʬΥƷ׻
! ɬפϤʤ.
! ̤˿ľʱ٥٥ȥ curl ǶޤǹθƷ׻ǽǤ.
! , ǤդγʻҺɸϤб뤿, ˥󥰥եץ
! ɲä, ߤϻѤƤʤ.
  implicit none
  real, intent(in) :: x(:)  ! x ζֺɸ [m]
  real, intent(in) :: y(:)  ! y ζֺɸ [m]
  real, intent(in) :: z(:)  ! z ζֺɸ [m]
  real, intent(in) :: u(size(x),size(y),size(z))  ! x б 2 ٥ȥʬ
  real, intent(in) :: v(size(x),size(y),size(z))  ! y б 2 ٥ȥʬ
  real, intent(in) :: w(size(x),size(y),size(z))  ! y б 2 ٥ȥʬ
  real, intent(inout) :: zeta(size(x),size(y),size(z))  ! ٥٥ȥ x ʬ
  real, intent(inout) :: eta(size(x),size(y),size(z))  ! ٥٥ȥ y ʬ
  real, intent(inout) :: xi(size(x),size(y),size(z))  ! ٥٥ȥ z ʬ
  real, intent(in), optional :: undeff
  real, intent(in), optional :: hx(size(x),size(y),size(z))  ! x Υ
  real, intent(in), optional :: hy(size(x),size(y),size(z))  ! y Υ
  real, intent(in), optional :: hz(size(x),size(y),size(z))  ! z Υ
  integer :: i   ! 졼ź
  integer :: j   ! 졼ź
  integer :: k   ! 졼ź
  integer :: nx  ! ǿ 1 
  integer :: ny  ! ǿ 2 
  integer :: nz  ! ǿ 3 
  real :: dx  ! 1 ܤʬʻҴֳ [m]
  real :: dy  ! 2 ܤʬʻҴֳ [m]
  real :: dz  ! 3 ܤʬʻҴֳ [m]

  dx=x(2)-x(1)
  dy=y(2)-y(1)
  dz=z(2)-z(1)
  nx=size(x)
  ny=size(y)
  nz=size(z)

  if(present(undeff))then
!$omp parallel default(shared)
!$omp do private(i)
! x ˿ľ̾Ǥ x α٥٥ȥ 3 Ƿ׻.
     do i=1,nx
        call curl( y, z, v(i,:,:), w(i,:,:), zeta(i,:,:), undeff )
     end do

!$omp end do
!$omp end parallel
  else
!$omp parallel default(shared)
!$omp do private(i)
! x ˿ľ̾Ǥ x α٥٥ȥ 3 Ƿ׻.
     do i=1,nx
        call curl( y, z, v(i,:,:), w(i,:,:), zeta(i,:,:) )
     end do
!$omp end do
!$omp end parallel

  end if

! y ˿ľ̾Ǥ y α٥٥ȥ 3 Ƿ׻.

  if(present(undeff))then
!$omp parallel default(shared)
!$omp do private(j)
     do j=1,ny
        call curl( x, z, u(:,j,:), w(:,j,:), eta(:,j,:), undeff, ord=.false. )
     end do
!$omp end do
!$omp end parallel

  else
!$omp parallel default(shared)
!$omp do private(j)
     do j=1,ny
        call curl( x, z, u(:,j,:), w(:,j,:), eta(:,j,:), ord=.false. )
     end do
!$omp end do
!$omp end parallel

  end if

! z ˿ľ̾Ǥ z α٥٥ȥ 3 Ƿ׻.

  if(present(undeff))then
!$omp parallel default(shared)
!$omp do private(k)
     do k=1,nz
        call curl( x, y, u(:,:,k), v(:,:,k), xi(:,:,k), undeff )
     end do

!$omp end do
!$omp end parallel
  else
!$omp parallel default(shared)
!$omp do private(k)
     do k=1,nz
        call curl( x, y, u(:,:,k), v(:,:,k), xi(:,:,k) )
     end do

!$omp end do
!$omp end parallel
  end if

end subroutine

!-----------------------------------------
!-----------------------------------------

subroutine grad_1d( x, u, val, undef, hx )
! 1 Υ顼ѿθۤ׻
! $\frac{\partial p}{\partial x} $ 
! 2 ʬǽ񤭴,  $(i)$ Ǥθۤ
! $\frac{p_{i+1}-p_{i-1}}{2dx} $
! ȤǤ. Ѥ 1 ۤ׻.
! ǡ­ʤΰǤ, 1 κʬǷ׻Τ, ٤
! .
! ŪֳֳʻҤΥǡΤߤ׻ǤʤΤ, ֳ֤Υǡ
! ֳ֤ޤʤԤäƤ餳Υ롼ƤӽФɬפ.
  implicit none
  real, intent(in) :: x(:)  ! ֺɸ
  real, intent(in) :: u(size(x))  ! ζб 1 顼
  real, intent(inout) :: val(size(x))  ! 顼ͤ x θ
  real, intent(in), optional :: undef
  real, intent(in), optional :: hx(size(x))  ! x Υ
  integer :: i  ! 졼ź
  integer :: nx  ! ǿ
  real :: dx  ! ʻҴֳ [m]

  nx=size(x)
  dx=x(2)-x(1)

  if(present(undef))then
     do i=2,nx-1
        if(u(i+1)==undef.or.u(i-1)==undef)then
           val(i)=undef
        else
           val(i)=0.5*(u(i+1)-u(i-1))/dx
        end if
     end do
!-- ǡΤʤξüν ---
     if(u(1)==undef.or.u(2)==undef)then
        val(1)=undef
     else
        val(1)=(u(2)-u(1))/dx
     end if
     if(u(nx)==undef.or.u(nx-1)==undef)then
        val(nx)=undef
     else
        val(nx)=(u(nx)-u(nx-1))/dx
     end if
  else
     do i=2,nx-1
        val(i)=0.5*(u(i+1)-u(i-1))/dx
     end do
!-- ǡΤʤξüν ---
     val(1)=(u(2)-u(1))/dx
     val(nx)=(u(nx)-u(nx-1))/dx
  end if

end subroutine grad_1d



!-- 1 顼ۤΥ롼Ѥ 2 ۤΥ٥ȥ׻ ---
subroutine grad_vec_2d( x, y, u, valx, valy, undeff, hx, hy )
  !-------------------------------------------------------------------
  ! $\nabla _hp =\left(\frac{\partial p}{\partial x} ,\; \frac{\partial p}{\partial y} \right) $ 
  ! 2 ʬǽ񤭴,  $(i,j)$ Ǥθۤ
  ! $\left(\frac{p_{i+1,j}-p_{i-1,j}}{2dx} ,\; \frac{p_{i,j+1}-p_{i,j-1}}{2dy} \right) $
  ! ȤǤ. Ѥ2ۤ׻.
  ! ǡ­ʤΰǤ, 1 κʬǷ׻Τ, ٤
  ! .
  ! ŪֳֳʻҤΥǡΤߤ׻ǤʤΤ, ֳ֤Υǡ
  ! ֳ֤ޤʤԤäƤ餳Υ롼ƤӽФɬפ.
  ! Ѥ 1 ۷׻롼 2 ƤӽФȤˤƤ.
  !-------------------------------------------------------------------
  implicit none
  real, intent(in) :: x(:)  ! x κɸѿ [m]
  real, intent(in) :: y(:)  ! y κɸѿ [m]
  real, intent(in) :: u(size(x),size(y))  ! ۤȤ 2 顼ʬ
  real, intent(inout) :: valx(size(x),size(y))  ! ׻줿 y  2 ۥ٥ȥ
  real, intent(inout) :: valy(size(x),size(y))  ! ׻줿 y  2 ۥ٥ȥ
  real, intent(in), optional :: undeff
  real, intent(in), optional :: hx(size(x),size(y))  ! x Υ
  real, intent(in), optional :: hy(size(x),size(y))  ! y Υ
  integer :: i   ! 졼ź
  integer :: j   ! 졼ź
  integer :: nx  ! x ǿ(size ؿǼưŪ˷׻)
  integer :: ny  ! y ǿ(size ؿǼưŪ˷׻)
  real :: dx  ! x γʻֳ
  real :: dy  ! y γʻֳ

  nx=size(x)
  ny=size(y)
  dx=x(2)-x(1)
  dy=y(2)-y(1)

  if(present(undeff))then
     do i=1,ny
        call grad_1d(x, u(:,i), valx(:,i), undeff)
     end do

     do i=1,nx
        call grad_1d(y, u(i,:), valy(i,:), undeff)
     end do
  else
     do i=1,ny
        call grad_1d(x, u(:,i), valx(:,i) )
     end do

     do i=1,nx
        call grad_1d(y, u(i,:), valy(i,:) )
     end do
  end if

end subroutine grad_vec_2d



!-- 1 顼ۤΥ롼Ѥ 3 ۤΥ٥ȥ׻ ---
subroutine grad_vec_3d( x, y, z, u, valx, valy, valz, undeff, hx, hy, hz )
  !-------------------------------------------------------------------
  ! $\nabla p =\left(\frac{\partial p}{\partial x} ,\; \frac{\partial p}{\partial y} ,\; \frac{\partial p}{\partial z} \right) $ 
  ! 2 ʬǽ񤭴,  $(i,j,k)$ Ǥθۤ
  ! $\left(\frac{p_{i+1,j,k}-p_{i-1,j,k}}{2dx} ,\; \frac{p_{i,j+1,k}-p_{i,j-1,k}}{2dy} ,\; \frac{p_{i,j,k+1}-p_{i,j,k-1}}{2dz} \right) $
  ! ȤǤ. Ѥ 3 ۤ׻.
  ! ǡ­ʤΰǤ, 1 κʬǷ׻Τ, ٤
  ! .
  ! ŪֳֳʻҤΥǡΤߤ׻ǤʤΤ, ֳ֤Υǡ
  ! ֳ֤ޤʤԤäƤ餳Υ롼ƤӽФɬפ.
  ! Ѥ 1 ۷׻롼 3 ƤӽФȤˤƤ.
  !-------------------------------------------------------------------
  implicit none
  real, intent(in) :: x(:)  ! x κɸѿ [m]
  real, intent(in) :: y(:)  ! y κɸѿ [m]
  real, intent(in) :: z(:)  ! z κɸѿ [m]
  real, intent(in) :: u(size(x),size(y),size(z))  ! ۤȤ 2 顼ʬ
  real, intent(inout) :: valx(size(x),size(y),size(z))  ! ׻줿 y  2 ۥ٥ȥ
  real, intent(inout) :: valy(size(x),size(y),size(z))  ! ׻줿 y  2 ۥ٥ȥ
  real, intent(inout) :: valz(size(x),size(y),size(z))  ! ׻줿 z  2 ۥ٥ȥ
  real, intent(in), optional :: undeff
  real, intent(in), optional :: hx(size(x),size(y),size(z))  ! x Υ
  real, intent(in), optional :: hy(size(x),size(y),size(z))  ! y Υ
  real, intent(in), optional :: hz(size(x),size(y),size(z))  ! z Υ
  integer :: i   ! 졼ź
  integer :: j   ! 졼ź
  integer :: k   ! 졼ź
  integer :: nx  ! x ǿ(size ؿǼưŪ˷׻)
  integer :: ny  ! y ǿ(size ؿǼưŪ˷׻)
  integer :: nz  ! z ǿ(size ؿǼưŪ˷׻)
  real :: dx  ! x γʻֳ
  real :: dy  ! y γʻֳ
  real :: dz  ! z γʻֳ

  nx=size(x)
  ny=size(y)
  nz=size(z)
  dx=x(2)-x(1)
  dy=y(2)-y(1)
  dz=z(2)-z(1)

  if(present(undeff))then
     do i=1,nz
        do j=1,ny
           call grad_1d(x, u(:,j,i), valx(:,j,i),undeff)
        end do
     end do

     do i=1,nz
        do j=1,nx
           call grad_1d(y, u(j,:,i), valy(j,:,i),undeff)
        end do
     end do

     do i=1,ny
        do j=1,nx
           call grad_1d(z, u(j,i,:), valz(j,i,:),undeff)
        end do
     end do
  else
     do i=1,nz
        do j=1,ny
           call grad_1d(x, u(:,j,i), valx(:,j,i))
        end do
     end do

     do i=1,nz
        do j=1,nx
           call grad_1d(y, u(j,:,i), valy(j,:,i))
        end do
     end do

     do i=1,ny
        do j=1,nx
           call grad_1d(z, u(j,i,:), valz(j,i,:))
        end do
     end do
  end if

end subroutine grad_vec_3d

!-----------------------------------------
!-----------------------------------------

subroutine laplacian_1d( x, u, val, undef, hx )
! 1 Υ顼ѿΥץ饷׻
! $\frac{\partial ^2p}{\partial x^2} $ 
! 2 ʬǽ񤭴,  $(i)$ Ǥθۤ
! $\frac{p_{i+1}+p_{i-1}-2p_i}{dx^2} $
! ȤǤ. Ѥ 1 ץ饷׻.
! ǡ­ʤΰǤ, undef .
! option  undef Ƥʤ, 0.0 .
! ŪֳֳʻҤΥǡΤߤ׻ǤʤΤ, ֳ֤Υǡ
! ֳ֤ޤʤԤäƤ餳Υ롼ƤӽФɬפ.
  implicit none
  real, intent(in) :: x(:)  ! x κɸѿ [m]
  real, intent(in) :: u(size(x))  ! ζб 1 顼
  real, intent(inout) :: val(size(x))  ! 顼ͤ x θ
  real, intent(in), optional :: undef
  real, intent(in), optional :: hx(size(x))  ! x Υ
  integer :: i  ! 졼ź
  integer :: nx  ! ǿ
  real :: dx  ! ʻҴֳ [m]

  nx=size(x)
  dx=x(2)-x(1)

  if(present(undef))then
     do i=2,nx-1
        if(u(i+1)==undef.or.u(i-1)==undef.or.u(i)==undef)then
           val(i)=undef
        else
           val(i)=(u(i+1)+u(i-1)-2.0*u(i))/(dx*dx)
        end if
     end do
!-- ǡΤʤξüν ---
!     if(u(1)==undef.or.u(2)==undef)then
!        val(1)=undef
!     else
!        val(1)=(u(2)-u(1))/dx
!     end if
!     if(u(nx)==undef.or.u(nx-1)==undef)then
!        val(nx)=undef
!     else
!        val(nx)=(u(nx)-u(nx-1))/dx
!     end if
     val(1)=undef
     val(nx)=undef
  else
     do i=2,nx-1
        val(i)=(u(i+1)+u(i-1)-2.0*u(i))/(dx*dx)
     end do
!-- ǡΤʤξüν ---
!     val(1)=(u(2)-u(1))/dx
!     val(nx)=(u(nx)-u(nx-1))/dx
     val(1)=0.0
     val(nx)=0.0
  end if

end subroutine laplacian_1d

!-----------------------------------------
!-----------------------------------------


subroutine abst(x,y,z,dis)  ! 3 ٥ȥͤ׻롼
  ! Ĵ뤳Ȥˤ, 2 Ǥη׻ǽ.
  implicit none
  real, intent(in) :: x(:,:,:)  ! x Υ٥ȥʬ
  real, intent(in) :: y(size(x,1),size(x,2),size(x,3))  ! y Υ٥ȥʬ
  real, intent(in) :: z(size(x,1),size(x,2),size(x,3))  ! z Υ٥ȥʬ
  real, intent(inout) :: dis(size(x,1),size(x,2),size(x,3))  ! Ǥͥ٥ȥ
  integer :: i, j, k, nx, ny, nz

  nx=size(x,1)
  ny=size(x,2)
  nz=size(x,3)

!$omp parallel do shared(dis,x,y,z) private(i,j,k)
  do k=1,nz
     do j=1,ny
        do i=1,nx
           dis(i,j,k)=sqrt(x(i,j,k)**2+y(i,j,k)**2+z(i,j,k)**2)
        end do
     end do
  end do
!$omp end parallel do

end subroutine abst


subroutine radius(xp,yp,zp,x,y,z,rad)
  ! ֤εΥ׻롼
  ! Ĵ뤳Ȥˤ, 2 Ǥη׻ǽ.
  implicit none
  real, intent(in) :: xp  ! 濴ֺɸ x ʬ
  real, intent(in) :: yp  ! 濴ֺɸ y ʬ
  real, intent(in) :: zp  ! 濴ֺɸ z ʬ
  real, intent(in) :: x(:)  ! x ΰֺɸ
  real, intent(in) :: y(:)  ! y ΰֺɸ
  real, intent(in) :: z(:)  ! z ΰֺɸ
  real, intent(inout) :: rad(size(x),size(y),size(z))  ! Υ
  integer :: i, j, k, nx, ny, nz

  nx=size(x)
  ny=size(y)
  nz=size(z)

!$omp parallel do shared(rad,x,y,z,xp,yp,zp) private(i,j,k)
  do k=1,nz
     do j=1,ny
        do i=1,nx
           rad(i,j,k)=sqrt((x(i)-xp)**2+(y(j)-yp)**2+(z(k)-zp)**2)
        end do
     end do
  end do
!$omp end parallel do


end subroutine radius


subroutine Rangular_moment(xp,yp,x,y,u,v,mome)
! Ǥդޤгѱư̤׻롼
!
!  3 ٥ȥǷ׻뤬, ݳؤǤ 3 ̤Ϥޤפʤ
! ǤȤȽǤ, žޤγѱưʬΤߤ
! ׻뤳ȤˤƤ.
!
! Ū濴濴˱ľޤγѱư̤׻뤳ȤŪȤ.
!
! $$M=rv,\quad r=濴εΥ, \quad v=®Ʊ̳ʬ$$
!
! ֤®˰٤ѴͿ, Ǥμžޤγѱư̤
! ׻뤳Ȥǽ.
! ٥ȥγѷ׻롼 vec_prod Ѥ뤳ȤǶ˺ɸǤ׻ǽ.
  implicit none
  real, intent(in) :: x(:)  ! x ΰֺɸ
  real, intent(in) :: y(:)  ! y ΰֺɸ
  real, intent(in) :: xp  ! ž x ֺɸ
  real, intent(in) :: yp  ! ž y ֺɸ
  real, intent(in) :: u(size(x),size(y))  !  i,j Ǥ® 1 ʬ
  real, intent(in) :: v(size(x),size(y))  !  i,j Ǥ® 1 ʬ
  real, intent(inout) :: mome(size(x),size(y))  ! žޤгѱư
  real :: xxp(size(x),size(y),1)  ! x,y,xp,yp ׻濴ΰ֥٥ȥ x ʬ
  real :: yyp(size(x),size(y),1)  ! x,y,xp,yp ׻濴ΰ֥٥ȥ y ʬ
  integer :: i, j, nx, ny
  real :: tmp(size(x),size(y),1)

  nx=size(x)
  ny=size(y)

!$omp parallel do shared(xxp,yyp,x,y,xp,yp) private(i,j)
  do j=1,ny
     do i=1,nx
        xxp(i,j,1)=x(i)-xp
        yyp(i,j,1)=y(j)-yp
     end do
  end do
!$omp end parallel do

  tmp=0.0
  call vec_prod(xxp,yyp,tmp,u,v,tmp,tmp,tmp,mome)

end subroutine Rangular_moment


subroutine Aangular_moment(xp,yp,x,y,u,v,f,mome)
! Ǥդޤгѱư̤׻롼
!
! Ū濴濴˱ľޤγѱư̤׻뤳ȤŪȤ.
!
! $$M=rv+\dfrac{fr^2}{2} ,\quad r=濴εΥ, \quad v=®Ʊ̳ʬ$$
!
! ֤®˰٤ѴͿ, Ǥμžޤγѱư̤
! ׻뤳Ȥǽ.
!
! ٥ȥγѷ׻롼 vec_prod Ѥ뤳ȤǶ˺ɸǤ׻ǽ.
  implicit none
  real, intent(in) :: x(:)  ! x ΰֺɸ
  real, intent(in) :: y(:)  ! y ΰֺɸ
  real, intent(in) :: xp  ! ž x ֺɸ
  real, intent(in) :: yp  ! ž y ֺɸ
  real, intent(in) :: u(size(x),size(y))  !  i,j Ǥ® 1 ʬ
  real, intent(in) :: v(size(x),size(y))  !  i,j Ǥ® 1 ʬ
  real, intent(in) :: f(size(x),size(y))  !  i,j ǤΥꥪѥ᡼
  real, intent(inout) :: mome(size(x),size(y))  ! žޤгѱư
  real :: xxp(size(x),size(y),1)  ! x,y,xp,yp ׻濴ΰ֥٥ȥ x ʬ
  real :: yyp(size(x),size(y),1)  ! x,y,xp,yp ׻濴ΰ֥٥ȥ y ʬ
  integer :: i, j, nx, ny
  real :: tmp(size(x),size(y),1), rp(size(x),size(y)), tmp1(1)

  nx=size(x)
  ny=size(y)

!$omp parallel do shared(xxp,yyp,x,y,xp,yp) private(i,j)
  do j=1,ny
     do i=1,nx
        xxp(i,j,1)=x(i)-xp
        yyp(i,j,1)=y(j)-yp
     end do
  end do
!$omp end parallel do

  tmp=0.0
  call vec_prod(xxp,yyp,tmp,u,v,tmp,tmp,tmp,mome)
  call radius(xp,yp,0.0,x,y,tmp1,rp)

!$omp parallel do shared(mome,f,rp) private(i,j)
  do j=1,ny
     do i=1,nx
        mome(i,j)=mome(i,j)+0.5*f(i,j)*rp(i,j)**2
     end do
  end do
!$omp end parallel do

end subroutine Aangular_moment

subroutine dot_prod(x,y,z,u,v,w,dot,undeff)
  ! 2٥ȥѷ׻롼
  ! פ, 2 ǤѤ׻뤳Ȥǽ
  implicit none
  real, intent(in) :: x(:,:,:)  ! x Υ٥ȥʬ
  real, intent(in) :: y(size(x,1),size(x,2),size(x,3))  ! y Υ٥ȥʬ
  real, intent(in) :: z(size(x,1),size(x,2),size(x,3))  ! z Υ٥ȥʬ
  real, intent(in) :: u(size(x,1),size(x,2),size(x,3))  ! x Υ٥ȥʬ
  real, intent(in) :: v(size(x,1),size(x,2),size(x,3))  ! y Υ٥ȥʬ
  real, intent(in) :: w(size(x,1),size(x,2),size(x,3))  ! z Υ٥ȥʬ
  real, intent(inout) :: dot(size(x,1),size(x,2),size(x,3))  ! 
  real, intent(in), optional :: undeff
  integer :: i, j, k, nx, ny, nz

  nx=size(x,1)
  ny=size(x,2)
  nz=size(x,3)

  if(present(undeff))then
!$omp parallel do shared(dot,x,y,z,u,v,w) private(i,j,k)
     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(x(i,j,k)==undeff.or.u(i,j,k)==undeff.or.y(i,j,k)==undeff.or.  &
  &              v(i,j,k)==undeff.or.z(i,j,k)==undeff.or.w(i,j,k)==undeff)then
                 dot(i,j,k)=undeff
              else
                 dot(i,j,k)=x(i,j,k)*u(i,j,k)+y(i,j,k)*v(i,j,k)+z(i,j,k)*w(i,j,k)
              end if
           end do
        end do
     end do
!$omp end parallel do
  else
!$omp parallel do shared(dot,x,y,z,u,v,w) private(i,j,k)
     do k=1,nz
        do j=1,ny
           do i=1,nx
              dot(i,j,k)=x(i,j,k)*u(i,j,k)+y(i,j,k)*v(i,j,k)+z(i,j,k)*w(i,j,k)
           end do
        end do
     end do
!$omp end parallel do
  end if

end subroutine dot_prod


subroutine vec_prod(x,y,z,u,v,w,vecx,vecy,vecz,undeff)
  ! 2٥ȥγѷ׻롼
  ! ǿפ뤳Ȥ 2 Ѥ׻ǽ
  implicit none
  real, intent(in) :: x(:,:,:)  ! x Υ٥ȥʬ
  real, intent(in) :: y(size(x,1),size(x,2),size(x,3))  ! y Υ٥ȥʬ
  real, intent(in) :: z(size(x,1),size(x,2),size(x,3))  ! z Υ٥ȥʬ
  real, intent(in) :: u(size(x,1),size(x,2),size(x,3))  ! x Υ٥ȥʬ
  real, intent(in) :: v(size(x,1),size(x,2),size(x,3))  ! y Υ٥ȥʬ
  real, intent(in) :: w(size(x,1),size(x,2),size(x,3))  ! z Υ٥ȥʬ
  real, intent(inout) :: vecx(size(x,1),size(x,2),size(x,3))  ! Ѥ x ʬ
  real, intent(inout) :: vecy(size(x,1),size(x,2),size(x,3))  ! Ѥ y ʬ
  real, intent(inout) :: vecz(size(x,1),size(x,2),size(x,3))  ! Ѥ z ʬ
  real, intent(in), optional :: undeff
  integer :: i, j, k, nx, ny, nz

  nx=size(x,1)
  ny=size(x,2)
  nz=size(x,3)

  if(present(undeff))then
!$omp parallel do shared(vecx,vecy,vecz,x,y,z,u,v,w) private(i,j,k)
     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(x(i,j,k)==undeff.or.u(i,j,k)==undeff.or.y(i,j,k)==undeff.or.  &
  &              v(i,j,k)==undeff.or.z(i,j,k)==undeff.or.w(i,j,k)==undeff)then
                 vecx(i,j,k)=undeff
                 vecy(i,j,k)=undeff
                 vecz(i,j,k)=undeff
              else
                 vecx(i,j,k)=y(i,j,k)*w(i,j,k)-z(i,j,k)*v(i,j,k)
                 vecy(i,j,k)=z(i,j,k)*u(i,j,k)-x(i,j,k)*w(i,j,k)
                 vecz(i,j,k)=x(i,j,k)*v(i,j,k)-y(i,j,k)*u(i,j,k)
              end if
           end do
        end do
     end do
!$omp end parallel do

  else

!$omp parallel do shared(vecx,vecy,vecz,x,y,z,u,v,w) private(i,j,k)
     do k=1,nz
        do j=1,ny
           do i=1,nx
              vecx(i,j,k)=y(i,j,k)*w(i,j,k)-z(i,j,k)*v(i,j,k)
              vecy(i,j,k)=z(i,j,k)*u(i,j,k)-x(i,j,k)*w(i,j,k)
              vecz(i,j,k)=x(i,j,k)*v(i,j,k)-y(i,j,k)*u(i,j,k)
           end do
        end do
     end do
!$omp end parallel do
  end if

end subroutine vec_prod


end module analy
