module Statistics  ! ײϴطΥ롼

  private :: summ

contains

subroutine Mean_1d( nx, x, ave, error )  ! 1 ʿͷ׻롼
  implicit none
  integer, intent(in) :: nx  ! ǡǿ
  real, intent(in) :: x(nx)  ! ǡ
  real, intent(inout) :: ave  ! ׻ʿ
  real, intent(in), optional :: error  ! »ͤ¸ߤǡåȤξη»
  integer :: i, nt
  real :: summ

  summ=0.0
  nt=0

  if(present(error))then
     do i=1,nx
        if(x(i)/=error)then
           summ=summ+x(i)
           nt=1+nt
        end if
     end do

     if(nt/=0)then
        ave=summ/nt
     else
        ave=0.0
     end if

  else

     do i=1,nx
        summ=summ+x(i)
     end do

     ave=summ/nx

  end if

end subroutine Mean_1d


subroutine Mean_2d( nx, ny, x, ave, error )  ! 2 ʿͷ׻롼
  implicit none
  integer, intent(in) :: nx  ! ǡǿ 1
  integer, intent(in) :: ny  ! ǡǿ 2
  real, intent(in) :: x(nx,ny)  ! ǡ
  real, intent(inout) :: ave  ! ׻ʿ
  real, intent(in), optional :: error  ! »ͤ¸ߤǡåȤξη»
  integer :: i, j, nt
  real :: summ, tmp

  summ=0.0
  nt=0

  if(present(error))then
     do j=1,ny
        do i=1,nx
           if(x(i,j)/=error)then
              summ=summ+x(i,j)
              nt=1+nt
           end if
        end do
     end do

     if(nt/=0)then
        ave=summ/nt
     else
        ave=0.0
     end if

  else

     do j=1,ny
        do i=1,nx
           summ=summ+x(i,j)
        end do
     end do

     ave=summ/(nx*ny)

  end if

end subroutine Mean_2d


subroutine Mean_3d( nx, ny, nz, x, ave, error )  ! 3 ʿͷ׻롼
  implicit none
  integer, intent(in) :: nx  ! ǡǿ 1
  integer, intent(in) :: ny  ! ǡǿ 2
  integer, intent(in) :: nz  ! ǡǿ 2
  real, intent(in) :: x(nx,ny,nz)  ! ǡ
  real, intent(inout) :: ave  ! ׻ʿ
  real, intent(in), optional :: error  ! »ͤ¸ߤǡåȤξη»
  integer :: i, j, k, nt
  real :: summ, tmp

  summ=0.0
  nt=0

  if(present(error))then
     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(x(i,j,k)/=error)then
                 summ=summ+x(i,j,k)
                 nt=1+nt
              end if
           end do
        end do
     end do

     if(nt/=0)then
        ave=summ/nt
     else
        ave=0.0
     end if

  else

     do k=1,nz
        do j=1,ny
           do i=1,nx
              summ=summ+x(i,j,k)
           end do
        end do
     end do

     ave=summ/(nx*ny*nz)

  end if

end subroutine Mean_3d


subroutine Anomaly_1d( nx, x, anor, error )  ! 1 ǡк֤
  implicit none
  integer, intent(in) :: nx  ! ǡǿ
  real, intent(in) :: x(nx)  ! ǡ
  real, intent(inout) :: anor(nx)  !  x(i) бк anor(i)
  real, intent(in), optional :: error  ! »ͤ¸ߤǡåȤξη»
  integer :: i
  real :: ave

  if(present(error))then
     call Mean_1d( nx, x, ave, error )
     do i=1,nx
        if(x(i)==error)then
           anor(i)=error
        else
           anor(i)=x(i)-ave
        end if
     end do
  else
     call Mean_1d( nx, x, ave )
     do i=1,nx
        anor(i)=x(i)-ave
     end do
  end if

end subroutine Anomaly_1d


subroutine Anomaly_2d( nx, ny, x, anor, error )  ! 2 ǡк֤
  implicit none
  integer, intent(in) :: nx  ! ǡǿ 1
  integer, intent(in) :: ny  ! ǡǿ 2
  real, intent(in) :: x(nx,ny)  ! ǡ
  real, intent(inout) :: anor(nx,ny)  !  x(i,j) бк anor(i,j)
  real, intent(in), optional :: error  ! »ͤ¸ߤǡåȤξη»
  integer :: i, j
  real :: ave

  if(present(error))then
     call Mean_2d( nx, ny, x, ave, error )
     do j=1,ny
        do i=1,nx
           if(x(i,j)==error)then
              anor(i,j)=error
           else
              anor(i,j)=x(i,j)-ave
           end if
        end do
     end do
  else
     call Mean_2d( nx, ny, x, ave, error )
     do j=1,ny
        do i=1,nx
           anor(i,j)=x(i,j)-ave
        end do
     end do
  end if

end subroutine Anomaly_2d


subroutine Anomaly_3d( nx, ny, nz, x, anor, error )  ! 3 ǡк֤
  implicit none
  integer, intent(in) :: nx  ! ǡǿ 1
  integer, intent(in) :: ny  ! ǡǿ 2
  integer, intent(in) :: nz  ! ǡǿ 3
  real, intent(in) :: x(nx,ny,nz)  ! ǡ
  real, intent(inout) :: anor(nx,ny,nz)  !  x(i,j,k) бк anor(i,j,k)
  real, intent(in), optional :: error  ! »ͤ¸ߤǡåȤξη»
  integer :: i, j, k
  real :: ave

  if(present(error))then
     call Mean_3d( nx, ny, nz, x, ave, error )
     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(x(i,j,k)==error)then
                 anor(i,j,k)=error
              else
                 anor(i,j,k)=x(i,j,k)-ave
              end if
           end do
        end do
     end do
  else
     call Mean_3d( nx, ny, nz, x, ave, error )
     do k=1,nz
        do j=1,ny
           do i=1,nx
              anor(i,j,k)=x(i,j,k)-ave
           end do
        end do
     end do
  end if

end subroutine Anomaly_3d


subroutine stand_vari( nx, x, anor, error )  ! 1 ǡɸк׻
  ! ɸк$\sigma $,
  ! $$\sigma =\sum^{nx}_{i=1}{epsilon ^2} $$
  ! , $\epsilon $ʿͤΤ$x-\bar{x}$Ǥ.
  implicit none
  integer, intent(in) :: nx  ! ǡ
  real, intent(in) :: x(nx)  ! ǡ
  real, intent(inout) :: anor  ! ɸк
  real, intent(in), optional :: error  ! »
  integer :: i
  real :: an(nx)

  anor=0.0

  if(present(error))then
     call Anomaly_1d( nx, x, an, error )
     do i=1,nx
        if(x(i)/=error)then
           anor=anor+an(i)**2
        end if
     end do
  else
     call Anomaly_1d( nx, x, an )
     do i=1,nx
        anor=anor+an(i)**2
     end do
  end if

end subroutine stand_vari

subroutine covariance( nx, x, y, cov, error )  ! 2 Ĥ 1 ǡζʬ׻
  ! ʬ$\sigma $,
  ! $$\sigma =\sum^{nx}_{i=1}{(x-\bar{x})(y-\bar{y})} $$
  implicit none
  integer, intent(in) :: nx  ! ǡ
  real, intent(in) :: x(nx)  ! ǡ 1
  real, intent(in) :: y(nx)  ! ǡ 2
  real, intent(inout) :: cov  ! ɸк
  real, intent(in), optional :: error  ! »
  integer :: i
  real :: an1(nx), an2(nx)

  cov=0.0

  if(present(error))then
     call Anomaly_1d( nx, x, an1, error )
     call Anomaly_1d( nx, y, an2, error )
     do i=1,nx
        if(x(i)/=error)then
           cov=cov+an1(i)*an2(i)
        end if
     end do
  else
     call Anomaly_1d( nx, x, an1 )
     call Anomaly_1d( nx, y, an2 )
     do i=1,nx
        cov=cov+an1(i)*an2(i)
     end do
  end if

end subroutine covariance


subroutine nearest_search_1d( x, point, i, undeff )
  ! 1 Ƕ˵õ롼
  ! interpo_search_1d ͤ, ͤ +1 ͤεΥӤ
  ! Υû򤹤.
  implicit none
  real, intent(in) :: x(:)  ! 
  real, intent(in) :: point  ! 
  integer, intent(inout) :: i  ! point κǶ˵ֹ
  real, intent(in), optional :: undeff  ! õϰϤǤ꾮ͤõ褦Ȥ, undef ֤,  undef ͤꤹ. default Ǥ 0.
  real :: tmp1, tmp2
  integer :: j

  if(present(undeff))then
     call interpo_search_1d( x, point, j, undeff )
  else
     call interpo_search_1d( x, point, j )
  end if

  tmp1=x(j)
  tmp2=x(j+1)

  if(abs(point-tmp1)>=abs(tmp2-point))then
     if(size(x)>=j+1)then  ! j+1 󻲾ȳξν
        i=j+1
     else
        i=j
     end if
  else
     i=j
  end if

  if(j==0)then
     write(*,*) "WARNING: j is undef value."
  end if
  if(present(undeff))then
     if(j==int(undeff))then
        write(*,*) "WARNING: j is undef value."
     end if
  end if

end subroutine nearest_search_1d


subroutine nearest_search_2d( x, y, pointx, pointy, i, j, undeff )
  ! 2 Ƕ˵õ롼
  ! nearest_search_1d ͤ.
  ! , 2 Ǥ뤿,  4 κǶ׻ɬפ뤬,
  ! ǤľľɸͤƤΤ, ƼΩǺǶ׻,
  ! ɤǶ᤿ 2 κǶȤʤ.
  implicit none
  real, intent(in) :: x(:)  !  x
  real, intent(in) :: y(:)  !  y
  real, intent(in) :: pointx  !  x
  real, intent(in) :: pointy  !  y
  integer, intent(inout) :: i  ! pointx κǶֹ
  integer, intent(inout) :: j  ! pointy κǶֹ
  real, intent(in), optional :: undeff  ! õϰϤǤ꾮ͤõ褦Ȥ, undef ֤,  undef ͤꤹ. default Ǥ 0.

  if(present(undeff))then
     call nearest_search_1d( x, pointx, i, undeff )
     call nearest_search_1d( y, pointy, j, undeff )
  else
     call nearest_search_1d( x, pointx, i )
     call nearest_search_1d( y, pointy, j )
  end if

end subroutine nearest_search_2d


subroutine nearest_search_3d( x, y, z, pointx, pointy, pointz, i, j, k, undeff )
  ! 2 Ƕ˵õ롼
  ! nearest_search_1d ͤ.
  ! , 2 Ǥ뤿,  4 κǶ׻ɬפ뤬,
  ! ǤľľɸͤƤΤ, ƼΩǺǶ׻,
  ! ɤǶ᤿ 2 κǶȤʤ.
  implicit none
  real, intent(in) :: x(:)  !  x
  real, intent(in) :: y(:)  !  y
  real, intent(in) :: z(:)  !  z
  real, intent(in) :: pointx  !  x
  real, intent(in) :: pointy  !  y
  real, intent(in) :: pointz  !  z
  integer, intent(inout) :: i  ! pointx κǶֹ
  integer, intent(inout) :: j  ! pointy κǶֹ
  integer, intent(inout) :: k  ! pointz κǶֹ
  real, intent(in), optional :: undeff  ! õϰϤǤ꾮ͤõ褦Ȥ, undef ֤,  undef ͤꤹ. default Ǥ 0.
  integer :: just

  if(present(undeff))then
     call nearest_search_1d( x, pointx, i, undeff )
     call nearest_search_1d( y, pointy, j, undeff )
     call nearest_search_1d( z, pointz, k, undeff )
  else
     call nearest_search_1d( x, pointx, i )
     call nearest_search_1d( y, pointy, j )
     call nearest_search_1d( z, pointz, k )
  end if

end subroutine nearest_search_3d


subroutine interpo_search_1d( x, point, i, undeff )
  ! ǿ뤴Ȥͤ礭ʤˤΤʤ,
  ! point ֹϤ.
  implicit none
  real, intent(in) :: x(:)  ! 
  real, intent(in) :: point  ! 
  integer, intent(inout) :: i  ! point ͤۤʤֹͤ
  real, intent(in), optional :: undeff  ! õϰϤǤ꾮ͤõ褦Ȥ, undef ֤,  undef ͤꤹ. default Ǥ 0.
  integer :: nx, j
  integer :: just

  nx=size(x)
  if(present(undeff))then
     just=int(undeff)
  else
     just=0
  end if

  do j=1,nx
     if(x(1)>point)then
        write(*,*) "****** WARNING ******"
        write(*,*) "searching point was not found."
        write(*,*) "Abort. Exit.!!!"
        i=just
        exit
     end if

     if(present(undeff))then
        if(x(j)/=undeff)then
           if(x(j)<=point)then
              i=j
           else
              exit
           end if
        end if
     else
        if(x(j)<=point)then
           i=j
        else
           exit
        end if
     end if
  end do

end subroutine interpo_search_1d


subroutine interpo_search_2d( x, y, pointx, pointy, i, j, undeff )
  ! ǿ뤴Ȥͤ礭ʤˤΤʤ,
  ! point ֹϤ.
  implicit none
  real, intent(in) :: x(:)  !  x
  real, intent(in) :: y(:)  !  y
  real, intent(in) :: pointx  !  x
  real, intent(in) :: pointy  !  y
  integer, intent(inout) :: i  ! pointx ͤۤʤֹͤ
  integer, intent(inout) :: j  ! pointy ͤۤʤֹͤ
  real, intent(in), optional :: undeff  ! õϰϤǤ꾮ͤõ褦Ȥ, undef ֤,  undef ͤꤹ. default Ǥ 0.
  integer :: just

  if(present(undeff))then
     just=int(undeff)
     call interpo_search_1d( x, pointx, i, real(just) )
     call interpo_search_1d( y, pointy, j, real(just) )
  else
     call interpo_search_1d( x, pointx, i )
     call interpo_search_1d( y, pointy, j )
  end if

end subroutine interpo_search_2d


subroutine interpo_search_3d( x, y, z, pointx, pointy, pointz, i, j, k, undeff )
  ! ǿ뤴Ȥͤ礭ʤˤΤʤ,
  ! point ֹϤ.
  implicit none
  real, intent(in) :: x(:)  !  x
  real, intent(in) :: y(:)  !  y
  real, intent(in) :: z(:)  !  z
  real, intent(in) :: pointx  !  x
  real, intent(in) :: pointy  !  y
  real, intent(in) :: pointz  !  z
  integer, intent(inout) :: i  ! pointx ͤۤʤֹͤ
  integer, intent(inout) :: j  ! pointy ͤۤʤֹͤ
  integer, intent(inout) :: k  ! pointz ͤۤʤֹͤ
  real, intent(in), optional :: undeff  ! õϰϤǤ꾮ͤõ褦Ȥ, undef ֤,  undef ͤꤹ. default Ǥ 0.
  integer :: just

  if(present(undeff))then
     just=int(undeff)
     call interpo_search_1d( x, pointx, i, real(just) )
     call interpo_search_1d( y, pointy, j, real(just) )
     call interpo_search_1d( z, pointz, k, real(just) )
  else
     call interpo_search_1d( x, pointx, i )
     call interpo_search_1d( y, pointy, j )
     call interpo_search_1d( z, pointz, k )
  end if

end subroutine interpo_search_3d


subroutine interpolation_1d( tmin, tmax, xmin, xmax, point, val )
  ! 1 ޥ롼
  implicit none
  real, intent(in) :: tmin  ! κü
  real, intent(in) :: tmax  ! αü
  real, intent(in) :: xmin  ! tmin Ǥ
  real, intent(in) :: xmax  ! tmax Ǥ
  real, intent(in) :: point  ! 
  real, intent(inout) :: val  ! Ǥ
  real :: fd, dt

  dt=point-tmin

  fd=(xmax-xmin)/(tmax-tmin)

  val=xmin+dt*fd

end subroutine interpolation_1d


subroutine interpolation_2d( x, y, z, point, val )
  ! 2 νޥ롼
  ! ܥ롼ľľɸ֤ǤΤ߻Ѳǽ.
  implicit none
  real, intent(in) :: x(2)  ! ޤζ x κü
  real, intent(in) :: y(2)  ! ޤζ y κü
  real, intent(in) :: z(2,2)  ! x, y ǤγǤ, (i,j) ˤĤ, i<=x, j<=y
  real, intent(in) :: point(2)  !  point(1)<=x ɸ, point(2)<=y ɸ
  real, intent(inout) :: val  ! Ǥ
  real :: valx(2)

  ! y(1) Ǥ x Ǥ
  call interpolation_1d( x(1), x(2), z(1,1), z(2,1), point(1), valx(1) )

  ! y(2) Ǥ x Ǥ
  call interpolation_1d( x(1), x(2), z(1,2), z(2,2), point(1), valx(2) )

  ! x  y Ǥ(줬)
  call interpolation_1d( y(1), y(2), valx(1), valx(2), point(2), val )

end subroutine interpolation_2d


subroutine interpolation_3d( x, y, z, u, point, val )
  ! 3 νޥ롼
  ! ܥ롼ľľɸ֤ǤΤ߻Ѳǽ.
  implicit none
  real, intent(in) :: x(2)  ! ޤζ x κü
  real, intent(in) :: y(2)  ! ޤζ y κü
  real, intent(in) :: z(2)  ! ޤζ z κü
  real, intent(in) :: u(2,2,2)  ! x, y, z ǤγǤ, (i,j,k) ˤĤ, i<=x, j<=y, k<=z
  real, intent(in) :: point(3)  !  point(1)<=x ɸ, point(2)<=y ɸ, point(3)<=z ɸ
  real, intent(inout) :: val  ! Ǥ
  real :: valx(2)

  ! z(1) Ǥ x-y ʿ̤Ǥνޤ
  call interpolation_2d( x, y, u(:,:,1), point(1:2), valx(1) )

  ! z(2) Ǥ x Ǥ
  call interpolation_2d( x, y, u(:,:,2), point(1:2), valx(2) )

  ! z(1)  z Ǥ(줬)
  call interpolation_1d( z(1), z(2), valx(1), valx(2), point(3), val )

end subroutine interpolation_3d



subroutine LSM( nx, x, y, slope, intercept, undef )  ! Ǿˡˤ뷹ҷ׻
  implicit none
  integer, intent(in) :: nx  ! ǡ
  real, intent(in) :: x(nx)  ! ǡ 1
  real, intent(in) :: y(nx)  ! ǡ 2
  real, intent(inout) :: slope  ! Ŭʷ
  real, intent(inout) :: intercept  ! Ŭ
  real, intent(in), optional :: undef ! undef 
  real :: u(nx), v(nx)
  integer :: i, j, k
  real :: a, b, c, d

  a=0.0
  b=0.0
  c=0.0
  d=0.0

!$omp parallel do shared(u, v, x, y) private(i)
  do i=1,nx
     u(i)=x(i)*x(i)
     v(i)=x(i)*y(i)
  end do
!$omp end parallel do

  call summ(nx,v,a,undef)
  call summ(nx,x,b,undef)
  call summ(nx,y,c,undef)
  call summ(nx,u,d,undef)

  slope=(nx*a-b*c)/(nx*d-b**2)
  intercept=(c*d-a*b)/(nx*d-b**2)

end subroutine LSM

!------------------------------------

subroutine LSM_poly( poly_n, nx, x, y, a, intercept, undef )
! LSM ¿༰С.
! LSM Ǥ, F(x)=a_0+a_1x ľԤäƤ,
! LSM_poly Ǥ, F(x)=\sum^{N}_{n=0}{a_nx^n}
! Ǥռ¿༰ԤȤǽ.
! 르ꥺϺǾˡѤƤ, ΥФˤ gausss 롼.
  use Algebra
  implicit none
  integer, intent(in) :: poly_n  ! κǹ⼡. 1 ʤ, LSM Ʊ.
  integer, intent(in) :: nx  ! ǡθĿ
  real, intent(in) :: x(nx)  ! ǡ 1
  real, intent(in) :: y(nx)  ! ǡ 2
  real, intent(inout) :: a(poly_n)  ! ¿༰η
  real, intent(inout) :: intercept  ! y . 
                         ! a Ȥ߹ȰϤȤ, poly_n+1 Ϥɬפ
                         ! , ʶ路ȽǤ, a_0 Ǥ y Ҥ
                         ! ΩǰȤϤȤˤ.
  real, intent(in), optional :: undef  ! ̤.
  integer :: i, j, k, l, m, n
  real :: coe(0:poly_n), tmpa_coe(0:poly_n,0:poly_n), tmpb_coe(0:poly_n)
          ! coe  a_n . tmp_coe ϥǡ¤.
          ! [] : Ǥ. Ǥ.
  real :: tmp(nx)  ! ٤׻ΰ


!-- gausss Ϥ䤹褦, Ѱդ˰.
  if(present(undef))then
     do k=0,poly_n  ! ʬη׻
        do j=0,poly_n  ! ʬη׻. ʬη׻˲뤳Ȥ.
           if(j >= k)then  ! ʬ(j)ʬ(k)ǿ, ͤ
                           ! ޤ˷׻.
              do i=1,nx
                 if(x(i)/=undef)then
                    tmp(i)=x(i)**(j+k)
                 else
                    tmp(i)=undef
                 end if
              end do
              call summ( nx, tmp, tmpa_coe(j,k), undef )
           else  ! ʬ(j)ʬ(k)ǿ礭, 򤯷
                 ! оιǤ뤳Ȥ, ͤλΤ߹Ԥ.
              tmpa_coe(j,k)=tmpa_coe(k,j)  ! оʬʤǤ˷׻Ѥߡ
           end if
        end do
     end do
     do j=0,poly_n
        do i=1,nx
           if(x(i)/=undef)then
              tmp(i)=y(i)*(x(i)**j)
           else
              tmp(i)=undef
           end if
        end do
        call summ( nx, tmp, tmpb_coe(j), undef )
     end do
  else  ! undef ʤȤ.
     do k=0,poly_n  ! ʬη׻
        do j=0,poly_n  ! ʬη׻. ʬη׻˲뤳Ȥ.
           if(j >= k)then  ! ʬ(j)ʬ(k)ǿ, ͤ
                           ! ޤ˷׻.
              do i=1,nx
                 tmp(i)=x(i)**(j+k)
              end do
              call summ( nx, tmp, tmpa_coe(j,k), undef )
           else  ! ʬ(j)ʬ(k)ǿ礭, 򤯷
                 ! оιǤ뤳Ȥ, ͤλΤ߹Ԥ.
              tmpa_coe(j,k)=tmpa_coe(k,j)  ! оʬʤǤ˷׻Ѥߡ
           end if
        end do
     end do
     do j=0,poly_n
        do i=1,nx
           tmp(i)=y(i)*(x(i)**j)
        end do
        call summ( nx, tmp, tmpb_coe(j), undef )
     end do
  end if

!  ʾǷͤä.

  call gausss( poly_n+1, tmpa_coe(0:poly_n,0:poly_n), tmpb_coe(0:poly_n),  &
  &            coe(0:poly_n) )

  do i=1,poly_n
     a(i)=coe(i)
  end do
  intercept=coe(0)

end subroutine

!------------------------------------

subroutine Reg_Line( nx, x, y, slope, intercept )
  ! LSM ѤƲľη slope  intercept ׻롼
  implicit none
  integer, intent(in) :: nx  ! ǡ
  real, intent(in) :: x(nx)  ! ǡ 1
  real, intent(in) :: y(nx)  ! ǡ 2
  real, intent(inout) :: slope  ! Ŭʷ
  real, intent(inout) :: intercept  ! Ŭ
  real :: u(nx), v(nx)

  call Anomaly_1d( nx, x, u )
  call Anomaly_1d( nx, y, v )
  call LSM( nx, u, v, slope, intercept )

end subroutine

subroutine Cor_Coe( nx, x, y ,cc, error )  ! 2 ǡط׻롼
  implicit none
  integer, intent(in) :: nx  ! ǡĿ
  real, intent(in) :: x(nx)  ! ǡ 1
  real, intent(in) :: y(nx)  ! ǡ 2
  real, intent(inout) :: cc  ! ط
  real, intent(in), optional :: error  ! »
  integer :: i
  real :: cov, anor1, anor2

  if(present(error))then
     call covariance( nx, x, y, cov, error )
     call stand_vari( nx, x, anor1, error )
     call stand_vari( nx, y, anor2, error )
  else
     call covariance( nx, x, y, cov )
     call stand_vari( nx, x, anor1 )
     call stand_vari( nx, y, anor2 )
  end if

  cc=cov/(sqrt(anor1)*sqrt(anor2))

end subroutine Cor_Coe

!---------------------------------
!---------------------------------
!---- ʲ, private 롼----
!---------------------------------
!---------------------------------

subroutine summ(nx,z,add,undeff)
! undef ±黻Ԥ private 롼. ȤԲ.
  implicit none
  integer, intent(in) :: nx
  real, intent(in) :: z(nx)
  real, intent(inout) :: add
  real, intent(in), optional :: undeff
  integer :: i

  add=0.0
  if(present(undeff))then
     do i=1,nx
        if(undeff/=z(i))then
           add=add+z(i)
        end if
     end do
  else
     do i=1,nx
        add=add+z(i)
     end do
  end if

end subroutine summ


end module
