module Special_Function  !-- üؿ׻⥸塼 ---

interface kaijo

  module procedure kaijo_i, kaijo_f

end interface

interface Full_Ellip1_Func

  module procedure Full_Ellip1_Func_f, Full_Ellip1_Func_d

end interface

interface Full_Ellip2_Func

  module procedure Full_Ellip2_Func_f, Full_Ellip2_Func_d

end interface

interface bessj

  module procedure bessj_f, bessj_d, bessj_fnoni, bessj_dnoni

end interface

interface bessy

  module procedure bessy_f, bessy_d, bessy_fnoni, bessy_dnoni

end interface

interface sp_bessj

  module procedure sp_bessj_f, sp_bessj_d

end interface

interface sp_bessy

  module procedure sp_bessy_f, sp_bessy_d

end interface

interface df_bessj

  module procedure df_bessj_f, df_bessj_d, df_bessj_fnoni, df_bessj_dnoni

end interface

interface df_bessy

  module procedure df_bessy_f, df_bessy_d, df_bessy_fnoni, df_bessy_dnoni

end interface

interface gamma_func

  module procedure gamma_func_f, gamma_func_d

end interface

interface beta_func

  module procedure beta_func_f, beta_func_d

end interface

!interface Airy

!  module procedure Airy_f, Airy_d

!end interface

interface beszero

  module procedure besfzero, besdzero

end interface

private :: df_bessy_term1_f
private :: df_bessy_term2_f
private :: df_bessy_term1_d
private :: df_bessy_term2_d

contains

real function digamma(k)
  !-- ޴ؿ׻륵֥롼 ---
  !-- Ȥ ---
  !-- ؿ̾ "digamma(n)" , ɬǤʤФʤʤ
  implicit none
  integer, intent(in) :: k  ! (k+1) ܤޤǤη׻
  integer :: j

  if (k.gt.1) then
     digamma=0.0
     do j=1,k
        digamma=digamma+1.0/j
     end do
  else
     if (k.eq.1) then
        digamma=1.0
     else
        digamma=0.0
     end if
  end if
  return
end function

real function epsilon(i,j,k)
!-- ǥȥΥץ׻륵֥롼 ---
!-- F77 ǤǤѤǤʤä CASE ʸǿʬԤ ---
!-- i,j,k  1..3  3 ष¸ߤʤȤΤȤδؿǤΤ,
!-- ǤΥƥ󥽥ˤŬѤǤʤ. ---
  implicit none
  integer, intent(in) :: i  !  1 ʬ
  integer, intent(in) :: j  !  1 ʬ
  integer, intent(in) :: k  !  1 ʬ

  select case (i)

  case (1)

     select case (j)

     case (1)
        epsilon=0.0

     case (2)

        select case (k)

        case (1)
           epsilon=0.0

        case (2)
           epsilon=0.0

        case (3)
           epsilon=1.0

        end select

     case (3)

        select case (k)

        case (1)
           epsilon=0.0

        case (2)
           epsilon=-1.0

        case (3)
           epsilon=0.0

        end select
     end select

  case (2)

     select case (j)

     case (1)

        select case (k)

        case (1)
           epsilon=0.0

        case (2)
           epsilon=0.0

        case (3)
           epsilon=-1.0

        end select

     case (2)
        epsilon=0.0

     case (3)

        select case (k)

        case (1)
           epsilon=1.0

        case (2)
           epsilon=0.0

        case (3)
           epsilon=0.0

        end select
     end select

  case (3)

     select case (j)

     case (1)

        select case (k)

        case (1)
           epsilon=0.0

        case (2)
           epsilon=1.0

        case (3)
           epsilon=0.0

        end select

     case (2)

        select case (k)

        case (1)
           epsilon=-1.0

        case (2)
           epsilon=0.0

        case (3)
           epsilon=0.0

        end select

     case (3)
        epsilon=0.0

     end select
  end select

  return
end function


real function Full_Ellip1_Func_f(k)  !  1 ﴰʱߴؿ׻
  implicit none
  real, intent(in) :: k  ! ؿΰ
  real :: pi, m, dt, t, tmin, tmax
  integer :: i, j
  integer, parameter :: nmax=1000
  real :: f, x

  f(m,x) = 1.0/sqrt(1.0-(m*sin(x))**2)

  if(k.ge.1.0)then
     write(*,*) "(error ! : k must 0=<k<1.)"
     return
  end if

  pi = 3.14159265

  tmin = 0.0
  tmax = pi/2.0
  dt = (tmax-tmin)/(nmax-1)

  Full_Ellip1_Func_f = 0.5*dt*(f(k,tmin)+f(k,tmax))
  do i=1,nmax-2
     t = tmin+dt*i
     Full_Ellip1_Func_f = Full_Ellip1_Func_f+dt*f(k,t)
  end do

  return
end function


double precision function Full_Ellip1_Func_d(k)  !  1 ﴰʱߴؿ׻
  implicit none
  double precision, intent(in) :: k  ! ؿΰ
  double precision :: pi, m, dt, t, tmin, tmax
  integer :: i, j
  integer, parameter :: nmax=1000
  double precision :: f, x

  f(m,x) = 1.0d0/dsqrt(1.0d0-(m*dsin(x))**2)

  if(k.ge.1.0d0)then
     write(*,*) "(error ! : k must 0=<k<1.)"
     return
  end if

  pi = 3.1415926535898d0

  tmin = 0.0d0
  tmax = pi/2.0d0
  dt = (tmax-tmin)/dble(nmax-1)

  Full_Ellip1_Func_d = 0.5d0*dt*(f(k,tmin)+f(k,tmax))
  do i=1,nmax-2
     t = tmin+dt*dble(i)
     Full_Ellip1_Func_d = Full_Ellip1_Func_d+dt*f(k,t)
  end do

  return
end function


real function Full_Ellip2_Func_f(k)  ! ﴰʱߴؿ
  implicit none
  real, intent(in) :: k  ! ؿΰ
  real :: pi, m, dt, t, tmin, tmax
  integer :: i, j
  integer, parameter :: nmax=1000
  real :: f, x

  f(m,x) = sqrt(1.0-(m*sin(x))**2)

  pi = 3.14159265

  if(k.gt.1.0)then
     write(*,*) "(error) ! : k must 0=<k=<1."
     return
  end if

  tmin = 0.0
  tmax = pi/2.0
  dt = (tmax-tmin)/(nmax-1)

  Full_Ellip2_Func_f = 0.5*dt*(f(k,tmin)+f(k,tmax))
  do i=1,nmax-2
     t = tmin+dt*i
     Full_Ellip2_Func_f = Full_Ellip2_Func_f+dt*f(k,t)
  end do

  return
end function



double precision function Full_Ellip2_Func_d(k)  ! ﴰʱߴؿ
  implicit none
  double precision, intent(in) :: k  ! ؿΰ
  double precision :: pi, m, dt, t, tmin, tmax
  integer :: i, j
  integer, parameter :: nmax=1000
  double precision :: f, x

  f(m,x) = dsqrt(1.0d0-(m*dsin(x))**2)

  pi = 3.1415926535898d0

  if(k.gt.1.0d0)then
     write(*,*) "(error) ! : k must 0=<k=<1."
     return
  end if

  tmin = 0.0d0
  tmax = pi/2.0d0
  dt = (tmax-tmin)/dble(nmax-1)

  Full_Ellip2_Func_d = 0.5d0*dt*(f(k,tmin)+f(k,tmax))
  do i=1,nmax-2
     t = tmin+dt*dble(i)
     Full_Ellip2_Func_d = Full_Ellip2_Func_d+dt*f(k,t)
  end do

  return
end function

!----------------------------------------------------
!----------------------------------------------------

integer function kaijo_i(k)
  !-- ؿ׻륵֥롼 ---
  !-- Ȥ ---
  !-- ؿ̾ "kaijo(k)" ,  "k" ˤΤ뤳
  implicit none
  integer, intent(in) :: k
  integer :: j

  if (k.lt.2) then
     kaijo_i=1
  else
     kaijo_i=1
     do j=1,k
        kaijo_i=j*kaijo_i
     end do
  end if

  return
end function

!----------------------------------------------------
!----------------------------------------------------

real function kaijo_f(k)
  !-- ؿ׻륵֥롼 ---
  !-- Ȥ ---
  !-- ؿ̾ "kaijo(k)" ,  "k" ˤΤ뤳
  implicit none
  real, intent(in) :: k
  integer :: j

  if (k.lt.2.0) then
     kaijo_f=1.0
  else
     kaijo_f=1.0
     do j=1,k
        kaijo_f=real(j)*kaijo_f
     end do
  end if

  return
end function

!----------------------------------------------------
!----------------------------------------------------

real function bessj_f(m,t)  !  I ٥åؿ׻
  implicit none
  integer, intent(in) :: m  ! ׻뼡
  real, intent(in) :: t  ! 
  integer :: istep, n
  real :: x, coe1
  integer, parameter :: mmax = 100 ! ʬѤ
  real, parameter :: pis=3.14159265
  real, parameter :: xmin = 0.0d0, xmax = 2.0d0*pis
  real, parameter :: dx = (xmax-xmin)/(mmax-1)

  if(t<0.0)then
     write(*,*) "*** ERROR ***"
     write(*,*) "The argument of bessj must not be negative."
     write(*,*) "Stop."
     stop
  end if

!-- μǤäʬ ---
  if(m < 0)then
     n=-m
  else
     n=m
  end if

!-- ٥åؿʬ׻ ---
  bessj_f=0.0

  do istep=2,mmax-1
     x=xmin+dx*(istep-1)
     bessj_f=bessj_f+dx*(cos(t*sin(x)-real(n)*x))
  end do

  bessj_f=bessj_f+0.5*dx*(cos(t*sin(xmin)-real(n)*xmin) &
 &            +cos(t*sin(xmax)-real(n)*xmax))
  bessj_f=bessj_f/(2.0*pis)

!-- μǤäʬ ---
  if(m.lt.0)then
     if(mod(n,2)==0)then  ! (-1)^m η׻󤹤
        coe1=1.0
     else
        coe1=-1.0
     end if
     bessj_f=coe1*bessj_f
  end if

  return
end function

!----------------------------------------------------
!----------------------------------------------------

double precision function bessj_d(m,t)  !  I ٥åؿ׻
  implicit none
  integer, intent(in) :: m  ! ׻뼡
  double precision, intent(in) :: t  ! 
  integer :: istep, n
  double precision :: x, coe1
  integer, parameter :: mmax = 100 ! ʬѤ
  double precision, parameter :: pis=3.14159265
  double precision, parameter :: xmin = 0.0d0, xmax = 2.0d0*pis
  double precision, parameter :: dx = (xmax-xmin)/(mmax-1)

  if(t<0.0)then
     write(*,*) "*** ERROR ***"
     write(*,*) "The argument of bessj must not be negative."
     write(*,*) "Stop."
     stop
  end if

!-- μǤäʬ ---
  if(m < 0)then
     n=-m
  else
     n=m
  end if

!-- ٥åؿʬ׻ ---
  bessj_d=0.0d0

  do istep=2,mmax-1
     x=xmin+dx*dble(istep-1)
     bessj_d=bessj_d+dx*(dcos(t*dsin(x)-dble(n)*x))
  end do

  bessj_d=bessj_d+0.5d0*dx*(dcos(t*dsin(xmin)-dble(n)*xmin) &
 &            +dcos(t*dsin(xmax)-dble(n)*xmax))
  bessj_d=bessj_d/(2.0d0*pis)

!-- μǤäʬ ---
  if(m.lt.0)then
     if(mod(n,2)==0)then  ! (-1)^m η׻󤹤
        coe1=1.0d0
     else
        coe1=-1.0d0
     end if
     bessj_d=coe1*bessj_d
  end if

  return
end function

!----------------------------------------------------
!----------------------------------------------------

real function bessj_fnoni(nu,t)
! ˤ٥åؿ׻.
! Ǥϥ졼եʬΩʤΤ, Lommel ʬ
! ׻뤳Ȥˤäɾ. ޤ,
! $J_{-n}(x)=(-1)^nJ_n(x)$
! μΩʤΤ, μξľܷ׻Ԥ褦ѹ.
! Lommel ʬϰʲμ
! $J_{\nu} (x)=\left(\frac{x}{2} \right) ^{\nu} \frac{1}{\sqrt[]{\pi} \Gamma (\nu +1/2)} \int^{\pi}_{0}{\cos{(z\cos{\theta} )} } $
! , μɾǤΤ, $\nu > -\frac{1}{2} $ޤǤʤΤ, 꾮Υ٥åؿϷ׻Ǥʤ.
! , ʲμ٥åؿ
! $J_{\nu -1}(x)+J_{\nu +1}(x)=\frac{2\nu}{x} J_{\nu} (x)$
! ѤƷ׻. , ξ, $x>0$ ˸¤.

  use Math_Const
  implicit none
  real, intent(in) :: nu  ! ׻뼡
  real, intent(in) :: t  ! 
  integer :: istep, n
  real :: x
  integer, parameter :: mmax = 100 ! ʬѤ
  real :: xmin, xmax, dx, tmp1, tmp2, bess0, bess1, bess2, tmp
  intrinsic :: aint

  xmin = 0.0
  xmax = pi
  dx = (xmax-xmin)/(mmax-1)

  if(t<0.0)then
     write(*,*) "*** ERROR ***"
     write(*,*) "The argument of bessj must not be negative."
     write(*,*) "Stop."
     stop
  end if

  if(nu<=-0.5)then  ! nu <= -1/2 ξν.
     tmp1=nu+1.0+aint(abs(nu))
     tmp2=nu+2.0+aint(abs(nu))  !  3 ʤΤ, ͤ 2 .
  end if


!-- ٥åؿʬ׻ ---
  bessj_fnoni=0.0

  if(nu>-0.5)then
     do istep=2,mmax-1
        x=xmin+dx*(istep-1)
        bessj_fnoni=bessj_fnoni+dx*(cos(t*cos(x))*((sin(x))**(2.0*nu)))
     end do

     bessj_fnoni=bessj_fnoni+0.5*dx*(cos(t*cos(xmin))*((sin(xmin))**(2.0*nu)) &
 &               +cos(t*cos(xmax))*((sin(xmax))**(2.0*nu)))
     bessj_fnoni=bessj_fnoni*((0.5*x)**nu)/(sqrt(pi)*gamma_func_f(nu+0.5))

  else  ! nu <= -0.5 ΤȤ.
     bess1=0.0
     bess2=0.0
     do istep=2,mmax-1
        x=xmin+dx*(istep-1)
        bess1=bess1+dx*(cos(t*cos(x))*((sin(x))**(2.0*tmp1)))
        bess2=bess2+dx*(cos(t*cos(x))*((sin(x))**(2.0*tmp2)))
     end do

     bess1=bess1+0.5*dx*(cos(t*cos(xmin))*((sin(xmin))**(2.0*tmp1)) &
 &               +cos(t*cos(xmax))*((sin(xmax))**(2.0*tmp1)))
     bess1=bess1*((0.5*x)**tmp1)/(sqrt(pi)*gamma_func_f(tmp1+0.5))
     bess2=bess2+0.5*dx*(cos(t*cos(xmin))*((sin(xmin))**(2.0*tmp2)) &
 &               +cos(t*cos(xmax))*((sin(xmax))**(2.0*tmp2)))
     bess2=bess2*((0.5*x)**tmp2)/(sqrt(pi)*gamma_func_f(tmp2+0.5))

     tmp=tmp1

     do while(tmp/=nu)  ! tmp=nu ˤʤä, ˤʤäȽǤ.
        bess0=2.0*tmp1*bess1/t-bess2
        tmp=tmp-1.0
        tmp1=tmp1-1.0
        bess2=bess1
        bess1=bess0  ! η겼
     end do

     bessj_fnoni=bess1

  end if

  return

end function

!----------------------------------------------------
!----------------------------------------------------

double precision function bessj_dnoni(nu,t)
! ˤ٥åؿ׻.
! Ǥϥ졼եʬΩʤΤ, Lommel ʬ
! ׻뤳Ȥˤäɾ. ޤ,
! $J_{-n}(x)=(-1)^nJ_n(x)$
! μΩʤΤ, μξľܷ׻Ԥ褦ѹ.
! Lommel ʬϰʲμ
! $J_{\nu} (x)=\left(\frac{x}{2} \right) ^{\nu} \frac{1}{\sqrt[]{\dble(pi)} \Gamma (\nu +1/2)} \int^{\dble(pi)}_{0}{\cos{(z\cos{\theta} )} } $
! , μɾǤΤ, $\nu > -\frac{1}{2} $ޤǤʤΤ, 꾮Υ٥åؿϷ׻Ǥʤ.
! , ʲμ٥åؿ
! $J_{\nu -1}(x)+J_{\nu +1}(x)=\frac{2\nu}{x} J_{\nu} (x)$
! ѤƷ׻. , ξ, $x>0$ ˸¤.

  use Math_Const
  implicit none
  double precision, intent(in) :: nu  ! ׻뼡
  double precision, intent(in) :: t  ! 
  integer :: istep, n
  double precision :: x
  integer, parameter :: mmax = 100 ! ʬѤ
  double precision :: xmin, xmax, dx, tmp1, tmp2, bess0, bess1, bess2, tmp
  intrinsic :: aint

  xmin = 0.0d0
  xmax = dble(pi)
  dx = (xmax-xmin)/(mmax-1)

  if(t<0.0d0)then
     write(*,*) "*** ERROR ***"
     write(*,*) "The argument of bessj must not be negative."
     write(*,*) "Stop."
     stop
  end if

  if(nu<=-0.5d0)then  ! nu <= -1/2 ξν.
     tmp1=nu+1.0d0+aint(abs(nu))
     tmp2=nu+2.0d0+aint(abs(nu))  !  3 ʤΤ, ͤ 2 .
  end if


!-- ٥åؿʬ׻ ---
  bessj_dnoni=0.0d0

  if(nu>-0.5d0)then
     do istep=2,mmax-1
        x=xmin+dx*(istep-1)
        bessj_dnoni=bessj_dnoni+dx*(cos(t*cos(x))*((sin(x))**(2.0d0*nu)))
     end do

     bessj_dnoni=bessj_dnoni+0.5d0*dx*(cos(t*cos(xmin))*((sin(xmin))**(2.0d0*nu)) &
 &               +cos(t*cos(xmax))*((sin(xmax))**(2.0d0*nu)))
     bessj_dnoni=bessj_dnoni*((0.5d0*x)**nu)/(sqrt(dble(pi))*gamma_func_d(nu+0.5d0))

  else  ! nu <= -0.5 ΤȤ.
     bess1=0.0d0
     bess2=0.0d0
     do istep=2,mmax-1
        x=xmin+dx*(istep-1)
        bess1=bess1+dx*(cos(t*cos(x))*((sin(x))**(2.0d0*tmp1)))
        bess2=bess2+dx*(cos(t*cos(x))*((sin(x))**(2.0d0*tmp2)))
     end do

     bess1=bess1+0.5d0*dx*(cos(t*cos(xmin))*((sin(xmin))**(2.0d0*tmp1)) &
 &               +cos(t*cos(xmax))*((sin(xmax))**(2.0d0*tmp1)))
     bess1=bess1*((0.5d0*x)**tmp1)/(sqrt(dble(pi))*gamma_func_d(tmp1+0.5))
     bess2=bess2+0.5d0*dx*(cos(t*cos(xmin))*((sin(xmin))**(2.0d0*tmp2)) &
 &               +cos(t*cos(xmax))*((sin(xmax))**(2.0d0*tmp2)))
     bess2=bess2*((0.5d0*x)**tmp2)/(sqrt(dble(pi))*gamma_func_d(tmp2+0.5d0))

     tmp=tmp1

     do while(tmp/=nu)  ! tmp=nu ˤʤä, ˤʤäȽǤ.
        bess0=2.0d0*tmp1*bess1/t-bess2
        tmp=tmp-1.0d0
        tmp1=tmp1-1.0d0
        bess2=bess1
        bess1=bess0  ! η겼
     end do

     bessj_dnoni=bess1

  end if

  return

end function

!----------------------------------------------------

!----------------------------------------------------
!----------------------------------------------------

!----------------------------------------------------
!----------------------------------------------------

real function bessy_f( n, z )
! ΥΥޥؿ׻.
! ׻ˤ, 졼եʬɽѤ, Ⱦ̵ΰʬˤĤƤ,
! ʬؿ 10^{-6} ãޤǤǤ.
! ޤ, Ⱦ̵ʬʬؿ 2 Ĥ뤬, 줾ˤĤƹͤ
! ɾ, ΤͤۤǤιʬ褦ˤ.
! , ˡŬڤɤݾڤǤʤ.
  use Math_Const
  implicit none
  integer, intent(in) :: n  ! 
  real, intent(in) :: z  ! ѿ
  real :: coe1, coe2, coe3, dt, term1, term2, tmp1, tmp2, t
  real,parameter :: tmin=0.0, tmax=pi  ! ʬʬΰ
  real, parameter :: thres=1.0e-6
  integer :: i, j, k
  integer, parameter :: nt=100  ! ʬʬʬ

  if(z<0.0)then
     write(*,*) "*** ERROR ***"
     write(*,*) "The argument of bessj must not be negative."
     write(*,*) "Stop."
     stop
  end if

  term1=0.0
  term2=0.0
  dt=1.0e-2

!-- Ⱦ̵ʬη׻
!--  1

  t=0.0

  tmp1=0.5  ! ʬؿ z=0 Ǥ x 0.5
  term1=tmp1

  do while (tmp1>thres)
     t=t+dt
     tmp1=exp(n*t-z*sinh(t))
     term1=term1+tmp1
  end do

  t=t+dt
  term1=term1+0.5*exp(n*t-z*sinh(t))
  term1=dt*term1/pi

!--  2

  t=0.0

  tmp2=0.5  ! ʬؿ z=0 Ǥ x 0.5
  term2=tmp2

  do while (tmp2>thres)
     t=t+dt
     tmp2=exp(-(n*t+z*sinh(t)))
     term2=term2+tmp2*cos(n*pi)  ! cos μǤͤŪ˲ʤ
                               ! 褦, Τߤɾ. cos ϤȤǤ
  end do

  t=t+dt
  term2=term2+0.5*exp(-(n*t+z*sinh(t)))*cos(n*pi)
  term2=dt*term2/pi

!-- ʬ׻
  dt=(tmax-tmin)/nt
  t=0.0

  bessy_f=0.0  ! tmin Ǥʬؿ

  do i=1,nt-1
     t=t+dt
     bessy_f=bessy_f+sin(z*sin(t)-n*t)
  end do

  bessy_f=bessy_f+0.5*sin(z*sin(tmax)-n*tmax)
  bessy_f=dt*bessy_f/pi-term1-term2

  return
end function

!----------------------------------------------------
!----------------------------------------------------

double precision function bessy_d( n, z )
! ΥΥޥؿ׻.
! ׻ˤ, 졼եʬɽѤ, Ⱦ̵ΰʬˤĤƤ,
! ʬؿ 10^{-6} ãޤǤǤ.
! ޤ, Ⱦ̵ʬʬؿ 2 Ĥ뤬, 줾ˤĤƹͤ
! ɾ, ΤͤۤǤιʬ褦ˤ.
! , ˡŬڤɤݾڤǤʤ.
  use Math_Const
  implicit none
  integer, intent(in) :: n  ! 
  double precision, intent(in) :: z  ! ѿ
  double precision :: coe1, coe2, coe3, dt, term1, term2, tmp1, tmp2, t
  double precision,parameter :: tmin=0.0, tmax=dble(pi)  ! ʬʬΰ
  double precision, parameter :: thres=1.0d-6
  integer :: i, j, k
  integer, parameter :: nt=100  ! ʬʬʬ

  if(z<0.0d0)then
     write(*,*) "*** ERROR ***"
     write(*,*) "The argument of bessj must not be negative."
     write(*,*) "Stop."
     stop
  end if

  term1=0.0d0
  term2=0.0d0
  dt=1.0d-2

!-- Ⱦ̵ʬη׻
!--  1

  t=0.0d0

  tmp1=0.5d0  ! ʬؿ z=0 Ǥ x 0.5
  term1=tmp1

  do while (tmp1>thres)
     t=t+dt
     tmp1=exp(n*t-z*sinh(t))
     term1=term1+tmp1
  end do

  t=t+dt
  term1=term1+0.5d0*exp(n*t-z*sinh(t))
  term1=dt*term1/dble(pi)

!--  2

  t=0.0d0

  tmp2=0.5d0  ! ʬؿ z=0 Ǥ x 0.5
  term2=tmp2

  do while (tmp2>thres)
     t=t+dt
     tmp2=exp(-(n*t+z*sinh(t)))
     term2=term2+tmp2*cos(n*dble(pi))  ! cos μǤͤŪ˲ʤ
                               ! 褦, Τߤɾ. cos ϤȤǤ
  end do

  t=t+dt
  term2=term2+0.5d0*exp(-(n*t+z*sinh(t)))*cos(n*dble(pi))
  term2=dt*term2/dble(pi)

!-- ʬ׻
  dt=(tmax-tmin)/nt
  t=0.0d0

  bessy_d=0.0d0  ! tmin Ǥʬؿ

  do i=1,nt-1
     t=t+dt
     bessy_d=bessy_d+sin(z*sin(t)-n*t)
  end do

  bessy_d=bessy_d+0.5d0*sin(z*sin(tmax)-n*tmax)
  bessy_d=dt*bessy_d/dble(pi)-term1-term2

  return
end function

!----------------------------------------------------
!----------------------------------------------------

real function bessy_fnoni( nu, t )
! ˤΥޥؿ׻.
! $Y_{\nu} =\frac{1}{\sin{\nu \pi}} [\cos{\nu \pi }J_{\nu} (x)-J_{-\nu} (x)]$
  use Math_Const
  implicit none
  real, intent(in) :: nu  ! 
  real, intent(in) :: t  ! ѿ
  intrinsic :: aint

  if(t<=0.0)then
     write(*,*) "*** ERROR ***"
     write(*,*) "The argument of bessy must not be negative or zero."
     write(*,*) "Stop."
     stop
  end if

  if(nu/=aint(nu))then  ! nu ξ, bessy_f ˥쥯Ȥ.
     bessy_fnoni=(cos(nu*pi)*bessj_fnoni( nu, t )-bessj_fnoni( -nu, t ))  &
  &              /(sin(nu*pi))
  else
     bessy_fnoni=bessy_f( int(nu), t )
  end if

  return
end function

!----------------------------------------------------
!----------------------------------------------------

double precision function bessy_dnoni( nu, t )
! ˤΥޥؿ׻.
! $Y_{\nu} =\frac{1}{\sin{\nu \pi}} [\cos{\nu \pi }J_{\nu} (x)-J_{-\nu} (x)]$
  use Math_Const
  implicit none
  double precision, intent(in) :: nu  ! 
  double precision, intent(in) :: t  ! ѿ
  intrinsic :: aint

  if(t<=0.0)then
     write(*,*) "*** ERROR ***"
     write(*,*) "The argument of bessy must not be negative or zero."
     write(*,*) "Stop."
     stop
  end if

  if(nu/=aint(nu))then  ! nu ξ, bessy_f ˥쥯Ȥ.
     bessy_dnoni=(cos(nu*dble(pi))*bessj_dnoni( nu, t )-bessj_dnoni( -nu, t ))  &
  &              /(sin(nu*dble(pi)))
  else
     bessy_dnoni=bessy_d( int(nu), t )
  end if

  return
end function

!----------------------------------------------------
!----------------------------------------------------

real function sp_bessj_f( m, t )
! 1٥åؿη׻.
! ٥åؿȵ٥åؿδط.
  use Math_Const
  implicit none
  integer, intent(in) :: m  ! 
  real, intent(in) :: t

  if(t<=0.0)then
     write(*,*) "*** ERROR ***"
     write(*,*) "The argument of sp_bessj must not be negative or zero."
     write(*,*) "Stop."
     stop
  end if

  sp_bessj_f=sqrt(0.5*pi/t)*bessj_fnoni( real(m)+0.5, t )

  return
end function

!----------------------------------------------------
!----------------------------------------------------

double precision function sp_bessj_d( m, t )
! 1٥åؿη׻.
! ٥åؿȵ٥åؿδط.
  use Math_Const
  implicit none
  integer, intent(in) :: m  ! 
  double precision, intent(in) :: t

  if(t<=0.0d0)then
     write(*,*) "*** ERROR ***"
     write(*,*) "The argument of sp_bessj must not be negative or zero."
     write(*,*) "Stop."
     stop
  end if

  sp_bessj_d=sqrt(0.5d0*dble(pi)/t)*bessj_dnoni( dble(m)+0.5d0, t )

  return
end function

!----------------------------------------------------
!----------------------------------------------------

real function sp_bessy_f( m, t )
! 2٥åؿη׻.
! 1٥åؿȤδط.
  use Math_Const
  implicit none
  integer, intent(in) :: m  ! 
  real, intent(in) :: t
  real :: coe1

  if(t<=0.0)then
     write(*,*) "*** ERROR ***"
     write(*,*) "The argument of sp_bessj must not be negative or zero."
     write(*,*) "Stop."
     stop
  end if

  if(mod(abs(m+1),2)==0)then  ! (-1)^n η׻Ȥ򸺤餹, Ƚ.
     coe1=1.0  ! $m+1 = \pm 2n$ ʤΤ, coe1=1
  else
     coe1=-1.0
  end if

  sp_bessy_f=coe1*sp_bessj_f( -m-1, t )

  return
end function

!----------------------------------------------------
!----------------------------------------------------

double precision function sp_bessy_d( m, t )
! 2٥åؿη׻.
! 1٥åؿȤδط.
  use Math_Const
  implicit none
  integer, intent(in) :: m  ! 
  double precision, intent(in) :: t
  double precision :: coe1

  if(t<=0.0d0)then
     write(*,*) "*** ERROR ***"
     write(*,*) "The argument of sp_bessy must not be negative or zero."
     write(*,*) "Stop."
     stop
  end if

  if(mod(abs(m+1),2)==0)then  ! (-1)^n η׻Ȥ򸺤餹, Ƚ.
     coe1=1.0d0  ! $m+1 = \pm 2n$ ʤΤ, coe1=1
  else
     coe1=-1.0d0
  end if

  sp_bessy_d=coe1*sp_bessj_d( -m-1, t )

  return
end function

!----------------------------------------------------
!----------------------------------------------------

real function df_bessj_f( m, t )
! ˤ 1 ѷ٥åؿη׻
! df_bessj_fnoni إ쥯
  implicit none
  integer, intent(in) :: m  ! 
  real, intent(in) :: t  ! ѿ

  df_bessj_f=df_bessj_fnoni( real(m), t )

end function

!----------------------------------------------------
!----------------------------------------------------

double precision function df_bessj_d( m, t )
! ˤ 1 ѷ٥åؿη׻
! df_bessj_fnoni إ쥯
  implicit none
  integer, intent(in) :: m  ! 
  double precision, intent(in) :: t  ! ѿ

  df_bessj_d=df_bessj_dnoni( dble(m), t )

end function

!----------------------------------------------------
!----------------------------------------------------

real function df_bessj_fnoni( nu, t )
! ˤ 1 ѷ٥åؿη׻
! ʬ׻.
! ʬϰʲμ
! $$I_{\nu} (x)=\frac{1}{\sqrt[]{\pi} \mathit{\Gamma} (\nu +1/2)} \left(\frac{x}{2} \right) ^{\nu} \int^{\infty}_{0}{\cosh{(x\cosh{t})} sin^{2\nu}{t} dt} $$
! , $\nu >-1/2$ǤΤ, 꾮ˤĤƤ, 
! $$I_{\nu -1}-I_{\nu +1} =\frac{2\nu}{x} I_{\nu} $$
! ѤƼ򲼤.
  use Math_Const
  implicit none
  real, intent(in) :: nu  ! ׻뼡
  real, intent(in) :: t  ! 
  integer :: istep, n
  real :: x
  integer, parameter :: mmax = 100 ! ʬѤ
  real :: xmin, xmax, dx, tmp1, tmp2, bess0, bess1, bess2, tmp
  intrinsic :: aint

  xmin = 0.0
  xmax = pi
  dx = (xmax-xmin)/(mmax-1)

  if(t<0.0)then
     write(*,*) "*** ERROR ***"
     write(*,*) "The argument of df_bessj must not be negative."
     write(*,*) "Stop."
     stop
  end if

  if(nu<=-0.5)then  ! nu <= -1/2 ξν.
     tmp1=nu+1.0+aint(abs(nu))
     tmp2=nu+2.0+aint(abs(nu))  !  3 ʤΤ, ͤ 2 .
  end if


!-- ٥åؿʬ׻ ---
  df_bessj_fnoni=0.0

  if(nu>-0.5)then
     do istep=2,mmax-1
        x=xmin+dx*(istep-1)
        df_bessj_fnoni=df_bessj_fnoni+dx*(cosh(t*cos(x))*((sin(x))**(2.0*nu)))
     end do

     df_bessj_fnoni=df_bessj_fnoni+0.5*dx*(cosh(t*cos(xmin))*((sin(xmin))**(2.0*nu)) &
 &               +cosh(t*cos(xmax))*((sin(xmax))**(2.0*nu)))
     df_bessj_fnoni=df_bessj_fnoni*((0.5*x)**nu)/(sqrt(pi)*gamma_func_f(nu+0.5))

  else  ! nu <= -0.5 ΤȤ.
     bess1=0.0
     bess2=0.0
     do istep=2,mmax-1
        x=xmin+dx*(istep-1)
        bess1=bess1+dx*(cosh(t*cos(x))*((sin(x))**(2.0*tmp1)))
        bess2=bess2+dx*(cosh(t*cos(x))*((sin(x))**(2.0*tmp2)))
     end do

     bess1=bess1+0.5*dx*(cosh(t*cos(xmin))*((sin(xmin))**(2.0*tmp1)) &
 &               +cosh(t*cos(xmax))*((sin(xmax))**(2.0*tmp1)))
     bess1=bess1*((0.5*x)**tmp1)/(sqrt(pi)*gamma_func_f(tmp1+0.5))
     bess2=bess2+0.5*dx*(cosh(t*cos(xmin))*((sin(xmin))**(2.0*tmp2)) &
 &               +cosh(t*cos(xmax))*((sin(xmax))**(2.0*tmp2)))
     bess2=bess2*((0.5*x)**tmp2)/(sqrt(pi)*gamma_func_f(tmp2+0.5))

     tmp=tmp1

     do while(tmp/=nu)  ! tmp=nu ˤʤä, ˤʤäȽǤ.
        bess0=2.0*tmp1*bess1/t-bess2
        tmp=tmp-1.0
        tmp1=tmp1-1.0
        bess2=bess1
        bess1=bess0  ! η겼
     end do

     df_bessj_fnoni=bess1

  end if

  return
end function

!----------------------------------------------------
!----------------------------------------------------

double precision function df_bessj_dnoni( nu, t )
! ˤ 1 ѷ٥åؿη׻
! ʬ׻.
! ʬϰʲμ
! $$I_{\nu} (x)=\frac{1}{\sqrt[]{\pi} \mathit{\Gamma} (\nu +1/2)} \left(\frac{x}{2} \right) ^{\nu} \int^{\infty}_{0}{\cosh{(x\cosh{t})} sin^{2\nu}{t} dt} $$
! , $\nu >-1/2$ǤΤ, 꾮ˤĤƤ, 
! $$I_{\nu -1}-I_{\nu +1} =\frac{2\nu}{x} I_{\nu} $$
! ѤƼ򲼤.
  use Math_Const
  implicit none
  double precision, intent(in) :: nu  ! ׻뼡
  double precision, intent(in) :: t  ! 
  integer :: istep, n
  double precision :: x
  integer, parameter :: mmax = 100 ! ʬѤ
  double precision :: xmin, xmax, dx, tmp1, tmp2, bess0, bess1, bess2, tmp
  intrinsic :: aint

  xmin = 0.0d0
  xmax = dble(pi)
  dx = (xmax-xmin)/(mmax-1)

  if(t<0.0d0)then
     write(*,*) "*** ERROR ***"
     write(*,*) "The argument of df_bessj must not be negative."
     write(*,*) "Stop."
     stop
  end if

  if(nu<=-0.5d0)then  ! nu <= -1/2 ξν.
     tmp1=nu+1.0d0+aint(abs(nu))
     tmp2=nu+2.0d0+aint(abs(nu))  !  3 ʤΤ, ͤ 2 .
  end if


!-- ٥åؿʬ׻ ---
  df_bessj_dnoni=0.0d0

  if(nu>-0.5d0)then
     do istep=2,mmax-1
        x=xmin+dx*(istep-1)
        df_bessj_dnoni=df_bessj_dnoni+dx*(cosh(t*cos(x))*((sin(x))**(2.0d0*nu)))
     end do

     df_bessj_dnoni=df_bessj_dnoni+0.5d0*dx*(cosh(t*cos(xmin))*((sin(xmin))**(2.0d0*nu)) &
 &               +cosh(t*cos(xmax))*((sin(xmax))**(2.0d0*nu)))
     df_bessj_dnoni=df_bessj_dnoni*((0.5d0*x)**nu)/(sqrt(dble(pi))*gamma_func_d(nu+0.5d0))

  else  ! nu <= -0.5 ΤȤ.
     bess1=0.0d0
     bess2=0.0d0
     do istep=2,mmax-1
        x=xmin+dx*(istep-1)
        bess1=bess1+dx*(cosh(t*cos(x))*((sin(x))**(2.0d0*tmp1)))
        bess2=bess2+dx*(cosh(t*cos(x))*((sin(x))**(2.0d0*tmp2)))
     end do

     bess1=bess1+0.5d0*dx*(cosh(t*cos(xmin))*((sin(xmin))**(2.0d0*tmp1)) &
 &               +cosh(t*cos(xmax))*((sin(xmax))**(2.0d0*tmp1)))
     bess1=bess1*((0.5d0*x)**tmp1)/(sqrt(dble(pi))*gamma_func_d(tmp1+0.5d0))
     bess2=bess2+0.5d0*dx*(cosh(t*cos(xmin))*((sin(xmin))**(2.0d0*tmp2)) &
 &               +cosh(t*cos(xmax))*((sin(xmax))**(2.0d0*tmp2)))
     bess2=bess2*((0.5d0*x)**tmp2)/(sqrt(dble(pi))*gamma_func_d(tmp2+0.5d0))

     tmp=tmp1

     do while(tmp/=nu)  ! tmp=nu ˤʤä, ˤʤäȽǤ.
        bess0=2.0d0*tmp1*bess1/t-bess2
        tmp=tmp-1.0d0
        tmp1=tmp1-1.0d0
        bess2=bess1
        bess1=bess0  ! η겼
     end do

     df_bessj_dnoni=bess1

  end if

  return
end function

!----------------------------------------------------
!----------------------------------------------------

real function df_bessy_f( n, z )
! ѷΥޥؿ׻.
! ׻ˤ, 
! $$K_n(x)=\int^{\infty}_{0}{e^{-z\cosh{t}} \cosh{nt} dt} $$
! , $n>=0$. $n<0$ˤĤƤ, ѷΥޥؿ:
! $$K_{\nu -1}-K_{\nu +1} =-\frac{2\nu}{x} K_{\nu} $$
! Ѥ,
! Ⱦ̵ΰʬˤĤƤ,
! ʬؿ 10^{-6} ãޤǤǤ.
! , ˡŬڤɤݾڤǤʤ.
  use Math_Const
  implicit none
  integer, intent(in) :: n  ! 
  real, intent(in) :: z  ! ѿ
  integer :: coe1, coe2, coe3, coe
  real :: dt, term1, term2, tmp1, tmp2, t, bess0, bess1, bess2
  real, parameter :: thres=1.0e-6
  integer :: i, j, k
  intrinsic :: aint

  if(t<0.0)then
     write(*,*) "*** ERROR ***"
     write(*,*) "The argument of df_bessy must not be negative."
     write(*,*) "Stop."
     stop
  end if

  if(n<0)then  ! nu <= -1/2 ξν.
     coe1=n+1+aint(abs(real(n)))
     coe2=n+2+aint(abs(real(n)))  !  3 ʤΤ, ͤ 2 .
  end if

  if(n>=0)then
     df_bessy_f=df_bessy_term1_f( n, z )+df_bessy_term2_f( n, z )
  else  ! n<0 ΤȤ
     bess1=df_bessy_term1_f( coe1, z )+df_bessy_term2_f( coe1, z )
     bess2=df_bessy_term1_f( coe2, z )+df_bessy_term2_f( coe2, z )

     coe=coe1

     do while(coe/=n)  ! coe=n ˤʤä, ˤʤäȽǤ.
        bess0=2.0d0*coe1*bess1/t-bess2
        coe=coe-1.0d0
        coe1=coe1-1.0d0
        bess2=bess1
        bess1=bess0  ! η겼
     end do

     df_bessy_f=bess1
  end if

  return
end function

!----------------------------------------------------
!----------------------------------------------------

double precision function df_bessy_d( n, z )
! ѷΥޥؿ׻.
! ׻ˤ, 
! $$K_n(x)=\int^{\infty}_{0}{e^{-z\cosh{t}} \cosh{nt} dt} $$
! , $n>=0$. $n<0$ˤĤƤ, ѷΥޥؿ:
! $$K_{\nu -1}-K_{\nu +1} =-\frac{2\nu}{x} K_{\nu} $$
! Ѥ,
! Ⱦ̵ΰʬˤĤƤ,
! ʬؿ 10^{-6} ãޤǤǤ.
! , ˡŬڤɤݾڤǤʤ.
  use Math_Const
  implicit none
  integer, intent(in) :: n  ! 
  double precision, intent(in) :: z  ! ѿ
  integer :: coe1, coe2, coe3, coe
  double precision :: dt, term1, term2, tmp1, tmp2, t, bess0, bess1, bess2
  double precision, parameter :: thres=1.0d-6
  integer :: i, j, k
  intrinsic :: aint

  if(t<0.0d0)then
     write(*,*) "*** ERROR ***"
     write(*,*) "The argument of df_bessy must not be negative."
     write(*,*) "Stop."
     stop
  end if

  if(n<0)then  ! nu <= -1/2 ξν.
     coe1=n+1+aint(abs(real(n)))
     coe2=n+2+aint(abs(real(n)))  !  3 ʤΤ, ͤ 2 .
  end if

  if(n>=0)then
     df_bessy_d=df_bessy_term1_d( n, z )+df_bessy_term2_d( n, z )
  else  ! n<0 ΤȤ
     bess1=df_bessy_term1_d( coe1, z )+df_bessy_term2_d( coe1, z )
     bess2=df_bessy_term1_d( coe2, z )+df_bessy_term2_d( coe2, z )

     coe=coe1

     do while(coe/=n)  ! coe=n ˤʤä, ˤʤäȽǤ.
        bess0=2.0d0*coe1*bess1/t-bess2
        coe=coe-1.0d0
        coe1=coe1-1.0d0
        bess2=bess1
        bess1=bess0  ! η겼
     end do

     df_bessy_d=bess1
  end if

  return
end function

!----------------------------------------------------
!----------------------------------------------------
!-- Private Function --
real function df_bessy_term1_f( n, z )
  use Math_Const
  implicit none
  integer, intent(in) :: n  ! 
  real, intent(in) :: z  ! ѿ
  real :: term1, tmp1, tmp2, t, term2, dt
  real, parameter :: thres=1.0e-6
  integer :: i, j, k

  term1=0.0
  term2=0.0
  dt=1.0e-2

!-- Ⱦ̵ʬη׻
!--  1

  t=0.0

  tmp1=0.5  ! ʬؿ z=0 Ǥ x 0.5
  term1=tmp1

  do while (tmp1>thres)
     t=t+dt
     tmp1=exp(n*t-z*cosh(t))
     term1=term1+tmp1
  end do

  t=t+dt
  term1=term1+0.5*exp(n*t-z*cosh(t))
  df_bessy_term1_f=0.5*dt*term1

  return
end function

!----------------------------------------------------
!----------------------------------------------------
!-- Private Function --
real function df_bessy_term2_f( n, z )
  use Math_Const
  implicit none
  integer, intent(in) :: n  ! 
  real, intent(in) :: z  ! ѿ
  real :: term1, tmp1, tmp2, t, term2, dt
  real, parameter :: thres=1.0e-6
  integer :: i, j, k

  term1=0.0
  term2=0.0
  dt=1.0e-2

!-- Ⱦ̵ʬη׻
!--  2

  t=0.0

  tmp2=0.5  ! ʬؿ z=0 Ǥ x 0.5
  term2=tmp2

  do while (tmp2>thres)
     t=t+dt
     tmp2=exp(-(n*t+z*cosh(t)))
     term2=term2+tmp2
  end do
  t=t+dt
  term2=term2+0.5*exp(-(n*t+z*cosh(t)))
  df_bessy_term2_f=0.5*dt*term2

  return
end function

!----------------------------------------------------
!----------------------------------------------------
!-- Private Function --
double precision function df_bessy_term1_d( n, z )
  use Math_Const
  implicit none
  integer, intent(in) :: n  ! 
  double precision, intent(in) :: z  ! ѿ
  double precision :: term1, tmp1, tmp2, term2, t, dt
  double precision, parameter :: thres=1.0d-6
  integer :: i, j, k

  term1=0.0
  term2=0.0
  dt=1.0d-2

!-- Ⱦ̵ʬη׻
!--  1

  t=0.0d0

  tmp1=0.5d0  ! ʬؿ z=0 Ǥ x 0.5
  term1=tmp1

  do while (tmp1>thres)
     t=t+dt
     tmp1=exp(n*t-z*cosh(t))
     term1=term1+tmp1
  end do

  t=t+dt
  term1=term1+0.5d0*exp(n*t-z*cosh(t))
  df_bessy_term1_d=0.5d0*dt*term1

  return
end function

!----------------------------------------------------
!----------------------------------------------------
!-- Private Function --
double precision function df_bessy_term2_d( n, z )
  use Math_Const
  implicit none
  integer, intent(in) :: n  ! 
  double precision, intent(in) :: z  ! ѿ
  double precision :: term1, tmp1, tmp2, t, term2, dt
  double precision, parameter :: thres=1.0d-6
  integer :: i, j, k

  term1=0.0d0
  term2=0.0d0
  dt=1.0d-2

!-- Ⱦ̵ʬη׻
!--  2

  t=0.0d0

  tmp2=0.5d0  ! ʬؿ z=0 Ǥ x 0.5
  term2=tmp2

  do while (tmp2>thres)
     t=t+dt
     tmp2=exp(-(n*t+z*cosh(t)))
     term2=term2+tmp2
  end do
  t=t+dt
  term2=term2+0.5d0*exp(-(n*t+z*cosh(t)))
  df_bessy_term2_d=0.5d0*dt*term2

  return
end function

!----------------------------------------------------
!----------------------------------------------------

real function df_bessy_fnoni( nu, t )
! ˤѷΥޥؿ׻.
! $K_{\nu} =\frac{1}{\sin{\nu \pi}} [I_{-\nu} (x)-I_{\nu} (x)]$
  use Math_Const
  implicit none
  real, intent(in) :: nu  ! 
  real, intent(in) :: t  ! ѿ
  intrinsic :: aint

  if(t<=0.0)then
     write(*,*) "*** ERROR ***"
     write(*,*) "The argument of df_bessy must not be negative or zero."
     write(*,*) "Stop."
     stop
  end if

  if(nu/=aint(nu))then  ! nu ξ, bessy_f ˥쥯Ȥ.
     df_bessy_fnoni=(df_bessj_fnoni( -nu, t )-df_bessj_fnoni( nu, t ))  &
  &              /(sin(nu*pi))
  else
     df_bessy_fnoni=df_bessy_f( int(nu), t )
  end if

  return
end function

!----------------------------------------------------
!----------------------------------------------------

double precision function df_bessy_dnoni( nu, t )
! ˤѷΥޥؿ׻.
! $K_{\nu} =\frac{1}{\sin{\nu \pi}} [I_{-\nu} (x)-I_{\nu} (x)]$
  use Math_Const
  implicit none
  double precision, intent(in) :: nu  ! 
  double precision, intent(in) :: t  ! ѿ
  intrinsic :: aint

  if(t<=0.0d0)then
     write(*,*) "*** ERROR ***"
     write(*,*) "The argument of df_bessy must not be negative or zero."
     write(*,*) "Stop."
     stop
  end if

  if(nu/=aint(nu))then  ! nu ξ, bessy_f ˥쥯Ȥ.
     df_bessy_dnoni=(df_bessj_dnoni( -nu, t )-df_bessj_dnoni( nu, t ))  &
  &              /(sin(nu*dble(pi)))
  else
     df_bessy_dnoni=df_bessy_d( int(nu), t )
  end if

  return
end function

!----------------------------------------------------
!----------------------------------------------------
!
!real function Airy_f( x )
! ꡼ؿ׻
!  implicit none
!  real, intent(in) :: x  ! 
!  real :: t, z, dx
!  real, parameter :: xmin=-1.0
!  real, parameter :: xmax=1.0
!  integer :: i, j
!  integer, parameter :: nx=100

!  dx=(xmax-xmin)/(nx-1)

!  z=0.0

!  do i=

!  return
!end function

!----------------------------------------------------
!----------------------------------------------------

real function gamma_func_f(x)
! ޴ؿ׻.
! ˤϡִȿظüؿp.5פζ¿༰.
! ζ 0<=x<=1 ǤȤʤΤ, ޴ؿ
! $z\Gamma (z)=\Gamma (z+1)$ ǶŬϰϤȤ.
! z>1.0 ξ,
! $\Gamma (z)=(z-1)\Gamma (z-1)=\cdots =(z-1)\cdots (x)\Gamma (x)$
! z<0.0 ξ,
! $\Gamma (z)=\Gamma (z+1)/z=\cdots =\Gamma (x)/(z\cdots x)$
! ޤ, ޴ؿ, ǤϷ׻ȥåפ褦.

  implicit none
  real, intent(in) :: x
  real :: tmp, intg
  real :: coe(8)
  integer :: i
  intrinsic :: aint

  if(x<0.0.and.x==aint(x))then
     write(*,*) "*** Error ***"
     write(*,*) " The agreement of Gamma function must not be negative and integer."
     write(*,*) "Stop"
     stop
  end if

  coe=(/-0.577191652, 0.988205891, -0.897056937, 0.918206857,  &
  &     -0.756704078, 0.482199394, -0.193527818, 0.035868343 /)

  if(abs(x)>1.0)then
     intg=aint(abs(x))  ! ʲڤΤ
     if(x>1.0)then  ! Ƚ
        tmp=x-intg
     else
        tmp=x+1.0+intg  ! 0 ޤΤ +1.
     end if
  else
     tmp=x
  end if

  gamma_func_f=1.0

  do i=1,8
     gamma_func_f=gamma_func_f+coe(i)*(tmp**i)
  end do

  if(abs(x)>1.0)then  ! ޴ؿˤ׻
     tmp=x
     do while(tmp>1.0.or.tmp<0.0)
        if(x>1.0)then
           gamma_func_f=gamma_func_f*tmp
           tmp=tmp-1.0
        else
           gamma_func_f=gamma_func_f/tmp
           tmp=tmp+1.0
        end if
     end do
  end if

  return
end function

!----------------------------------------------------
!----------------------------------------------------

double precision function gamma_func_d(x)
! ޴ؿ׻.
! ˤϡִȿظüؿp.5פζ¿༰.
! ζ 0<=x<=1 ǤȤʤΤ, ޴ؿ
! $z\Gamma (z)=\Gamma (z+1)$ ǶŬϰϤȤ.
! z>1.0 ξ,
! $\Gamma (z)=(z-1)\Gamma (z-1)=\cdots =(z-1)\cdots (x)\Gamma (x)$
! z<0.0 ξ,
! $\Gamma (z)=\Gamma (z+1)/z=\cdots =\Gamma (x)/(z\cdots x)$
! ޤ, ޴ؿ, ǤϷ׻ȥåפ褦.

  implicit none
  double precision, intent(in) :: x
  double precision :: tmp, intg
  double precision :: coe(8)
  integer :: i
  intrinsic :: aint

  if(x<0.0d0.and.x==aint(x))then
     write(*,*) "*** Error ***"
     write(*,*) " The agreement of Gamma function must not be negative and integer."
     write(*,*) "Stop"
     stop
  end if

  coe=(/-0.577191652d0, 0.988205891d0, -0.897056937d0, 0.918206857d0,  &
  &     -0.756704078d0, 0.482199394d0, -0.193527818d0, 0.035868343d0 /)

  if(abs(x)>1.0d0)then
     intg=aint(abs(x))  ! ʲڤΤ
     if(x>1.0d0)then  ! Ƚ
        tmp=x-intg
     else
        tmp=x+1.0d0+intg  ! 0 ޤΤ +1.
     end if
  else
     tmp=x
  end if

  gamma_func_d=1.0d0

  do i=1,8
     gamma_func_d=gamma_func_d+coe(i)*(tmp**i)
  end do

  if(abs(x)>1.0d0)then  ! ޴ؿˤ׻
     tmp=x
     do while(tmp>1.0d0.or.tmp<0.0d0)
        if(x>1.0d0)then
           gamma_func_d=gamma_func_d*tmp
           tmp=tmp-1.0d0
        else
           gamma_func_d=gamma_func_d/tmp
           tmp=tmp+1.0d0
        end if
     end do
  end if

  return
end function

!----------------------------------------------------
!----------------------------------------------------

real function beta_func_f( x, y )
! ١ؿ׻롼.
! ١ؿȥ޴ؿδ֤δط
! $B(x,y)=\frac{\Gamma (x)\Gamma (y)}{\Gamma (x+y)} $
! Ѥ뤳Ȥˤä, ޴ؿη׻Ԥ.
! gamma_func ˤ, ðξ, ٹФ򤷤ƤΤ,
! ١ؿðˤƤٹ𤬽ФͤˤʤäƤ.
  implicit none
  real, intent(in) :: x  ! 
  real, intent(in) :: y  ! 

  beta_func_f=(gamma_func_f(x)*gamma_func_f(y))/(gamma_func_f(x+y))

  return
end function

!----------------------------------------------------
!----------------------------------------------------

double precision function beta_func_d( x, y )
! ١ؿ׻롼.
! ١ؿȥ޴ؿδ֤δط
! $B(x,y)=\frac{\Gamma (x)\Gamma (y)}{\Gamma (x+y)} $
! Ѥ뤳Ȥˤä, ޴ؿη׻Ԥ.
! gamma_func ˤ, ðξ, ٹФ򤷤ƤΤ,
! ١ؿðˤƤٹ𤬽ФͤˤʤäƤ.
  implicit none
  double precision, intent(in) :: x  ! 
  double precision, intent(in) :: y  ! 

  beta_func_d=(gamma_func_d(x)*gamma_func_d(y))/(gamma_func_d(x+y))

  return
end function

!----------------------------------------------------
!----------------------------------------------------

real function delta(t,u)  ! ͥåΥǥ륿׻륵֥롼
  implicit none
  integer, intent(in) :: t  ! ʬ
  integer, intent(in) :: u  ! ʬ

  if(t==u)then
     delta=1.0
  else
     delta=0.0
  end if

  return
end function


subroutine besfzero(nmax,mmax,k)
!**********************************
!  ٥åؿΥ׻ *
!**********************************
  implicit none
  integer, intent(in) :: nmax          ! ٥åؿΥκĿ
  integer, intent(in) :: mmax          ! ٥åؿκ缡
  real, intent(inout) :: k(0:nmax,mmax)  ! mmax ޤǤ nmax+1 ĤΥǼ
  real :: a, b, c, d, e, f, g, lim, dx
  integer :: i, j, n

!-- ʬˡβȶ ---
  lim=1.0e-6    ! «

!-- ʬˡꤹ뤿,  ---
!-- ٥åؿΥδֳ֤Ϥ褽 3 ȤǤΤ,
!-- 0.5 Ĺ, ޤ
!-- ա˼ºݻѤκݤ, bessj_f ؿȤƤ뤫ǧΤ.
!-- Х
  dx=0.5
!-- ν ---
  do i=0,nmax
     do j=1,mmax
        k(i,j)=0.0
     end do
  end do

!-- 0 ׻ ---
  k(0,1)=0.0
  d=k(0,1)

  do 10 i=1,mmax

     if(i.gt.1)then
        d=k(0,i-1)+dx
     end if

     do while (k(0,mmax).eq.0.0)
        a=d
        e=bessj_f(0,a)
        b=a+dx
        f=bessj_f(0,b)
        d=d+dx

        do while (e*f.lt.0.0)
           c=0.5*(a+b)
           g=bessj_f(0,c)
           if(e*g.lt.0.0)then
              b=c
           else
              a=c
           end if

           if(abs(g).lt.lim)then
              k(0,i)=c
              go to 10
           end if

        end do
     end do 
  10 continue

  if(nmax > 0)then
!-- 1 ʾ׻ ---
     do n=1,nmax
     do 21 i=1,mmax
        d=k(n-1,i)+dx
        do while (k(n,mmax).eq.0.0)
           a=d
           e=bessj_f(n,a)
           b=a+dx
           f=bessj_f(n,b)
           d=d+dx
           do while (e*f.lt.0.0)
              c=0.5*(a+b)
              g=bessj_f(n,c)
              if(e*g.lt.0.0)then
                 b=c
              else
                 a=c
              end if
              if(abs(g).lt.lim)then
                 k(n,i)=c
                 go to 21
              end if
           end do
        end do
  21  continue
     end do
  end if

end subroutine


subroutine besdzero(nmax,mmax,k)
!**********************************
!  ٥åؿΥ׻ *
!**********************************
  implicit none
  integer, intent(in) :: nmax          ! ٥åؿΥκĿ
  integer, intent(in) :: mmax          ! ٥åؿκ缡
  double precision, intent(inout) :: k(0:nmax,mmax)  ! mmax ޤǤ nmax+1 ĤΥǼ
  double precision :: a, b, c, d, e, f, g, lim, dx
  integer :: i, j, n

!-- ʬˡβȶ ---
  lim=1.0d-6    ! «

!-- ʬˡꤹ뤿,  ---
!-- ٥åؿΥδֳ֤Ϥ褽 3 ȤǤΤ,
!-- 0.5 Ĺ, ޤ
  dx=0.5d0
!-- ν ---
  do i=0,nmax
     do j=1,mmax
        k(i,j)=0.0d0
     end do
  end do

!-- 0 ׻ ---
  k(0,1)=0.0d0
  d=k(0,1)

  do 10 i=1,mmax

     if(i.gt.1)then
        d=k(0,i-1)+dx
     end if

     do while (k(0,mmax).eq.0.0d0)
        a=d
        e=bessj_d(0,a)
        b=a+dx
        f=bessj_d(0,b)
        d=d+dx

        do while (e*f.lt.0.0d0)
           c=0.5d0*(a+b)
           g=bessj_d(0,c)
           if(e*g.lt.0.0d0)then
              b=c
           else
              a=c
           end if

           if(abs(g).lt.lim)then
              k(0,i)=c
              go to 10
           end if

        end do
     end do 
  10 continue

  if(nmax > 0)then
!-- 1 ʾ׻ ---
     do n=1,nmax
     do 21 i=1,mmax
        d=k(n-1,i)+dx
        do while (k(n,mmax).eq.0.0d0)
           a=d
           e=bessj_d(n,a)
           b=a+dx
           f=bessj_d(n,b)
           d=d+dx
           do while (e*f.lt.0.0d0)
              c=0.5d0*(a+b)
              g=bessj_d(n,c)
              if(e*g.lt.0.0d0)then
                 b=c
              else
                 a=c
              end if
              if(abs(g).lt.lim)then
                 k(n,i)=c
                 go to 21
              end if
           end do
        end do
  21  continue
     end do
  end if

end subroutine


end module Special_Function

