module Thermo_Advanced_Function
! å롼, ؿ use ʣǮϳشؿ׻⥸塼
use Thermo_Function
use Thermo_Const
use Thermo_Routine
use Math_Const
use Phys_Const
use Algebra
use Statistics

contains

real function Rich( za, pta, ptg, va, qva, qvs )
! Х륯㡼ɥ׻ؿ
  use Phys_Const
  use Thermo_Function
  implicit none
  real, intent(in) :: za  ! 㡼ɥ׻ [m]
  real, intent(in) :: pta  ! za Ǥβ [K]
  real, intent(in) :: ptg  ! ɽ̤Ǥβ [K]
  real, intent(in) :: va  !  za Ǥοʿ® [m/s]
  real, intent(in) :: qva  ! za Ǥκ [kg/kg]
  real, intent(in) :: qvs  ! ɽ̤Ǥ˰º [kg/kg]
  real :: ptvg, ptva, dpt

  ptvg=ptg*((1.0+eps_rdrv*qvs)/(1.0+qvs))
  ptva=pta*((1.0+eps_rdrv*qva)/(1.0+qva))
  dpt=ptva-ptvg
  Rich=(g*za*dpt)/(ptva*(va**2))

  return
end function

!--------------------------------------------------------

real function Louis( z, z0m, richard )
! Louis(1980) ƤƤ絤԰٤θХ륯׻ؿ
  use Thermo_Const
  implicit none
  real, intent(in) :: z  ! cm  [m]
  real, intent(in) :: z0m  ! ǥǷ׻ٹ [m]
  real, intent(in) :: richard  ! Х륯㡼ɥ
  real, parameter :: b=5.0, c=5.0
  real :: cm_tmp, zratio

  cm_tmp=(kalm/(log(z)-log(z0m)))**2
  zratio=z/z0m

  if(richard<0.0)then
     Louis=1.0-((2.0*b*richard)/(1.0+3.0*b*c*cm_tmp*sqrt(-richard*zratio)))
  else
     Louis=1.0/(1.0+2.0*b*richard*sqrt(1.0+c*richard))
  end if

  return
end function

!--------------------------------------------------------

real function cm( z, z0m, richard )
! ư̤˴ؤХ륯׻ؿ
  use Thermo_Const
  implicit none
  real, intent(in) :: z  ! cm  [m]
  real, intent(in) :: z0m  ! ǥǷ׻ٹ [m]
  real, intent(in), optional :: richard  ! Louis (1980) ΥǷ׻ΥХ륯㡼ɥ

  if(present(richard))then
     cm=(kalm/(log(z)-log(z0m)))**2
     cm=cm*Louis( z, z0m, richard )
  else
     cm=(kalm/(log(z)-log(z0m)))**2
  end if

  return
end function

!--------------------------------------------------------
!--------------------------------------------------------

real function ust( cmd, va )
! ໤® u_* ׻ؿ
  implicit none
  real, intent(in) :: cmd  !  za ǤΥХ륯
  real, intent(in) :: va  !  za Ǥοʿ [m/s]

  ust=va*sqrt(cmd)

end function

!--------------------------------------------------------
!--------------------------------------------------------

real function precip_water( p, qv, undef )  ! Ĺ߿̤׻. ñ̤ [kg/m^2]
! ʬϰϤ p ǿξ岼üǼưŪ˻.
! ݤ狼ȼ, ٺɸʬΤǤϤʤ,
! ϳʿդ鵤ɸ֤ľʬ.
  use Algebra
  implicit none
  real, intent(in) :: p(:)  !  [Pa]
  real, intent(in) :: qv(size(p))  !  [kg/kg]
  real, intent(in), optional :: undef  ! undef
  integer :: nx, i
  real, dimension(size(p)) :: tmp_p, tmp_qv
  real :: precip

  nx=size(p)

  if(present(undef))then
     do i=1,nx
        if(p(i)==undef.or.qv(i)==undef)then
           tmp_qv(i)=0.0
           tmp_p(i)=tmp_p(i-1)
        else
           tmp_qv(i)=qv(i)
           tmp_p(i)=p(i)
        end if
     end do
  else
     do i=1,nx
        tmp_qv(i)=qv(i)
        tmp_p(i)=p(i)
     end do
  end if

  call rectangle_int( tmp_p, tmp_qv, tmp_p(nx), tmp_p(1), precip )
write(*,*) "precip", precip, tmp_qv(1), tmp_qv(nx)
  precip_water=-precip/g

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function CAPE( tmp_p, tmp_z, tmp_qv, tmp_t, z_ref, undeff )
  use Thermo_Const
  use Thermo_Function
  use Algebra
  use Statistics
  implicit none
  real, intent(in) :: tmp_p(:)  !  [Pa]
  real, intent(in) :: tmp_z(size(tmp_p))  !  [m]
  real, intent(in) :: tmp_qv(size(tmp_p))  !  [kg/kg]
  real, intent(in) :: tmp_t(size(tmp_p))  !  [K]
  real, intent(in) :: z_ref  ! ѡ夲 [m]
  real, intent(in), optional :: undeff
  integer :: nx, i, j, iz_LFC, iz_LNB
  real :: PLFC, TLFC, PLNB, ZLFC, ZLNB
  real :: tmp(size(tmp_p)), t_par(size(tmp_p))

  t_par=0.0

  nx=size(tmp_p)

!-- LFC, LNB Ǥι, , Ϥη׻

  TLFC=T_LFC( z_ref, tmp_z, tmp_t, tmp_p, tmp_qv )
  ZLFC=z_LFC( z_ref, tmp_z, tmp_t, tmp_p, tmp_qv )
  ZLNB=z_LNB( z_ref, tmp_z, tmp_t, tmp_p, tmp_qv )
  call interpo_search_1d( tmp_z, ZLFC, iz_LFC, undeff )
  call interpo_search_1d( tmp_z, ZLNB, iz_LNB, undeff )
  call interpolation_1d( tmp_z(iz_LFC), tmp_z(iz_LFC+1), tmp_p(iz_LFC),  &
  &    tmp_p(iz_LFC+1), ZLFC, PLFC )
  call interpolation_1d( tmp_z(iz_LNB), tmp_z(iz_LNB+1), tmp_p(iz_LNB),  &
  &    tmp_p(iz_LNB+1), ZLNB, PLNB )

  do i=1,nx
     if(tmp_p(i)<=PLFC.and.tmp_p(i)>=PLNB)then
        if(present(undeff))then
           if(undeff==tmp_t(i))then
              tmp(i)=undeff
           else
              t_par(i)=moist_laps_temp( PLFC, TLFC, tmp_p(i) )
              tmp(i)=(t_par(i)-tmp_t(i))/tmp_p(i)
           end if
        else
           t_par(i)=moist_laps_temp( PLFC, TLFC, tmp_p(i) )
           tmp(i)=(t_par(i)-tmp_t(i))/tmp_p(i)
        end if
     end if
  end do

  call rectangle_int( tmp_p, tmp, PLNB, PLFC, CAPE, undeff )
! PLNB Ƥ뤬, rectangle_int νԹǤʤäƤ.
! ʬθ, \int^{PLNB}_{PLFC} ǹԤ.
  CAPE=-CAPE*Rd

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function CIN( tmp_p, tmp_z, tmp_qv, tmp_t, z_ref, undeff )
  use Thermo_Const
  use Algebra
  use Thermo_Function
  use Statistics
  implicit none
  real, intent(in) :: tmp_p(:)  !  [Pa]
  real, intent(in) :: tmp_z(size(tmp_p))  !  [m]
  real, intent(in) :: tmp_qv(size(tmp_p))  !  [kg/kg]
  real, intent(in) :: tmp_t(size(tmp_p))  !  [K]
  real, intent(in) :: z_ref  ! ѡ夲 [m]
  real, intent(in), optional :: undeff
  integer :: nx, i, j, iz_LFC, iz_ref, iz_LCL
  real :: PLFC, TLFC, ZLFC, PLCL, ZLCL, TLCL, p_ref, T_ref, qv_ref
  real :: tmp(size(tmp_p)), t_par(size(tmp_p))

  t_par=0.0

  nx=size(tmp_p)

!-- z_ref Ȥ, LCL, LFC Ǥβ, , Ϥη׻

!-- LFC ٤ѿ׻
  TLFC=T_LFC( z_ref, tmp_z, tmp_t, tmp_p, tmp_qv )
  ZLFC=z_LFC( z_ref, tmp_z, tmp_t, tmp_p, tmp_qv )
  call interpo_search_1d( tmp_z, ZLFC, iz_LFC, undeff )
  call interpolation_1d( tmp_z(iz_LFC), tmp_z(iz_LFC+1), tmp_p(iz_LFC),  &
  &    tmp_p(iz_LFC+1), ZLFC, PLFC )
!-- reference ٤ѿ׻
  call interpo_search_1d( tmp_z, z_ref, iz_ref, undeff )
  call interpolation_1d( tmp_z(iz_ref), tmp_z(iz_ref+1), tmp_p(iz_ref),  &
  &    tmp_p(iz_ref+1), z_ref, p_ref )
  call interpolation_1d( tmp_z(iz_ref), tmp_z(iz_ref+1), tmp_t(iz_ref),  &
  &    tmp_t(iz_ref+1), z_ref, T_ref )
  call interpolation_1d( tmp_z(iz_ref), tmp_z(iz_ref+1), tmp_qv(iz_ref),  &
  &    tmp_qv(iz_ref+1), z_ref, qv_ref )
!-- LCL ٤ѿ׻
  TLCL=TqvP_2_TLCL( t_ref, qv_ref, p_ref )
  ZLCL=z_LCL( z_ref, tmp_z, tmp_t, tmp_p, tmp_qv )
  call interpo_search_1d( tmp_z, ZLCL, iz_LCL, undeff )
  call interpolation_1d( tmp_z(iz_LCL), tmp_z(iz_LCL+1), tmp_p(iz_LCL),  &
  &    tmp_p(iz_LCL+1), ZLCL, PLCL )

! Ϥβ٤ T ƤΤ, ޤ LCL ׻, ι
! ޤǤǮ, ʹߤ򼾽Ǯǥѡ벹٤׻.

  do i=1,nx
     if(tmp_z(i)>=z_ref.and.tmp_z(i)<=ZLCL)then
        t_par(i)=T_ref-(g/Cpd)*(tmp_z(i)-z_ref)
     else
        t_par(i)=moist_laps_temp( PLCL, TLCL, tmp_p(i) )
     end if
     if(present(undeff))then
        if(undeff==tmp_t(i))then
           tmp(i)=undeff
        else
           tmp(i)=(t_par(i)-tmp_t(i))/tmp_p(i)
        end if
     else
        tmp(i)=(t_par(i)-tmp_t(i))/tmp_p(i)
     end if
  end do

!do i=1,nx
!   if(tmp_p(i)<p_ref.and.tmp_p(i)>PLFC)then
!      t_par(i)=t_bot-(g/CPD)*(height(i+1)-height(i))
!      if(PLCL>PLFC)then   ! žؤΤ
!         if(p(i)<=PLCL.and.p(i)>=PLFC)then
!            call moist_laps_calc( PLCL, TLCL, p(i), t_par(i) )
!         end if
!      end if
!   end if
!end do

  call rectangle_int( tmp_p, tmp, PLFC, p_ref, CIN, undeff )
! PLNB Ƥ뤬, rectangle_int νԹǤʤäƤ.
! ʬθ, \int^{PLNB}_{PLFC} ǹԤ.
  CIN=-CIN*Rd

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function z_LCL( z_ref, z, temp, pres, qv )  ! LCL ٤׻.
! ѡ뤬 z_ref ǮǾ徺, β٤ãȤι٤
! LCL ٤ȤʤΤ, z_ref 鴥ǮΨǰʲΤ褦˷׻.
! LCL ٤ z_LCL Ȥ, ѡδ٤ z_ref Ȥ,
! LCL ãޤǤϴǮΨ \Gamma _d ѲΤ,
! $\Gamma _d=\frac{g}{C_p} =-\frac{T_LCL-T_ref}{z_LCL-z_ref} $
! ȤΩ. , z_LCL ˤĤƲ򤯤,
! $z_LCL=z_ref+\frac{C_p}{g} (T_ref-T_LCL)$
! Ȥʤ.
  use Thermo_Const
  use Phys_Const
  use Statistics
  implicit none
  real, intent(in) :: z_ref  !  [m]
  real, intent(in) :: z(:)  ! ٺɸ [m]
  real, intent(in) :: temp(size(z))  !  [K]
  real, intent(in) :: pres(size(z))  !  [Pa]
  real, intent(in) :: qv(size(z))  !  [kg/kg]
  integer :: i, j, k, nz, iz_ref
  real :: TLCL
  real :: T_ref, P_ref, qv_ref

  call interpo_search_1d( z, z_ref, iz_ref )
  call interpolation_1d( z(iz_ref), z(iz_ref), temp(iz_ref),  &
  &    temp(iz_ref+1), z_ref, T_ref )
  call interpolation_1d( z(iz_ref), z(iz_ref), pres(iz_ref),  &
  &    pres(iz_ref+1), z_ref, P_ref )
  call interpolation_1d( z(iz_ref), z(iz_ref), qv(iz_ref),  &
  &    qv(iz_ref+1), z_ref, qv_ref )

  TLCL=TqvP_2_TLCL( T_ref, P_ref, qv_ref )  ! z_ref Υѡ LCL Ǥβ.
  z_LCL=z_ref+(Cpd/g)*(T_ref-TLCL)

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function z_LFC( z_ref, z, temp, pres, qv )  ! LFC ٤׻.
! ٤Ǥ̤徺Ȥ, Ϥ˰̤Ȱפ٤
! LFC Ǥ. 
! Ǥ, Ϥ˰̤ȸ򺹤 2 , 
! ޤ뤳Ȥǹ٤ꤹ.
  use Statistics
  use Thermo_Function
  implicit none
  real, intent(in) :: z_ref  !  [m]
  real, intent(in) :: z(:)  ! ٺɸ [m]
  real, intent(in) :: temp(size(z))  !  [K]
  real, intent(in) :: pres(size(z))  !  [Pa]
  real, intent(in) :: qv(size(z))  !  [kg/kg]
  integer :: i, j, k, nz, iz, iept
  real :: sept(size(z))
  real :: eptiz, eptiz1, ept_ref, z_sol

  nz=size(z)

!-- ľ˰̤׻.
  do i=1,nz
     sept(i)=thetaes_Bolton( temp(i), pres(i) )
  end do

!-- z_ref Ǥ̤׻.
  call interpo_search_1d( z, z_ref, iz )
!-- iz  iz+1 Ǥ̤׻.
  eptiz=thetae_Bolton( temp(iz), qv(iz), pres(iz) )
  eptiz1=thetae_Bolton( temp(iz+1), qv(iz+1), pres(iz+1) )
!-- δ֤̤
  call interpolation_1d( z(iz), z(iz+1), eptiz, eptiz1, z_ref, ept_ref )
!-- z_ref ι٤ ept_ref ˰̤δط׻.
  do i=iz+1,nz
     if((sept(i)-ept_ref)*(sept(i+1)-ept_ref)<0.0)then
        iept=i
        exit
     end if
  end do
!-- ѡ̤Ķ˰̤ȵžľι٤ iept Ǥ.
!-- , iept  iept+1 ˰̤٤ޤ.
  call interpolation_1d( sept(iept), sept(iept+1), z(iept), z(iept+1),  &
  &                      ept_ref, z_sol )

  z_LFC=z_sol

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function z_LNB( z_ref, z, temp, pres, qv, opt )  ! LNB ٤׻.
! LFC ٰʾǺƤӴĶ˰̤ȸ٤ LNB Ǥ.
! , ºݤ¬ǡǤ, ¬ưˤ, LFC ľ LNB 
! ã礬.
! , opt Ȥ, LFC Ƥ LNB ׻ˡ
! 鲼˲ƺǽ˸򺹤٤ LNB ˡ
! 2 ѥѰդ뤳Ȥˤ.
! opt = 1, LFC . opt = 2 ľ夫׻.
! ǥեȤǤ opt = 1 ׻.
  use Statistics
  use Thermo_Function
  implicit none
  real, intent(in) :: z_ref  !  [m]
  real, intent(in) :: z(:)  ! ٺɸ [m]
  real, intent(in) :: temp(size(z))  !  [K]
  real, intent(in) :: pres(size(z))  !  [Pa]
  real, intent(in) :: qv(size(z))  !  [kg/kg]
  integer, intent(in), optional :: opt  ! ׻ˡΥץ
  integer :: i, j, k, nz, iz, iept, counter
  real :: sept(size(z))
  real :: eptiz, eptiz1, ept_ref, z_sol

  nz=size(z)

!-- ľ˰̤׻.
  do i=1,nz
     sept(i)=thetaes_Bolton( temp(i), pres(i) )
  end do

!-- z_ref Ǥ̤׻.
  call interpo_search_1d( z, z_ref, iz )
!-- iz  iz+1 Ǥ̤׻.
  eptiz=thetae_Bolton( temp(iz), qv(iz), pres(iz) )
  eptiz1=thetae_Bolton( temp(iz+1), qv(iz+1), pres(iz+1) )
!-- δ֤̤
  call interpolation_1d( z(iz), z(iz+1), eptiz, eptiz1, z_ref, ept_ref )

  counter=0

  if(present(opt))then
     if(opt==2)then
        do i=nz,iz+1,-1  ! 夫鲼˲.
           if((sept(i)-ept_ref)*(sept(i-1)-ept_ref)<0.0)then
              iept=i-1  ! 夫鲼˲ƤΤ, 1 ǲΥǡ iept.
              exit
           end if
        end do
     else
!-- z_ref ι٤ ept_ref ˰̤δط׻.
        do i=iz+1,nz
           if((sept(i)-ept_ref)*(sept(i+1)-ept_ref)<0.0)then
              counter=counter+1
              if(counter==2)then
                 iept=i
                 exit
              end if
           end if
        end do
     end if
  else
     do i=iz+1,nz
        if((sept(i)-ept_ref)*(sept(i+1)-ept_ref)<0.0)then
           counter=counter+1
           if(counter==2)then
              iept=i
              exit
           end if
        end if
     end do
  end if
!-- ѡ̤Ķ˰̤ȵžľι٤ iept Ǥ.
!-- , iept  iept+1 ˰̤٤ޤ.
  call interpolation_1d( sept(iept), sept(iept+1), z(iept), z(iept+1),  &
  &                      ept_ref, z_sol )

  z_LNB=z_sol

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function T_LFC( z_ref, z, temp, pres, qv )  ! LFC ٤Ǥβ٤׻.
! ٤Ǥ̤徺Ȥ, Ϥ˰̤Ȱפ٤
! LFC Ǥ. 
! Ǥ, Ϥ˰̤ȸ򺹤 2 , 
! ޤ뤳Ȥǹ٤ꤹ.
  use Statistics
  use Thermo_Function
  implicit none
  real, intent(in) :: z_ref  !  [m]
  real, intent(in) :: z(:)  ! ٺɸ [m]
  real, intent(in) :: temp(size(z))  !  [K]
  real, intent(in) :: pres(size(z))  !  [Pa]
  real, intent(in) :: qv(size(z))  !  [kg/kg]
  integer :: i, j, k, nz, iz, iept
  real :: sept(size(z))
  real :: eptiz, eptiz1, ept_ref, z_sol

  nz=size(z)

!-- ľ˰̤׻.
  do i=1,nz
     sept(i)=thetaes_Bolton( temp(i), pres(i) )
  end do

!-- z_ref Ǥ̤׻.
  call interpo_search_1d( z, z_ref, iz )
!-- iz  iz+1 Ǥ̤׻.
  eptiz=thetae_Bolton( temp(iz), qv(iz), pres(iz) )
  eptiz1=thetae_Bolton( temp(iz+1), qv(iz+1), pres(iz+1) )
!-- δ֤̤
  call interpolation_1d( z(iz), z(iz+1), eptiz, eptiz1, z_ref, ept_ref )
!-- z_ref ι٤ ept_ref ˰̤δط׻.
  do i=iz+1,nz
     if((sept(i)-ept_ref)*(sept(i+1)-ept_ref)<0.0)then
        iept=i
        exit
     end if
  end do
!-- ѡ̤Ķ˰̤ȵžľι٤ iept Ǥ.
!-- , iept  iept+1 ˰̤٤ޤ.
  call interpolation_1d( sept(iept), sept(iept+1), temp(iept), temp(iept+1),  &
  &                      ept_ref, z_sol )

  T_LFC=z_sol

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

real function T_LNB( z_ref, z, temp, pres, qv, opt )  ! LNB ٤Ǥβ٤׻.
! LFC ٰʾǺƤӴĶ˰̤ȸ٤ LNB Ǥ.
! , ºݤ¬ǡǤ, ¬ưˤ, LFC ľ LNB 
! ã礬.
! , opt Ȥ, LFC Ƥ LNB ׻ˡ
! 鲼˲ƺǽ˸򺹤٤ LNB ˡ
! 2 ѥѰդ뤳Ȥˤ.
! opt = 1, LFC . opt = 2 ľ夫׻.
! ǥեȤǤ opt = 1 ׻.
  use Statistics
  use Thermo_Function
  implicit none
  real, intent(in) :: z_ref  !  [m]
  real, intent(in) :: z(:)  ! ٺɸ [m]
  real, intent(in) :: temp(size(z))  !  [K]
  real, intent(in) :: pres(size(z))  !  [Pa]
  real, intent(in) :: qv(size(z))  !  [kg/kg]
  integer, intent(in), optional :: opt  ! ׻ˡΥץ
  integer :: i, j, k, nz, iz, iept, counter
  real :: sept(size(z))
  real :: eptiz, eptiz1, ept_ref, z_sol

  nz=size(z)

!-- ľ˰̤׻.
  do i=1,nz
     sept(i)=thetaes_Bolton( temp(i), pres(i) )
  end do

!-- z_ref Ǥ̤׻.
  call interpo_search_1d( z, z_ref, iz )
!-- iz  iz+1 Ǥ̤׻.
  eptiz=thetae_Bolton( temp(iz), qv(iz), pres(iz) )
  eptiz1=thetae_Bolton( temp(iz+1), qv(iz+1), pres(iz+1) )
!-- δ֤̤
  call interpolation_1d( z(iz), z(iz+1), eptiz, eptiz1, z_ref, ept_ref )

  counter=0

  if(present(opt))then
     if(opt==2)then
        do i=nz,iz+1,-1  ! 夫鲼˲.
           if((sept(i)-ept_ref)*(sept(i-1)-ept_ref)<0.0)then
              iept=i-1  ! 夫鲼˲ƤΤ, 1 ǲΥǡ iept.
              exit
           end if
        end do
     else
!-- z_ref ι٤ ept_ref ˰̤δط׻.
        do i=iz+1,nz
           if((sept(i)-ept_ref)*(sept(i+1)-ept_ref)<0.0)then
              counter=counter+1
              if(counter==2)then
                 iept=i
                 exit
              end if
           end if
        end do
     end if
  else
     do i=iz+1,nz
        if((sept(i)-ept_ref)*(sept(i+1)-ept_ref)<0.0)then
           counter=counter+1
           if(counter==2)then
              iept=i
              exit
           end if
        end if
     end do
  end if
!-- ѡ̤Ķ˰̤ȵžľι٤ iept Ǥ.
!-- , iept  iept+1 ˰̤٤ޤ.
  call interpolation_1d( sept(iept), sept(iept+1), temp(iept), temp(iept+1),  &
  &                      ept_ref, z_sol )

  T_LNB=z_sol

  return
end function

!-----------------------------------------------------
!-----------------------------------------------------

!-----------------------------------------------------
!-----------------------------------------------------

!real function




!  return
!end function

!-----------------------------------------------------
!-----------------------------------------------------





end module
