module Thermo_Advanced_Routine
! å롼, ؿ use ʣǮϳشؿ׻⥸塼
use Thermo_Function
use Thermo_Routine
use Thermo_Advanced_Function
use analy

contains

subroutine Rich_horizon( za, pta, ptg, va, qva, qvs, Ri )
! Х륯㡼ɥ׻롼
  use Thermo_Advanced_Function
  implicit none
  real, intent(in) :: za  ! 㡼ɥ׻ [m]
  real, intent(in), dimension(:,:) :: pta  ! za Ǥβ [K]
  real, intent(in), dimension(size(pta,1),size(pta,2)) :: ptg  ! ɽ̤Ǥβ [K]
  real, intent(in), dimension(size(pta,1),size(pta,2)) :: va  !  za Ǥοʿ® [m/s]
  real, intent(in), dimension(size(pta,1),size(pta,2)) :: qva  ! za Ǥκ [kg/kg]
  real, intent(in), dimension(size(pta,1),size(pta,2)) :: qvs  ! ɽ̤Ǥ˰º [kg/kg]
  real, intent(inout), dimension(size(pta,1),size(pta,2)) :: Ri  ! 㡼ɥ
  real, dimension(size(pta,1),size(pta,2)) :: ptvg, ptva, dpt
  integer :: i, j, nx, ny

  nx=size(pta,1)
  ny=size(pta,2)

!$omp parallel default(shared)
!$omp do private(i,j)
  do j=1,ny
     do i=1,nx
        Ri(i,j)=Rich( za, pta(i,j), ptg(i,j), va(i,j), qva(i,j), qvs(i,j) )
     end do
  end do
!$omp end do
!$omp end parallel

end subroutine

!--------------------------------------------------------

subroutine Louis_horizon( z, z0m, richard, Lo )
! Louis(1980) ƤƤ絤԰٤θХ륯׻ؿ
  use Thermo_Advanced_Function
  implicit none
  real, intent(in) :: z  ! cm  [m]
  real, intent(in), dimension(:,:) :: z0m  ! ǥǷ׻ٹ [m]
  real, intent(in), dimension(size(z0m,1),size(z0m,2)) :: richard  ! Х륯㡼ɥ
  real, intent(inout), dimension(size(z0m,1),size(z0m,2)) :: Lo  ! 
  real, parameter :: b=5.0, c=5.0
  real :: cm_tmp, zratio
  integer :: i, j, nx, ny

  nx=size(z0m,1)
  ny=size(z0m,2)

!$omp parallel default(shared)
!$omp do private(i,j)
  do j=1,ny
     do i=1,nx
        Lo(i,j)=Louis( z, z0m(i,j), richard(i,j) )
     end do
  end do
!$omp end do
!$omp end parallel

end subroutine

!--------------------------------------------------------

subroutine cm_horizon( z, z0m, coem, richard )
! ư̤˴ؤХ륯׻롼
  use Thermo_Advanced_Function
  implicit none
  real, intent(in) :: z  ! cm  [m]
  real, intent(in), dimension(:,:) :: z0m  ! ǥǷ׻ٹ [m]
  real, intent(inout), dimension(size(z0m,1),size(z0m,2)) :: coem  ! Х륯
  real, intent(in), dimension(size(z0m,1),size(z0m,2)), optional :: richard  ! Louis (1980) ΥǷ׻ΥХ륯㡼ɥ
  integer :: i, j, nx, ny

  nx=size(z0m,1)
  ny=size(z0m,2)

  if(present(richard))then
!$omp parallel default(shared)
!$omp do private(i,j)
     do j=1,ny
        do i=1,nx
           coem(i,j)=cm( z, z0m(i,j), richard(i,j) )
        end do
     end do
!$omp end do
!$omp end parallel
  else
!$omp parallel default(shared)
!$omp do private(i,j)
     do j=1,ny
        do i=1,nx
           coem(i,j)=cm( z, z0m(i,j), richard(i,j) )
        end do
     end do
!$omp end do
!$omp end parallel
  end if

end subroutine

!--------------------------------------------------------

subroutine ust_horizon( cmd, va, velst )
! ໤® u_* ׻롼
  use Thermo_Advanced_Function
  implicit none
  real, intent(in), dimension(:,:) :: cmd  !  za ǤΥХ륯
  real, intent(in), dimension(size(cmd,1),size(cmd,2)) :: va  !  za Ǥοʿ [m/s]
  real, intent(inout), dimension(size(cmd,1),size(cmd,2)) :: velst  ! ໤® [m/s]
  integer :: i, j, nx, ny

!$omp parallel default(shared)
!$omp do private(i,j)
     do j=1,ny
        do i=1,nx
           velst(i,j)=ust( cmd(i,j), va(i,j) )
        end do
     end do
!$omp end do
!$omp end parallel

end subroutine

!--------------------------------------------------------

subroutine Ertel_PV( nx, ny, nz, dx, dy, dz, u, v, w, rho, pt, pv, undeff )
! ƥΥݥƥ󥷥뱲٤׻
  use Thermo_Function
  use Thermo_Routine
  use analy 
  implicit none
  integer, intent(in) :: nx  !  1 ǿ
  integer, intent(in) :: ny  !  2 ǿ
  integer, intent(in) :: nz  !  3 ǿ
  real, intent(in) :: dx  ! x γʻҴֳ [m]
  real, intent(in) :: dy  ! y γʻҴֳ [m]
  real, intent(in) :: dz  ! z γʻҴֳ [m]
  real, intent(in) :: u(nx,ny,nz)  ! ®پ x ʬ [m/s]
  real, intent(in) :: v(nx,ny,nz)  ! ®پ y ʬ [m/s]
  real, intent(in) :: w(nx,ny,nz)  ! ®پ z ʬ [m/s]
  real, intent(in) :: rho(nx,ny,nz)  ! ̩پ [kg/m^3]
  real, intent(in) :: pt(nx,ny,nz)  ! ̾ [K]
  real, intent(inout) :: pv(nx,ny,nz)  ! PV [Km^2/kgs]
  real, intent(in), optional :: undeff
  real :: tmp1(nx,ny,nz)
  real :: tmp2(nx,ny,nz)
  real :: tmp3(nx,ny,nz)
  real :: tmp4(nx,ny,nz)
  real :: tmp5(nx,ny,nz)
  real :: tmp6(nx,ny,nz)
  real :: tmp7(nx,ny,nz)
  integer :: i, j, k

  if(present(undeff))then
!  ̤ζָۤ׻.
     call grad_vec_3d( nx, ny, nz, dx, dy, dz, pt, tmp1, tmp2, tmp3, undeff )
!  3  rotation ׻.
     call rotate( nx, ny, nz, dx, dy, dz, u, v, w, tmp4, tmp5, tmp6, undeff )
!  omega  grad pt Ѥ׻
     call dot_prod( tmp4, tmp5, tmp6, tmp1, tmp2, tmp3, tmp7, undeff )
  else
!  ̤ζָۤ׻.
     call grad_vec_3d( nx, ny, nz, dx, dy, dz, pt, tmp1, tmp2, tmp3 )
!  3  rotation ׻.
     call rotate( nx, ny, nz, dx, dy, dz, u, v, w, tmp4, tmp5, tmp6 )
!  omega  grad pt Ѥ׻
     call dot_prod( tmp4, tmp5, tmp6, tmp1, tmp2, tmp3, tmp7 )
  end if

  if(present(undeff))then
!$omp parallel default(shared)
!$omp do private(i,j,k)

     do k=1,nz
        do j=1,ny
           do i=1,nx
              if(tmp7(i,j,k)==undeff.or.rho(i,j,k)==undeff)then
                 pv(i,j,k)=undeff
              else
                 pv(i,j,k)=tmp7(i,j,k)/rho(i,j,k)
              end if
           end do
        end do
     end do

!$omp end do
!$omp end parallel

  else

!$omp parallel default(shared)
!$omp do private(i,j,k)

     do k=1,nz
        do j=1,ny
           do i=1,nx
              pv(i,j,k)=tmp7(i,j,k)/rho(i,j,k)
           end do
        end do
     end do

!$omp end do
!$omp end parallel

  end if

end subroutine



end module
