module Algebra   ! 黻˹Ԥ⥸塼

  public :: rectangle_int
  public :: Gau_Sei
  public :: LU_devs
  public :: Jacobi_algebra
  public :: SOR_Gau_Sei
  public :: SOR_Jacobi_algebra
  public :: gausss
  public :: schumit_norm
  private :: errata
  private :: Pivot_part
  private :: vec_dot

contains

subroutine rectangle_int( x, y, bot, top, res, undeff )  ! 1 ʬ
  ! ֳ֤Ǥ׻ǽǤ뤬, ٤ݾڤʤ.
  implicit none
  real, intent(in) :: bot  ! ʬֺü
  real, intent(in) :: top  ! ʬֱü
  real, intent(in) :: x(:)  ! ʬѿ
  real, intent(in) :: y(size(x))  ! ʬؿ
  real, intent(inout) :: res  ! ʬʬ
  real, intent(in), optional :: undeff
  integer :: i, j, k, nx
  real :: dx

  nx=size(x)

  res=0.0

  if(present(undeff))then
     do i=1,nx-1
        if(x(i)>=bot.and.x(i)<=top)then  ! ʬϰ֤
           if(y(i+1)/=undeff.and.y(i)/=undeff)then
              res=res+0.5*(x(i+1)-x(i))*(y(i+1)+y(i))
           end if
        end if
     end do
  else
     do i=1,nx-1
        if(x(i)>=bot.and.x(i)<=top)then  ! ʬϰ֤
           res=res+0.5*(x(i+1)-x(i))*(y(i+1)+y(i))
        end if
     end do
  end if

end subroutine rectangle_int

!------------------------------------------

subroutine gausss( nmax, a, b, x )
! ʬԥܥåդξõˡ
  implicit none
  integer, intent(in) :: nmax  ! ǿ
  real, intent(inout) :: a(nmax,nmax)  !  ( 1 ǤԤɽ)
  real, intent(inout) :: b(nmax)
  real, intent(inout) :: x(nmax)
  real :: s, pivotb
  real :: pivot(nmax+1)
  integer :: piv, i, j, k

!-- ʾõ ---
!-- A(I,J) ʾõ ---
  do k=1,nmax-1
!-- PIVOT  ---
!-- ޤ, I ʬκͤꤹ ---
     piv=k
     do i=k+1,nmax
         if(abs(a(i,k)).gt.abs(a(piv,k)))then
            piv=i
         end if
     end do
!-- ޤǤ, ͤꤵ ---
!-- ʲ, ͤȤʬιԤؤ ---
     do j=k,nmax
        pivot(j)=a(k,j)
        a(k,j)=a(piv,j)
        a(piv,j)=pivot(j)
     end do
     pivotb=b(k)
     b(k)=b(piv)
     b(piv)=pivotb
!-- PIVOT ޤ ---
     do i=k+1,nmax
        a(k,i)=a(k,i)/a(k,k)
     end do
     b(k)=b(k)/a(k,k)
     a(k,k)=1.0

     do j=k+1,nmax
        do i=k+1,nmax
            a(j,i)=a(j,i)-a(k,i)*a(j,k)
        end do
        b(j)=b(j)-b(k)*a(j,k)
        a(j,k)=0.0
     end do
  end do

  b(nmax)=b(nmax)/a(nmax,nmax)
  a(nmax,nmax)=1.0

!-- X(I) θ
  x(nmax)=b(nmax)
  do i=nmax-1,1,-1
     s=b(i)
     do j=i+1,nmax
        s=s-a(i,j)*x(j)
     end do
     x(i)=s
  end do

end subroutine gausss

!------------------------------------------

subroutine LU_devs( nmax, a, b, x, itermax )
!-- LU ʬ׻륵֥롼 ---
  implicit none
  integer, intent(in) :: nmax  ! ǿ
  real, intent(inout) :: a(nmax,nmax)  !  ( 1 ǤԤɽ)
  real, intent(inout) :: b(nmax)  ! դΥ٥ȥ
  real, intent(inout) :: x(nmax)  ! 
  real :: d(nmax,nmax), r(nmax), y(nmax)
  integer :: ip(nmax)
  real :: scale(nmax), dx(nmax)
  real :: s, t, pivot, xnorm, dxnorm
  real :: s1, s2, s3, s4, s5, t0, t1, t2, t3, t4, eps
  integer :: iter, itermax
  integer :: p, itemp, i, j, k

!-- ȿɤǤ٤ ---
  t4=6.0

!--  x(i) ν ---
  do i=1,nmax
     x(i)=0.0
  end do

  do i=1,nmax
     do j=1,nmax
        d(i,j)=a(i,j)
     end do

     ip(i)=i

!-- ͤ׻롼 ---
     s=d(i,1)
     do j=2,nmax
        if(d(i,j).gt.s)then
           s=d(i,j)
        end if
     end do
     scale(i)=1.0/s
  end do

  do k=1,nmax
     t=d(ip(k),k)*scale(ip(k))
     p=k
     do i=k,nmax
        t0=d(ip(i),k)*scale(ip(i))
        if(t0.gt.t)then
           t=t0
           p=i
        end if
     end do

!-- ip(p)  ip(k) ؤ ---
     if(p.ne.k)then
        itemp=ip(p)
        ip(p)=ip(k)
        ip(k)=itemp
     end if

     pivot=d(ip(k),k)
     do i=k+1,nmax
        d(ip(i),k)=d(ip(i),k)/pivot
        do j=k+1,nmax
           d(ip(i),j)=d(ip(i),j)-d(ip(i),k)*d(ip(k),j)
        end do
     end do
     if(k.ge.nmax-1)then
        exit
     end if
  end do

!-- ʾõ ---
  y(1)=b(ip(1))
  do i=2,nmax
     s1=0.0
     do j=1,i-1
        s1=s1+d(ip(i),j)*y(j)
     end do
     y(i)=b(ip(i))-s1
  end do

!--  ---
  x(nmax)=y(nmax)/d(ip(nmax),nmax)
  do i=nmax-1,1,-1
     s2=0.0
     do j=i+1,nmax
        s2=s2+d(ip(i),j)*y(j)
     end do
     x(i)=(y(i)-s2)/d(ip(i),i)
  end do

  t1=x(1)
  xnorm=x(1)

  do i=2,nmax
     if(x(i).gt.t1)then
        t1=x(i)
        xnorm=x(i)
     end if
  end do

!-- ȿ ---
  eps=10**(-t4)                      ! ɸ٤ 10 ʿ t4 Ȥ

  do iter=1,itermax
     if(xnorm==0.0)then
        exit
     end if
!-- ĺη׻ ---
     do i=1,nmax
        s3=0.0
        do j=1,nmax
           s3=s3+a(i,j)*x(j)
        end do
        r(i)=b(i)-s3
     end do

!-- ʾõ ---
     y(1)=r(ip(1))
     do i=2,nmax
        s4=0.0
        do j=1,i-1
           s4=s4+d(ip(i),j)*y(j)
        end do
        y(i)=r(ip(i))-s4
     end do

!--  ---
     dx(nmax)=y(nmax)/d(ip(nmax),nmax)
     do i=nmax-1,1,-1
        s5=0.0
        do j=i+1,nmax
           s5=s5+d(ip(i),j)*y(j)
        end do
        dx(i)=(y(i)-s5)/d(ip(i),i)
     end do

     do i=1,nmax
        x(i)=x(i)+dx(i)
     end do

     t3=dx(1)
     dxnorm=dx(1)
     do i=1,nmax
        if(dx(i).gt.t3)then
           t3=dx(i)
           dxnorm=dx(i)
        end if
     end do

     if(dxnorm/xnorm.le.eps)then
        exit
     end if
  end do

end subroutine LU_devs

!------------------------------------------

subroutine Gau_Sei(nx, a, b, eps, x)
  ! ǥˡˤϢΩ 1 
  implicit none
  integer, intent(in) :: nx  !  1 ʬǿ
  real, intent(inout) :: a(nx,nx)  !  ( 1 Ǥιʬɽ)
  real, intent(inout) :: b(nx)  ! ax=b Υ٥ȥ
  real, intent(in) :: eps  ! «
  real, intent(inout) :: x(nx)  ! 򤯲
  integer :: i, j, k, l, m, n  ! ƥ졼ź
  real :: xn  !  x(i) Υƥΰ
  real :: err, err_max  ! 
!-- ͤ 0.0 饹Ȥ ---
  x=0.0

!-- ԥܥåƥ
  call Pivot_part( nx, a, b )

!-- ʲ, while Ѥ뤿, 1 ܤΥƥ졼ȤñȤǹԤ ---
  err_max=0.0
  do i=1,nx
     xn=0.0

     do j=1,nx
        if(j/=i)then
           xn=xn+a(i,j)*x(j)
        end if
     end do

     xn=(b(i)-xn)/a(i,i)

     err=errata(x(i),xn,1)
write(*,*) "err_max", x(i), nx, err_max,err

     if(err_max<=err)then
        err_max=err
     end if

     x(i)=xn

  end do

!-- ʲ, «ޤǥ롼פ ---
  do while(err_max>=eps)
     err_max=0.0
     do i=1,nx
        xn=0.0

        do j=1,nx
           if(j/=i)then
              xn=xn+a(i,j)*x(j)
           end if
        end do

        xn=(b(i)-xn)/a(i,i)
        err=errata(x(i),xn,1)

        if(err_max<=err)then
           err_max=err
        end if

        x(i)=xn

     end do
  end do

end subroutine Gau_Sei

!------------------------------------------

subroutine Jacobi_algebra(nx, a, b, eps, x)
  ! 䥳ˡˤϢΩ 1 
  implicit none
  integer, intent(in) :: nx  !  1 ʬǿ
  real, intent(inout) :: a(nx,nx)  !  ( 1 ǤιԤɽ)
  real, intent(inout) :: b(nx)  ! ax=b Υ٥ȥ
  real, intent(in) :: eps  ! «
  real, intent(inout) :: x(nx)  ! 򤯲
  real :: y(nx)  ! 䥳ˡǻѤǼ, ǰƹ.(xn )
  integer :: i, j, k, l, m, n  ! ƥ졼ź
  real :: err, err_max  ! 
!-- ͤ 0,0 饹Ȥ ---
  x=0.0
  y=0.0

!-- ԥܥåƥ
  call Pivot_part( nx, a, b )

!-- ʲ, ºݤΥ(while Ѥ뤿, 1 ܤΥƥ졼ȤñȤǹԤ) ---
  err_max=0.0
  do i=1,nx
     y(i)=0.0

     do j=1,nx
        if(j/=i)then
           y(i)=y(i)+a(i,j)*x(j)
        end if
     end do

     y(i)=(b(i)-y(i))/a(i,i)

     err=errata(x(i),y(i),1)
write(*,*) "err_max", x(i), nx, err_max,err

     if(err_max<=err)then
        err_max=err
     end if
  end do

  do i=1,nx  ! ǡΰƹ
     x(i)=y(i)
  end do

!-- ʲ, «ޤǥ롼פ ---
  do while(err_max>=eps)
     err_max=0.0
     do i=1,nx
        y(i)=0.0

        do j=1,nx
           if(j/=i)then
              y(i)=y(i)+a(i,j)*x(j)
           end if
        end do

        y(i)=(b(i)-y(i))/a(i,i)
        err=errata(x(i),y(i),1)

        if(err_max<=err)then
           err_max=err
        end if
     end do

     do i=1,nx  ! ǡΰƹ
        x(i)=y(i)
     end do
  end do

end subroutine Jacobi_algebra

!------------------------------------------

subroutine SOR_Gau_Sei(nx, a, b, eps, accel, x)
  ! ǥˡ, SOR ǲ®ˤϢΩ 1 
  implicit none
  integer, intent(in) :: nx  !  1 ʬǿ
  real, intent(inout) :: a(nx,nx)  !  ( 1 ǤιԤɽ)
  real, intent(inout) :: b(nx)  ! ax=b Υ٥ȥ
  real, intent(in) :: eps  ! «
  real, intent(in) :: accel  ! ®. , Ū accel >= 2 ǤȯΤ,
                             ! Ͱʾ夬ꤵȥ顼ǻߤ.
  real, intent(inout) :: x(nx)  ! 򤯲
  integer :: i, j, k, l, m, n  ! ƥ졼ź
  real :: xn  !  x(i) Υƥΰ
  real :: err, err_max  ! 

!-- ®ѥ᡼γǧ
  if(accel>=2.0)then
     write(*,*) "***** ERROR *****"
     write(*,*) "accel parameter must be less than 2.0. STOP."
     stop
  end if

!-- ͤ 0.0 饹Ȥ ---
  x=0.0

!-- ԥܥåƥ
  call Pivot_part( nx, a, b )

!-- ʲ, while Ѥ뤿, 1 ܤΥƥ졼ȤñȤǹԤ ---
  err_max=0.0
  do i=1,nx
     xn=0.0

     do j=1,nx
        if(j/=i)then
           xn=xn+a(i,j)*x(j)
        end if
     end do

     xn=(b(i)-xn)/a(i,i)
     xn=x(i)+accel*(xn-x(i))

     err=errata(x(i),xn,1)
write(*,*) "err_max", x(i), nx, err_max,err

     if(err_max<=err)then
        err_max=err
     end if

     x(i)=xn

  end do

!-- ʲ, «ޤǥ롼פ ---
  do while(err_max>=eps)
     err_max=0.0
     do i=1,nx
        xn=0.0

        do j=1,nx
           if(j/=i)then
              xn=xn+a(i,j)*x(j)
           end if
        end do

        xn=(b(i)-xn)/a(i,i)
        xn=x(i)+accel*(xn-x(i))
        err=errata(x(i),xn,1)

        if(err_max<=err)then
           err_max=err
        end if

        x(i)=xn

     end do
  end do

end subroutine SOR_Gau_Sei

!------------------------------------------

subroutine SOR_Jacobi_algebra(nx, a, b, eps, accel, x)
  ! 䥳ˡ SOR ®ˤϢΩ 1 
  implicit none
  integer, intent(in) :: nx  !  1 ʬǿ
  real, intent(inout) :: a(nx,nx)  !  ( 1 ǤιԤɽ)
  real, intent(inout) :: b(nx)  ! ax=b Υ٥ȥ
  real, intent(in) :: eps  ! «
  real, intent(in) :: accel  ! ®. , Ū accel >= 2 ǤȯΤ,
                             ! Ͱʾ夬ꤵȥ顼ǻߤ.
  real, intent(inout) :: x(nx)  ! 򤯲
  real :: y(nx)  ! 䥳ˡǻѤǼ, ǰƹ.(xn )
  integer :: i, j, k, l, m, n  ! ƥ졼ź
  real :: err, err_max  ! 

!-- ®ѥ᡼γǧ
  if(accel>=2.0)then
     write(*,*) "***** ERROR *****"
     write(*,*) "accel parameter must be less than 2.0. STOP."
     stop
  end if

!-- ͤ 0,0 饹Ȥ ---
  x=0.0
  y=0.0

!-- ԥܥåƥ
  call Pivot_part( nx, a, b )

!-- ʲ, ºݤΥ(while Ѥ뤿, 1 ܤΥƥ졼ȤñȤǹԤ) ---
  err_max=0.0
  do i=1,nx
     y(i)=0.0

     do j=1,nx
        if(j/=i)then
           y(i)=y(i)+a(i,j)*x(j)
        end if
     end do

     y(i)=(b(i)-y(i))/a(i,i)

     err=errata(x(i),y(i),1)
write(*,*) "err_max", x(i), nx, err_max,err

     if(err_max<=err)then
        err_max=err
     end if
  end do

  do i=1,nx  ! ǡΰƹ
     x(i)=x(i)+accel*(y(i)-x(i))
  end do

!-- ʲ, «ޤǥ롼פ ---
  do while(err_max>=eps)
     err_max=0.0
     do i=1,nx
        y(i)=0.0

        do j=1,nx
           if(j/=i)then
              y(i)=y(i)+a(i,j)*x(j)
           end if
        end do

        y(i)=(b(i)-y(i))/a(i,i)
        y(i)=x(i)+accel*(y(i)-x(i))
        err=errata(x(i),y(i),1)

        if(err_max<=err)then
           err_max=err
        end if
     end do

     do i=1,nx  ! ǡΰƹ
        x(i)=y(i)
     end do
  end do

end subroutine SOR_Jacobi_algebra

!-----------------------------------------

subroutine eigenvalue_power( nx, a, eps, eigenval, eigenvec )
! ٤ˡѤƹκͭͤȤθͭͤбͭ٥ȥ.
  implicit none
  integer, intent(in) :: nx  ! ǿ
  real, intent(in) :: a(nx,nx)  ! ͭͤ ( 1 ǤԤɽ)
  real, intent(in) :: eps  ! «Ƚ
  real, intent(inout) :: eigenval  !  a κͭ
  real, intent(inout) :: eigenvec(nx)  ! ͭ٥ȥ
  integer :: i, j, k
  real, dimension(nx) :: x, y
  real :: tmp1, tmp2, err_max, err

  do i=1,nx
     x(i)=1.0  ! ȿˡνͤȤ󥼥Υ٥ȥ
  end do

  tmp1=sqrt(vec_dot( x, x ))  ! ٥ȥΥΥ׻

  do i=1,nx
     x(i)=x(i)/tmp1  ! ٥ȥ򵬳ʲ
  end do

  err_max=eps  ! while ʸ뤿ν

!-- ȿˡ

  do while(err_max>=eps)
     err_max=0.0
     do i=1,nx
        y(i)=0.0  ! ν
        do j=1,nx
           y(i)=y(i)+a(i,j)*x(j)
        end do
     end do

     tmp1=sqrt(vec_dot( y, y ))  ! ٥ȥΥΥ׻

     do i=1,nx
        x(i)=y(i)/tmp1  ! x(i) ι
     end do

!-- ͭͷ׻
     tmp2=vec_dot( x, y )  ! Ƿ׻ Ay  y^t (Ĥޤ, ͭ٥ȥž) 򤫤.
     err_max=errata( eigenval, tmp2, 1 )  !  x(i) ȹ y(i) θ
     eigenval=tmp2

  end do

!-- ȿˡλ

  do i=1,nx
     eigenvec(i)=x(i)  ! ͭ٥ȥѿ
  end do

end subroutine eigenvalue_power

!------------------------------------------

subroutine invert_mat( nx, ax, xx )
! ξõˡĥ, չ׻.
! Ūˤ, դ b ñ̥٥ȥ 1 Ĥ,õ̤Υ٥ȥ¤٤
! չˤ.
  implicit none
  integer, intent(in) :: nx  ! ǿ
  real, intent(in) :: ax(nx,nx)  ! չ
  real, intent(inout) :: xx(nx,nx)  ! ᤿չ
  integer :: i, j, k
  real :: c(nx,nx)  ! ñ̹
  real :: d(nx,nx)  ! a(i,j) 򥬥롼Ϥ, ̤ѲΤǤ˰

  c=0.0

  do i=1,nx
     c(i,i)=1.0
  end do

  do i=1,nx

     do j=1,nx
        do k=1,nx
           d(k,j)=ax(k,j)  ! ߡѿ
        end do
     end do

     call gausss( nx, d, c(:,i), xx(:,i) )  !  2 ʬɽΤ, ν֤ OK.
  end do

end subroutine invert_mat

!-----------------------------------------

subroutine schumit_norm( u, v )
! ߥåȤľˡѤ, nx ٥ȥľ򲽤.
!  1 Ǥ٥ȥγʬ,  2 ʬ٥ȥ뷲 1 ٥ȥɽ.
! Ĥޤ, u(i,j)  j ܥ٥ȥ i ʬȤȤɽ.
! ɽʤ, ĥ٥ȥ򲣤¤٤.
  implicit none
  real, intent(in) :: u(:,:)  ! ľ򲽤Υ٥ȥ
  real, intent(inout) :: v(size(u,1),size(u,2))  ! ľ򲽸Υ٥ȥ
  integer :: i, j, k, nx, ny
  real :: tmp
  real :: tmpn(size(u,2))  ! ԤȤ, ΥͤǼ.
  real :: tmps(size(u,1))  ! ±黻κݤΰǼ˻.

  nx=size(u,1)
  ny=size(u,2)

  tmpn(1)=sqrt(vec_dot( u(:,1), u(:,1) ))
  do i=1,nx  ! 1 ܤΥ٥ȥδȤ.
     v(i,1)=u(i,1)/tmpn(1)
  end do

  do j=2,ny
     do i=1,nx
        tmps(i)=0.0
     end do
     do k=1,j-1
        do i=1,nx
           tmps(i)=tmps(i)+vec_dot( u(:,j), v(:,k) )*u(i,j)
        end do
     end do

     do i=1,nx
        v(i,j)=u(i,j)-tmps(i)
     end do
! ʲԤ
     tmpn(j)=sqrt(vec_dot( v(:,j), v(:,j) ))
     do i=1,nx
        v(i,j)=v(i,j)/tmpn(j)
     end do
  end do

end subroutine schumit_norm

!-----------------------------------------
! ʲ, private °դ롼
!-----------------------------------------

subroutine Pivot_part( nx, a, b )
! гʬ¸ߤ를ԥܥåƥ󥰤ˤä󥼥֤ͤ.
  implicit none
  integer, intent(in) :: nx  ! ǿ
  real, intent(inout) :: a(nx,nx)  ! ԥܥåƥ󥰤Ԥ ( 1 ǤԤб)
  real, intent(inout) :: b(nx)  ! ԥܥåƥ󥰤ȤȤ֤뱦ե٥ȥ
  real :: tmp(nx)  ! ؤΰ
  real :: tmpv  ! ؤȼ b(i) 򤵤ѿ
  integer :: i, j, k

  do i=1,nx
     if(a(i,i)==0.0)then
        do j=1,nx  !  do  j=1 ֤Ԥõ
! ʲȽ̼ϼ̤
! a(i,i)==0 ʤΤ, j ܤ i 󤬥ǤʤԤõ a(j,i)/=0.
!  j ܤؤ뤬, ؤȤ,  i ܤˤä j ؤȤ
! j ܤгʬ a(j,j) ˤʤʤ褦 a(i,j)/=0  j ꤹ.
           if(a(i,j)/=0.0.and.a(j,i)/=0.0.and.i/=j)then
              do k=1,nx  ! ºݤؤ
                 tmp(k)=a(i,k)
                 a(i,k)=a(j,k)
                 a(j,k)=tmp(k)
              end do
              tmpv=b(i)
              b(i)=b(j)
              b(j)=tmpv
              exit
           end if
        end do
     end if
  end do

end subroutine Pivot_part

!-----------------------------------------

real function errata(x1, x2, n)
  implicit none
  real, intent(in) :: x1  ! 
  real, intent(in) :: x2  ! 
  integer, intent(in) :: n  ! μ (n=1 : и, n=2 : и)

  if(n==1)then
     if(abs(x1)==0.0)then
        errata=(abs(x1-x2))/(abs(x2))
     else
        errata=(abs(x1-x2))/(abs(x1))
     end if
  else
     errata=abs(x1-x2)
  end if

  return
end function errata

!-----------------------------------------

real function vec_dot( u, v )
! ǤդμΥ٥ȥѤ׻
  implicit none
  real, intent(in) :: u(:)
  real, intent(in) :: v(size(u))
  integer :: i, j, nx
  real :: tmp

  nx=size(u)
  tmp=0.0

  do i=1,nx
     tmp=tmp+u(i)*v(i)
  end do

  vec_dot=tmp

  return
end function

end module
