program so
use Alge_Solv
integer, parameter :: nx=101, ny=101
real :: dx=0.01, dy=0.01
real :: x(nx), y(ny)
real :: rho(nx,ny)
real :: bound(nx,ny), psi(nx,ny)
integer :: tp

 namelist /input /tp
 read(5,input)

 x=(/(dx*(i-1),i=1,nx)/)
 y=(/(dy*(i-1),i=1,ny)/)
 rho=0.0
 do i=1,nx
 do j=1,ny
 if((((i-50)**2+(j-50)**2)*dx*dy)<0.05*0.05)then
 rho(i,j)=-1.0e4/8.85
 end if
 end do
 end do
 
  bound=0.0
  call Poisson_Jacobi(nx,ny,dx,dy,rho,1.0e-6,tp,psi,bound)
!  call Poisson_GauSei(nx,ny,dx,dy,rho,1.0e-6,tp,psi)

open(unit=11,file="tmp.dat",status='unknown')
  do j=1,ny
  do i=1,nx
     write(11,*) x(i), y(j), psi(i,j), rho(i,j)
  end do
  end do
close(unit=11,status='keep')

end program
