module ffts
! fft ϢΥ֥롼

contains

subroutine ffttp_1d( nx, a, b, csign, prim )
!  1d  fft  csign Ȥ, Ѵ, Ѵ롼
!  Temperton's FFT
  implicit none
  integer, intent(in) :: nx  ! ǿ
  complex, intent(in), dimension(0:nx-1) :: a  ! 
  complex, intent(inout), dimension(0:nx-1) :: b  ! 
  character(1), intent(in) :: csign  ! ѴȽ [r=Ѵ, i=Ѵ]
  character(1), optional, intent(in) :: prim  ! ǰʬ򤹤뤫ɤ
  ! [o=ʬ򤹤, x=ʬ򤷤ʤ] default=ʬ򤷤ʤ. ξ, ̾ DFT.
  ! ǰʬ򤹤, nx=2^a*3^b*5^c*7^d ޤǤʬ򤷤ʤ褦ˤ.
  integer, allocatable, dimension(:) :: l, m, n  ! κ
  real, parameter :: pi=3.14159265
  complex, parameter :: img=(0.0,1.0)
  complex :: fact, ctmp
  integer :: stat, counter, base
  integer :: i, j, k, id, jd, kd  ! do loop 
  integer, parameter, dimension(4) :: prim_dim=(/2, 3, 5, 7/)  ! ǰ
  integer, dimension(4) :: prim_num  ! ǰΤ٤
  complex, dimension(0:1,0:1) :: omega2
  complex, dimension(0:2,0:2) :: omega3
  complex, dimension(0:4,0:4) :: omega5
  complex, dimension(0:6,0:6) :: omega7
  complex, allocatable, dimension(:,:) :: omega
  complex, dimension(0:nx-1,0:nx-1) :: omegan
  complex, dimension(0:nx-1) :: c  ! tmp array

  base=nx
  prim_num=0
  counter=0

  do i=0,nx-1
     b(i)=a(i)
  end do

!-- ǰʬ򤹤
  if(present(prim))then
     if(prim=='o')then
        do i=1,4
           do while(mod(base,prim_dim(i))==0)
              base=base/prim_dim(i)
              prim_num(i)=prim_num(i)+1
              counter=counter+1
           end do
        end do

        if(base==1)then
           counter=counter-1
        end if

        if(counter/=0)then  ! prim=='o' ǤäƤ, ǰʬǤʤ DFT .
           allocate(l(counter+1))
           allocate(m(counter+1))
           allocate(n(counter+1))
           stat=0

           do i=1,4
              if(prim_num(i)/=0)then
                 select case(prim_dim(i))
                 case(2)
                    n(stat+1:stat+prim_num(i))=2
                    stat=stat+prim_num(i)

                 case(3)
                    n(stat+1:stat+prim_num(i))=3
                    stat=stat+prim_num(i)

                 case(5)
                    n(stat+1:stat+prim_num(i))=5
                    stat=stat+prim_num(i)

                 case(7)
                    n(stat+1:stat+prim_num(i))=7
                    stat=stat+prim_num(i)

                 end select
              end if
           end do
           if(base/=1)then
              n(counter+1)=base
           end if
        end if
     end if
  end if

!-- ž

  select case(csign)
  case('r')
     fact=cos(2.0*pi/real(nx))-img*sin(2.0*pi/real(nx))
     if(counter/=0)then
        omega2=1.0
        omega2(1,1)=-1.0
        do j=0,2
           do i=0,2
              omega3(i,j)=cos(2.0*pi*i*j/3.0)-img*sin(2.0*pi*i*j/3.0)
           end do
        end do
        do j=0,4
           do i=0,4
              omega5(i,j)=cos(2.0*pi*i*j/5.0)-img*sin(2.0*pi*i*j/5.0)
           end do
        end do
        do j=0,6
           do i=0,6
              omega7(i,j)=cos(2.0*pi*i*j/7.0)-img*sin(2.0*pi*i*j/7.0)
           end do
        end do

        if(base/=1)then
           allocate(omega(0:base-1,0:base-1))
           do j=0,base-1
              do i=0,base-1
                 omega(i,j)=cos(2.0*pi*i*j/real(base))-img*sin(2.0*pi*i*j/real(base))
              end do
           end do
        end if
     else
        allocate(omega(0:nx-1,0:nx-1))
        do j=0,nx-1
           do i=0,nx-1
              omega(i,j)=cos(2.0*pi*i*j/real(nx))-img*sin(2.0*pi*i*j/real(nx))
           end do
        end do
     end if

     do j=0,nx-1
        do i=0,nx-1
           omegan(i,j)=cos(2.0*pi*i*j/real(nx))-img*sin(2.0*pi*i*j/real(nx))
        end do
     end do


  case('i')
     if(counter/=0)then
        fact=exp(2.0*img*pi/real(nx))
        fact=cos(2.0*pi/real(nx))+img*sin(2.0*pi/real(nx))
        omega2=1.0
        omega2(1,1)=-1.0
        do j=0,2
           do i=0,2
              omega3(i,j)=cos(2.0*pi*i*j/3.0)+img*sin(2.0*pi*i*j/3.0)
           end do
        end do
        do j=0,4
           do i=0,4
              omega5(i,j)=cos(2.0*pi*i*j/5.0)+img*sin(2.0*pi*i*j/5.0)
           end do
        end do
        do j=0,6
           do i=0,6
              omega7(i,j)=cos(2.0*pi*i*j/7.0)+img*sin(2.0*pi*i*j/7.0)
           end do
        end do

        if(base/=1)then
           allocate(omega(0:base-1,0:base-1))
           do j=0,base-1
              do i=0,base-1
                 omega(i,j)=cos(2.0*pi*i*j/real(base))+img*sin(2.0*pi*i*j/real(base))
              end do
           end do
        end if
     end if

     do j=0,nx-1
        do i=0,nx-1
           omegan(i,j)=cos(2.0*pi*i*j/real(nx))+img*sin(2.0*pi*i*j/real(nx))
        end do
     end do

  case default
     write(*,*) "******** ERROR : csign is bad. **********"
     write(*,*) "Stop!"
     stop
  end select

!-- FFT 

  if(counter/=0)then
!-- 
     m(1)=1
     l(1)=nx/(n(1)*m(1))
     do i=2,counter+1
        m(i)=m(i-1)*n(i-1)
        l(i)=nx/(n(i)*m(i))
     end do

!-- Ѵ W 

     do kd=1,counter+1
        do jd=0,l(kd)-1
           do id=0,n(kd)-1
              do k=0,m(kd)-1
                 ctmp=b(jd*m(kd)+k)
                 do j=1,n(kd)-1
                    select case(n(kd))
                    case(2)
                       ctmp=ctmp+omega2(id,j)*b(j*l(kd)*m(kd)+jd*m(kd)+k)

                    case(3)
                       ctmp=ctmp+omega3(id,j)*b(j*l(kd)*m(kd)+jd*m(kd)+k)

                    case(5)
                       ctmp=ctmp+omega5(id,j)*b(j*l(kd)*m(kd)+jd*m(kd)+k)

                    case(7)
                       ctmp=ctmp+omega7(id,j)*b(j*l(kd)*m(kd)+jd*m(kd)+k)

                    case default
                       ctmp=ctmp+omega(id,j)*b(j*l(kd)*m(kd)+jd*m(kd)+k)

                    end select
                 end do
                 c(jd*n(kd)*m(kd)+id*m(kd)+k)=ctmp*omegan(m(kd),(id*jd))
              end do
           end do
        end do
        do id=0,nx-1
           b(id)=c(id)
        end do
     end do

  else

     do j=0,nx-1
        b(j)=a(0)
        do i=1,nx-1
           b(j)=b(j)+a(i)*omegan(i,j)
        end do
     end do

  end if

  do j=0,nx-1
     b(j)=2.0*b(j)/real(nx)
  end do

end subroutine

!-----------------------------------------------

subroutine ffttp_2d( nx, ny, a, b, csign, prim )
!  2d  fft  csign Ȥ, Ѵ, Ѵ롼
!  Temperton's FFT
  implicit none
  integer, intent(in) :: nx  ! ǿ 1
  integer, intent(in) :: ny  ! ǿ 2
  complex, intent(in), dimension(0:nx-1,0:ny-1) :: a  ! 
  complex, intent(inout), dimension(0:nx-1,0:ny-1) :: b  ! 
  character(1), intent(in) :: csign  ! ѴȽ [r=Ѵ, i=Ѵ]
  character(1), optional, intent(in) :: prim  ! ǰʬ򤹤뤫ɤ
  ! [o=ʬ򤹤, x=ʬ򤷤ʤ] default=ʬ򤷤ʤ. ξ, ̾ DFT.
  ! ǰʬ򤹤, nx=2^a*3^b*5^c*7^d ޤǤʬ򤷤ʤ褦ˤ.
  integer :: i

  do i=0,ny-1
     call ffttp_1d( nx, a(0:nx-1,i), b(0:nx-1,i), csign, prim )
  end do

end subroutine

!-----------------------------------------------

end module
