module Poly_Function  ! ľ¿༰׻륵֥롼

contains
subroutine CHEBYSHEV(n, nmax, x, che)
!****************************************
!*** ӥΥ֥롼 ***
!****************************************
  implicit none
  integer, intent(in) :: n  ! ׻ӥդκǹ⼡
  integer, intent(in) :: nmax  !  x ǿ
  real, intent(in) :: x(nmax)  ! ӥ¿༰ΰ
  real, intent(inout) :: che(0:n,nmax)  ! ׻ӥ¿༰
  integer :: i, j, k

!--  ---
  do i=1,nmax
     che(0,i)=1.0
  end do

  if(n > 0)then

     do i=1,nmax
        che(1,i)=x(i)
     end do

     if(n > 1)then
!-- η׻ ---
        do j=1,n-1
           do i=1,nmax
              che(j+1,i)=2.0*che(1,i)*che(j,i)-che(j-1,i)
           end do
        end do
     end if
  end if

end  subroutine

subroutine CHEBYSHEV_D(n, nmax, x, che)
!****************************************
!*** ӥΥ֥롼 ***
!****************************************
  implicit none
  integer, intent(in) :: n  ! ׻ӥդκǹ⼡
  integer, intent(in) :: nmax  !  x ǿ
  double precision, intent(in) :: x(nmax)  ! ӥ¿༰ΰ
  double precision, intent(inout) :: che(0:n,nmax)
  integer :: i, j, k

!--  ---
  do i=1,nmax
     che(0,i)=1.0d0
  end do

  if(n > 0)then

     do i=1,nmax
        che(1,i)=x(i)
     end do

     if(n > 1)then
!-- η׻ ---
        do j=1,n-1
           do i=1,nmax
              che(j+1,i)=2.0d0*che(1,i)*che(j,i)-che(j-1,i)
           end do
        end do
     end if
  end if

end subroutine


subroutine GEGENBAUER(n, nmax, x, p, lambda)
!************************************
!*  Х ¿༰׻֥롼  *
!************************************
!* Ȥ
!* n=(0ǽ)
!************************************
  implicit none
  integer, intent(in) :: n  ! ׻륲Х¿༰κǹ⼡
  integer, intent(in) :: nmax  !  x ǿ
  real, intent(in) :: x(nmax)  ! 
  real, intent(in) :: lambda  ! Х
  real, intent(inout) :: p(0:n,nmax)  ! ׻륲Х¿༰
  integer :: i, j, k

!--  ---
  do i=1,nmax
     p(0,i)=1.0
  end do

  if(n > 0)then

     do i=1,nmax
        p(1,i)=2.0*lambda*x(i)
     end do

     if(n > 1)then
!-- η׻ ---
        do j=1,n-1
           do i=1,nmax
              p(j+1,i)=(1.0/real(j+1))*(2.0*(lambda+real(j))*x(i)*p(j,i)  &
     &               -(2.0*lambda+real(j-1))*p(j-1,i))
           end do
        end do
     end if
  end if

end subroutine

subroutine GEGENBAUER_D(n, nmax, x, p, lambda)
!************************************
!*  Х ¿༰׻֥롼  *
!************************************
!* Ȥ
!* n=(0ǽ)
!************************************
  implicit none
  integer, intent(in) :: n  ! ׻륲Х¿༰κǹ⼡
  integer, intent(in) :: nmax  !  x ǿ
  double precision, intent(in) :: x(nmax)  ! 
  double precision, intent(in) :: lambda  ! Х
  double precision, intent(inout) :: p(0:n,nmax)  ! ׻륲Х¿༰
  integer :: i, j, k

!--  ---
  do i=1,nmax
     p(0,i)=1.0d0
  end do

  if(n > 0)then

     do i=1,nmax
        p(1,i)=2.0d0*lambda*x(i)
     end do

     if(n > 1)then
!-- η׻ ---
        do j=1,n-1
           do i=1,nmax
              p(j+1,i)=(1.0d0/dble(j+1))*(2.0d0*(lambda+dble(j))*x(i)*p(j,i)  &
     &               -(2.0d0*lambda+dble(j-1))*p(j-1,i))
           end do
        end do
     end if
  end if

end subroutine


subroutine HERMITE(n, nmax, x, p)
!************************************
!*  Hermite ¿༰׻֥롼  *
!************************************
!* Ȥ
!* n=(0ǽ)
!************************************
  implicit none
  integer, intent(in) :: n  ! ׻ Hermite ¿༰κǹ⼡
  integer, intent(in) :: nmax  !  x ǿ
  real, intent(in) :: x(nmax)  ! 
  real, intent(inout) :: p(0:n,nmax)  ! ׻ Hermite ¿༰
  integer :: i, j, k

!--  ---
  do i=1,nmax
     p(0,i)=1.0
  end do

  if(n > 0)then

     do i=1,nmax
        p(1,i)=2.0*x(i)
     end do

     if(n > 1)then
!-- η׻ ---
        do j=1,n-1
           do i=1,nmax
              p(j+1,i)=2.0*(x(i)*p(j,i)-real(j)*p(j-1,i))
           end do
        end do
     end if
  end if

end subroutine


subroutine HERMITE_D(n, nmax, x, p)
!************************************
!*  Hermite ¿༰׻֥롼  *
!************************************
!* Ȥ
!* n=(0ǽ)
!************************************
  implicit none
  integer, intent(in) :: n  ! ׻ Hermit ¿༰κǹ⼡
  integer, intent(in) :: nmax  !  x ǿ
  double precision, intent(in) :: x(nmax)  ! 
  double precision, intent(inout) :: p(0:n,nmax)  ! ׻ Hermit ¿༰
  integer :: i, j, k

!--  ---
  do i=1,nmax
     p(0,i)=1.0d0
  end do

  if(n > 0)then

     do i=1,nmax
        p(1,i)=2.0d0*x(i)
     end do

     if(n > 1)then
!-- η׻ ---
        do j=1,n-1
           do i=1,nmax
              p(j+1,i)=2.0d0*(x(i)*p(j,i)-dble(j)*p(j-1,i))
           end do
        end do
     end if
  end if

end subroutine


subroutine JACOBI_POLY(n, nmax, x, p, alpha, beta)
!***********************************
!  Jacobi ¿༰׻֥롼   *
!***********************************
! Ȥ
! n=(0ǽ)
! nmax=ֳʻ
! p=p(0:n,nmax) 2
!***********************************
  implicit none
  integer, intent(in) :: n  ! ׻ jacobi ¿༰κǹ⼡
  integer, intent(in) :: nmax  !  x ǿ
  real, intent(in) :: x(nmax)  ! 
  real, intent(inout) :: p(0:n,nmax)  ! ׻ Jacobi ¿༰
  real, intent(in) :: alpha  ! 
  real, intent(in) :: beta  ! 
  real :: gamma, omega
  integer :: i, j, k

!--  ---
  gamma=alpha+beta
  omega=alpha-beta

!--  ---
  do i=1,nmax
     p(0,i)=1.0
  end do

  if(n > 0)then

     do i=1,nmax
        p(1,i)=0.5*((gamma+2.0)*x(i)+omega)
     end do

     if(n > 1)then
!-- η׻ ---
        do j=1,n-1
           do i=1,nmax
              p(j+1,i)=(0.5/(real(j+1)*real(j+1+gamma)*real(2.0*j+gamma)))  &
     &                 *((2.0*j+gamma+1.0)  &
     &                 *(gamma*omega+(2.0*j+gamma)*(2.0*(j+1)+gamma)*x(i))  &
     &                 *p(j,i)  &
     &                 -2.0*(j+alpha)*(j+beta)*(2.0*(j+1)+gamma)*p(j-1,i))
           end do
        end do
     end if
  end if

end subroutine



subroutine JACOBI_POLY_D(n, nmax, x, p, alpha, beta)
!***********************************
!  Jacobi ¿༰׻֥롼   *
!***********************************
! Ȥ
! n=(0ǽ)
! nmax=ֳʻ
! p=p(0:n,nmax) 2
!***********************************
  implicit none
  integer, intent(in) :: n  ! ׻ jacobi ¿༰κǹ⼡
  integer, intent(in) :: nmax  !  x ǿ
  double precision, intent(in) :: x(nmax)  ! 
  double precision, intent(inout) :: p(0:n,nmax)  ! ׻ Jacobi ¿༰
  double precision, intent(in) :: alpha  ! 
  double precision, intent(in) :: beta  ! 
  double precision :: gamma, omega
  integer :: i, j, k

!--  ---
  gamma=alpha+beta
  omega=alpha-beta

!--  ---
  do i=1,nmax
     p(0,i)=1.0d0
  end do

  if(n > 0)then

     do i=1,nmax
        p(1,i)=0.5d0*((gamma+2.0d0)*x(i)+omega)
     end do

     if(n > 1)then
!-- η׻ ---
        do j=1,n-1
           do i=1,nmax
              p(j+1,i)=(0.5d0/(dble(j+1)*dble(j+1+gamma)*dble(2.0*j+gamma)))  &
     &                 *((2.0d0*dble(j)+gamma+1.0d0)  &
     &                 *(gamma*omega+(2.0d0*dble(j)+gamma)  &
     &                 *(2.0d0*dble(j+1)+gamma)*x(i))*p(j,i)  &
     &                 -2.0d0*dble(j+alpha)*dble(j+beta)  &
     &                 *(2.0d0*dble(j+1)+gamma)*p(j-1,i))
           end do
        end do
     end if
  end if

end subroutine


subroutine LAGUERRE(n, nmax, x, p)
!***********************************
!  Laguerre ¿༰׻֥롼 *
!***********************************
! Ȥ
! n=(0ǽ)
! nmax=ֳʻ
! p=p(0:n,nmax) 2
!***********************************
  implicit none
  integer, intent(in) :: n  ! ׻ jacobi ¿༰κǹ⼡
  integer, intent(in) :: nmax  !  x ǿ
  real, intent(in) :: x(nmax)  ! 
  real, intent(inout) :: p(0:n,nmax)  ! ׻ Jacobi ¿༰
  integer :: i, j, k

!--  ---
  do i=1,nmax
     p(0,i)=1.0
  end do

  if(n > 0)then

     do i=1,nmax
        p(1,i)=1.0-x(i)
     end do

     if(n > 1)then
!-- η׻ ---
        do j=1,n-1
           do i=1,nmax
              p(j+1,i)=(2.0*real(j)+1.0-x(i))*p(j,i)  &
     &                 -((real(j))**2)*p(j-1,i)
           end do
        end do
     end if
  end if

end subroutine


subroutine LAGUERRE_D(n, nmax, x, p)
!***********************************
!  Laguerre ¿༰׻֥롼 *
!***********************************
! Ȥ
! n=(0ǽ)
! nmax=ֳʻ
! p=p(0:n,nmax) 2
!***********************************
  implicit none
  integer, intent(in) :: n  ! ׻ jacobi ¿༰κǹ⼡
  integer, intent(in) :: nmax  !  x ǿ
  double precision, intent(in) :: x(nmax)  ! 
  double precision, intent(inout) :: p(0:n,nmax)  ! ׻ Jacobi ¿༰
  integer :: i, j, k

!--  ---
  do i=1,nmax
     p(0,i)=1.0d0
  end do

  if(n > 0)then

     do i=1,nmax
        p(1,i)=1.0d0-x(i)
     end do

     if(n > 1)then
!-- η׻ ---
        do j=1,n-1
           do i=1,nmax
              p(j+1,i)=(2.0d0*dble(j)+1.0d0-x(i))*p(j,i)  &
     &                 -((dble(j))**2)*p(j-1,i)
           end do
        end do
     end if
  end if

end subroutine


subroutine LEGENDRE(n, nmax, x, p)
!***********************************
!  Legendre ¿༰׻֥롼 *
!***********************************
! Ȥ
! n=(0ǽ)
! nmax=ֳʻ
! p=p(0:n,nmax) 2
!***********************************
  implicit none
  integer, intent(in) :: n  ! ׻ jacobi ¿༰κǹ⼡
  integer, intent(in) :: nmax  !  x ǿ
  real, intent(in) :: x(nmax)  ! 
  real, intent(inout) :: p(0:n,nmax)  ! ׻ Jacobi ¿༰
  integer :: i, j, k

!--  ---
  do i=1,nmax
     p(0,i)=1.0
  end do

  if(n > 0)then

     do i=1,nmax
        p(1,i)=x(i)
     end do

     if(n > 1)then
!-- η׻ ---
        do j=1,n-1
           do i=1,nmax
              p(j+1,i)=(1.0/real(j+1))*(p(j,i)*(2.0*real(j)+1.0)  &
     &                 *(p(1,i))-real(j)*p(j-1,i))
           end do
        end do
     end if
  end if

end subroutine


subroutine LEGENDRE_D(n, nmax, x, p)
!***********************************
!  Legendre ¿༰׻֥롼 *
!***********************************
! Ȥ
! n=(0ǽ)
! nmax=ֳʻ
! p=p(0:n,nmax) 2
!***********************************
  implicit none
  integer, intent(in) :: n  ! ׻ jacobi ¿༰κǹ⼡
  integer, intent(in) :: nmax  !  x ǿ
  double precision, intent(in) :: x(nmax)  ! 
  double precision, intent(inout) :: p(0:n,nmax)  ! ׻ Jacobi ¿༰
  integer :: i, j, k

!--  ---
  do i=1,nmax
     p(0,i)=1.0d0
  end do

  if(n > 0)then

     do i=1,nmax
        p(1,i)=x(i)
     end do

     if(n > 1)then
!-- η׻ ---
        do j=1,n-1
           do i=1,nmax
              p(j+1,i)=(1.0d0/dble(j+1))*(p(j,i)*(2.0d0*dble(j)+1.0d0)  &
     &                 *(p(1,i))-dble(j)*p(j-1,i))
           end do
        end do
     end if
  end if

end subroutine


subroutine SONINE(n, nmax, x, p, lambda)
!***********************************
!  Sonine ¿༰׻֥롼  *
!***********************************
! Ȥ
! n=(0ǽ)
! nmax=ֳʻ
! p=p(0:n,nmax) 2
!***********************************
  implicit none
  integer, intent(in) :: n  ! ׻ jacobi ¿༰κǹ⼡
  integer, intent(in) :: nmax  !  x ǿ
  real, intent(in) :: x(nmax)  ! 
  real, intent(inout) :: p(0:n,nmax)  ! ׻ Jacobi ¿༰
  real, intent(in) :: lambda  ! 
  integer :: i, j, k

!--  ---
  do i=1,nmax
     p(0,i)=1.0
  end do

  if(n > 0)then

     do i=1,nmax
         p(1,i)=lambda+1.0-x(i)
     end do

     if(n > 1)then
!-- η׻ ---
        do j=1,n-1
           do i=1,nmax
              p(j+1,i)=(1.0/real(j+1))  &
     &                 *((lambda+2.0*j+1.0-x(i))*p(j,i)  &
     &                 -(j+lambda)*p(j-1,i))
           end do
        end do
     end if
  end if

end subroutine


subroutine SONINE_D(n, nmax, x, p, lambda)
!***********************************
!  Sonine ¿༰׻֥롼  *
!***********************************
! Ȥ
! n=(0ǽ)
! nmax=ֳʻ
! p=p(0:n,nmax) 2
!***********************************
  implicit none
  integer, intent(in) :: n  ! ׻ jacobi ¿༰κǹ⼡
  integer, intent(in) :: nmax  !  x ǿ
  double precision, intent(in) :: x(nmax)  ! 
  double precision, intent(inout) :: p(0:n,nmax)  ! ׻ Jacobi ¿༰
  double precision, intent(in) :: lambda  ! 
  integer :: i, j, k

!--  ---
  do i=1,nmax
     p(0,i)=1.0d0
  end do

  if(n > 0)then

     do i=1,nmax
         p(1,i)=lambda+1.0d0-x(i)
     end do

     if(n > 1)then
!-- η׻ ---
        do j=1,n-1
           do i=1,nmax
              p(j+1,i)=(1.0d0/dble(j+1))  &
     &                 *((lambda+2.0d0*dble(j)+1.0d0-x(i))*p(j,i)  &
     &                 -(dble(j)+lambda)*p(j-1,i))
           end do
        end do
     end if
  end if

end subroutine


end module
