require "numru/vizshot"

module NumRu
  class VizShot

    alias :_plot :plot
    def plot(arg)
      unless Hash===arg
        raise "argument must be Hash"
      end
      arg = variable_to_file_and_var(arg.dup)
      _plot(arg)
    end

    def get_variables
      @variables.flatten
    end

    alias :_to_yaml :to_yaml
    def to_yaml
      viz = self.semi_deep_clone
      viz.prescript_to_yaml
      viz._to_yaml
    end

=begin
    def file_and_var_to_variable
      @variables = Array.new

      for i in 0...@plots.length
        var = @variables[i] = Array.new
        
        if path = @plots[i][:__gfdnavipath] 
          var[0] = Variable.find_by_path(path)
        end
        if path = @plots[i][:__gfdnavipath2]
          var[1] = Variable.find_by_path(path)
        end
      end
      nil
    end
=end

# delete cache before save image.
    def reopen_variables
      @variables[0].collect! do |var|
        Variable.find_by_path(var.attributes["path"])
      end
    end
    
# find Variable object, not Unknown object.
    def find_variables
      @variables ||= Array.new
      @plots.each_with_index{|plot,i|
        variable_to_file_and_var(plot,i)
      }
    end


#    alias __get_gphyses get_gphyses
#    def get_gphyses(arg)
#      arg.delete(:__gfdnavipath)
#      arg.delete(:__gfdnavipath2)
#      __get_gphyses(arg)
#    end

    def get_plots
      @plots.collect{|pl| pl.dup}
    end

    def get_size
      [ @set[:admin][:iwidth], @set[:admin][:iheight] ]
    end

    def get_itr
      @set[:fig]['itr']
    end

    def get_viewport
      @set[:fig]['viewport'].join(',')
    end

    protected
    alias :_semi_deep_clone :semi_deep_clone
    def semi_deep_clone
      viz = _semi_deep_clone
      viz.variables = @variables
      return viz
    end

    def variables=(v)
      @variables = v
    end

    def prescript_to_yaml
      @plots.each_with_index{|pl,i|
        pl.delete(:file)
        pl.delete(:var)
        pl.delete(:file2)
        pl.delete(:var2)
        if (var = @variables[i])
          pl[:variable] = var[0].path if var[0]
          pl[:variable2] = var[1].path if var[1]
        end
      }
      remove_instance_variable :@variables
    end

    private
    def variable_to_file_and_var(arg, np=nil)
      @variables ||= Array.new
      np ||= @plots.length
      @variables[np] ||= Array.new
      if (var = arg.delete(:variable))
        var = Variable.find(:first,:conditions=>["path=?",var]) unless Variable === var
        @variables[np].push var
        arg[:file] = var.fname
        arg[:var] = var.vname
      end
      if (var = arg.delete(:variable2))
        var = Variable.find(:first,:conditions=>["path=?",var]) unless Variable === var
        @variables[np].push var
        arg[:file2] = var.fname
        arg[:var2] = var.vname
      end
      return arg
    end

  end
end



DrawMethod.find(:all, :user=>:all).each{|dm|
  if dm.name && dm.script && dm.script!="NULL"
    hash = {
      :name => dm.name,
      :ndims => dm.ndims,
      :nvars => dm.nvars,
      :script => dm.script
    }
    hash[:ggraph] = dm.ggraph if dm.ggraph && dm.ggraph!="NULL"
    NumRu::VizShot.add_extensions(hash)
  end
}
