desc "Clean all"
task :clean do
  Rake::Task["clean:diagram_cache"].invoke rescue got_error = true
  Rake::Task["clean:session_files"].invoke rescue got_error = true
  Rake::Task["clean:diagram_dirs"].invoke rescue got_error = true
  Rake::Task["clean:work_dirs"].invoke rescue got_error = true

  raise "Clean failures" if got_error
end

namespace :clean do

  desc "Clean diagram cache"
  task :diagram_cache => :environment do
    path = GFDNAVI_DIAGRAM_CACHE_PATH + "/"
    Dir.foreach(path){|fname|
      fname = path + fname
      File.delete(fname) unless File.directory?(fname)
    }
    DiagramCacheSession.destroy_all unless DiagramCacheSession.count == 0
    DiagramCacheDatum.destroy_all unless DiagramCacheDatum.count == 0
    DiagramCache.destroy_all unless DiagramCache.count == 0
  end

  desc "Clean session files"
  task :session_files do
    session_dir = "#{RAILS_ROOT}/tmp/sessions"
    Dir.foreach(session_dir){|fname|
      if fname =~ /^ruby_sess\./
        File.delete("#{session_dir}/#{fname}")
      end
    }
  end

  except_dirs = %w(. .. CVS)

  desc "Clean temporary diagram directories"
  task :diagram_dirs => :environment do
    path = GFDNAVI_DIAGRAM_PATH + "/"
    Dir.foreach(path){|dname|
      next if except_dirs.include?(dname)
      dname = path + dname + "/"
      next unless File.directory?(dname)
      Dir.foreach(dname){|fname|
        File.delete(dname + fname) unless except_dirs.include?(fname)
      }
      Dir.delete(dname)
    }
  end

  desc "Clean work directories"
  task :work_dirs => :environment do
    path = GFDNAVI_WORK_PATH + "/"
    Dir.foreach(path){|dname|
      next if except_dirs.include?(dname)
      dname = path + dname + "/"
      next unless File.directory?(dname)
      Dir.foreach(dname){|fname|
        begin
          File.delete(dname + fname) unless except_dirs.include?(fname)
        rescue
          # Suppose that fname is a directory
          Dir.foreach(dname + fname){|subfname|
             File.delete(dname + fname +'/' + subfname) \
                                 unless except_dirs.include?(subfname)
          }
          Dir.delete(dname + fname)
        end
      }
      Dir.delete(dname)
    }
  end

end
