require "activerecord_gfdnavi"

class ExplorerResult
 attr_accessor :id, :keynames, :qsetid, :resulttree
  def initialize(id)
    @id=id
    @keynames = Array.new
    @resulttree=PathNode.new
    @resulttree.path="/"    
    
    if @id>0 then
      qh=QueryHistory.find(@id)
      if qh then
        @qsetid=qh.queryset_id
      else
        @qsetid=0
      end
    else
      @qsetid=0
    end
  end
  def reset_resulttree
    @resulttree=PathNode.new
    @resulttree.path="/"
  end 
  
  def resultlist(p)
    reset_resulttree   
    dir=Node.find_by_sql(["select n.* from nodes n join gfdnavi_querycache.queryset_? q on n.node_type=0 and n.id = q.vid",qsetid])
    res=Node.find_by_sql(["select n.* from nodes n join gfdnavi_querycache.queryset_? q on n.node_type=1 and n.id = q.vid",qsetid])
    res.each{ |r|
      flg=0
      dir.each{ |d|
        if r.path=~/#{d.path}/ then
            flg=1
            break
        end
      }
      if flg==0 then
        @resulttree.addpath(r)
      end
    }
    return res
  end
 
  def count
    if @qsetid==0 then
#     return Node.find(:all).length
      return Node.find_by_sql("select count(*) as cnt from nodes")[0].cnt
    else
     return Node.find_by_sql(["select count(*) as cnt from gfdnavi_querycache.queryset_?",@qsetid])[0].cnt
    end
  end
  
  def all_covered(slat,slon,elat,elon)
    if @qsetid==0 then 
      tablename="nodes"
      vid="c.id"
    else
      tablename="gfdnavi_querycache.queryset_#{@qsetid}"
      vid="c.vid"
    end
    qstr=<<-EOM
      select latitude_lb,longitude_lb, latitude_rt, longitude_rt, count(*) as cnt
      from #{tablename} c, spatial_and_time_attributes s
      where #{vid} = s.node_id
        and latitude_lb<#{slat} and latitude_rt>#{elat}
        and longitude_lb<#{slon} and longitude_rt>#{elon}
        group by latitude_lb,longitude_lb, latitude_rt, longitude_rt
    EOM
    return Node.find_by_sql(qstr)
  end

  def partial_covered(slat,slon,elat,elon)
    if @qsetid==0 then 
      tablename="nodes"
      vid="c.id"
    else
      tablename="gfdnavi_querycache.queryset_#{@qsetid}"
      vid="c.vid"
    end
    qstr=<<-EOM
      select latitude_lb,longitude_lb, latitude_rt, longitude_rt,count(*) as cnt
      from #{tablename} c, spatial_and_time_attributes s
      where #{vid} = s.node_id
        and not (latitude_lb<#{slat} and latitude_rt>#{elat}
             and longitude_lb<#{slon} and longitude_rt>#{elon})
        and latitude_lb<>latitude_rt
        and longitude_lb<>longitude_rt
        group by latitude_lb,longitude_lb, latitude_rt, longitude_rt
    EOM
    return Node.find_by_sql(qstr)
  end

  def points(slat,slon,elat,elon)
    if @qsetid==0 then 
      tablename="nodes"
      vid="c.id"
    else
      tablename="gfdnavi_querycache.queryset_#{@qsetid}"
      vid="c.vid"
    end
    qstr=<<-EOM
      select latitude_lb,longitude_lb,count(*) as cnt
      from #{tablename} c, spatial_and_time_attributes s
      where #{vid} = s.node_id
        and latitude_lb=latitude_rt
        and longitude_lb=longitude_rt
      group by latitude_lb,longitude_lb
    EOM
    return Node.find_by_sql(qstr)
  end

  def get_keyname_list
    if @qsetid!=0 then
      qstr=<<-EOF
        select k.name as kname,count(*) as cnt
        from keyword_attributes k join gfdnavi_querycache.queryset_#{@qsetid} q
          on k.node_id = q.vid
        where not (k.name in ('_FillValue','missing_value'))
        group by k.name
        order by cnt DESC
      EOF
    else
      qstr=<<-EOF
        select k.name as kname,count(*) as cnt
        from keyword_attributes k join nodes q
          on k.node_id = q.id
        where not (k.name in ('_FillValue','missing_value'))
        group by k.name
        order by cnt DESC
      EOF
   end
   keylist=KeywordAttribute.find_by_sql(qstr)
   return keylist
  end
  
 def get_path
  if @qsetid!=0 then
    res=QueryHistory.find(:all,:conditions=>["queryset_id=? and querytype='path'",@qsetid])
    if res.size>0 then
      res[0].description=~/[P](.*)/
      return $1
    end
  end
  return "/"
 end
 
 def get_path_list
  if @qsetid!=0 then
    QueryHistory.find(:all,:conditions=>["queryset_id=? and querytype='path'",@qsetid])  
    tables="(select v.* from nodes v, gfdnavi_querycache.queryset_#{@qsetid} c where v.id=c.vid)"
    path=get_path
  else
    tables="nodes"
    path="/"
  end
      sql1=<<-EOM
       select d2.path as dpath, count(v.id) as cnt
       from nodes d1,nodes d2,#{tables} v
       where d1.path = ?
         and d2.parent_id = d1.id
         and v.path like #{concat("d2.path","'%'")}
       group by d2.path
       order by cnt DESC
     EOM
     pathlist = Node.find_by_sql([sql1,path])
   return pathlist
 end
 
 def get_keyvalue_list(keyname)
   if @qsetid!=0 then
    valuelist=KeywordAttribute.find(:all,:joins=>"JOIN gfdnavi_querycache.queryset_#{@qsetid} ON node_id=gfdnavi_querycache.queryset_#{@qsetid}.vid",:select=>"value,num_value,count(*) as cnt",:conditions=>["keyword_attributes.name=?",keyname],:group=>"value")
   else
    valuelist=KeywordAttribute.find(:all,:joins=>"JOIN nodes ON node_id=nodes.id",:select=>"value,num_value,count(*) as cnt",:conditions=>["keyword_attributes.name=?",keyname],:group=>"value")   
   end
   return valuelist   
 end
 
=begin
 def get_result_path_tree
   if id!= 0 then
     reslist=Node.find(:all,:select=>"path, count(*) as cnt",:joins=>"JOIN gfdnavi_querycache.cache_#{@id} ON gfdnavi_querycache.cache_#{@id}.vid=id", :group=>"path", :order=>"path")
   else
     reslist=Node.find(:all,:select=>"path, count(*) as cnt",:group=>"path",:order=>"path")
  end
  
  rid=0
  resultpath=PathNode.new
  reslist.each{ |res|
    if resultpath.path=="" then
      resultpath.path=res.path
      resultpath.id=rid
      resultpath.cnt=1
      rid=rid+1
    else
      patharray_res=res.path.split(/\//)
      patharray_node=resultpath.path.split(/\//)
      i=0
      while patharray_res[i]==patharray_node[i] do
        i=i+1
      end
      if patharray_
    end
  }    
  
 end
=end
end
