# Methods added to this helper will be available to all templates in the application.
module ApplicationHelper

  @@locale = 'en'  # or 'ja' etc etc
  def self.locale= (locale)
    @@locale = locale
  end

  def help_popup(html_file_partial)
    if base_path
      dir = File.join(base_path, controller.controller_name)
    else
      dir = File.join(view_paths[0], controller.controller_name)
    end
    prefix = dir + '/__help_' + html_file_partial
    if File.exists?( path = prefix+'.'+@@locale+'.html' ) ||
	File.exists?( path = prefix+'.html' ) || 
	File.exists?( path = prefix+'.en.html' )
      help_text = File.read( path )
    else
      help_text = '[BUG] Sorry, no help text was found for '+html_file_partial
    end

    html =<<-EOS
      <label id='#{'help_'+html_file_partial}' style="cursor:pointer">
      #{image_tag('helpmark16.png', :title=>'Help')}
      </label>
      <script>
        new PopupMenu('#{'help_'+html_file_partial}', 
                      '#{escape_javascript(help_text)}',
                      'Help' );
      </script>
    EOS
    html
  end

  def host_information_table
    request = controller.request
    html =<<-"EOS"
      <table>
        <tr><td>Host</td><td>#{request.host_with_port}</td></tr>
        <tr><td>Gfdnavi Root</td><td>/#{request.relative_url_root}</td></tr>
        <tr><td>Path</td><td>#{request.path}</td></tr>
        <tr><td>Env</td><td>#{RAILS_ENV}</td></tr>
        <tr><td>Server Software</td><td>#{request.server_software}</td></tr>
      </table>
    EOS
    return html
  end

end
