class ImageController < ApplicationController

  def show
    path = params[:path]
    raise 'you need to give me a path as a parameter' unless path
    img = Node.find(:first, :conditions => [ "path = ?",path ],
                    :user=> session[:user] ).entity
    raise("#{path} is not available") if img.nil?
    response.headers['Content-Type'] = _content_type(params[:path])
    internal_path = img.fname
    file = File.open(internal_path,"rb")
    imgbin = file.read
    file.close
    render(:text => imgbin )
  end

  def _content_type(filename)
    case filename
    when /\.png$/i
      'image/png'
    when /\.jpeg$|\.jpg$/i
      'image/jpeg'
    when /\.gif$/i
      'image/gif'
    when /\.tiff?$/i
      'image/tiff'
    when /\.xwd?$/i
      'image/xwindowdump'
    else
      raise "#{params[:path]} Not a image file or unsupported image type (which can be easily extended. Contact the gfdnavi developpers.)"
    end
  end

end
