class DrawMethodController < ApplicationController
  layout "gfdnavi"

  before_filter :login_required

  def index
    redirect_to :action => "list"
  end

  def create
    user = session[:user]
    @directory = "/usr/#{user.login}/draw_methods"
    case request.method
    when :post
      @draw_method = DrawMethod.new
      @draw_method.attributes = params[:draw_method]
      @draw_method.owner = user
      @draw_method.path = "#{@directory}/#{@draw_method.name}"
      attribute_num = params[:attribute_num].to_i
      attribute_num.times{|i|
        param = params[:attribute][i.to_s]
        value_type = param.delete(:value_type)
        dma = @draw_method.draw_method_attributes.create(param)
        dma.value_type = ValueType.find(:first,:conditions=>["name=?",value_type])
      }
      Node.make_user_directory(@directory, user, 0)
      groups = params[:groups]
      groups.shift if groups[0] == 'only me'
      @draw_method.other_mode = 0
      @draw_method.set_rgroups(groups) if groups.length > 0
      if check_erb(@draw_method) && check_srcipt(@draw_method)
        if @draw_method.save
          flash[:notice] = "create successful"
          redirect_back_or_default :action => "list"
        else
          flash[:notice] = "create unsuccessful"
        end
      end
    when :get
      @draw_method = DrawMethod.new
    end
    @groups = user.own_groups + user.belonging_groups
    @user = user
  end

  def edit
    user = session[:user]
    @draw_method = DrawMethod.find(:first, :conditions=>["name=?",params[:id]], :user=>user)
    unless @draw_method && @draw_method.owner==user
      redirect_back_or_default :action => "list"
      return
    end
    @directory = "/usr/#{user.login}/draw_methods"
    case request.method
    when :post
      @draw_method.attributes = params[:draw_method]
      attribute_num = params[:attribute_num].to_i
      dmas = @draw_method.draw_method_attributes
      attribute_num.times{|i|
        param = params[:attribute][i.to_s]
        value_type = param.delete(:value_type)
        if dmas[i]
          dma = dmas[i]
          dma.attributes = param
        else
          dma = dmas.create(param)
        end
        dma.value_type = ValueType.find(:first,:conditions=>["name=?",value_type])
        dma.update
      }
      for i in attribute_num...dmas.length
        dmas[i].destroy
      end
      groups = params[:groups]
      groups.shift if groups[0] == 'only me'
      @draw_method.other_mode = 0
      @draw_method.set_rgroups(groups) if groups.length > 0
      if check_erb(@draw_method) && check_srcipt(@draw_method)
        if @draw_method.update
          flash[:notice] = "edit successful"
          redirect_back_or_default :action => "list"
        else
          flash[:notice] = "edit unsuccessful"
        end
      end
    end
    @groups = user.own_groups + user.belonging_groups
    @user = user
  end

  def list
    user = session[:user]
    dms = DrawMethod.find(:all, :user => user)
    @own_dms = Array.new
    @other_dms = Array.new
    dms.each{|dm|
      if dm.owner == user
        @own_dms.push dm
      else
        @other_dms.push dm
      end
    }
    @super_user = user.super_user
 end

  def details
    name = params[:id]
    user = session[:user]
    dm = DrawMethod.find(:first, :conditions=>["name=?",name], :user=>user)
    if dm
      @draw_method = dm
      @user = user
    else
      redirect_back_or_default :action => "list"
      return
    end
  end

  def create_setting_html
    unless request.xhr?
      render :nothing => true
      return
    end
    name = params[:name]
    nattr = params[:nattr].to_i
    attrs = params[:attribute]
    html = ""
    if nattr > 0
      html += "<table>\n"
      nattr.times{|n|
        html += "  <tr>\n"
        attr = attrs[n.to_s]
        html +=<<-"EOS"
    <td>#{attr["name"]}</td>
    <td>(#{attr["value_type"]})</td>
    <td><input type="text" size="5" value="#{attr["default"]}" name="analysis[#{name}_#{attr["name"]}][#{n}]"/></td>
        EOS
        html += "  </tr>\n"
      }
      html += "</table>\n"
    end
    render :update do |page|
      page << "$('draw_method_setting_html').value='#{escape_javascript(html)}'"
    end
  end


  private

  def check_script(function)
    script = function.script
    ggraph = function.ggraph
    if script =~ /retry/ || ggraph =~ /retry/
      flash[:notice] = "you cannot use retry in script"
      return false
    end
    return true
  end

  def check_erb(draw_method)
    html = draw_method.setting_html
    begin
      ERB.new(html).run
      return true
    rescue SyntaxError
      flash[:notice] = "html is invalid"
      return false
    end
  end


end
