class DescriptionController < ApplicationController
  layout "gfdnavi"

  def node
    if path = params[:path]
      node = Node.find(:first, :conditions => [ "path = ?",path ], :user => session[:user]  )
      if node.directory?
        directory(node)
        return
      elsif node.variable? || node.image?
        variable_or_image(node)
        return
      end
    end
    render :nothing => true
  end

  protected

  def variable_or_image(var)
    @variable = var
    @path = var.path
    dir = @variable.parent
    @desc = get_descriptions(dir)
    @desc.push( Hash.new )
    ttl = @variable.keyword_attributes.find_by_stdname("title")
    @title = @desc[-1][:title] = ttl ? ttl.value : @variable.name
    kwattrs = @variable.keyword_attributes
    kwdsc = kwattrs.find_by_stdname("description")
    kwattrs.delete(kwdsc) if kwdsc
    @desc[-1][:desc] = kwdsc ? kwdsc.value : ''
    @desc[-1][:name] = @variable.name
    @desc[-1][:type] = var.variable? ? "variable" : "image"
#    @desc[-1][:id] = @variable.id
    @desc[-1][:kwa] = get_kwattrs(kwattrs, kwdsc)

    @mode = get_mode(var)
    render :layout => !request.xhr?, :action => :variable
  end

  def directory(dir)
    @path = dir.path
    @plain_file = dir.entity.plain_file
    if dir.entity.downloadable?
      if dir.opendap?
        @url_data = dir.path + '.html'
      elsif GFDNAVI_DATA_URL_PREFIX
        @url_data = request.relative_url_root + GFDNAVI_DATA_URL_PREFIX + dir.path
      end
    else
      @url_data = nil
    end
    @desc = get_descriptions(dir)
    @mode = get_mode(dir)
    render :layout => !request.xhr?, :action => :directory
  end

  def get_descriptions(dir)
    descs = Array.new
    loop do
      h = Hash.new
      ttl = dir.keyword_attributes.find_by_stdname("title")
      h[:type] = "directory"
#      h[:id] = dir.id
      h[:path] = dir.path
      h[:title] = ttl ? ttl.value : dir.name
      kwattrs = dir.keyword_attributes
      desc = kwattrs.find_by_stdname("description")
      h[:desc] = desc ? desc.value : ''
      h[:name] = dir.name
      h[:kwa] = get_kwattrs(kwattrs, desc)
      info_url = dir.keyword_attributes.find_by_stdname("information_url")
      h[:infomation_url] = info_url.value if info_url
      descs.unshift( h )
      dir = dir.parent
      break if !dir
    end
    return descs
  end

  def get_kwattrs(kwattrs, desc)
    ary = Array.new
    kwattrs.each do |att| 
      if att != desc
        v=att.value
        if v.is_a?(NArray)
          if v.length == 1
            v = v[0].to_s
          else
            v = v.to_a.inspect
          end
        end
        ary.push( {:name=>att.name, :value=>v} )
      end
    end
    return ary
  end

  private
  def get_mode(node)
    mode = nil
    if (user=session[:user]) && (user.super_user? || node.owner==user)
      mode = {
        :other_mode => node.other_mode,
        :rgroups => Group.find_by_bit_flag(node.rgroups).collect{|g| g.name}.join(", "),
        :wgroups => Group.find_by_bit_flag(node.wgroups).collect{|g| g.name}.join(", ")
      }
    end
    return mode
  end

end
