# Filters added to this controller will be run for all controllers in the application.
# Likewise, all the methods added will be available for all controllers.

require_dependency "login_system"

class ApplicationController < ActionController::Base
  include LoginSystem
  before_filter :session_expires

  protected
  def session_expires
    ::ActionController::CgiRequest::DEFAULT_SESSION_OPTIONS.update(
      :session_expires => GFDNAVI_SESSION_DURATION.minute.from_now
    )
  end

  def user_path
    GFDNAVI_USER_PATH + "/" + session[:user].login
  end

end

require "analysis"
class AnalysisHistory < Array
  MAX_LENGTH = 10
  def push(analysis)
    raise("Analysis is expected") unless Analysis === analysis
    case Analysis::ACTION_TYPE[analysis.action_type]
    when "draw"
      dl = "Draw: "
      if analysis.draw_method.nvars >= 2
        dl += analysis.draw_variables_order.collect{|ary| "["+ary.collect{|i| analysis.variables[i].name}.join(",")+"]" }.join(",")
      else
        dl += analysis.variables.collect{|v| v.name}.join(",")
      end
      dl += " " + analysis.diagram_label
    when "analysis"
      dl = "Analysis: "
      if analysis.function.nvars > 1
        dl += analysis.function_variables_order.collect{|i| analysis.variables[i].name }.join(",")
      else
        dl += analysis.variables[0].name
      end
      dl += ",  " + analysis.function.name
      arg = analysis.function_arguments
      if analysis.function.function_arguments.length > 0
        dl += "(" + analysis.function_arguments.join(",") + ")"
      end
    end
    delete_if{|a| a[1] == dl}
    super( [analysis,dl] )
    @offset = 0 if !@offset
    if length >= MAX_LENGTH + 1
      shift
      @offset += 1
    end
    self
  end

  def offset
    @offset || 0
  end

end

