var gfdnaviUrlRoot;

var PopupMenu = Class.create();
PopupMenu.prototype = {
  initialize: function(element, html, title) {
    this.html = html;
    this.title = title;
    if (element)
      Event.observe(element, "click", this.openMenu.bindAsEventListener(this));
  },
  openMenu: function(e) {
    var date = new Date();
    date = date.getTime();
    var id = 'popup_menu_'+date;
    var hid = 'popup_header_'+date;
    html = '<div id="'+id+'" class="popup_menu" style="display:none">';
    html += '<table cellspacing="0" cellpadding="0" border="1" bordercolor="black">'
    html += '<tr id="'+hid+'" border="0" style="background-color:#ddeeff;cursor:move;">';
    html += '<td>';
    html += '<div align="left" style="float:left">';
    if (this.title)
      html += this.title;
    html += '</div>';
    html += '<div align="right"><a href="#" onClick="Element.remove($(\''+id+'\'));"><img src="' + gfdnaviUrlRoot + '/images/x.gif" alt="X" class="delete"/></a></div>';
    html += '</td></tr>';
    html += '<tr><td>';
    html += '<div style="padding:5px">' + this.html  + '</div>';
    html += '</td></tr>';
    html += '</table>';
    html += '</div>';

    new Insertion.Bottom(Element.extend(document.body), html);
    var menu = $(id);
    new Draggable(menu,{handle: hid});
    if (e) {
      menu.style.left = Event.pointerX(e)-5 + 'px';
      menu.style.top = Event.pointerY(e)-5 + 'px';
    } else {
      menu.style.left = '10px';
      menu.style.top = '10px';
    }
    Element.show(menu);
    if (e)
      Event.stop(e);
    this.id = id;
  },
  closeMenu: function(e) {
    Element.remove(this.id);
  }
}

var BenchMark = Class.create();
BenchMark.prototype = {
  initialize: function (){},
  start: function() {
    this.start_date = new Date();
  },
  set: function(ary, body) {
    this.ids = ary;
    this.body = body;
  },
  load: function(id) {
    if (this.ids) {
      this.ids = this.ids.without(id);
      if (this.ids.length == 0)
        this.complete();
    }
  },
  complete: function() {
    if ( this.start_date ) {
      var html = this.body + '<br/><hr/>';
      var now = new Date();
      var msec = now.getTime() - this.start_date.getTime();
      html += parseInt(msec/60000)+':'+parseInt((msec%60000)/1000)+'.'+parseInt(msec%1000);
      var pop = new PopupMenu(null, html, 'Result of Benchmark');
      pop.openMenu();
      this.start_date = null;
      this.ids = null;
      this.body = null;
    }
  }
}
var benchMark = new BenchMark();


var normalBgColor = "transparent";
var highlightBgColor = "yellow";
function bgUnhighlight(obj) { obj.style.backgroundColor=normalBgColor; }
function bgHighlight(obj) { obj.style.backgroundColor=highlightBgColor; }

var html_hidden = " <font color='red'><b>(hidden currently)</b></font> ";
var temp_save_str = "";

function helpLinkHilit(id, self) {
  obj = $(id);
  if(obj && testElementVisible(obj)){
    obj.style.backgroundColor=highlightBgColor;
  } else {
    temp_save_str = self.innerHTML
    self.innerHTML = temp_save_str + html_hidden;
  }
}
function helpLinkUnhilit(id, self) {
  obj = $(id);
  if(obj && testElementVisible(obj)){
    obj.style.backgroundColor=normalBgColor;
  } else {
    self.innerHTML = temp_save_str;
  }
}

function testElementVisible(obj) {
  elm = obj;
  while (elm) {
    if (elm == document)
      return true;
    if (!Element.visible(elm))
      return false;
    elm = elm.parentNode;
  }
}

function bgFlash(id){
   new Effect.Highlight(id,
          {startcolor:"#ff0000",endcolor:"#ffffff",restorecolor:"#ffffff"});
}
