class InitialScheme < ActiveRecord::Migration

  def self.up

    create_table "nodes", :force => true do |t|
      t.column "parent_id", :integer
      t.column "name", :string, :null => false
      t.column "path", :string, :null => false
      t.column "node_type", :integer, :null => false
               # 0: directory
               # 1: variable, 2: image
               # 3: knowledge, 4: function, 5: draw_method
      t.column "mtime", :datetime, :null => false
      t.column "owner_id", :integer, :null => false
      t.column "other_mode", :integer, :default => 4, :null => false
      t.column "rgroups", :integer, :length => 12, :default => 0  # 64bit
      t.column "wgroups", :integer, :length => 12, :default => 0  # 64bit
      t.column "size", :integer, :length => 12                    # 64bit
      t.column "guest_owner_id", :integer
      t.column "file", :string
      t.column "other_readable", :boolean, :null => false
      t.column "groups_readable", :integer, :length=>12, :null=>false #64bit
    end

    create_table "guest_owners", :force => true do |t|
      t.column "name", :string, :null => false
      t.column "email", :string
      t.column "identifier", :string, :null => false
    end

    create_table "directories", :force => true do |t|
      t.column "node_id", :integer, :null => false
      t.column "plain_file", :boolean, :default => false, :null => false
      t.column "downloadable", :boolean, :default => true, :null => false
    end

    create_table "actual_files", :force => true do |t|
      t.column "variable_id", :integer, :null => false
      t.column "path", :string, :null => false
    end

    create_table "variables", :force => true do |t|
      t.column "node_id", :integer, :null => false
    end

    create_table "images", :force => true do |t|
      t.column "node_id", :integer, :null => false
      t.column "vizshot", :text
    end

    create_table "knowledges", :force => true do |t|
      t.column "node_id", :integer, :null => false
      t.column "title", :string, :null => false
      t.column "textbody", :text, :null => false
      t.column "default_layout", :string, :null => false
    end

    create_table "knowledge_figures", :force => true do |t|
      t.column "knowledge_id", :integer, :null => false
      t.column "image_id", :integer, :null => false
      t.column "caption", :text, :null => false
    end

    create_table "node_relations", :force => true do |t|
      t.column "name", :text, :null => false
      t.column "reference", :integer, :null => false
      t.column "referenced_by", :integer, :null => false
    end

    create_table "keyword_attributes", :force => true do |t|
      t.column "node_id", :integer, :null => false
      t.column "name", :string, :null => false
      t.column "value", :text
      t.column "num_value", :binary
      t.column "lang", :string
    end

    create_table "spatial_and_time_attributes", :force => true do |t|
      t.column "node_id", :integer, :null => false
      t.column "longitude_lb", :float, :default => nil 
      t.column "latitude_lb", :float, :default => nil
      t.column "longitude_rt", :float, :default => nil
      t.column "latitude_rt", :float, :default => nil
      t.column "starttime", :datetime, :default => nil
      t.column "endtime", :datetime, :default => nil
    end

    create_table "value_types", :force => true do |t|
      t.column "name", :string, :null => false
    end

    create_table "functions", :force => true do |t|
      t.column "node_id", :integer, :null => false
      t.column "description", :text
      t.column "nvars", :integer, :null => false
      t.column "script", :text, :null => false
      t.column "setting_html", :text
      t.column "default", :boolean, :default => false
    end

    create_table "function_outputs", :force => true do |t|
      t.column "function_id", :integer, :null => false
      t.column "name", :string, :null => false
      t.column "description", :text
      t.column "subscript", :string, :null => false
      t.column "position", :integer
    end

    create_table "function_arguments", :force => true do |t|
      t.column "function_id", :integer, :null => false
      t.column "description", :text
      t.column "value_type_id", :integer, :null => false
      t.column "default", :string
      t.column "position", :integer
    end

    create_table "draw_methods", :force => true do |t|
      t.column "node_id", :integer, :null => false
      t.column "description", :text
      t.column "ndims", :integer, :null => false
      t.column "nvars", :integer, :null => false
      t.column "vizshot_method", :string, :null => false
      t.column "script", :text
      t.column "ggraph", :text
      t.column "setting_html", :text
      t.column "default", :boolean, :default => false
    end

    create_table "draw_method_attributes", :force => true do |t|
      t.column "draw_method_id", :integer, :null => false
      t.column "name", :string, :null => false
      t.column "value_type_id", :integer, :null => false
      t.column "default", :string
      t.column "optional", :boolean, :default => false, :null => false
      t.column "parser", :string
    end

    create_table "users", :force => true do |t|
      t.column "login", :string, :null => false
      t.column "password", :string, :null => false
      t.column "full_name", :string, :null => false
      t.column "email_address", :string, :null => false
      t.column "affiliation", :string, :null => false
      t.column "super_user", :boolean, :default => false, :null => false
      t.column "groups", :integer, :length => 12, :default => 0
    end

    create_table "sign_up_users", :force => true do |t|
      t.column "login", :string, :null => false
      t.column "password", :string, :null => false
      t.column "full_name", :string, :null => false
      t.column "email_address", :string, :null => false
      t.column "affiliation", :string, :null => false
    end

    create_table "groups", :force => true do |t|
      t.column "name", :string, :null => false
      t.column "owner_id", :integer, :null => false
    end

##    create_table "group_members", :force => true do |t|
##      t.column "group_id", :integer, :null => false
##      t.column "user_id", :integer, :null => false
##    end

    create_table "diagram_caches", :force => true do |t|
      t.column "uri_params", :text, :null => false
      t.column "path", :string, :null => false
      t.column "label", :string, :null => false
    end

    create_table "diagram_cache_data", :force => true do |t|
      t.column "diagram_cache_id", :integer, :null => false
      t.column "variable_id", :integer, :null => false
    end

    create_table "diagram_cache_sessions", :force => true do |t|
      t.column "diagram_cache_id", :integer, :null => false
      t.column "session", :string, :null => false
      t.column "share", :boolean, :default => true, :null => false
    end

    create_table "draw_parameters", :force => true do |t|
      t.column "node_id", :integer, :null => false
      t.column "name", :string, :null => false
      t.column "value", :string, :null => false
    end

    create_table "query_histories", :force => true do |t|
      t.column "args",         :string
      t.column "querytype",    :string
      t.column "user_id",      :integer
      t.column "time",         :datetime
      t.column "description",  :string
      t.column "queryset_id",  :int
      t.column "conditions",  :string
      t.column "count",        :integer
    end

  end

  def self.down

    drop_table :nodes
    drop_table :guest_owners
    drop_table :directories
    drop_table :actual_files
    drop_table :variables
    drop_table :images
    drop_table :knowledges
    drop_table :knowledge_figures
    drop_table :node_relations
    drop_table :keyword_attributes
    drop_table :spatial_and_time_attributes
    drop_table :draw_method_attributes
    drop_table :draw_methods
    drop_table :function_outputs
    drop_table :function_arguments
    drop_table :functions
    drop_table :value_types
    drop_table :users
    drop_table :sign_up_users
    drop_table :groups
##    drop_table :group_members
    drop_table :diagram_caches
    drop_table :diagram_cache_data
    drop_table :diagram_cache_sessions
    drop_table :draw_parameters
    drop_table :query_histories

  end
end
