class UserController < ApplicationController
  layout  'gfdnavi'

  append_before_filter :login_required, :except => [:login, :signup]

  def index
    @user = session[:user]
  end

  def login
    if GFDNAVI_DISABLE_USER
      redirect_to :controller => "search", :action => "index"
    end

    case request.method
    when :post
      user = User.authenticate(params[:user][:login], params[:user][:password])
      if user
=begin
!!! have to reset session, but this is not valide under rails 1.2
        data = session.instance_variable_get(:@data)
        data ||= session.instance_variable_get(:@attributes)
        request.reset_session
        for key, val in data
          session[key] = val
        end
=end
        session[:user] = user
        flash['notice']  = "Login successful"
        redirect_back_or_default :action => "index"
      else
        flash.now['notice']  = "Login unsuccessful"
        @login = params[:user_login]
      end
    end
  end

  def add_user
    unless User.super_user?(session[:user])
      redirect_back_or_default :action => "index"
    end
    case request.method
    when :post
      @user = User.new(params['user'])
      if @user.save
        flash['notice']  = "Signup successful"
        redirect_back_or_default :action => "index"
      end
    when :get
      @user = User.new
    end
  end

  def signup
    logout
    case request.method
    when :post
      @sign_up_user = SignUpUser.new(params['sign_up_user'])
      if @sign_up_user.save
        if GFDNAVI_ENABLE_EMAIL
          UserMailer.deliver_signup_confirm(@sign_up_user, url)
          UserMailer.deliver_signup_inform(@sign_up_user, url)
        end
        render :action => "signup_succeeded"
	return
      end
    when :get
      @sign_up_user = SignUpUser.new
    end
  end

  def change_password
    @user = session[:user]
    if @user.super_user?
      if name=params[:name] && user=User.find(:first,:conditions=>["login=?",name])
        @user = user
      end
      @super = true
    end
    case request.method
    when :post
      password = params['current_password']
      if @super || User.authenticate(@user.login, password) == @user
        if @user.change_password(params['new_password'], params['new_password_confirmation'])
          flash['notice']  = "Change successful"
          redirect_to :action => "index"
        end
      end
      flash['notice']  = "Change unsuccessful"
    end
  end

  def edit
    @user = session[:user]
    if @user.super_user?
      if name=params[:name] && user=User.find(:first,:conditions=>["login=?",name])
        @user = user
      end
      @super = true
    end
    case request.method
    when :post
      password = params[:password]
      if @user.super_user? || User.authenticate(@user.login, password) == @user
        @user.update_attributes(params[:user])
	if @user.save
	  flash[:notice] = "Change successful"
	  redirect_to :action => "index"
	end
      end
      flash['notice']  = "Change unsuccessful"
    end
  end

  def delete
    if (name = params[:name]) and (user = session[:user])
      user_to_delete = User.find(:first, :conditions=>["login = ?",name])
      if user.super_user? || user == user_to_delete
        user_to_delete.destroy
      end
    end
    redirect_to :action => "index"
  end

  def logout
    session[:user] = nil
    request.reset_session
    session = request.session
  end

  def set_super_user
    if (name = params[:name]) and session[:user].super_user
      user = User.find(:first, :conditions=>["login = ?",name])
      user.super_user = true
      user.save!
    end
    redirect_to :action => "index"
  end

  def unset_super_user
    if (name = params[:name]) and session[:user].super_user?
      user = User.find(:first,:conditions=>["login=?",name])
      user.super_user = false
      user.save!
    end
    redirect_to :action => "index"
  end

  def accept_signup
    suser = session[:user]
    unless User.super_user?(suser)
      redirect_to :action => "index"
    end
    user = SignUpUser.find(params['id'])
    new_user = User.new
    %w(login full_name email_address affiliation).each{|attr|
      new_user.send("#{attr}=", user.send(attr))
    }
    new_user.password = "dummy"
    new_user.password_confirmation = "dummy"
    if new_user.save
      new_user.password = user.password
      new_user.save!
      user.destroy
      flash[:notice] = "authorization of #{user.login} was succeeded"
      @uri = url
      if GFDNAVI_ENABLE_EMAIL
        UserMailer.deliver_signup_accepted(new_user, url)
        UserMailer.deliver_authorization_inform(new_user, url, suser, "accept")
      end
    else
      flash[:notice] = "authorization of #{user.login} was failed"
    end
    redirect_to :action => "index"
  end

  def reject_signup
    suser = session[:user]
    unless User.super_user?(suser)
      redirect_to :action => "index"
    end
    user = SignUpUser.find(params['id'])
    @uri = url
    if GFDNAVI_ENABLE_EMAIL
      UserMailer.deliver_signup_rejected(user, url)
      UserMailer.deliver_authorization_inform(user, url, suser, "reject")
    end
    user.destroy
    redirect_to :action => "index"
  end

  private
  def url
    prot = request.ssl? ? "https" : "http"
    "#{prot}://#{request.host_with_port}#{request.relative_url_root}/"
  end

end
