/* Copyright (C) by GFD-Dennou Club, 1999-2000.  All rights reserved. */
#include "f2c.h"
#undef abs
#undef min
#undef max
#include "stdio.h"
#include "stdlib.h"

extern void sig_die(char*,int);
#define log10e 0.43429448190325182765

double r_lg10(real *x);
double r_mod(real *x, real *y);
double r_sign(real *a, real *b);
integer i_sign(integer *a, integer *b);
integer i_nint(real *x);
void c_div(complex *c, complex *a, complex *b);

/* caculate the result of 2 complex number and the result is c.
 * that is, c=a/b.
 */
void c_div(complex *c, complex *a, complex *b)
{
	double div;

	div=b->r*b->r+b->i*b->i;
	if(div == 0)
		sig_die("complex division by zero", 1);
	c->r=(a->r*b->r+a->i*b->i)/div;
	c->i=(a->i*b->r-a->r*b->i)/div;
}

#include "math.h"

/* Returns the 10 based logarithm of (*x)
 */
double r_lg10(real *x)
{
	return( log10e * log(*x) );
}

/* Returns a remainder.
 */
double r_mod(real *x, real *y)
{
	double quotient;
	
	if( (quotient = (double)*x / *y) >= 0)
		quotient = floor(quotient);
	else
		quotient = -floor(-quotient);
	return(*x - (*y) * quotient );
}

/* Performs a sign transfer by returning the absolute value of 
 * the first argument multiplied by the sign of the second argument.
 */
double r_sign(real *a, real *b)
{
	double x;
	
	x = (*a >= 0 ? *a : - *a);
	return( *b >= 0 ? x : -x);
}

/* return the integer with sign of b but absolute value of a.
*/
integer i_sign(integer *a, integer *b)
{
	integer x;
	x = (*a >= 0 ? *a : - *a);
	return( *b >= 0 ? x : -x);
}

/*	return the most nearest integer for float number x.
*/
integer i_nint(real *x)
{
	return (integer)(*x >= 0 ? floor(*x + .5) : -floor(.5 - *x));
}

/* return the value of (*ap)**(*bp)
 */
double pow_dd(doublereal *ap, doublereal *bp)
{
	return(pow(*ap, *bp) );
}
