!= Sample program for gt4_history/gt4f90io
!
! * 2007/06/27 M.Odaka
! * 2006/10/25 Y.Morikawa
! * 2003/08/21 M.Odaka
! * 2001/02/27 S.Takehiro
!
! Solving diffusion equation
! \[
!     du/dt = \kappa d^2 u/dx^2
! \]
! for giving values of $u$ at $x=[0,1]$.
!
program diffusion_6

  use gt4_history                                   ! ⥸塼
  use dc_types, only : DP                           ! ⥸塼
  use dc_message, only : MessageNotify              ! ⥸塼
  use dc_trace, only : SetDebug, DbgMessage         ! ⥸塼

  integer, parameter     :: nx=30                   ! åɿ
  integer, parameter     :: nt=200                  ! ֥ƥå׿
  integer, parameter     :: ndisp=10                ! ϴֳ
  real(DP), parameter    :: dx=1.0/(nx-1)           ! åɴֳ
  real(DP), parameter    :: dt=0.0005               ! ֳִ
  real(DP), dimension(nx):: x=(/(dx*(i-1),i=1,nx)/) ! ɸѿ
  real(DP), dimension(nx):: temp                    ! 
  real(DP), parameter    :: kappa=1.0               ! ǮȻ
  real(DP)               :: sigma                   ! ׻ѥ᥿

  call SetDebug                                     ! ǥХå⡼ɥ
  call DbgMessage(fmt="*** Debug Message [diffusion_6] *** Debug Message On")
                                                    ! ǥХå  

  tinit = 0.0                                       ! 

  sigma = kappa*dt/dx**2.0d0

  if ( sigma >= 0.5d0 ) then
    call MessageNotify( "E", &                      ! 顼å 
      &                 "diffusion_6", &
      &                 "dt is too large: k*dt/(dx)^2 = %f", &
      &                  d=(/sigma/) )
  else if ( sigma >= 0.4d0 ) then
    call MessageNotify( "W", &                      ! ٹå 
      &                 "diffusion_6", &
      &                 "dt is moderately large: k*dt/(dx)^2 = %f", &
      &                 d=(/sigma/) )
  else
    call MessageNotify( "M", &                      ! å 
      &                 "diffusion_6", &
      &                 "dt is sufficiently small: k*dt/(dx)^2 = %f", &
      &                  d=(/sigma/) )
  end if
    
  temp = exp(-((x-0.5)/0.1)**2)                     ! 

  call HistoryCreate( &                             ! ҥȥ꡼
    & file='diffusion_6.nc', title='Diffusion equation', &
    & source='Sample program of gt4_history/gt4f90io',   &
    & institution='GFD_Dennou Club davis project',       &
    & dims=(/'x','t'/), dimsizes=(/nx,0/),               &
    & longnames=(/'X-coordinate','time        '/),       &
    & units=(/'m','s'/),                                 &
    & origin=real(tinit), interval=real(ndisp*dt) )

  call HistoryPut('x',x)                            ! ѿ

  call HistoryAddVariable( &                        ! ѿ
    & varname='temp', dims=(/'x','t'/), &
    & longname='temperature', units='K', xtype='double')

  call HistoryAddAttr('temp','gt_graph_tick_all',1)
  call HistoryAddAttr('temp','gt_graph_contour_spacing',(/0.0,1.0,0.01/))
  call HistoryAddAttr('temp','+gt_user_davis_kappa',kappa)

  call HistoryPut('temp',temp)                      ! ѿ


  call DbgMessage(fmt="*** Debug Message [diffusion_6] *** Begin time integration")

  do it=1,nt

    temp(2:nx-1) = temp(2:nx-1) &                   ! ʬ
      & + kappa*(temp(3:nx)-2*temp(2:nx-1)+temp(1:nx-2))/dx**2*dt

    if ( mod(it,ndisp) == 0 ) then
      call HistoryPut('temp',temp)                  ! ѿ
    endif

    call DbgMessage(fmt="*** Debug Message [diffusion_6] *** it=%d, &
      &             i= (/it/) )                     ! ǥХå  

  end do

  call DbgMessage(fmt="*** Debug Message [diffusion_6] *** End time integration")

  call HistoryClose

  stop
end program diffusion_6
