program dc_hash_test
  use dc_types, only: STRING
  use dc_test, only: Verify
  use dc_string, only: StoA
  use dc_hash, only: HASH, Put, Put_Line, Get, Size, Delete
  use dc_trace, only: SetDebug
  implicit none
  type(HASH) :: hashv
  character(STRING) :: value
  logical :: found
continue

  call SetDebug

  call Put(hashv, 'hoge', 'hero')
  call Put(hashv, 'key', 'value')
  call Put(hashv, 'hoge  ', 'foo')
  call Put(hashv, 'local', 'demo')
  call Get(hashv, 'hoge', value)
  call Verify('Put, Get test 1', 'foo', value)

  call Get(hashv, 'not+found', value, found)
  call Verify('Put, Get test 2', '', value)
  call Verify('Put, Get test 3', .false., found)

  call Get(hashv, 'local', value, found)
  call Verify('Put, Get test 4', 'demo', value)
  call Verify('Put, Get test 5', .true., found)

  call Verify('Size test', 3, size(hashv))

  call Delete(hashv, 'hogehoge')
  call Verify('Delete test 1', 3, size(hashv))
  
  call Delete(hashv, 'hoge')
  call Verify('Delete test 2', 2, size(hashv))
  
  call Delete(hashv, 'key')
  call Verify('Delete test 3', 1, size(hashv))
  
  call Delete(hashv, 'local')
  call Verify('Delete test 4', 0, size(hashv))
  
  call Put(hashv, 'new', 'val1')
!  call Put_Line(hashv)

  call Delete(hashv)

end program dc_hash_test
